#include "genericAPI/threaddecl.hh"

#include "Commands.hh"

#ifndef DISKCACHE_API__COMMANDS_TCL_HH
#define DISKCACHE_API__COMMANDS_TCL_HH

namespace diskCache
{
  namespace TCL
  {
    namespace Commands
    {
      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      std::string getDirCache( const char* ifo = "all", const char* type = "all" );
      CREATE_THREADED2_DECL( getDirCache, std::string, const char*, const char* );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      std::string getFileExtList( );

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      std::string getFileNames( const char* IfoType,
				const unsigned int Start,
				const unsigned int Stop,
				const char* Extension );

      CREATE_THREADED4_DECL( getFileNames, std::string, const char*,
			     const unsigned int,
			     const unsigned int,
			     const char* );

      //-----------------------------------------------------------------
      /// \brief Frame query.
      ///   
      /// This function is used to search global frame data hash for a specific data.
      ///   
      ///   
      /// \param[in] Ifo
      ///     Data IFO.
      /// \param[in] Type
      ///     Data Type.
      /// \param[in] Start
      ///     Data start time.
      /// \param[in] Stop
      ///     Data stop time.
      /// \param[in] Extension
      ///     Query file extension
      /// \param[in] AllowGaps
      ///     Flag to indicate if data gaps are allowed.
      ///     Set to TRUE (1) if allowed,
      ///     to FALSE (0) - if not.
      ///   
      /// \return
      ///     Tcl formated string: { frame files }{ errors if any }.
      ///
      //-----------------------------------------------------------------
      std::string
      getFrameFiles( const char* Ifo, const char* Type,
		     const unsigned int Start, 
		     const unsigned int Stop,
		     const char* Extension,
		     const bool AllowGaps );

      CREATE_THREADED6_DECL( getFrameFiles, std::string,
			     const char*, const char*,
			     const unsigned int,
			     const unsigned int,
			     const char*,
			     const bool );

      //-----------------------------------------------------------------
      ///
      /// \brief Get lists of intervals
      ///
      /// \param[in] IfoType
      ///     A space delimited list of IFO-Type strings.
      /// \param[in] Start
      ///     Query start time.
      /// \param[in] Stop
      ///     Query stop time.
      /// \param[in] Extension
      ///     Filename extension (ex: ".gwf").
      ///
      /// \return
      ///     A list for each IFO-Type pair with data intervals:
      ///     IFO-Type1 { i1_start i1_stop ... iN_start iN_stop } ... IFO-TypeN { ... }
      ///
      //-----------------------------------------------------------------
      std::string
      getIntervalsList( const char* IfoType,
			const unsigned int Start,
			const unsigned int Stop,
			const char* Extension );

      CREATE_THREADED4_DECL( getIntervalsList, std::string,
			     const char*,
			     const unsigned int,
			     const unsigned int,
			     const char* );

      //-----------------------------------------------------------------
      /// \brief RDS frame query.
      ///   
      /// \param[in] Ifo
      ///     Data IFO.    
      /// \param[in] Type
      ///     Data Type.       
      /// \param[in] Start
      ///     Data start time.
      /// \param[in] Stop
      ///     Data stop time.
      /// \param[in] Extension
      ///     Query file extension
      /// \param[in] WillResample
      ///     Flag to indicate if requested data will be
      ///     resampled. Set to TRUE (1) if will be resampled,
      ///     to FALSE (0) if not.
      ///                       
      /// \return
      ///     Tcl formated string: { frame files }{ errors if any }.
      ///                       
      //-----------------------------------------------------------------
      std::string
      getRDSFrameFiles( const char* Ifo, 
			const char* Type,
			const unsigned int Start,
			const unsigned int Stop,
			const char* Extension,
			const bool WillResample );

      CREATE_THREADED6_DECL( getRDSFrameFiles, std::string, const char*, const char*,
			     const unsigned int, const unsigned int, const char*, const bool );

      //-----------------------------------------------------------------
      /// \brief Update the list of extensions to cache by SDGTx engine
      //-----------------------------------------------------------------
      void
      updateFileExtList( const char* Extensions );

      //-----------------------------------------------------------------
      //: Update list of mount point directories (as they appear in
      //: the resource file): initialize list if called at API startup time;
      //:                     otherwise, check if any MOUNT_PT directory
      //:                     has been pruned, and remove that directory from
      //:                     global hash.   
      //
      //!usage: set dir_list [ updateMountPtList known_mount_pt_dirs ]
      //   
      //!param: const CHAR* dir_list - A list of directories as they appear
      //+       in MOUNT_PT list (API resource file variable).
      //!param: const bool enable_global_check - A flag to indicate if API should check for 
      //+       data conflicts across all MOUNT_PT entries (diskcacheAPI@LDAS reports
      //+       data conflicts only under the same MOUNT_PT).   
      //+       This flag should be set to TRUE only when called by outside of LDAS utility,
      //+       such as /ldas/bin/cacheCheck.   
      //+       Default is FALSE.         
      //   
      //!return: string - Sorted Tcl list of all removed subdirectories, followed by
      //+        error messages if any.   
      //      
      //-----------------------------------------------------------------
      std::string
      updateMountPtList( const char* dir_list,
			 const bool enable_global_check = false );

    } // namespace - Commands
  } // namespace - TCL
} // namespace - diskCache

#endif /* DISKCACHE_API__COMMANDS_TCL_HH */
