#include <ldas_tools_config.h>

#include <sstream>

#include "ExcludedDirectories.hh"

namespace diskCache
{
  namespace Cache
  {
    ExcludedDirectories::
    ExcludedDirectories( )
    {
    } /* ExcludedDirectories::ExcludedDirectories */

    void ExcludedDirectories::
    Update( const directory_container_type& Directories )
    {
      //-----------------------------------------------------------------
      // Generate a new regular expression to quickly identify
      // directories that should be excluded
      //-----------------------------------------------------------------
      std::ostringstream	r;

      r << "^(";
      for ( directory_container_type::const_iterator
	      start = Directories.begin( ),
	      cur = Directories.begin( ),
	      last = Directories.end( );
	    cur != last;
	    ++cur )
      {
	if ( cur != start )
	{
	  r << "|";
	}
	r << *cur;
      }
      r << ")$";

      //-----------------------------------------------------------------
      // Save the new pattern
      //-----------------------------------------------------------------
      pattern = Regex( r.str( ).c_str( ) );
      //-----------------------------------------------------------------
      // Check to see if anyone needs to be notified of the update
      //-----------------------------------------------------------------
      for ( callback_container_type::const_iterator
	      cur = callbacks.begin( ),
	      last = callbacks.end( );
	    cur != last;
	    ++cur )
	{
	  (*cur)( );	// Execute the callback
	}
    } /* ExcludedDirectories::Update */

  } /* namespace - Cache */
} /* namespace - diskCache */
