dnl ---------------------------------------------------------------------
dnl  AX_LDAS_CXX_TEMPLATE_ALIASES
dnl     Check if C++ supports template aliasing (2011 standard)
dnl ---------------------------------------------------------------------
AC_DEFUN([AX_LDAS_CXX_TEMPLATE_ALIASES],
[
AC_MSG_CHECKING([if the C++ compiler supports template aliasing])
AC_LANG_PUSH([C++])
AC_TRY_COMPILE([
#include <memory>
namespace {
  template< class T > using AutoArray = std::unique_ptr< T[] >;
  template< typename T, typename U > using DynamicPointerCast = typename std::dynamic_pointer_cast< T, U >;
}
],[
 AutoArray< int >	a;
],[
  AC_DEFINE([HAVE_CXX_TEMPLATE_ALIASES],[1],[Defined if C++ supports template aliasing])
  AC_MSG_RESULT([yes])
  HAVE_CXX_TEMPLATE_ALIASES=1
],[
  AC_MSG_RESULT([no])
  HAVE_CXX_TEMPLATE_ALIASES=0
])
AC_SUBST([HAVE_CXX_TEMPLATE_ALIASES])
AC_LANG_POP([C++])
])
