/*
 * LALInspiralVCSInfo.h - LALInspiral VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALINSPIRALVCSINFO_H
#define _LALINSPIRALVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/* global variables for vcs information */
extern const char *const lalInspiralVCSVersion;
extern const char *const lalInspiralVCSId;
extern const char *const lalInspiralVCSDate;
extern const char *const lalInspiralVCSBranch;
extern const char *const lalInspiralVCSTag;
extern const char *const lalInspiralVCSAuthor;
extern const char *const lalInspiralVCSCommitter;
extern const char *const lalInspiralVCSStatus;

/* global variables for vcs information - identable */
extern const char *const lalInspiralVCSIdentId;
extern const char *const lalInspiralVCSIdentDate;
extern const char *const lalInspiralVCSIdentBranch;
extern const char *const lalInspiralVCSIdentTag;
extern const char *const lalInspiralVCSIdentAuthor;
extern const char *const lalInspiralVCSIdentCommitter;
extern const char *const lalInspiralVCSIdentStatus;

/* library vcs information structure */
extern const struct tagLALVCSInfo lalInspiralVCSInfo;

/* configure arguments */
extern const char *const lalInspiralConfigureArgs;

/* configure date */
extern const char *const lalInspiralConfigureDate;

/* build date */
extern const char *const lalInspiralBuildDate;

#ifdef __cplusplus
}
#endif

#endif /* _LALINSPIRALVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
