# regression tests for the dd utilitiy

KEEP "*.dat"

a_dat='
 000 001 002 003 004 005 006 007 010 011 012 013 014 015 016 017
 020 021 022 023 024 025 026 027 030 031 032 033 034 035 036 037
 040 041 042 043 044 045 046 047 050 051 052 053 054 055 056 057
 060 061 062 063 064 065 066 067 070 071 072 073 074 075 076 077
 100 101 102 103 104 105 106 107 110 111 112 113 114 115 116 117
 120 121 122 123 124 125 126 127 130 131 132 133 134 135 136 137
 140 141 142 143 144 145 146 147 150 151 152 153 154 155 156 157
 160 161 162 163 164 165 166 167 170 171 172 173 174 175 176 177
 200 201 202 203 204 205 206 207 210 211 212 213 214 215 216 217
 220 221 222 223 224 225 226 227 230 231 232 233 234 235 236 237
 240 241 242 243 244 245 246 247 250 251 252 253 254 255 256 257
 260 261 262 263 264 265 266 267 270 271 272 273 274 275 276 277
 300 301 302 303 304 305 306 307 310 311 312 313 314 315 316 317
 320 321 322 323 324 325 326 327 330 331 332 333 334 335 336 337
 340 341 342 343 344 345 346 347 350 351 352 353 354 355 356 357
 360 361 362 363 364 365 366 367 370 371 372 373 374 375 376 377
'

e_dat='
 000 001 002 003 067 055 056 057 026 005 045 013 014 015 016 017
 020 021 022 023 074 075 062 046 030 031 077 047 034 035 036 037
 100 132 177 173 133 154 120 175 115 135 134 116 153 140 113 141
 360 361 362 363 364 365 366 367 370 371 172 136 114 176 156 157
 174 301 302 303 304 305 306 307 310 311 321 322 323 324 325 326
 327 330 331 342 343 344 345 346 347 350 351 255 340 275 232 155
 171 201 202 203 204 205 206 207 210 211 221 222 223 224 225 226
 227 230 231 242 243 244 245 246 247 250 251 300 117 320 137 007
 040 041 042 043 044 025 006 027 050 051 052 053 054 011 012 033
 060 061 032 063 064 065 066 010 070 071 072 073 004 024 076 341
 101 102 103 104 105 106 107 110 111 121 122 123 124 125 126 127
 130 131 142 143 144 145 146 147 150 151 160 161 162 163 164 165
 166 167 170 200 212 213 214 215 216 217 220 152 233 234 235 236
 237 240 252 253 254 112 256 257 260 261 262 263 264 265 266 267
 270 271 272 273 274 241 276 277 312 313 314 315 316 317 332 333
 334 335 336 337 352 353 354 355 356 357 372 373 374 375 376 377
'

i_dat='
 000 001 002 003 067 055 056 057 026 005 045 013 014 015 016 017
 020 021 022 023 074 075 062 046 030 031 077 047 034 035 036 037
 100 132 177 173 133 154 120 175 115 135 134 116 153 140 113 141
 360 361 362 363 364 365 366 367 370 371 172 136 114 176 156 157
 174 301 302 303 304 305 306 307 310 311 321 322 323 324 325 326
 327 330 331 342 343 344 345 346 347 350 351 255 340 275 137 155
 171 201 202 203 204 205 206 207 210 211 221 222 223 224 225 226
 227 230 231 242 243 244 245 246 247 250 251 300 117 320 241 007
 040 041 042 043 044 025 006 027 050 051 052 053 054 011 012 033
 060 061 032 063 064 065 066 010 070 071 072 073 004 024 076 341
 101 102 103 104 105 106 107 110 111 121 122 123 124 125 126 127
 130 131 142 143 144 145 146 147 150 151 160 161 162 163 164 165
 166 167 170 200 212 213 214 215 216 217 220 232 233 234 235 236
 237 240 252 253 254 255 256 257 260 261 262 263 264 265 266 267
 270 271 272 273 274 275 276 277 312 313 314 315 316 317 332 333
 334 335 336 337 352 353 354 355 356 357 372 373 374 375 376 377
'

o_dat='
 000 001 002 003 067 055 056 057 026 005 025 013 014 015 016 017
 020 021 022 023 074 075 062 046 030 031 077 047 034 035 036 037
 100 132 177 173 133 154 120 175 115 135 134 116 153 140 113 141
 360 361 362 363 364 365 366 367 370 371 172 136 114 176 156 157
 174 301 302 303 304 305 306 307 310 311 321 322 323 324 325 326
 327 330 331 342 343 344 345 346 347 350 351 255 340 275 137 155
 171 201 202 203 204 205 206 207 210 211 221 222 223 224 225 226
 227 230 231 242 243 244 245 246 247 250 251 300 117 320 241 007
 040 041 042 043 044 045 006 027 050 051 052 053 054 011 012 033
 060 061 032 063 064 065 066 010 070 071 072 073 004 024 076 377
 101 252 112 261 237 262 152 265 273 264 232 212 260 312 257 274
 220 217 352 372 276 240 266 263 235 332 233 213 267 270 271 253
 144 145 142 146 143 147 236 150 164 161 162 163 170 165 166 167
 254 151 355 356 353 357 354 277 200 375 376 373 374 272 256 131
 104 105 102 106 103 107 234 110 124 121 122 123 130 125 126 127
 214 111 315 316 313 317 314 341 160 335 336 333 334 215 216 337
'

i2a_dat='
 000 001 002 003 004 005 006 007 010 011 012 013 014 015 016 017
 020 021 022 023 024 025 026 027 030 031 032 033 034 035 036 037
 040 041 042 043 044 045 046 047 050 051 052 053 054 055 056 057
 060 061 062 063 064 065 066 067 070 071 072 073 074 075 076 077
 100 101 102 103 104 105 106 107 110 111 112 113 114 115 116 117
 120 121 122 123 124 125 126 127 130 131 132 133 134 135 136 137
 140 141 142 143 144 145 146 147 150 151 152 153 154 155 156 157
 160 161 162 163 164 165 166 167 170 171 172 173 174 175 176 177
 200 201 202 203 204 205 206 207 210 211 212 213 214 215 216 217
 220 221 222 223 224 225 226 227 230 231 232 233 234 235 236 237
 240 241 242 243 244 245 246 247 250 251 252 253 254 255 256 257
 260 261 262 263 264 265 266 267 270 271 272 273 274 275 276 277
 300 301 302 303 304 305 306 307 310 311 312 313 314 315 316 317
 320 321 322 323 324 133 326 327 330 331 332 333 334 335 336 337
 340 341 342 343 344 135 346 347 350 351 352 353 354 355 356 357
 360 361 362 363 364 365 366 367 370 371 372 373 374 375 376 377
'

function DATA
{
	typeset f
	integer i
	typeset -i8 n
	for f
	do	test -f $f.dat && continue
		case $f in
		*k)	print 1234567890abcde > 1k.dat
			for ((i=1;i<=3;i++))
			do	cat 1k.dat 1k.dat > t
				cat t t > 1k.dat
			done
			cat 1k.dat 1k.dat > 2k.dat
			cat 2k.dat 2k.dat > 4k.dat
			cat 4k.dat 4k.dat > 8k.dat
			cat 8k.dat 8k.dat > 1024k.dat
			for ((i=1;i<=3;i++))
			do	cat 1024k.dat 1024k.dat > t
				cat t t > 1024k.dat
			done
			head -c 1000 1k.dat > 1000.dat
			rm t
			;;
		*)	eval d=\$${f}_dat
			for o in $d
			do	print -f "\\$o"
			done > $f.dat
			;;
		esac
	done
}

TEST 01 'std ascii <=> ebcdic conversion'
	DO	DATA a e i
	EXEC	if=a.dat conv=ebcdic
		ERROR - $'0+1 records in\n0+1 records out'
		SAME OUTPUT e.dat
	EXEC	if=a.dat conv=ibm
		SAME OUTPUT i.dat
	EXEC	if=e.dat conv=ascii
		SAME OUTPUT a.dat

TEST 02 'ast ascii <=> ebcdic conversion'
	DO	DATA a e i o i2a
	EXEC	if=a.dat conv=a2e
		ERROR - $'0+1 records in\n0+1 records out'
		SAME OUTPUT e.dat
	EXEC	if=a.dat from=a to=e
	EXEC	if=a.dat conv=a2i
		SAME OUTPUT i.dat
	EXEC	if=a.dat from=a to=i
	EXEC	if=a.dat conv=a2o
		SAME OUTPUT o.dat
	EXEC	if=a.dat from=a to=o
	EXEC	if=e.dat conv=e2a
		SAME OUTPUT a.dat
	EXEC	if=e.dat from=e to=a
	EXEC	if=i.dat conv=i2a
		SAME OUTPUT i2a.dat
	EXEC	if=i.dat from=i to=a
	EXEC	if=o.dat conv=o2a
		SAME OUTPUT a.dat
	EXEC	if=o.dat from=o to=a

TEST 03 'record report'
	DO	DATA k
	EXEC	if=1k.dat of=t.dat bs=1ki count=1
		SAME t.dat 1k.dat
		ERROR - $'1+0 records in\n1+0 records out'
	EXEC	if=2k.dat of=t.dat bs=2ki count=1
		SAME t.dat 2k.dat
	EXEC	if=4k.dat of=t.dat bs=4ki count=1
		SAME t.dat 4k.dat
	EXEC	if=8k.dat of=t.dat bs=8ki count=1
		SAME t.dat 8k.dat
	EXEC	if=1024k.dat of=t.dat bs=1024ki count=1
		SAME t.dat 1024k.dat
	EXEC	if=1k.dat of=t.dat bs=1000
		SAME t.dat 1k.dat
		ERROR - $'1+1 records in\n1+1 records out'
	EXEC	if=1k.dat of=t.dat bs=1000 count=1
		SAME t.dat 1000.dat
		ERROR - $'1+0 records in\n1+0 records out'
	EXEC	if=1k.dat of=t.dat bs=100 count=10
		SAME t.dat 1000.dat
		ERROR - $'10+0 records in\n10+0 records out'
	EXEC	if=1k.dat of=t.dat bs=10 count=100
		SAME t.dat 1000.dat
		ERROR - $'100+0 records in\n100+0 records out'
