/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.metadata.serialization.StringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;", "Lorg/jetbrains/kotlin/metadata/serialization/StringTable;", "getQualifiedClassNameIndex", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFqNameIndex", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "getLocalClassIdReplacement", "isLocalClassIdReplacementKeptGeneric", "", "()Z", "renderDescriptor", "", "serialization"})
public interface DescriptorAwareStringTable
extends StringTable {
    default public int getQualifiedClassNameIndex(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.getQualifiedClassNameIndex(classId.asString(), classId.isLocal());
    }

    default public int getFqNameIndex(@NotNull ClassifierDescriptorWithTypeParameters descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (ErrorUtils.isError(descriptor)) {
            throw new IllegalStateException("Cannot get FQ name of error class: " + this.renderDescriptor(descriptor));
        }
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)descriptor);
        if (classId == null && (classId = this.getLocalClassIdReplacement(descriptor)) == null) {
            throw new IllegalStateException("Cannot get FQ name of local class: " + this.renderDescriptor(descriptor));
        }
        ClassId classId2 = classId;
        return this.getQualifiedClassNameIndex(classId2);
    }

    @Nullable
    default public ClassId getLocalClassIdReplacement(@NotNull ClassifierDescriptorWithTypeParameters descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return null;
    }

    default public boolean isLocalClassIdReplacementKeptGeneric() {
        return false;
    }

    private String renderDescriptor(ClassifierDescriptorWithTypeParameters descriptor) {
        StringBuilder stringBuilder = new StringBuilder().append(DescriptorRenderer.COMPACT.render(descriptor)).append(" defined in ");
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        return stringBuilder.append(DescriptorRenderer.FQ_NAMES_IN_TYPES.render(declarationDescriptor)).toString();
    }
}

