/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptionalExpectationTargetChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend"})
public final class OptionalExpectationTargetChecker {
    public static final OptionalExpectationTargetChecker INSTANCE;

    public final void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isExpect()) {
            return;
        }
        for (KtAnnotationEntry entry : declaration.getAnnotationEntries()) {
            AnnotationDescriptor annotationDescriptor;
            if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry) == null) {
                continue;
            }
            if (!Intrinsics.areEqual(annotationDescriptor.getFqName(), ExpectedActualDeclarationChecker.Companion.getOPTIONAL_EXPECTATION_FQ_NAME())) continue;
            trace.report(Errors.OPTIONAL_EXPECTATION_NOT_ON_EXPECTED.on(entry));
        }
    }

    private OptionalExpectationTargetChecker() {
    }

    static {
        OptionalExpectationTargetChecker optionalExpectationTargetChecker;
        INSTANCE = optionalExpectationTargetChecker = new OptionalExpectationTargetChecker();
    }
}

