/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.Ivy;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.Configuration;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.ExtraInfoHolder;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ArtifactId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.core.BundleArtifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.core.BundleInfo;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.core.BundleRequirement;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.core.ExecutionEnvironmentProfile;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.core.ExportPackage;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.util.Version;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.util.VersionRange;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser.ModuleDescriptorParser;

public class BundleInfoAdapter {
    public static final String CONF_NAME_DEFAULT = "default";
    public static final Configuration CONF_DEFAULT = new Configuration("default");
    public static final String CONF_NAME_OPTIONAL = "optional";
    public static final Configuration CONF_OPTIONAL = new Configuration("optional", Configuration.Visibility.PUBLIC, "Optional dependencies", new String[]{"default"}, true, null);
    public static final String CONF_NAME_TRANSITIVE_OPTIONAL = "transitive-optional";
    public static final Configuration CONF_TRANSITIVE_OPTIONAL = new Configuration("transitive-optional", Configuration.Visibility.PUBLIC, "Optional dependencies", new String[]{"optional"}, true, null);
    public static final String CONF_USE_PREFIX = "use_";
    public static final String EXTRA_INFO_EXPORT_PREFIX = "_osgi_export_";

    public static DefaultModuleDescriptor toModuleDescriptor(ModuleDescriptorParser parser, URI baseUri, BundleInfo bundle, ExecutionEnvironmentProfileProvider profileProvider) {
        return BundleInfoAdapter.toModuleDescriptor(parser, baseUri, bundle, null, profileProvider);
    }

    public static DefaultModuleDescriptor toModuleDescriptor(ModuleDescriptorParser parser, URI baseUri, BundleInfo bundle, Manifest manifest, ExecutionEnvironmentProfileProvider profileProvider) throws ProfileNotFoundException {
        DefaultModuleDescriptor md = new DefaultModuleDescriptor(parser, null);
        md.addExtraAttributeNamespace("o", Ivy.getIvyHomeURL() + "osgi");
        ModuleRevisionId mrid = BundleInfoAdapter.asMrid("bundle", bundle.getSymbolicName(), bundle.getVersion());
        md.setResolvedPublicationDate(new Date());
        md.setModuleRevisionId(mrid);
        md.addConfiguration(CONF_DEFAULT);
        md.addConfiguration(CONF_OPTIONAL);
        md.addConfiguration(CONF_TRANSITIVE_OPTIONAL);
        HashSet<String> exportedPkgNames = new HashSet<String>(bundle.getExports().size());
        for (ExportPackage exportPackage : bundle.getExports()) {
            md.getExtraInfos().add(new ExtraInfoHolder(EXTRA_INFO_EXPORT_PREFIX + exportPackage.getName(), exportPackage.getVersion().toString()));
            exportedPkgNames.add(exportPackage.getName());
            String[] confDependencies = new String[exportPackage.getUses().size() + 1];
            int i = 0;
            for (String use : exportPackage.getUses()) {
                confDependencies[i++] = CONF_USE_PREFIX + use;
            }
            confDependencies[i] = CONF_NAME_DEFAULT;
            md.addConfiguration(new Configuration(CONF_USE_PREFIX + exportPackage.getName(), Configuration.Visibility.PUBLIC, "Exported package " + exportPackage.getName(), confDependencies, true, null));
        }
        BundleInfoAdapter.requirementAsDependency(md, bundle, exportedPkgNames);
        if (baseUri != null) {
            for (BundleArtifact bundleArtifact : bundle.getArtifacts()) {
                URI uri;
                String type = "jar";
                String ext = "jar";
                String packaging = null;
                if (bundle.hasInnerClasspath() && !bundleArtifact.isSource()) {
                    packaging = "bundle";
                }
                if ("packed".equals(bundleArtifact.getFormat())) {
                    ext = "jar.pack.gz";
                    packaging = packaging != null ? packaging + ",pack200" : "pack200";
                }
                if (bundleArtifact.isSource()) {
                    type = "source";
                }
                if ((uri = bundleArtifact.getUri()) == null) continue;
                DefaultArtifact artifact = BundleInfoAdapter.buildArtifact(mrid, baseUri, uri, type, ext, packaging);
                md.addArtifact(CONF_NAME_DEFAULT, artifact);
            }
        }
        if (profileProvider != null) {
            for (String string : bundle.getExecutionEnvironments()) {
                ExecutionEnvironmentProfile profile = profileProvider.getProfile(string);
                if (profile == null) {
                    throw new ProfileNotFoundException("Execution environment profile " + string + " not found");
                }
                for (String pkg : profile.getPkgNames()) {
                    ArtifactId id = new ArtifactId(ModuleId.newInstance("package", pkg), "*", "*", "*");
                    DefaultExcludeRule rule = new DefaultExcludeRule(id, ExactOrRegexpPatternMatcher.INSTANCE, null);
                    String[] confs = md.getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        rule.addConfiguration(confs[i]);
                    }
                    md.addExcludeRule(rule);
                }
            }
        }
        if (manifest != null) {
            for (Map.Entry entry : manifest.getMainAttributes().entrySet()) {
                md.addExtraInfo(new ExtraInfoHolder(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
        return md;
    }

    public static DefaultArtifact buildArtifact(ModuleRevisionId mrid, URI baseUri, URI uri, String type, String ext, String packaging) {
        DefaultArtifact artifact;
        if ("ivy".equals(uri.getScheme())) {
            artifact = BundleInfoAdapter.decodeIvyURI(uri);
        } else {
            if (!uri.isAbsolute()) {
                uri = baseUri.resolve(uri);
            }
            HashMap<String, String> extraAtt = new HashMap<String, String>();
            if (packaging != null) {
                extraAtt.put("packaging", packaging);
            }
            try {
                artifact = new DefaultArtifact(mrid, null, mrid.getName(), type, ext, new URL(uri.toString()), extraAtt);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to make the uri into the url", e);
            }
        }
        return artifact;
    }

    public static List<String> getConfigurations(BundleInfo bundle) {
        ArrayList<String> confs = new ArrayList<String>();
        confs.add(CONF_NAME_DEFAULT);
        confs.add(CONF_NAME_OPTIONAL);
        confs.add(CONF_NAME_TRANSITIVE_OPTIONAL);
        for (ExportPackage exportPackage : bundle.getExports()) {
            confs.add(CONF_USE_PREFIX + exportPackage.getName());
        }
        return confs;
    }

    public static URI buildIvyURI(Artifact artifact) {
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        return BundleInfoAdapter.asIvyURI(mrid.getOrganisation(), mrid.getName(), mrid.getBranch(), mrid.getRevision(), artifact.getType(), artifact.getName(), artifact.getExt());
    }

    private static URI asIvyURI(String org, String name, String branch, String rev, String type, String art, String ext) {
        StringBuffer builder = new StringBuffer();
        builder.append("ivy:///");
        builder.append(org);
        builder.append('/');
        builder.append(name);
        builder.append('?');
        if (branch != null) {
            builder.append("branch=");
            builder.append(branch);
        }
        if (rev != null) {
            builder.append("&rev=");
            builder.append(rev);
        }
        if (type != null) {
            builder.append("&type=");
            builder.append(type);
        }
        if (art != null) {
            builder.append("&art=");
            builder.append(art);
        }
        if (ext != null) {
            builder.append("&ext=");
            builder.append(ext);
        }
        try {
            return new URI(builder.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("illformed ivy url", e);
        }
    }

    private static DefaultArtifact decodeIvyURI(URI uri) {
        String org = null;
        String name = null;
        String branch = null;
        String rev = null;
        String art = null;
        String type = null;
        String ext = null;
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("An ivy url should be of the form ivy:///org/module but was : " + uri);
        }
        int i = path.indexOf(47, 1);
        if (i < 0) {
            throw new IllegalArgumentException("Expecting an organisation in the ivy url: " + uri);
        }
        org = path.substring(1, i);
        name = path.substring(i + 1);
        String query = uri.getQuery();
        String[] parameters = query.split("&");
        for (int j = 0; j < parameters.length; ++j) {
            String parameter = parameters[j];
            if (parameter.length() == 0) continue;
            String[] nameAndValue = parameter.split("=");
            if (nameAndValue.length != 2) {
                throw new IllegalArgumentException("Malformed query string in the ivy url: " + uri);
            }
            if (nameAndValue[0].equals("branch")) {
                branch = nameAndValue[1];
                continue;
            }
            if (nameAndValue[0].equals("rev")) {
                rev = nameAndValue[1];
                continue;
            }
            if (nameAndValue[0].equals("art")) {
                art = nameAndValue[1];
                continue;
            }
            if (nameAndValue[0].equals("type")) {
                type = nameAndValue[1];
                continue;
            }
            if (nameAndValue[0].equals("ext")) {
                ext = nameAndValue[1];
                continue;
            }
            throw new IllegalArgumentException("Unrecognized parameter '" + nameAndValue[0] + " in the query string of the ivy url: " + uri);
        }
        ModuleRevisionId amrid = ModuleRevisionId.newInstance(org, name, branch, rev);
        DefaultArtifact artifact = new DefaultArtifact(amrid, null, art, type, ext);
        return artifact;
    }

    private static void requirementAsDependency(DefaultModuleDescriptor md, BundleInfo bundleInfo, Set<String> exportedPkgNames) {
        for (BundleRequirement requirement : bundleInfo.getRequirements()) {
            String type = requirement.getType();
            String name = requirement.getName();
            if ("package".equals(type) && exportedPkgNames.contains(name) || "ee".equals(type)) continue;
            ModuleRevisionId ddmrid = BundleInfoAdapter.asMrid(type, name, requirement.getVersion());
            DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(ddmrid, false);
            String conf = CONF_NAME_DEFAULT;
            if ("package".equals(type)) {
                conf = CONF_USE_PREFIX + name;
                md.addConfiguration(new Configuration(CONF_USE_PREFIX + name, Configuration.Visibility.PUBLIC, "Exported package " + name, new String[]{CONF_NAME_DEFAULT}, true, null));
                dd.addDependencyConfiguration(conf, conf);
            }
            if (CONF_NAME_OPTIONAL.equals(requirement.getResolution())) {
                dd.addDependencyConfiguration(CONF_NAME_OPTIONAL, conf);
                dd.addDependencyConfiguration(CONF_NAME_TRANSITIVE_OPTIONAL, CONF_NAME_TRANSITIVE_OPTIONAL);
            } else {
                dd.addDependencyConfiguration(CONF_NAME_DEFAULT, conf);
            }
            md.addDependency(dd);
        }
    }

    public static ModuleRevisionId asMrid(String type, String name, Version v) {
        return ModuleRevisionId.newInstance(type, name, v == null ? null : v.toString());
    }

    public static ModuleRevisionId asMrid(String type, String name, VersionRange v) {
        String revision = v == null ? "[0,)" : v.toIvyRevision();
        return ModuleRevisionId.newInstance(type, name, revision);
    }

    public static class ProfileNotFoundException
    extends RuntimeException {
        public ProfileNotFoundException(String msg) {
            super(msg);
        }
    }
}

