/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.synthetic.diagnostic;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.synthetic.descriptors.AndroidSyntheticPackageFragmentDescriptor;
import org.jetbrains.kotlin.android.synthetic.diagnostic.DefaultErrorMessagesAndroid;
import org.jetbrains.kotlin.android.synthetic.diagnostic.ErrorsAndroid;
import org.jetbrains.kotlin.android.synthetic.res.AndroidSyntheticProperty;
import org.jetbrains.kotlin.android.synthetic.res.SyntheticDescriptorGenerationKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u0004*\u00020\u00102\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u0017\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/android/synthetic/diagnostic/AndroidExtensionPropertiesCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findLeftOutermostQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtElement;", "calleeExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkDeprecated", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "expression", "packageDescriptor", "Lorg/jetbrains/kotlin/android/synthetic/descriptors/AndroidSyntheticPackageFragmentDescriptor;", "checkPartiallyDefinedResource", "property", "Lorg/jetbrains/kotlin/android/synthetic/res/AndroidSyntheticProperty;", "checkUnresolvedWidgetType", "android-extensions-compiler"})
public final class AndroidExtensionPropertiesCallChecker
implements CallChecker {
    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        PsiElement psiElement = reportOn;
        if (!(psiElement instanceof KtExpression)) {
            psiElement = null;
        }
        if ((KtExpression)psiElement == null) {
            return;
        }
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        if (!(callableDescriptor instanceof PropertyDescriptor)) {
            callableDescriptor = null;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)callableDescriptor;
        if (propertyDescriptor == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        DeclarationDescriptor declarationDescriptor = propertyDescriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof AndroidSyntheticPackageFragmentDescriptor)) {
            declarationDescriptor = null;
        }
        AndroidSyntheticPackageFragmentDescriptor androidSyntheticPackageFragmentDescriptor = (AndroidSyntheticPackageFragmentDescriptor)declarationDescriptor;
        if (androidSyntheticPackageFragmentDescriptor == null) {
            return;
        }
        AndroidSyntheticPackageFragmentDescriptor containingPackage = androidSyntheticPackageFragmentDescriptor;
        PropertyDescriptor propertyDescriptor3 = propertyDescriptor2;
        if (!(propertyDescriptor3 instanceof AndroidSyntheticProperty)) {
            propertyDescriptor3 = null;
        }
        AndroidSyntheticProperty androidSyntheticProperty = (AndroidSyntheticProperty)propertyDescriptor3;
        if (androidSyntheticProperty == null) {
            return;
        }
        AndroidSyntheticProperty androidSyntheticProperty2 = androidSyntheticProperty;
        BindingTrace bindingTrace = context2.getTrace();
        boolean bl = false;
        boolean bl2 = false;
        BindingTrace $this$with = bindingTrace;
        boolean bl3 = false;
        this.checkUnresolvedWidgetType((DiagnosticSink)$this$with, (KtExpression)reportOn, androidSyntheticProperty2);
        this.checkDeprecated((DiagnosticSink)$this$with, (KtExpression)reportOn, containingPackage);
        this.checkPartiallyDefinedResource((DiagnosticSink)$this$with, resolvedCall, androidSyntheticProperty2, context2);
    }

    private final void checkDeprecated(@NotNull DiagnosticSink $this$checkDeprecated, KtExpression expression, AndroidSyntheticPackageFragmentDescriptor packageDescriptor) {
        if (packageDescriptor.getPackageData().isDeprecated()) {
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)$this$checkDeprecated, (Diagnostic)((Diagnostic)ErrorsAndroid.SYNTHETIC_DEPRECATED_PACKAGE.on((PsiElement)expression)), (DefaultErrorMessages.Extension)DefaultErrorMessagesAndroid.INSTANCE);
        }
    }

    private final void checkUnresolvedWidgetType(@NotNull DiagnosticSink $this$checkUnresolvedWidgetType, KtExpression expression, AndroidSyntheticProperty property2) {
        if (!SyntheticDescriptorGenerationKt.isErrorType(property2)) {
            return;
        }
        String string = property2.getErrorType();
        if (string == null) {
            return;
        }
        String type = string;
        DiagnosticFactory1<KtExpression, String> warning = StringsKt.contains$default((CharSequence)type, (char)'.', (boolean)false, (int)2, null) ? ErrorsAndroid.SYNTHETIC_UNRESOLVED_WIDGET_TYPE : ErrorsAndroid.SYNTHETIC_INVALID_WIDGET_TYPE;
        DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)$this$checkUnresolvedWidgetType, (Diagnostic)((Diagnostic)warning.on((PsiElement)expression, (Object)type)), (DefaultErrorMessages.Extension)DefaultErrorMessagesAndroid.INSTANCE);
    }

    private final void checkPartiallyDefinedResource(@NotNull DiagnosticSink $this$checkPartiallyDefinedResource, ResolvedCall<?> resolvedCall, AndroidSyntheticProperty property2, CallCheckerContext context2) {
        if (!property2.getResource().getPartiallyDefined()) {
            return;
        }
        Call call = resolvedCall.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call, (String)"resolvedCall.call");
        KtExpression ktExpression = call.getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"resolvedCall.call.calleeExpression ?: return");
        KtExpression calleeExpression = ktExpression;
        KotlinType kotlinType = context2.getResolutionContext().expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"context.resolutionContext.expectedType");
        KotlinType expectedType = kotlinType;
        if (!(TypeUtils.noExpectedType((KotlinType)expectedType) || expectedType.isMarkedNullable() || FlexibleTypesKt.isFlexible((KotlinType)expectedType))) {
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)$this$checkPartiallyDefinedResource, (Diagnostic)((Diagnostic)ErrorsAndroid.UNSAFE_CALL_ON_PARTIALLY_DEFINED_RESOURCE.on((PsiElement)calleeExpression)), (DefaultErrorMessages.Extension)DefaultErrorMessagesAndroid.INSTANCE);
            return;
        }
        KtElement ktElement = this.findLeftOutermostQualifiedExpression(calleeExpression);
        if (ktElement == null) {
            return;
        }
        KtElement outermostQualifiedExpression = ktElement;
        PsiElement usage = outermostQualifiedExpression.getParent();
        if (usage instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)usage).getReceiverExpression(), (Object)outermostQualifiedExpression)) {
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)$this$checkPartiallyDefinedResource, (Diagnostic)((Diagnostic)ErrorsAndroid.UNSAFE_CALL_ON_PARTIALLY_DEFINED_RESOURCE.on((PsiElement)calleeExpression)), (DefaultErrorMessages.Extension)DefaultErrorMessagesAndroid.INSTANCE);
        }
    }

    private final KtElement findLeftOutermostQualifiedExpression(KtExpression calleeExpression) {
        KtExpression ktExpression = calleeExpression;
        if (ktExpression == null || (ktExpression = ktExpression.getParent()) == null) {
            return null;
        }
        KtExpression parent = ktExpression;
        if (parent instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent).getSelectorExpression(), (Object)calleeExpression)) {
            return this.findLeftOutermostQualifiedExpression(parent);
        }
        return (KtElement)calleeExpression;
    }
}

