/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.api.Error;
import org.jruby.ext.ffi.FFI;
import org.jruby.ext.ffi.Type;
import org.jruby.runtime.builtin.IRubyObject;

public final class TypeResolver {
    private final FFI ffi;
    private volatile Map<RubySymbol, Type> symbolTypeCache = Collections.emptyMap();

    TypeResolver(FFI ffi2) {
        this.ffi = ffi2;
    }

    public final Type findType(Ruby runtime2, IRubyObject name2) {
        return this.findType(runtime2, name2, runtime2.getNil());
    }

    public final Type findType(Ruby runtime2, IRubyObject name2, IRubyObject typeMap) {
        if (name2 instanceof Type) {
            Type type2 = (Type)name2;
            return type2;
        }
        if (name2 instanceof RubySymbol) {
            RubyHash hash2;
            Type type3;
            RubySymbol sym = (RubySymbol)name2;
            Object obj = sym.getFFIHandle();
            if (obj instanceof Type) {
                Type type4 = (Type)obj;
                return type4;
            }
            if (typeMap != null && typeMap instanceof RubyHash && (type3 = (Type)(hash2 = (RubyHash)typeMap).get(name2)) != null && !type3.isNil()) {
                return type3;
            }
            Type type5 = this.symbolTypeCache.get(name2);
            if (type5 != null) {
                return type5;
            }
            return this.lookupAndCacheType(runtime2, sym, typeMap);
        }
        return this.lookupType(runtime2, name2, typeMap);
    }

    private synchronized Type lookupAndCacheType(Ruby runtime2, RubySymbol name2, IRubyObject typeMap) {
        Type type2 = this.lookupType(runtime2, name2, typeMap);
        IdentityHashMap<RubySymbol, Type> map2 = new IdentityHashMap<RubySymbol, Type>(this.symbolTypeCache);
        map2.put(name2, type2);
        this.symbolTypeCache = map2;
        name2.setFFIHandle(type2);
        return type2;
    }

    private Type lookupType(Ruby runtime2, IRubyObject name2, IRubyObject typeMap) {
        IRubyObject type2 = this.ffi.typedefs.fastARef(name2);
        if (type2 instanceof Type) {
            Type t = (Type)type2;
            return t;
        }
        throw Error.argumentError(runtime2.getCurrentContext(), "cannot resolve type " + String.valueOf(name2));
    }
}

