/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.sign;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.sign.AbstractSigner;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.internal.signing.SigningTool;
import org.jreleaser.sdk.signing.SigningUtils;
import org.jreleaser.sdk.tool.Cosign;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.util.StringUtils;

public final class CosignSigner
extends AbstractSigner {
    public CosignSigner(JReleaserContext context, SigningTool tool) {
        super(context, tool);
    }

    public void sign() throws SigningException {
        Path thePublicKeyFile;
        List<Object> files;
        Signing signing = this.context.getModel().getSigning();
        Cosign cosign = new Cosign(this.context.asImmutable(), signing.getCosign().getVersion());
        try {
            if (!cosign.setup()) {
                this.context.getLogger().warn(RB.$((String)"tool_unavailable", (Object[])new Object[]{"cosign"}));
                return;
            }
        }
        catch (ToolException e) {
            throw new SigningException(e.getMessage(), (Throwable)e);
        }
        String privateKey = signing.getCosign().getSecretKey();
        String publicKey = signing.getCosign().getPublicKeyFile();
        Path privateKeyFile = StringUtils.isNotBlank((String)privateKey) ? this.context.getBasedir().resolve(privateKey) : null;
        Path publicKeyFile = StringUtils.isNotBlank((String)publicKey) ? this.context.getBasedir().resolve(publicKey) : null;
        String password = signing.getCosign().getPassphrase();
        boolean forceSign = false;
        if (null == privateKeyFile) {
            privateKeyFile = signing.getCosign().getResolvedSecretKeyFilePath(this.context);
            publicKeyFile = privateKeyFile.resolveSibling("cosign.pub");
            if (!Files.exists(privateKeyFile, new LinkOption[0])) {
                privateKeyFile = cosign.generateKeyPair(password);
                forceSign = true;
            }
        }
        if ((files = this.collectArtifacts(forceSign, arg_0 -> this.lambda$sign$0(cosign, thePublicKeyFile = publicKeyFile, arg_0))).isEmpty()) {
            this.context.getLogger().info(RB.$((String)"signing.no.match", (Object[])new Object[0]));
            return;
        }
        if ((files = files.stream().filter(SigningUtils.FilePair::isInvalid).collect(Collectors.toList())).isEmpty()) {
            this.context.getLogger().info(RB.$((String)"signing.up.to.date", (Object[])new Object[0]));
            return;
        }
        if (!cosign.checkPassword(privateKeyFile, password)) {
            this.context.getLogger().warn(RB.$((String)"WARN_cosign_password_does_not_match", (Object[])new Object[]{"cosign"}));
            return;
        }
        this.sign(files, cosign, privateKeyFile, password);
        this.verify(files, cosign, publicKeyFile);
    }

    private void sign(List<SigningUtils.FilePair> files, Cosign cosign, Path privateKeyFile, String password) throws SigningException {
        Path signaturesDirectory = this.context.getSignaturesDirectory();
        try {
            Files.createDirectories(signaturesDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_create_signature_dir", (Object[])new Object[0]), (Throwable)e);
        }
        this.context.getLogger().debug(RB.$((String)"signing.signing.files", (Object[])new Object[0]), new Object[]{files.size(), this.context.relativizeToBasedir(signaturesDirectory)});
        for (SigningUtils.FilePair pair : files) {
            cosign.signBlob(privateKeyFile, password, pair.getInputFile(), signaturesDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify(List<SigningUtils.FilePair> files, Cosign cosign, Path publicKeyFile) throws SigningException {
        this.context.getLogger().debug(RB.$((String)"signing.verify.signatures", (Object[])new Object[0]), new Object[]{files.size()});
        this.context.getLogger().setPrefix("verify");
        try {
            for (SigningUtils.FilePair pair : files) {
                cosign.verifyBlob(publicKeyFile, pair.getSignatureFile(), pair.getInputFile());
                pair.setValid(true);
                if (pair.isValid()) continue;
                throw new SigningException(RB.$((String)"ERROR_signing_verify_file", (Object[])new Object[]{this.context.relativizeToBasedir(pair.getInputFile()), this.context.relativizeToBasedir(pair.getSignatureFile())}));
            }
        }
        finally {
            this.context.getLogger().restorePrefix();
        }
    }

    private boolean isValid(Cosign cosign, Path publicKeyFile, SigningUtils.FilePair pair) {
        if (Files.notExists(pair.getSignatureFile(), new LinkOption[0])) {
            this.context.getLogger().debug(RB.$((String)"signing.signature.not.exist", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(pair.getSignatureFile())});
            return false;
        }
        if (pair.getInputFile().toFile().lastModified() > pair.getSignatureFile().toFile().lastModified()) {
            this.context.getLogger().debug(RB.$((String)"signing.file.newer", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(pair.getInputFile()), this.context.relativizeToBasedir(pair.getSignatureFile())});
            return false;
        }
        try {
            cosign.verifyBlob(publicKeyFile, pair.getSignatureFile(), pair.getInputFile());
            return true;
        }
        catch (SigningException e) {
            return false;
        }
    }

    private /* synthetic */ boolean lambda$sign$0(Cosign cosign, Path thePublicKeyFile, SigningUtils.FilePair pair) {
        return this.isValid(cosign, thePublicKeyFile, pair);
    }
}

