/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.common;

import java.util.Collection;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Ftp;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;

public final class FtpValidator {
    private static final String USERNAME = ".username";
    private static final String PASSWORD = ".password";
    private static final String HOST = ".host";
    private static final String PORT = ".port";

    private FtpValidator() {
    }

    public static void validateFtp(JReleaserContext context, Ftp ftp, String prefix, String name, Errors errors, boolean anonymousAccess) {
        String baseKey1 = prefix + ".ftp." + name;
        String baseKey2 = prefix + ".ftp";
        String baseKey3 = "ftp." + name;
        String baseKey4 = "ftp";
        ftp.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + USERNAME, baseKey2 + USERNAME, baseKey3 + USERNAME, baseKey4 + USERNAME}), baseKey1 + USERNAME, ftp.getUsername(), errors, anonymousAccess));
        ftp.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + PASSWORD, baseKey2 + PASSWORD, baseKey3 + PASSWORD, baseKey4 + PASSWORD}), baseKey1 + PASSWORD, ftp.getPassword(), errors, anonymousAccess));
        ftp.setHost(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + HOST, baseKey2 + HOST, baseKey3 + HOST, baseKey4 + HOST}), baseKey1 + HOST, ftp.getHost(), errors, context.isDryrun()));
        ftp.setPort(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + PORT, baseKey2 + PORT, baseKey3 + PORT, baseKey4 + PORT}), baseKey1 + PORT, ftp.getPort(), errors, context.isDryrun()));
    }
}

