/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.assemble.JpackageAssembler;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.common.Java;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.AbstractJavaAssembler;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.common.Glob;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.PlatformUtils;

public final class JpackageAssembler
extends AbstractJavaAssembler<JpackageAssembler, org.jreleaser.model.api.assemble.JpackageAssembler> {
    private static final long serialVersionUID = 7361967020493389521L;
    private final Set<org.jreleaser.model.internal.common.Artifact> runtimeImages = new LinkedHashSet<org.jreleaser.model.internal.common.Artifact>();
    private final ApplicationPackage applicationPackage = new ApplicationPackage();
    private final Launcher launcher = new Launcher();
    private final Linux linux = new Linux();
    private final Windows windows = new Windows();
    private final Osx osx = new Osx();
    private String jlink;
    private Boolean attachPlatform;
    private Boolean verbose;
    @JsonIgnore
    private final org.jreleaser.model.api.assemble.JpackageAssembler immutable = new org.jreleaser.model.api.assemble.JpackageAssembler(){
        private static final long serialVersionUID = -5355530264697452901L;
        private Set<? extends Artifact> artifacts;
        private Set<? extends Artifact> runtimeImages;
        private Set<? extends JpackageAssembler.PlatformPackager> platformPackagers;
        private List<? extends org.jreleaser.model.api.common.Glob> jars;
        private List<? extends org.jreleaser.model.api.common.Glob> files;
        private List<? extends org.jreleaser.model.api.common.FileSet> fileSets;
        private Set<? extends Artifact> outputs;

        public String getJlink() {
            return JpackageAssembler.this.jlink;
        }

        public boolean isAttachPlatform() {
            return JpackageAssembler.this.isAttachPlatform();
        }

        public boolean isVerbose() {
            return JpackageAssembler.this.isVerbose();
        }

        public Set<? extends Artifact> getRuntimeImages() {
            if (null == this.runtimeImages) {
                this.runtimeImages = JpackageAssembler.this.runtimeImages.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.runtimeImages;
        }

        public JpackageAssembler.ApplicationPackage getApplicationPackage() {
            return JpackageAssembler.this.applicationPackage.asImmutable();
        }

        public JpackageAssembler.Launcher getLauncher() {
            return JpackageAssembler.this.launcher.asImmutable();
        }

        public JpackageAssembler.Linux getLinux() {
            return JpackageAssembler.this.linux.asImmutable();
        }

        public JpackageAssembler.Windows getWindows() {
            return JpackageAssembler.this.windows.asImmutable();
        }

        public JpackageAssembler.Osx getOsx() {
            return JpackageAssembler.this.osx.asImmutable();
        }

        public Set<? extends JpackageAssembler.PlatformPackager> getPlatformPackagers() {
            if (null == this.platformPackagers) {
                this.platformPackagers = Collections.unmodifiableSet(CollectionUtils.setOf((Object[])new JpackageAssembler.PlatformPackager[]{JpackageAssembler.this.osx.asImmutable(), JpackageAssembler.this.linux.asImmutable(), JpackageAssembler.this.windows.asImmutable()}));
            }
            return this.platformPackagers;
        }

        public String getExecutable() {
            return JpackageAssembler.this.getExecutable();
        }

        public String getTemplateDirectory() {
            return JpackageAssembler.this.getTemplateDirectory();
        }

        public Set<String> getSkipTemplates() {
            return Collections.unmodifiableSet(JpackageAssembler.this.getSkipTemplates());
        }

        public Java getJava() {
            return JpackageAssembler.this.getJava().asImmutable();
        }

        public Artifact getMainJar() {
            return JpackageAssembler.this.getMainJar().asImmutable();
        }

        public List<? extends org.jreleaser.model.api.common.Glob> getJars() {
            if (null == this.jars) {
                this.jars = JpackageAssembler.this.getJars().stream().map(Glob::asImmutable).collect(Collectors.toList());
            }
            return this.jars;
        }

        public Set<? extends Artifact> getArtifacts() {
            if (null == this.artifacts) {
                this.artifacts = JpackageAssembler.this.getArtifacts().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.artifacts;
        }

        public List<? extends org.jreleaser.model.api.common.Glob> getFiles() {
            if (null == this.files) {
                this.files = JpackageAssembler.this.getFiles().stream().map(Glob::asImmutable).collect(Collectors.toList());
            }
            return this.files;
        }

        public Platform getPlatform() {
            return JpackageAssembler.this.getPlatform().asImmutable();
        }

        public Distribution.DistributionType getDistributionType() {
            return JpackageAssembler.this.getDistributionType();
        }

        public String getType() {
            return JpackageAssembler.this.getType();
        }

        public Stereotype getStereotype() {
            return JpackageAssembler.this.getStereotype();
        }

        public boolean isExported() {
            return JpackageAssembler.this.isExported();
        }

        public String getName() {
            return JpackageAssembler.this.getName();
        }

        public List<? extends org.jreleaser.model.api.common.FileSet> getFileSets() {
            if (null == this.fileSets) {
                this.fileSets = JpackageAssembler.this.getFileSets().stream().map(FileSet::asImmutable).collect(Collectors.toList());
            }
            return this.fileSets;
        }

        public Set<? extends Artifact> getOutputs() {
            if (null == this.outputs) {
                this.outputs = JpackageAssembler.this.getOutputs().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.outputs;
        }

        public Active getActive() {
            return JpackageAssembler.this.getActive();
        }

        public boolean isEnabled() {
            return JpackageAssembler.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(JpackageAssembler.this.asMap(full));
        }

        public String getPrefix() {
            return JpackageAssembler.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(JpackageAssembler.this.getExtraProperties());
        }
    };

    public JpackageAssembler() {
        super("jpackage");
    }

    @Override
    public org.jreleaser.model.api.assemble.JpackageAssembler asImmutable() {
        return this.immutable;
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.NATIVE_PACKAGE;
    }

    @Override
    public void merge(JpackageAssembler source) {
        super.merge(source);
        this.jlink = this.merge(this.jlink, source.jlink);
        this.attachPlatform = this.merge(this.attachPlatform, source.attachPlatform);
        this.verbose = this.merge(this.verbose, source.verbose);
        this.setRuntimeImages(source.runtimeImages);
        this.setApplicationPackage(source.applicationPackage);
        this.setLauncher(source.launcher);
        this.setLinux(source.linux);
        this.setWindows(source.windows);
        this.setOsx(source.osx);
    }

    public String getJlink() {
        return this.jlink;
    }

    public void setJlink(String jlink) {
        this.jlink = jlink;
    }

    public boolean isAttachPlatformSet() {
        return null != this.attachPlatform;
    }

    public boolean isAttachPlatform() {
        return null != this.attachPlatform && this.attachPlatform != false;
    }

    public void setAttachPlatform(Boolean attachPlatform) {
        this.attachPlatform = attachPlatform;
    }

    public boolean isVerboseSet() {
        return null != this.verbose;
    }

    public boolean isVerbose() {
        return null != this.verbose && this.verbose != false;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    public Set<org.jreleaser.model.internal.common.Artifact> getRuntimeImages() {
        return org.jreleaser.model.internal.common.Artifact.sortArtifacts(this.runtimeImages);
    }

    public void setRuntimeImages(Set<org.jreleaser.model.internal.common.Artifact> runtimeImages) {
        this.runtimeImages.clear();
        this.runtimeImages.addAll(runtimeImages);
    }

    public void addRuntimeImage(org.jreleaser.model.internal.common.Artifact jdk) {
        if (null != jdk) {
            this.runtimeImages.add(jdk);
        }
    }

    public Optional<org.jreleaser.model.internal.common.Artifact> findRuntimeImageByPlatform(String platform) {
        return this.runtimeImages.stream().filter(ri -> ri.getPlatform().equals(platform)).findFirst();
    }

    public ApplicationPackage getApplicationPackage() {
        return this.applicationPackage;
    }

    public void setApplicationPackage(ApplicationPackage applicationPackage) {
        this.applicationPackage.merge(applicationPackage);
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public void setLauncher(Launcher launcher) {
        this.launcher.merge(launcher);
    }

    public Linux getLinux() {
        return this.linux;
    }

    public void setLinux(Linux linux) {
        this.linux.merge(linux);
    }

    public Windows getWindows() {
        return this.windows;
    }

    public void setWindows(Windows windows) {
        this.windows.merge(windows);
    }

    public Osx getOsx() {
        return this.osx;
    }

    public void setOsx(Osx osx) {
        this.osx.merge(osx);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("jlink", this.jlink);
        props.put("attachPlatform", this.isAttachPlatform());
        LinkedHashMap<String, Map<String, Object>> mapped = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (org.jreleaser.model.internal.common.Artifact runtimeImage : this.getRuntimeImages()) {
            mapped.put("runtimeImage " + i++, runtimeImage.asMap(full));
        }
        props.put("runtimeImages", mapped);
        if (this.launcher.isSet()) {
            props.put("launcher", this.launcher.asMap(full));
        }
        props.put("applicationPackage", this.applicationPackage.asMap(full));
        props.putAll(this.linux.asMap(full));
        props.putAll(this.osx.asMap(full));
        props.putAll(this.windows.asMap(full));
    }

    public PlatformPackager getResolvedPlatformPackager() {
        String currentPlatform = PlatformUtils.getCurrentFull();
        if (PlatformUtils.isMac((String)currentPlatform)) {
            return this.getOsx();
        }
        if (PlatformUtils.isWindows((String)currentPlatform)) {
            return this.getWindows();
        }
        return this.getLinux();
    }

    public Set<PlatformPackager> getPlatformPackagers() {
        return Collections.unmodifiableSet(CollectionUtils.setOf((Object[])new AbstractPlatformPackager[]{this.osx, this.linux, this.windows}));
    }

    public static final class Osx
    extends AbstractPlatformPackager<Osx> {
        private static final long serialVersionUID = -9141240583821973075L;
        private String packageIdentifier;
        private String packageName;
        private String packageSigningPrefix;
        private String signingKeychain;
        private String signingKeyUsername;
        private Boolean sign;
        @JsonIgnore
        private final JpackageAssembler.Osx immutable = new JpackageAssembler.Osx(){
            private static final long serialVersionUID = 8703264589112990966L;

            public String getPackageIdentifier() {
                return packageIdentifier;
            }

            public String getPackageName() {
                return packageName;
            }

            public String getPackageSigningPrefix() {
                return packageSigningPrefix;
            }

            public String getSigningKeychain() {
                return signingKeychain;
            }

            public String getSigningKeyUsername() {
                return signingKeyUsername;
            }

            public boolean isSign() {
                return this.isSign();
            }

            public String getAppName() {
                return this.getAppName();
            }

            public String getIcon() {
                return this.getIcon();
            }

            public String getPlatform() {
                return this.getPlatform();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Artifact getJdk() {
                return this.getJdk().asImmutable();
            }

            public List<String> getTypes() {
                return Collections.unmodifiableList(this.getTypes());
            }

            public String getInstallDir() {
                return this.getInstallDir();
            }

            public String getResourceDir() {
                return this.getResourceDir();
            }

            public boolean isLauncherAsService() {
                return this.isLauncherAsService();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Osx() {
            super("osx", Arrays.asList("dmg", "pkg"));
        }

        public JpackageAssembler.Osx asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Osx source) {
            super.merge(source);
            this.packageIdentifier = this.merge(this.packageIdentifier, source.packageIdentifier);
            this.packageName = this.merge(this.packageName, source.packageName);
            this.packageSigningPrefix = this.merge(this.packageSigningPrefix, source.packageSigningPrefix);
            this.signingKeychain = this.merge(this.signingKeychain, source.signingKeychain);
            this.signingKeyUsername = this.merge(this.signingKeyUsername, source.signingKeyUsername);
            this.sign = this.merge(this.sign, source.sign);
        }

        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        public void setPackageIdentifier(String packageIdentifier) {
            this.packageIdentifier = packageIdentifier;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageSigningPrefix() {
            return this.packageSigningPrefix;
        }

        public void setPackageSigningPrefix(String packageSigningPrefix) {
            this.packageSigningPrefix = packageSigningPrefix;
        }

        public String getSigningKeychain() {
            return this.signingKeychain;
        }

        public void setSigningKeychain(String signingKeychain) {
            this.signingKeychain = signingKeychain;
        }

        public String getSigningKeyUsername() {
            return this.signingKeyUsername;
        }

        public void setSigningKeyUsername(String signingKeyUsername) {
            this.signingKeyUsername = signingKeyUsername;
        }

        public boolean isSign() {
            return null != this.sign && this.sign != false;
        }

        public void setSign(Boolean sign) {
            this.sign = sign;
        }

        @Override
        protected void asMap(boolean full, Map<String, Object> props) {
            props.put("packageIdentifier", this.packageIdentifier);
            props.put("packageName", this.packageName);
            props.put("packageSigningPrefix", this.packageSigningPrefix);
            props.put("signingKeychain", this.signingKeychain);
            props.put("signingKeyUsername", this.signingKeyUsername);
            props.put("sign", this.isSign());
        }
    }

    public static final class Windows
    extends AbstractPlatformPackager<Windows> {
        private static final long serialVersionUID = 5422667595967237081L;
        private Boolean console;
        private Boolean dirChooser;
        private Boolean menu;
        private Boolean perUserInstall;
        private Boolean shortcut;
        private Boolean shortcutPrompt;
        private String menuGroup;
        private String upgradeUuid;
        private String helpUrl;
        private String updateUrl;
        @JsonIgnore
        private final JpackageAssembler.Windows immutable = new JpackageAssembler.Windows(){
            private static final long serialVersionUID = 6920391900633709089L;

            public boolean isConsole() {
                return this.isConsole();
            }

            public boolean isDirChooser() {
                return this.isDirChooser();
            }

            public boolean isMenu() {
                return this.isMenu();
            }

            public boolean isPerUserInstall() {
                return this.isPerUserInstall();
            }

            public boolean isShortcut() {
                return this.isShortcut();
            }

            public boolean isShortcutPrompt() {
                return this.isShortcutPrompt();
            }

            public String getMenuGroup() {
                return menuGroup;
            }

            public String getUpgradeUuid() {
                return upgradeUuid;
            }

            public String getHelpUrl() {
                return helpUrl;
            }

            public String getUpdateUrl() {
                return updateUrl;
            }

            public String getAppName() {
                return this.getAppName();
            }

            public String getIcon() {
                return this.getIcon();
            }

            public String getPlatform() {
                return this.getPlatform();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Artifact getJdk() {
                return this.getJdk().asImmutable();
            }

            public List<String> getTypes() {
                return Collections.unmodifiableList(this.getTypes());
            }

            public String getInstallDir() {
                return this.getInstallDir();
            }

            public String getResourceDir() {
                return this.getResourceDir();
            }

            public boolean isLauncherAsService() {
                return this.isLauncherAsService();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Windows() {
            super("windows", Arrays.asList("msi", "exe"));
        }

        public JpackageAssembler.Windows asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Windows source) {
            super.merge(source);
            this.console = this.merge(this.console, source.console);
            this.dirChooser = this.merge(this.dirChooser, source.dirChooser);
            this.menu = this.merge(this.menu, source.menu);
            this.perUserInstall = this.merge(this.perUserInstall, source.perUserInstall);
            this.shortcut = this.merge(this.shortcut, source.shortcut);
            this.shortcutPrompt = this.merge(this.shortcutPrompt, source.shortcutPrompt);
            this.menuGroup = this.merge(this.menuGroup, source.menuGroup);
            this.upgradeUuid = this.merge(this.upgradeUuid, source.upgradeUuid);
            this.helpUrl = this.merge(this.helpUrl, source.helpUrl);
            this.updateUrl = this.merge(this.updateUrl, source.updateUrl);
        }

        public boolean isConsole() {
            return null != this.console && this.console != false;
        }

        public void setConsole(Boolean console) {
            this.console = console;
        }

        public boolean isDirChooser() {
            return null != this.dirChooser && this.dirChooser != false;
        }

        public void setDirChooser(Boolean dirChooser) {
            this.dirChooser = dirChooser;
        }

        public boolean isMenu() {
            return null != this.menu && this.menu != false;
        }

        public void setMenu(Boolean menu) {
            this.menu = menu;
        }

        public boolean isPerUserInstall() {
            return null != this.perUserInstall && this.perUserInstall != false;
        }

        public void setPerUserInstall(Boolean perUserInstall) {
            this.perUserInstall = perUserInstall;
        }

        public boolean isShortcut() {
            return null != this.shortcut && this.shortcut != false;
        }

        public void setShortcut(Boolean shortcut) {
            this.shortcut = shortcut;
        }

        public boolean isShortcutPrompt() {
            return null != this.shortcutPrompt && this.shortcutPrompt != false;
        }

        public void setShortcutPrompt(Boolean shortcutPrompt) {
            this.shortcutPrompt = shortcutPrompt;
        }

        public String getMenuGroup() {
            return this.menuGroup;
        }

        public void setMenuGroup(String menuGroup) {
            this.menuGroup = menuGroup;
        }

        public String getUpgradeUuid() {
            return this.upgradeUuid;
        }

        public void setUpgradeUuid(String upgradeUuid) {
            this.upgradeUuid = upgradeUuid;
        }

        public String getHelpUrl() {
            return this.helpUrl;
        }

        public void setHelpUrl(String helpUrl) {
            this.helpUrl = helpUrl;
        }

        public String getUpdateUrl() {
            return this.updateUrl;
        }

        public void setUpdateUrl(String updateUrl) {
            this.updateUrl = updateUrl;
        }

        @Override
        protected void asMap(boolean full, Map<String, Object> props) {
            props.put("console", this.isConsole());
            props.put("dirChooser", this.isDirChooser());
            props.put("menu", this.isMenu());
            props.put("perUserInstall", this.isPerUserInstall());
            props.put("shortcut", this.isShortcut());
            props.put("shortcutPrompt", this.isShortcutPrompt());
            props.put("menuGroup", this.menuGroup);
            props.put("upgradeUuid", this.upgradeUuid);
            props.put("helpUrl", this.helpUrl);
            props.put("updateUrl", this.updateUrl);
        }
    }

    public static final class Linux
    extends AbstractPlatformPackager<Linux> {
        private static final long serialVersionUID = -3810090447757197994L;
        private final List<String> packageDeps = new ArrayList<String>();
        private String packageName;
        private String maintainer;
        private String menuGroup;
        private String license;
        private String appRelease;
        private String appCategory;
        private Boolean shortcut;
        @JsonIgnore
        private final JpackageAssembler.Linux immutable = new JpackageAssembler.Linux(){
            private static final long serialVersionUID = 6801354680613876649L;

            public List<String> getPackageDeps() {
                return Collections.unmodifiableList(packageDeps);
            }

            public String getPackageName() {
                return packageName;
            }

            public String getMaintainer() {
                return maintainer;
            }

            public String getMenuGroup() {
                return menuGroup;
            }

            public String getLicense() {
                return license;
            }

            public String getAppRelease() {
                return appRelease;
            }

            public String getAppCategory() {
                return appCategory;
            }

            public boolean isShortcut() {
                return this.isShortcut();
            }

            public String getAppName() {
                return this.getAppName();
            }

            public String getIcon() {
                return this.getIcon();
            }

            public String getPlatform() {
                return this.getPlatform();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Artifact getJdk() {
                return this.getJdk().asImmutable();
            }

            public List<String> getTypes() {
                return Collections.unmodifiableList(this.getTypes());
            }

            public String getInstallDir() {
                return this.getInstallDir();
            }

            public String getResourceDir() {
                return this.getResourceDir();
            }

            public boolean isLauncherAsService() {
                return this.isLauncherAsService();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Linux() {
            super("linux", Arrays.asList("deb", "rpm"));
        }

        public JpackageAssembler.Linux asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Linux source) {
            super.merge(source);
            this.packageName = this.merge(this.packageName, source.packageName);
            this.maintainer = this.merge(this.maintainer, source.maintainer);
            this.menuGroup = this.merge(this.menuGroup, source.menuGroup);
            this.license = this.merge(this.license, source.license);
            this.appRelease = this.merge(this.appRelease, source.appRelease);
            this.appCategory = this.merge(this.appCategory, source.appCategory);
            this.shortcut = this.merge(this.shortcut, source.shortcut);
            this.setPackageDeps(this.merge(this.packageDeps, source.packageDeps));
        }

        public List<String> getPackageDeps() {
            return this.packageDeps;
        }

        public void setPackageDeps(List<String> packageDeps) {
            this.packageDeps.clear();
            this.packageDeps.addAll(packageDeps);
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getMaintainer() {
            return this.maintainer;
        }

        public void setMaintainer(String maintainer) {
            this.maintainer = maintainer;
        }

        public String getMenuGroup() {
            return this.menuGroup;
        }

        public void setMenuGroup(String menuGroup) {
            this.menuGroup = menuGroup;
        }

        public String getLicense() {
            return this.license;
        }

        public void setLicense(String license) {
            this.license = license;
        }

        public String getAppRelease() {
            return this.appRelease;
        }

        public void setAppRelease(String appRelease) {
            this.appRelease = appRelease;
        }

        public String getAppCategory() {
            return this.appCategory;
        }

        public void setAppCategory(String appCategory) {
            this.appCategory = appCategory;
        }

        public boolean isShortcut() {
            return null != this.shortcut && this.shortcut != false;
        }

        public void setShortcut(Boolean shortcut) {
            this.shortcut = shortcut;
        }

        @Override
        protected void asMap(boolean full, Map<String, Object> props) {
            props.put("packageName", this.packageName);
            props.put("maintainer", this.maintainer);
            props.put("menuGroup", this.menuGroup);
            props.put("license", this.license);
            props.put("appRelease", this.appRelease);
            props.put("appCategory", this.appCategory);
            props.put("shortcut", this.isShortcut());
            props.put("packageDeps", this.packageDeps);
        }
    }

    public static final class Launcher
    extends AbstractModelObject<Launcher>
    implements Domain {
        private static final long serialVersionUID = -3575025563394732760L;
        private final List<String> arguments = new ArrayList<String>();
        private final List<String> javaOptions = new ArrayList<String>();
        private final List<String> launchers = new ArrayList<String>();
        @JsonIgnore
        private final JpackageAssembler.Launcher immutable = new JpackageAssembler.Launcher(){
            private static final long serialVersionUID = -3045561990255302058L;

            public List<String> getLaunchers() {
                return Collections.unmodifiableList(launchers);
            }

            public List<String> getArguments() {
                return Collections.unmodifiableList(arguments);
            }

            public List<String> getJavaOptions() {
                return Collections.unmodifiableList(javaOptions);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public JpackageAssembler.Launcher asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Launcher source) {
            this.setArguments(this.merge(this.arguments, source.arguments));
            this.setJavaOptions(this.merge(this.javaOptions, source.javaOptions));
            this.setLaunchers(this.merge(this.launchers, source.launchers));
        }

        public boolean isSet() {
            return !this.arguments.isEmpty() || !this.javaOptions.isEmpty() || !this.launchers.isEmpty();
        }

        public List<String> getLaunchers() {
            return this.launchers;
        }

        public void setLaunchers(List<String> launchers) {
            this.launchers.clear();
            this.launchers.addAll(launchers);
        }

        public void addLaunchers(List<String> launchers) {
            this.launchers.addAll(launchers);
        }

        public List<String> getArguments() {
            return this.arguments;
        }

        public void setArguments(List<String> arguments) {
            this.arguments.clear();
            this.arguments.addAll(arguments);
        }

        public void addArguments(List<String> arguments) {
            this.arguments.addAll(arguments);
        }

        public List<String> getJavaOptions() {
            return this.javaOptions;
        }

        public void setJavaOptions(List<String> javaOptions) {
            this.javaOptions.clear();
            this.javaOptions.addAll(javaOptions);
        }

        public void addJavaOptions(List<String> javaOptions) {
            this.javaOptions.addAll(javaOptions);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("arguments", this.arguments);
            props.put("javaOptions", this.javaOptions);
            props.put("launchers", this.launchers);
            return props;
        }
    }

    public static final class ApplicationPackage
    extends AbstractModelObject<ApplicationPackage>
    implements Domain {
        private static final long serialVersionUID = -1240484668237208097L;
        private final List<String> fileAssociations = new ArrayList<String>();
        private String appName;
        private String appVersion;
        private String vendor;
        private String copyright;
        private String licenseFile;
        @JsonIgnore
        private final JpackageAssembler.ApplicationPackage immutable = new JpackageAssembler.ApplicationPackage(){
            private static final long serialVersionUID = 2880902841456006360L;

            public String getAppName() {
                return appName;
            }

            public String getAppVersion() {
                return appVersion;
            }

            public String getVendor() {
                return vendor;
            }

            public String getCopyright() {
                return copyright;
            }

            public List<String> getFileAssociations() {
                return Collections.unmodifiableList(fileAssociations);
            }

            public String getLicenseFile() {
                return licenseFile;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public JpackageAssembler.ApplicationPackage asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(ApplicationPackage source) {
            this.appName = this.merge(this.appName, source.appName);
            this.appVersion = this.merge(this.appVersion, source.appVersion);
            this.vendor = this.merge(this.vendor, source.vendor);
            this.copyright = this.merge(this.copyright, source.copyright);
            this.licenseFile = this.merge(this.licenseFile, source.licenseFile);
            this.setFileAssociations(this.merge(this.fileAssociations, source.fileAssociations));
        }

        public String getResolvedAppVersion(JReleaserContext context, JpackageAssembler jpackage) {
            TemplateContext props = context.getModel().props();
            props.setAll(jpackage.props());
            return Templates.resolveTemplate((String)this.appVersion, (TemplateContext)props);
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        public String getVendor() {
            return this.vendor;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public String getCopyright() {
            return this.copyright;
        }

        public void setCopyright(String copyright) {
            this.copyright = copyright;
        }

        public List<String> getFileAssociations() {
            return this.fileAssociations;
        }

        public void setFileAssociations(List<String> fileAssociations) {
            this.fileAssociations.clear();
            this.fileAssociations.addAll(fileAssociations);
        }

        public String getLicenseFile() {
            return this.licenseFile;
        }

        public void setLicenseFile(String licenseFile) {
            this.licenseFile = licenseFile;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("appName", this.appName);
            props.put("appVersion", this.appVersion);
            props.put("copyright", this.copyright);
            props.put("vendor", this.vendor);
            props.put("licenseFile", this.licenseFile);
            props.put("fileAssociations", this.fileAssociations);
            return props;
        }
    }

    public static abstract class AbstractPlatformPackager<S extends AbstractPlatformPackager<S>>
    extends AbstractModelObject<S>
    implements PlatformPackager {
        private static final long serialVersionUID = 8350662398551017463L;
        private final org.jreleaser.model.internal.common.Artifact jdk = new org.jreleaser.model.internal.common.Artifact();
        private final List<String> types = new ArrayList<String>();
        private final List<String> validTypes = new ArrayList<String>();
        private final String platform;
        @JsonIgnore
        private boolean enabled;
        private String appName;
        private String icon;
        private String installDir;
        private String resourceDir;
        private Boolean launcherAsService;

        protected AbstractPlatformPackager(String platform, List<String> validTypes) {
            this.platform = platform;
            this.validTypes.addAll(validTypes);
        }

        @Override
        public void merge(S source) {
            this.icon = this.merge(this.icon, ((AbstractPlatformPackager)source).getIcon());
            this.appName = this.merge(this.appName, ((AbstractPlatformPackager)source).getAppName());
            this.enabled = this.merge(this.enabled, ((AbstractPlatformPackager)source).isEnabled());
            this.installDir = this.merge(this.installDir, ((AbstractPlatformPackager)source).getInstallDir());
            this.resourceDir = this.merge(this.resourceDir, ((AbstractPlatformPackager)source).getResourceDir());
            this.launcherAsService = this.merge(this.launcherAsService, ((AbstractPlatformPackager)source).isLauncherAsService());
            this.setJdk(((AbstractPlatformPackager)source).getJdk());
            this.setTypes(this.merge(this.types, ((AbstractPlatformPackager)source).getTypes()));
        }

        @Override
        public String getResolvedAppName(JReleaserContext context, JpackageAssembler jpackage) {
            TemplateContext props = context.getModel().props();
            props.setAll(jpackage.props());
            return Templates.resolveTemplate((String)this.appName, (TemplateContext)props);
        }

        @Override
        public String getAppName() {
            return this.appName;
        }

        @Override
        public void setAppName(String appName) {
            this.appName = appName;
        }

        @Override
        public String getIcon() {
            return this.icon;
        }

        @Override
        public void setIcon(String icon) {
            this.icon = icon;
        }

        @Override
        public List<String> getValidTypes() {
            return this.validTypes;
        }

        @Override
        public String getPlatform() {
            return this.platform;
        }

        @Override
        public String getResourceDir() {
            return this.resourceDir;
        }

        @Override
        public void setResourceDir(String resourceDir) {
            this.resourceDir = resourceDir;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void enable() {
            this.enabled = true;
        }

        @Override
        public void disable() {
            this.enabled = false;
        }

        @Override
        public org.jreleaser.model.internal.common.Artifact getJdk() {
            return this.jdk;
        }

        @Override
        public void setJdk(org.jreleaser.model.internal.common.Artifact jdk) {
            this.jdk.merge(jdk);
        }

        @Override
        public List<String> getTypes() {
            return this.types;
        }

        @Override
        public void setTypes(List<String> types) {
            this.types.clear();
            this.types.addAll(types);
        }

        @Override
        public String getInstallDir() {
            return this.installDir;
        }

        @Override
        public void setInstallDir(String installDir) {
            this.installDir = installDir;
        }

        @Override
        public boolean isLauncherAsService() {
            return null != this.launcherAsService && this.launcherAsService != false;
        }

        @Override
        public void setLauncherAsService(Boolean launcherAsService) {
            this.launcherAsService = launcherAsService;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("appName", this.appName);
            props.put("icon", this.icon);
            props.put("resourceDir", this.resourceDir);
            props.put("types", this.types);
            props.put("jdk", this.jdk.asMap(full));
            props.put("installDir", this.installDir);
            props.put("launcherAsService", this.isLauncherAsService());
            this.asMap(full, props);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.platform, props);
            return map;
        }

        protected abstract void asMap(boolean var1, Map<String, Object> var2);
    }

    public static interface PlatformPackager
    extends Domain {
        public String getAppName();

        public void setAppName(String var1);

        public String getResolvedAppName(JReleaserContext var1, JpackageAssembler var2);

        public String getIcon();

        public void setIcon(String var1);

        public List<String> getValidTypes();

        public String getPlatform();

        public boolean isEnabled();

        public void enable();

        public void disable();

        public org.jreleaser.model.internal.common.Artifact getJdk();

        public void setJdk(org.jreleaser.model.internal.common.Artifact var1);

        public List<String> getTypes();

        public void setTypes(List<String> var1);

        public String getInstallDir();

        public void setInstallDir(String var1);

        public String getResourceDir();

        public void setResourceDir(String var1);

        public boolean isLauncherAsService();

        public void setLauncherAsService(Boolean var1);
    }
}

