/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.swid.SwidTag;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.util.VersionUtils;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.ChecksumUtils;
import org.jreleaser.version.SemanticVersion;
import org.jreleaser.version.Version;

public final class SwidTagGenerator {
    private SwidTagGenerator() {
    }

    public static void generateTag(JReleaserContext context, Path archiveDirectory, SwidTag tag) throws IOException {
        SoftwareIdentity softwareIdentity = SwidTagGenerator.createSoftwareIdentity(context, tag);
        SwidTagGenerator.addEntities(softwareIdentity, tag);
        SwidTagGenerator.addPayload(context, softwareIdentity, tag, archiveDirectory);
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + xmlMapper.writeValueAsString((Object)softwareIdentity);
        Path tagFile = archiveDirectory.resolve(tag.getPath()).resolve(tag.getName() + ".xml");
        Files.createDirectories(tagFile.getParent(), new FileAttribute[0]);
        Files.write(tagFile, xml.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static SoftwareIdentity createSoftwareIdentity(JReleaserContext context, SwidTag tag) {
        SoftwareIdentity o = new SoftwareIdentity();
        Project project = context.getModel().getProject();
        o.setName(project.getName());
        o.setTagId(tag.getTagId());
        o.setTagVersion(tag.getTagVersion().toString());
        o.setVersion(project.getResolvedVersion());
        o.setCorpus(tag.getCorpus());
        o.setPatch(tag.getPatch());
        o.setLang(tag.getLang());
        Pattern versionPattern = VersionUtils.resolveVersionPattern((JReleaserContext)context);
        Version version = VersionUtils.version((JReleaserContext)context, (String)project.getResolvedVersion(), (Pattern)versionPattern);
        if (version instanceof SemanticVersion) {
            o.setVersionScheme("semver");
        } else {
            o.setVersionScheme("alphanumeric");
        }
        return o;
    }

    private static void addEntities(SoftwareIdentity softwareIdentity, SwidTag tag) {
        tag.getEntities().stream().map(e -> {
            Entity o = new Entity();
            o.setName(e.getName());
            o.setRegid(e.getRegid());
            o.setRole(String.join((CharSequence)" ", e.getRoles()));
            return o;
        }).forEach(softwareIdentity.getEntities()::add);
    }

    private static void addPayload(JReleaserContext context, SoftwareIdentity softwareIdentity, SwidTag tag, Path inputPath) throws IOException {
        FileTagger tagger = new FileTagger(context.getLogger());
        Files.walkFileTree(inputPath, tagger);
        if (!tagger.isSuccessful()) {
            throw new IOException(RB.$((String)"ERROR_swid_generator", (Object[])new Object[]{inputPath}));
        }
        softwareIdentity.getPayload().getDirectories().add(tagger.getRoot());
    }

    public static class SoftwareIdentity {
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="Entity")
        private Set<Entity> entities = new TreeSet<Entity>();
        @JacksonXmlProperty(localName="Payload")
        private Payload payload = new Payload();
        @JacksonXmlProperty(isAttribute=true)
        private Boolean corpus;
        @JacksonXmlProperty(isAttribute=true)
        private Boolean patch;
        @JacksonXmlProperty(isAttribute=true)
        private String name;
        @JacksonXmlProperty(isAttribute=true)
        private String tagId;
        @JacksonXmlProperty(isAttribute=true)
        private String tagVersion;
        @JacksonXmlProperty(isAttribute=true)
        private String version;
        @JacksonXmlProperty(isAttribute=true)
        private String versionScheme;
        @JacksonXmlProperty(isAttribute=true, localName="xml:lang")
        private String lang = "en-US";
        @JacksonXmlProperty(isAttribute=true)
        private String xmlns = "http://standards.iso.org/iso/19770/-2/2015/schema.xsd";

        public String getXmlns() {
            return this.xmlns;
        }

        public void setXmlns(String xmlns) {
            this.xmlns = xmlns;
        }

        public Set<Entity> getEntities() {
            return this.entities;
        }

        public void setEntities(Set<Entity> entities) {
            this.entities = entities;
        }

        public Payload getPayload() {
            return this.payload;
        }

        public void setPayload(Payload payload) {
            this.payload = payload;
        }

        public Boolean isCorpus() {
            return this.corpus;
        }

        public void setCorpus(Boolean corpus) {
            this.corpus = corpus;
        }

        public Boolean isPatch() {
            return this.patch;
        }

        public void setPatch(Boolean patch) {
            this.patch = patch;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTagId() {
            return this.tagId;
        }

        public void setTagId(String tagId) {
            this.tagId = tagId;
        }

        public String getTagVersion() {
            return this.tagVersion;
        }

        public void setTagVersion(String tagVersion) {
            this.tagVersion = tagVersion;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getVersionScheme() {
            return this.versionScheme;
        }

        public void setVersionScheme(String versionScheme) {
            this.versionScheme = versionScheme;
        }

        public String getLang() {
            return this.lang;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }
    }

    private static class FileTagger
    implements FileVisitor<Path> {
        private final JReleaserLogger logger;
        private final Deque<Directory> directories = new ArrayDeque<Directory>();
        private Directory root = new Directory();
        private boolean success = true;

        private FileTagger(JReleaserLogger logger) {
            this.logger = logger;
        }

        public Directory getRoot() {
            return this.root;
        }

        public boolean isSuccessful() {
            return this.success;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Directory d = new Directory();
            d.setName(dir.getFileName().toString());
            if (this.directories.isEmpty()) {
                this.root = d;
            } else {
                this.directories.peek().getDirectories().add(d);
            }
            this.directories.addFirst(d);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            this.directories.removeFirst();
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            File f = new File();
            f.setName(file.getFileName().toString());
            f.setSize(Files.size(file));
            byte[] data = Files.readAllBytes(file);
            f.setSha256(ChecksumUtils.checksum((Algorithm)Algorithm.SHA_256, (byte[])data));
            f.setSha512(ChecksumUtils.checksum((Algorithm)Algorithm.SHA_512, (byte[])data));
            this.directories.peek().getFiles().add(f);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
            if (e instanceof FileSystemLoopException) {
                this.logger.error(RB.$((String)"ERROR_files_cycle", (Object[])new Object[0]), new Object[]{file});
            } else {
                this.logger.error(RB.$((String)"ERROR_files_read", (Object[])new Object[0]), new Object[]{file, e});
            }
            this.success = false;
            return FileVisitResult.CONTINUE;
        }
    }

    public static class Payload
    extends ResourceCollection {
        @JacksonXmlProperty(isAttribute=true, localName="xmlns:SHA-256")
        private String sha256 = "http://www.w3.org/2001/04/xmlenc#sha256";
        @JacksonXmlProperty(isAttribute=true, localName="xmlns:SHA-512")
        private String sha512 = "http://www.w3.org/2001/04/xmlenc#sha512";

        public String getSha256() {
            return this.sha256;
        }

        public void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        public String getSha512() {
            return this.sha512;
        }

        public void setSha512(String sha512) {
            this.sha512 = sha512;
        }
    }

    public static class Directory
    extends FileSystemItem {
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="Directory")
        private Set<Directory> directories = new TreeSet<Directory>();
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="File")
        private Set<File> files = new TreeSet<File>();

        public Set<Directory> getDirectories() {
            return this.directories;
        }

        public void setDirectories(Set<Directory> directories) {
            this.directories = directories;
        }

        public Set<File> getFiles() {
            return this.files;
        }

        public void setFiles(Set<File> files) {
            this.files = files;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Directory directory = (Directory)o;
            return this.directories.equals(directory.directories) && this.files.equals(directory.files);
        }
    }

    public static class Entity
    implements Comparable<Entity> {
        @JacksonXmlProperty(isAttribute=true)
        private String name;
        @JacksonXmlProperty(isAttribute=true)
        private String regid;
        @JacksonXmlProperty(isAttribute=true)
        private String role;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRegid() {
            return this.regid;
        }

        public void setRegid(String regid) {
            this.regid = regid;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        @Override
        public int compareTo(Entity o) {
            return Comparator.comparing(Entity::getName).compare(this, o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entity entity = (Entity)o;
            return this.name.equals(entity.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static class File
    extends FileSystemItem {
        @JacksonXmlProperty(isAttribute=true)
        private long size;
        @JacksonXmlProperty(isAttribute=true)
        private String version;
        @JacksonXmlProperty(isAttribute=true, localName="SHA-256:hash")
        private String sha256;
        @JacksonXmlProperty(isAttribute=true, localName="SHA-512:hash")
        private String sha512;

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getSha256() {
            return this.sha256;
        }

        public void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        public String getSha512() {
            return this.sha512;
        }

        public void setSha512(String sha512) {
            this.sha512 = sha512;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            File file = (File)o;
            return this.size == file.size && this.version.equals(file.version) && this.sha256.equals(file.sha256) && this.sha512.equals(file.sha512);
        }
    }

    public static class FileSystemItem
    implements Comparable<FileSystemItem> {
        @JacksonXmlProperty(isAttribute=true)
        private Boolean key;
        @JacksonXmlProperty(isAttribute=true)
        private String location;
        @JacksonXmlProperty(isAttribute=true)
        private String name;
        @JacksonXmlProperty(isAttribute=true)
        private String root;

        public Boolean isKey() {
            return this.key;
        }

        public void setKey(Boolean key) {
            this.key = key;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRoot() {
            return this.root;
        }

        public void setRoot(String root) {
            this.root = root;
        }

        @Override
        public int compareTo(FileSystemItem o) {
            return Comparator.comparing(FileSystemItem::getName).compare(this, o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileSystemItem entity = (FileSystemItem)o;
            return this.name.equals(entity.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static abstract class ResourceCollection {
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="Directory")
        private Set<Directory> directories = new TreeSet<Directory>();
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="File")
        private Set<File> files = new TreeSet<File>();

        public Set<Directory> getDirectories() {
            return this.directories;
        }

        public void setDirectories(Set<Directory> directories) {
            this.directories = directories;
        }

        public Set<File> getFiles() {
            return this.files;
        }

        public void setFiles(Set<File> files) {
            this.files = files;
        }
    }
}

