/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.ExtensionManagerHolder;
import org.jreleaser.extensions.api.mustache.MustacheExtensionPoint;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.StringUtils;

public final class MustacheUtils {
    private MustacheUtils() {
    }

    private static Map<String, String> envVars() {
        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
        System.getenv().forEach((k, v) -> {
            if (!k.startsWith("JRELEASER_")) {
                vars.put("Env." + k, (String)v);
            }
        });
        return vars;
    }

    public static String applyTemplate(Reader reader, TemplateContext context, String templateName) {
        StringWriter input = new StringWriter();
        MyMustacheFactory mf = new MyMustacheFactory();
        Mustache mustache = mf.compile(reader, templateName);
        context.setAll(MustacheUtils.envVars());
        MustacheUtils.applyFunctions(context);
        mustache.execute((Writer)input, MustacheUtils.decorate(context.asMap()));
        input.flush();
        return input.toString();
    }

    private static Map<String, Object> decorate(Map<String, Object> context) {
        for (Map.Entry entry : new LinkedHashSet<Map.Entry<String, Object>>(context.entrySet())) {
            String val;
            Object value = entry.getValue();
            if (!(value instanceof CharSequence) || !(val = String.valueOf(value)).contains("{{")) continue;
            context.put((String)entry.getKey(), s -> val);
        }
        return context;
    }

    public static String applyTemplate(Reader reader, TemplateContext context) {
        return MustacheUtils.applyTemplate(reader, context, UUID.randomUUID().toString()).trim();
    }

    public static String applyTemplate(String template, TemplateContext context, String templateName) {
        return MustacheUtils.applyTemplate(new StringReader(template), context, templateName);
    }

    public static String applyTemplate(String template, TemplateContext context) {
        return MustacheUtils.applyTemplate(new StringReader(template), context, UUID.randomUUID().toString()).trim();
    }

    public static void applyTemplates(Map<String, Object> props, TemplateContext templates) {
        MustacheUtils.applyTemplates(new TemplateContext(props), templates);
    }

    public static void applyTemplates(TemplateContext props, Map<String, Object> templates) {
        for (Map.Entry entry : new LinkedHashSet<Map.Entry<String, Object>>(templates.entrySet())) {
            String val;
            Object value = entry.getValue();
            if (value instanceof CharSequence && (val = String.valueOf(value)).contains("{{") && val.contains("}}")) {
                value = MustacheUtils.applyTemplate(val, props);
            }
            props.set((String)entry.getKey(), value);
        }
    }

    public static void applyTemplates(TemplateContext props, TemplateContext templates) {
        for (Map.Entry entry : new LinkedHashSet<Map.Entry<String, Object>>(templates.entries())) {
            String val;
            Object value = entry.getValue();
            if (value instanceof CharSequence && (val = String.valueOf(value)).contains("{{") && val.contains("}}")) {
                value = MustacheUtils.applyTemplate(val, props);
            }
            props.set((String)entry.getKey(), value);
        }
    }

    public static String passThrough(String str) {
        return StringUtils.isNotBlank((String)str) ? "!!" + str + "!!" : str;
    }

    private static void applyFunctions(TemplateContext props) {
        ExtensionManagerHolder.get().findExtensionPoints(MustacheExtensionPoint.class).forEach(ep -> ep.apply(props));
    }

    private static class MyMustacheFactory
    extends DefaultMustacheFactory {
        private MyMustacheFactory() {
        }

        public void encode(String value, Writer writer) {
            if (value.startsWith("!!") && value.endsWith("!!")) {
                try {
                    writer.write(value.substring(2, value.length() - 2));
                }
                catch (IOException e) {
                    throw new MustacheException(RB.$((String)"ERROR_mustache_write_value", (Object[])new Object[]{value}), (Throwable)e);
                }
            } else {
                super.encode(value, writer);
            }
        }
    }
}

