/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.Token;

public class FloatValues
extends TokenRule {
    public static final String OPTION_REQUIRE_NUMERAL_BEFORE_DECIMAL = "require-numeral-before-decimal";
    public static final String OPTION_FORBID_SCIENTIFIC_NOTATION = "forbid-scientific-notation";
    public static final String OPTION_FORBID_NAN = "forbid-nan";
    public static final String OPTION_FORBID_INF = "forbid-inf";

    public FloatValues() {
        this.registerOption(OPTION_REQUIRE_NUMERAL_BEFORE_DECIMAL, false);
        this.registerOption(OPTION_FORBID_SCIENTIFIC_NOTATION, false);
        this.registerOption(OPTION_FORBID_NAN, false);
        this.registerOption(OPTION_FORBID_INF, false);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (prev instanceof TagToken || !(token instanceof ScalarToken) || ((ScalarToken)token).getStyle().getChar() != null) {
            return problems;
        }
        String val = ((ScalarToken)token).getValue();
        if (((Boolean)conf.get(OPTION_FORBID_NAN)).booleanValue() && val.matches("(\\.nan|\\.NaN|\\.NAN)$")) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, String.format("forbidden not a number value \"%s\"", val)));
        }
        if (((Boolean)conf.get(OPTION_FORBID_INF)).booleanValue() && val.matches("[-+]?(\\.inf|\\.Inf|\\.INF)$")) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, String.format("forbidden infinite value \"%s\"", val)));
        }
        if (((Boolean)conf.get(OPTION_FORBID_SCIENTIFIC_NOTATION)).booleanValue() && val.matches("[-+]?(\\.\\d+|\\d+(\\.\\d*)?)([eE][-+]?\\d+)$")) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, String.format("forbidden scientific notation \"%s\"", val)));
        }
        if (((Boolean)conf.get(OPTION_REQUIRE_NUMERAL_BEFORE_DECIMAL)).booleanValue() && val.matches("[-+]?(\\.\\d+)([eE][-+]?\\d+)?$")) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, String.format("forbidden decimal missing 0 prefix \"%s\"", val)));
        }
        return problems;
    }
}

