/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.jreleaser.model.JReleaserOutput;
import org.jreleaser.util.IoUtils;

final class Banner {
    private static final Banner INSTANCE = new Banner();
    private final ResourceBundle bundle = ResourceBundle.getBundle(Banner.class.getName());
    private final String productVersion = this.bundle.getString("product.version");
    private final String productId = this.bundle.getString("product.id");
    private final String productName = this.bundle.getString("product.name");
    private final String message = MessageFormat.format(this.bundle.getString("product.banner"), this.productName, this.productVersion);

    private Banner() {
    }

    public static void display(PrintWriter out) {
        block7: {
            File parent;
            File markerFile;
            File dir;
            File jreleaserDir = new File(System.getProperty("user.home"));
            String envJreleaserDir = System.getenv("JRELEASER_DIR");
            if (null != envJreleaserDir && !envJreleaserDir.isEmpty() && (dir = new File(envJreleaserDir)).exists()) {
                jreleaserDir = dir;
            }
            if (!(markerFile = Banner.getMarkerFile(parent = new File(jreleaserDir, "/.jreleaser/caches"), INSTANCE)).exists()) {
                if (!JReleaserOutput.isQuiet()) {
                    out.println(Banner.INSTANCE.message);
                }
                markerFile.getParentFile().mkdirs();
                Banner.writeQuietly(markerFile, "1");
            } else {
                try {
                    int count = Integer.parseInt(Banner.readQuietly(markerFile));
                    if (count < 3 && !JReleaserOutput.isQuiet()) {
                        out.println(Banner.INSTANCE.message);
                    }
                    Banner.writeQuietly(markerFile, count + 1 + "");
                }
                catch (NumberFormatException e) {
                    Banner.writeQuietly(markerFile, "1");
                    if (JReleaserOutput.isQuiet()) break block7;
                    out.println(Banner.INSTANCE.message);
                }
            }
        }
    }

    private static void writeQuietly(File file, String text) {
        try {
            PrintStream out = IoUtils.newPrintStream((OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            out.println(text);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String readQuietly(File file) {
        Scanner in = IoUtils.newScanner((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
        try {
            String string = in.next();
            if (in != null) {
                in.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception ignored) {
                return "";
            }
        }
    }

    private static File getMarkerFile(File parent, Banner b) {
        return new File(parent, "jreleaser" + File.separator + b.productId + File.separator + b.productVersion + File.separator + "marker.txt");
    }
}

