/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Jbang;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class JbangValidator
extends Validator {
    public static void validateJbang(JReleaserContext context, Distribution distribution, Jbang tool, Errors errors) {
        JReleaserModel model = context.getModel();
        Jbang parentTool = model.getPackagers().getJbang();
        if (!tool.isActiveSet() && parentTool.isActiveSet()) {
            tool.setActive(parentTool.getActive());
        }
        if (!tool.resolveEnabled(context.getModel().getProject(), distribution)) {
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            tool.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.jbang", new Object[]{distribution.getName()});
        JbangValidator.validateCommitAuthor(tool, parentTool);
        Jbang.JbangCatalog catalog = tool.getCatalog();
        catalog.resolveEnabled(model.getProject());
        JbangValidator.validateTap(context, distribution, catalog, parentTool.getCatalog(), "jbang.catalog");
        TemplateValidator.validateTemplate(context, distribution, tool, parentTool, errors);
        ExtraPropertiesValidator.mergeExtraProperties(tool, parentTool);
        JbangValidator.validateContinueOnError(tool, parentTool);
        if (StringUtils.isBlank((String)tool.getAlias())) {
            tool.setAlias(distribution.getExecutable());
        }
        if (model.getProject().getExtraProperties().containsKey("reverseRepoHost") && !parentTool.getExtraProperties().containsKey("reverseRepoHost")) {
            parentTool.getExtraProperties().put("reverseRepoHost", model.getProject().getExtraProperties().get("reverseRepoHost"));
        }
        if (parentTool.getExtraProperties().containsKey("reverseRepoHost") && !distribution.getExtraProperties().containsKey("reverseRepoHost")) {
            distribution.getExtraProperties().put("reverseRepoHost", parentTool.getExtraProperties().get("reverseRepoHost"));
        }
        if (distribution.getExtraProperties().containsKey("reverseRepoHost") && !tool.getExtraProperties().containsKey("reverseRepoHost")) {
            tool.getExtraProperties().put("reverseRepoHost", distribution.getExtraProperties().get("reverseRepoHost"));
        }
        if (StringUtils.isBlank((String)service.getReverseRepoHost()) && !tool.getExtraProperties().containsKey("reverseRepoHost")) {
            errors.configuration(RB.$((String)"validation_jbang_reverse_host", (Object[])new Object[]{distribution.getName(), "reverseRepoHost"}));
        }
        if (StringUtils.isBlank((String)distribution.getJava().getMainClass())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution." + distribution.getName() + ".java.mainClass"}));
        }
    }

    public static void postValidateJBang(JReleaserContext context, Errors errors) {
        Map<String, List<Distribution>> map = context.getModel().getDistributions().values().stream().filter(d -> d.isEnabled() && d.getJbang().isEnabled()).collect(Collectors.groupingBy(d -> d.getJbang().getAlias()));
        map.forEach((alias, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration(RB.$((String)"validation_jbang_multiple_definition", (Object[])new Object[]{alias, distributions.stream().map(Distribution::getName).collect(Collectors.joining(", "))}));
            }
        });
    }
}

