/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Domain;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Java;
import org.jreleaser.model.VersionPattern;
import org.jreleaser.util.CalVer;
import org.jreleaser.util.Env;
import org.jreleaser.util.JavaModuleVersion;
import org.jreleaser.util.JavaRuntimeVersion;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

public class Project
implements Domain,
ExtraProperties {
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String PROJECT_VERSION = "PROJECT_VERSION";
    public static final String PROJECT_VERSION_PATTERN = "PROJECT_VERSION_PATTERN";
    public static final String PROJECT_SNAPSHOT_PATTERN = "PROJECT_SNAPSHOT_PATTERN";
    public static final String PROJECT_SNAPSHOT_LABEL = "PROJECT_SNAPSHOT_LABEL";
    public static final String PROJECT_SNAPSHOT_FULL_CHANGELOG = "PROJECT_SNAPSHOT_FULL_CHANGELOG";
    public static final String DEFAULT_SNAPSHOT_PATTERN = ".*-SNAPSHOT";
    public static final String DEFAULT_SNAPSHOT_LABEL = "early-access";
    private final List<String> authors = new ArrayList<String>();
    private final List<String> tags = new ArrayList<String>();
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Java java = new Java();
    private final Snapshot snapshot = new Snapshot();
    private String name;
    private String version;
    private VersionPattern versionPattern = new VersionPattern();
    private String description;
    private String longDescription;
    private String website;
    private String license;
    private String licenseUrl;
    private String copyright;
    private String vendor;
    private String docsUrl;

    void setAll(Project project) {
        this.name = project.name;
        this.version = project.version;
        this.versionPattern = project.versionPattern;
        this.description = project.description;
        this.longDescription = project.longDescription;
        this.website = project.website;
        this.license = project.license;
        this.licenseUrl = project.licenseUrl;
        this.copyright = project.copyright;
        this.vendor = project.vendor;
        this.docsUrl = project.docsUrl;
        this.setJava(project.java);
        this.setSnapshot(project.snapshot);
        this.setAuthors(project.authors);
        this.setTags(project.tags);
        this.setExtraProperties(project.extraProperties);
    }

    @Override
    public String getPrefix() {
        return "project";
    }

    public String getEffectiveVersion() {
        if (this.isSnapshot()) {
            return this.getSnapshot().getEffectiveLabel();
        }
        return this.getResolvedVersion();
    }

    public boolean isSnapshot() {
        return this.snapshot.isSnapshot(this.getResolvedVersion());
    }

    public boolean isRelease() {
        return !this.isSnapshot();
    }

    public String getResolvedName() {
        return Env.resolve((String)PROJECT_NAME, (String)this.name);
    }

    public String getResolvedVersion() {
        String resolvedVersion = Env.resolve((String)PROJECT_VERSION, (String)this.version);
        return StringUtils.isNotBlank((String)resolvedVersion) ? resolvedVersion : "";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersionPattern() {
        return this.versionPattern != null ? this.versionPattern.toString() : "";
    }

    public void setVersionPattern(VersionPattern versionPattern) {
        this.versionPattern = versionPattern;
    }

    public void setVersionPattern(String str) {
        this.versionPattern = VersionPattern.of(str);
    }

    public VersionPattern versionPattern() {
        return this.versionPattern;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot.setAll(snapshot);
    }

    @Deprecated
    public String getSnapshotPattern() {
        return this.snapshot.getPattern();
    }

    @Deprecated
    public void setSnapshotPattern(String snapshotPattern) {
        System.out.println("project.snapshotPattern has been deprecated since 0.6.0 and will be removed in the future. Use project.snapshot.pattern instead");
        this.snapshot.setPattern(snapshotPattern);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getDocsUrl() {
        return this.docsUrl;
    }

    public void setDocsUrl(String docsUrl) {
        this.docsUrl = docsUrl;
    }

    public Java getJava() {
        return this.java;
    }

    public void setJava(Java java) {
        this.java.setAll(java);
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors.clear();
        this.authors.addAll(authors);
    }

    public void addAuthors(List<String> authors) {
        this.authors.addAll(authors);
    }

    public void addAuthor(String author) {
        if (StringUtils.isNotBlank((String)author)) {
            this.authors.add(author.trim());
        }
    }

    public void removeAuthor(String author) {
        if (StringUtils.isNotBlank((String)author)) {
            this.authors.remove(author.trim());
        }
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    public void addTags(List<String> tags) {
        this.tags.addAll(tags);
    }

    public void addTag(String tag) {
        if (StringUtils.isNotBlank((String)tag)) {
            this.tags.add(tag.trim());
        }
    }

    public void removeTag(String tag) {
        if (StringUtils.isNotBlank((String)tag)) {
            this.tags.remove(tag.trim());
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", this.name);
        map.put("version", this.version);
        map.put("versionPattern", this.versionPattern);
        map.put("snapshot", this.snapshot.asMap(full));
        map.put("description", this.description);
        map.put("longDescription", this.longDescription);
        map.put("website", this.website);
        map.put("docsUrl", this.docsUrl);
        map.put("license", this.license);
        map.put("licenseUrl", this.licenseUrl);
        map.put("copyright", this.copyright);
        map.put("vendor", this.vendor);
        map.put("authors", this.authors);
        map.put("tags", this.tags);
        map.put("extraProperties", this.getResolvedExtraProperties());
        if (this.java.isEnabled()) {
            map.put("java", this.java.asMap(full));
        }
        return map;
    }

    public void parseVersion() {
        String v = this.getResolvedVersion();
        if (StringUtils.isBlank((String)v)) {
            return;
        }
        switch (this.versionPattern().getType()) {
            case SEMVER: {
                Version parsedVersion;
                try {
                    parsedVersion = Version.of((String)v);
                    StringBuilder vn = new StringBuilder().append(parsedVersion.getMajor());
                    this.addExtraProperty("versionMajor", parsedVersion.getMajor());
                    if (parsedVersion.hasMinor()) {
                        vn.append(".").append(parsedVersion.getMinor());
                        this.addExtraProperty("versionMinor", parsedVersion.getMinor());
                    }
                    if (parsedVersion.hasPatch()) {
                        vn.append(".").append(parsedVersion.getPatch());
                        this.addExtraProperty("versionPatch", parsedVersion.getPatch());
                    }
                    this.addExtraProperty("versionNumber", vn.toString());
                    if (parsedVersion.hasTag()) {
                        this.addExtraProperty("versionTag", parsedVersion.getTag());
                    }
                    if (!parsedVersion.hasBuild()) break;
                    this.addExtraProperty("versionBuild", parsedVersion.getBuild());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "semver"}), e);
                }
            }
            case JAVA_RUNTIME: {
                Version parsedVersion;
                try {
                    parsedVersion = JavaRuntimeVersion.of((String)v);
                    this.addExtraProperty("versionNumber", parsedVersion.getVersion());
                    if (parsedVersion.hasPrerelease()) {
                        this.addExtraProperty("versionPrerelease", parsedVersion.getPrerelease());
                    }
                    if (parsedVersion.hasBuild()) {
                        this.addExtraProperty("versionBuild", parsedVersion.getBuild());
                    }
                    if (!parsedVersion.hasOptional()) break;
                    this.addExtraProperty("versionOptional", parsedVersion.getOptional());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "Java runtime"}), e);
                }
            }
            case JAVA_MODULE: {
                Version parsedVersion;
                try {
                    parsedVersion = JavaModuleVersion.of((String)v);
                    this.addExtraProperty("versionNumber", parsedVersion.getVersion());
                    if (parsedVersion.hasPrerelease()) {
                        this.addExtraProperty("versionPrerelease", parsedVersion.getPrerelease());
                    }
                    if (!parsedVersion.hasBuild()) break;
                    this.addExtraProperty("versionBuild", parsedVersion.getBuild());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "Java module"}), e);
                }
            }
            case CALVER: {
                Version parsedVersion;
                try {
                    parsedVersion = CalVer.of((String)this.versionPattern().getFormat(), (String)v);
                    this.addExtraProperty("versionNumber", v);
                    this.addExtraProperty("versionYear", parsedVersion.getYear());
                    if (parsedVersion.hasMonth()) {
                        this.addExtraProperty("versionMonth", parsedVersion.getMonth());
                    }
                    if (parsedVersion.hasDay()) {
                        this.addExtraProperty("versionDay", parsedVersion.getDay());
                    }
                    if (parsedVersion.hasWeek()) {
                        this.addExtraProperty("versionWeek", parsedVersion.getWeek());
                    }
                    if (parsedVersion.hasMinor()) {
                        this.addExtraProperty("versionMinor", parsedVersion.getMinor());
                    }
                    if (parsedVersion.hasMicro()) {
                        this.addExtraProperty("versionMicro", parsedVersion.getMicro());
                    }
                    if (parsedVersion.hasModifier()) {
                        this.addExtraProperty("versionModifier", parsedVersion.getModifier());
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "calver"}), e);
                }
            }
            default: {
                this.addExtraProperty("versionNumber", v);
            }
        }
        String vn = (String)this.getExtraProperties().get("versionNumber");
        String ev = this.getEffectiveVersion();
        this.addExtraProperty("versionWithUnderscores", new MustacheUtils.UnderscoreFunction().apply(v));
        this.addExtraProperty("versionWithDashes", new MustacheUtils.DashFunction().apply(v));
        this.addExtraProperty("versionNumberWithUnderscores", new MustacheUtils.UnderscoreFunction().apply(vn));
        this.addExtraProperty("versionNumberWithDashes", new MustacheUtils.DashFunction().apply(vn));
        if (StringUtils.isNotBlank((String)ev)) {
            this.addExtraProperty("effectiveVersionWithUnderscores", new MustacheUtils.UnderscoreFunction().apply(ev));
            this.addExtraProperty("effectiveVersionWithDashes", new MustacheUtils.DashFunction().apply(ev));
        }
    }

    public static class Snapshot
    implements Domain {
        private Boolean enabled;
        private String pattern;
        private String label;
        private Boolean fullChangelog;
        private String cachedLabel;

        void setAll(Snapshot snapshot) {
            this.enabled = snapshot.enabled;
            this.pattern = snapshot.pattern;
            this.label = snapshot.label;
            this.fullChangelog = snapshot.fullChangelog;
        }

        public boolean isSnapshot(String version) {
            if (null == this.enabled) {
                this.enabled = version.matches(this.getResolvedPattern());
            }
            return this.enabled;
        }

        public String getConfiguredPattern() {
            return Env.resolve((String)Project.PROJECT_SNAPSHOT_PATTERN, (String)this.pattern);
        }

        public String getResolvedPattern() {
            this.pattern = this.getConfiguredPattern();
            if (StringUtils.isBlank((String)this.pattern)) {
                this.pattern = Project.DEFAULT_SNAPSHOT_PATTERN;
            }
            return this.pattern;
        }

        public String getConfiguredLabel() {
            return Env.resolve((String)Project.PROJECT_SNAPSHOT_LABEL, (String)this.label);
        }

        public String getResolvedLabel(JReleaserModel model) {
            if (StringUtils.isBlank((String)this.cachedLabel)) {
                this.cachedLabel = this.getConfiguredLabel();
            }
            if (StringUtils.isBlank((String)this.cachedLabel)) {
                this.cachedLabel = MustacheUtils.applyTemplate((String)this.label, this.props(model));
            } else if (this.cachedLabel.contains("{{")) {
                this.cachedLabel = MustacheUtils.applyTemplate((String)this.cachedLabel, this.props(model));
            }
            return this.cachedLabel;
        }

        public String getEffectiveLabel() {
            return this.cachedLabel;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public Boolean getFullChangelog() {
            return this.fullChangelog;
        }

        public boolean isFullChangelog() {
            return this.fullChangelog != null && this.fullChangelog != false;
        }

        public void setFullChangelog(Boolean fullChangelog) {
            this.fullChangelog = fullChangelog;
        }

        public boolean isFullChangelogSet() {
            return this.fullChangelog != null;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.enabled);
            map.put("pattern", this.getConfiguredPattern());
            map.put("label", this.getConfiguredLabel());
            map.put("fullChangelog", this.isFullChangelog());
            return map;
        }

        public Map<String, Object> props(JReleaserModel model) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            Project project = model.getProject();
            props.putAll(model.getEnvironment().getProperties());
            props.put("projectName", project.getName());
            props.put("projectNameCapitalized", StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)project.getName()));
            props.put("projectVersion", project.getVersion());
            props.put("projectSnapshot", String.valueOf(project.isSnapshot()));
            if (StringUtils.isNotBlank((String)project.getDescription())) {
                props.put("projectDescription", MustacheUtils.passThrough((String)project.getDescription()));
            }
            if (StringUtils.isNotBlank((String)project.getLongDescription())) {
                props.put("projectLongDescription", MustacheUtils.passThrough((String)project.getLongDescription()));
            }
            if (StringUtils.isNotBlank((String)project.getWebsite())) {
                props.put("projectWebsite", project.getWebsite());
            }
            if (StringUtils.isNotBlank((String)project.getLicense())) {
                props.put("projectLicense", project.getLicense());
            }
            if (StringUtils.isNotBlank((String)project.getLicense())) {
                props.put("projectLicenseUrl", project.getLicenseUrl());
            }
            if (StringUtils.isNotBlank((String)project.getDocsUrl())) {
                props.put("projectDocsUrl", project.getDocsUrl());
            }
            if (StringUtils.isNotBlank((String)project.getCopyright())) {
                props.put("projectCopyright", project.getCopyright());
            }
            if (StringUtils.isNotBlank((String)project.getVendor())) {
                props.put("projectVendor", project.getVendor());
            }
            if (project.getJava().isEnabled()) {
                props.putAll(project.getJava().getResolvedExtraProperties());
                props.put("projectJavaGroupId", project.getJava().getGroupId());
                props.put("projectJavaArtifactId", project.getJava().getArtifactId());
                props.put("projectJavaVersion", project.getJava().getVersion());
                props.put("projectJavaMainClass", project.getJava().getMainClass());
                Version jv = Version.of((String)project.getJava().getVersion());
                props.put("projectJavaVersionMajor", jv.getMajor());
                if (jv.hasMinor()) {
                    props.put("projectJavaVersionMinor", jv.getMinor());
                }
                if (jv.hasPatch()) {
                    props.put("projectJavaVersionPatch", jv.getPatch());
                }
                if (jv.hasTag()) {
                    props.put("projectJavaVersionTag", jv.getTag());
                }
                if (jv.hasBuild()) {
                    props.put("projectJavaVersionBuild", jv.getBuild());
                }
            }
            project.parseVersion();
            props.putAll(project.getResolvedExtraProperties());
            String osName = PlatformUtils.getDetectedOs();
            String osArch = PlatformUtils.getDetectedArch();
            props.put("osName", osName);
            props.put("osArch", osArch);
            props.put("osVersion", PlatformUtils.getDetectedVersion());
            props.put("osPlatform", PlatformUtils.getCurrentFull());
            props.put("osPlatformReplaced", model.getPlatform().applyReplacements(PlatformUtils.getCurrentFull()));
            MustacheUtils.applyTemplates(props, project.getResolvedExtraProperties());
            props.put("__ZonedDateTime_now__", model.getNow());
            MustacheUtils.applyFunctions(props);
            return props;
        }
    }
}

