/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.assemblers.AbstractJavaAssemblerProcessor;
import org.jreleaser.assemblers.AssemblerUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JavaAssembler;
import org.jreleaser.model.Jlink;
import org.jreleaser.model.Project;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;
import org.jreleaser.util.command.Command;

public class JlinkAssemblerProcessor
extends AbstractJavaAssemblerProcessor<Jlink> {
    public JlinkAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(Map<String, Object> props) throws AssemblerProcessingException {
        Path jdkPath = ((Jlink)this.assembler).getJdk().getEffectivePath(this.context, this.assembler);
        Version jdkVersion = Version.of((String)AssemblerUtils.readJavaVersion(jdkPath));
        this.context.getLogger().debug(RB.$((String)"assembler.jlink.jdk", (Object[])new Object[0]), new Object[]{jdkVersion, jdkPath.toAbsolutePath().toString()});
        for (Artifact targetJdk : ((Jlink)this.assembler).getTargetJdks()) {
            if (!this.context.isPlatformSelected(targetJdk)) continue;
            Path targetJdkPath = targetJdk.getEffectivePath(this.context, this.assembler);
            Version targetJdkVersion = Version.of((String)AssemblerUtils.readJavaVersion(targetJdkPath));
            this.context.getLogger().debug(RB.$((String)"assembler.jlink.target", (Object[])new Object[0]), new Object[]{jdkVersion, targetJdkPath.toAbsolutePath().toString()});
            if (jdkVersion.getMajor() == targetJdkVersion.getMajor()) continue;
            throw new AssemblerProcessingException(RB.$((String)"ERROR_jlink_target_not_compatible", (Object[])new Object[]{targetJdkVersion, jdkVersion}));
        }
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        Path inputsDirectory = assembleDirectory.resolve("inputs");
        String imageName = ((Jlink)this.assembler).getResolvedImageName(this.context);
        if (StringUtils.isNotBlank((String)((Jlink)this.assembler).getImageNameTransform())) {
            imageName = ((Jlink)this.assembler).getResolvedImageNameTransform(this.context);
        }
        for (Artifact targetJdk : ((Jlink)this.assembler).getTargetJdks()) {
            if (!this.context.isPlatformSelected(targetJdk)) continue;
            String platform = targetJdk.getPlatform();
            String platformReplaced = ((Jlink)this.assembler).getPlatform().applyReplacements(platform);
            Path jarsDirectory = inputsDirectory.resolve("jars");
            Path universalJarsDirectory = jarsDirectory.resolve("universal");
            this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(universalJarsDirectory)});
            Set<Path> jars = AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, universalJarsDirectory, "");
            Path platformJarsDirectory = jarsDirectory.resolve(platform);
            this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(platformJarsDirectory)});
            jars.addAll(AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, platformJarsDirectory, platform));
            Set<String> moduleNames = this.resolveModuleNames(this.context, jdkPath, jarsDirectory, platform);
            this.context.getLogger().debug(RB.$((String)"assembler.resolved.module.names", (Object[])new Object[0]), new Object[]{moduleNames});
            if (moduleNames.isEmpty()) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_no_module_names", (Object[])new Object[0]));
            }
            moduleNames.addAll(((Jlink)this.assembler).getAdditionalModuleNames());
            if (StringUtils.isNotBlank((String)((Jlink)this.assembler).getModuleName())) {
                moduleNames.add(((Jlink)this.assembler).getModuleName());
            }
            this.context.getLogger().debug(RB.$((String)"assembler.module.names", (Object[])new Object[0]), new Object[]{moduleNames});
            String str = targetJdk.getExtraProperties().getOrDefault("archiveFormat", "ZIP").toString();
            Archive.Format archiveFormat = Archive.Format.of((String)str);
            this.jlink(assembleDirectory, jdkPath, targetJdk, moduleNames, imageName, archiveFormat);
        }
    }

    private Artifact jlink(Path assembleDirectory, Path jdkPath, Artifact targetJdk, Set<String> moduleNames, String imageName, Archive.Format archiveFormat) throws AssemblerProcessingException {
        String platform = targetJdk.getPlatform();
        String platformReplaced = ((Jlink)this.assembler).getPlatform().applyReplacements(platform);
        String finalImageName = imageName + "-" + platformReplaced;
        this.context.getLogger().info("- {}", new Object[]{finalImageName});
        Path inputsDirectory = assembleDirectory.resolve("inputs");
        Path jarsDirectory = inputsDirectory.resolve("jars");
        Path workDirectory = assembleDirectory.resolve("work-" + platform);
        Path imageDirectory = workDirectory.resolve(finalImageName).toAbsolutePath();
        try {
            FileUtils.deleteFiles((Path)imageDirectory);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_image", (Object[])new Object[]{finalImageName}), (Throwable)e);
        }
        String modulePath = targetJdk.getEffectivePath(this.context, this.assembler).resolve("jmods").toAbsolutePath().toString();
        if (StringUtils.isNotBlank((String)((Jlink)this.assembler).getModuleName()) || ((Jlink)this.assembler).isCopyJars().booleanValue()) {
            modulePath = modulePath + File.pathSeparator + jarsDirectory.resolve("universal").toAbsolutePath();
            try {
                Path platformJarsDirectory = jarsDirectory.resolve(platform).toAbsolutePath();
                if (Files.list(platformJarsDirectory).count() > 1L) {
                    modulePath = modulePath + File.pathSeparator + platformJarsDirectory;
                }
            }
            catch (IOException e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[]{e}));
            }
        }
        Command cmd = new Command(jdkPath.resolve("bin").resolve("jlink").toAbsolutePath().toString()).args((Collection)((Jlink)this.assembler).getArgs()).arg("--module-path").arg(modulePath).arg("--add-modules").arg(String.join((CharSequence)",", moduleNames));
        if (StringUtils.isNotBlank((String)((Jlink)this.assembler).getModuleName())) {
            cmd.arg("--launcher").arg(((Jlink)this.assembler).getExecutable() + "=" + ((Jlink)this.assembler).getModuleName() + "/" + ((Jlink)this.assembler).getJava().getMainClass());
        }
        cmd.arg("--output").arg(imageDirectory.toString());
        this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.executeCommandCapturing(cmd, out);
        if (StringUtils.isBlank((String)((Jlink)this.assembler).getModuleName())) {
            if (((Jlink)this.assembler).isCopyJars().booleanValue()) {
                Path outputJarsDirectory = imageDirectory.resolve("jars");
                try {
                    Files.createDirectory(outputJarsDirectory, new FileAttribute[0]);
                    FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)jarsDirectory.resolve("universal"), (Path)outputJarsDirectory);
                    FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)jarsDirectory.resolve(platform), (Path)outputJarsDirectory);
                }
                catch (IOException e) {
                    throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copy_jars", (Object[])new Object[]{this.context.relativizeToBasedir(outputJarsDirectory)}), (Throwable)e);
                }
            }
            try {
                if (PlatformUtils.isWindows((String)platform)) {
                    Files.copy(inputsDirectory.resolve(((Jlink)this.assembler).getExecutable().concat(".bat")), imageDirectory.resolve("bin").resolve(((Jlink)this.assembler).getExecutable().concat(".bat")), new CopyOption[0]);
                } else {
                    Path launcher = imageDirectory.resolve("bin").resolve(((Jlink)this.assembler).getExecutable());
                    Files.copy(inputsDirectory.resolve(((Jlink)this.assembler).getExecutable()), launcher, new CopyOption[0]);
                    FileUtils.grantExecutableAccess((Path)launcher);
                }
            }
            catch (IOException e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copy_launcher", (Object[])new Object[]{this.context.relativizeToBasedir(imageDirectory.resolve("bin"))}), (Throwable)e);
            }
        }
        try {
            Path imageArchive = assembleDirectory.resolve(finalImageName + "." + archiveFormat.extension());
            this.copyFiles(this.context, imageDirectory);
            this.copyFileSets(this.context, imageDirectory);
            switch (archiveFormat) {
                case ZIP: {
                    FileUtils.zip((Path)workDirectory, (Path)imageArchive);
                    break;
                }
                case TAR: {
                    FileUtils.tar((Path)workDirectory, (Path)imageArchive);
                    break;
                }
                case TGZ: 
                case TAR_GZ: {
                    FileUtils.tgz((Path)workDirectory, (Path)imageArchive);
                    break;
                }
                case TXZ: 
                case TAR_XZ: {
                    FileUtils.xz((Path)workDirectory, (Path)imageArchive);
                    break;
                }
                case TBZ2: 
                case TAR_BZ2: {
                    FileUtils.bz2((Path)workDirectory, (Path)imageArchive);
                }
            }
            this.context.getLogger().debug("- {}", new Object[]{imageArchive.getFileName()});
            return Artifact.of((Path)imageArchive, (String)platform);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private Set<String> resolveModuleNames(JReleaserContext context, Path jdkPath, Path jarsDirectory, String platform) throws AssemblerProcessingException {
        if (!((Jlink)this.assembler).getModuleNames().isEmpty()) {
            return ((Jlink)this.assembler).getModuleNames();
        }
        Command cmd = new Command(jdkPath.resolve("bin").resolve("jdeps").toAbsolutePath().toString());
        String multiRelease = ((Jlink)this.assembler).getJdeps().getMultiRelease();
        if (StringUtils.isNotBlank((String)multiRelease)) {
            cmd.arg("--multi-release").arg(multiRelease);
        }
        if (((Jlink)this.assembler).getJdeps().isIgnoreMissingDeps().booleanValue()) {
            cmd.arg("--ignore-missing-deps");
        }
        cmd.arg("--print-module-deps");
        if (StringUtils.isNotBlank((String)((Jlink)this.assembler).getModuleName())) {
            cmd.arg("--module").arg(((Jlink)this.assembler).getModuleName()).arg("--module-path");
        } else {
            cmd.arg("--class-path");
        }
        try {
            Files.list(jarsDirectory.resolve("universal")).map(Path::toAbsolutePath).map(Object::toString).forEach(arg_0 -> ((Command)cmd).arg(arg_0));
            Files.list(jarsDirectory.resolve(platform)).map(Path::toAbsolutePath).map(Object::toString).forEach(arg_0 -> ((Command)cmd).arg(arg_0));
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_jdeps_error", (Object[])new Object[]{e.getMessage()}));
        }
        context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.executeCommandCapturing(cmd, out);
        String output = out.toString().trim();
        long lineCount = Arrays.stream(output.split(System.lineSeparator())).map(String::trim).count();
        if (lineCount == 1L && StringUtils.isNotBlank((String)output)) {
            return Arrays.stream(output.split(",")).collect(Collectors.toSet());
        }
        throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_jdeps_error", (Object[])new Object[]{output}));
    }

    @Override
    protected void writeFile(Project project, String content, Map<String, Object> props, String fileName) throws AssemblerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputDirectory = (Path)props.get("distributionAssembleDirectory");
        Path inputsDirectory = outputDirectory.resolve("inputs");
        try {
            Files.createDirectories(inputsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_create_directories", (Object[])new Object[0]), (Throwable)e);
        }
        Path outputFile = "launcher.bat".equals(fileName) ? inputsDirectory.resolve(((Jlink)this.assembler).getExecutable().concat(".bat")) : ("launcher".equals(fileName) ? inputsDirectory.resolve(((Jlink)this.assembler).getExecutable()) : inputsDirectory.resolve(fileName));
        this.writeFile(content, outputFile);
    }
}

