/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart.axis;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.lang.reflect.Field;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.axis.Axis;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.AxisTypeProperties;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.util.ChartFont;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;

public final class YAxis
extends Axis
implements HTMLTestable {
    private float lastTickY;

    public YAxis(AxisChart axisChart, int n) {
        super(axisChart, n);
    }

    public float getLastTickY() {
        return this.lastTickY;
    }

    public void computeMinimumWidthNeeded(String string) {
        AxisTypeProperties axisTypeProperties = super.getAxisChart().getAxisProperties().getYAxisProperties();
        float f = 0.0f;
        if (axisTypeProperties.showAxisLabels()) {
            f += super.getAxisLabelsGroup().getWidestLabel();
        }
        if (axisTypeProperties.getShowTicks() != 0) {
            f += axisTypeProperties.getPaddingBetweenLabelsAndTicks();
            f += axisTypeProperties.getAxisTickMarkPixelLength();
        } else if (axisTypeProperties.showAxisLabels()) {
            f += axisTypeProperties.getPaddingBetweenAxisAndLabels();
        }
        if (string != null) {
            super.computeAxisTitleDimensions(string, axisTypeProperties.getTitleChartFont());
            f += super.getTitleHeight();
            f += axisTypeProperties.getPaddingBetweenAxisTitleAndLabels();
        }
        super.setMinimumWidthNeeded(f);
    }

    private void renderAxisTitle(String string, Graphics2D graphics2D, AxisTypeProperties axisTypeProperties) {
        if (string != null) {
            float f = super.getAxisChart().getXAxis().getOrigin() - super.getMinimumWidthNeeded() + super.getTitleHeight();
            float f2 = super.getTitleWidth() > super.getPixelLength() ? (float)super.getAxisChart().getImageHeight() - ((float)super.getAxisChart().getImageHeight() - super.getTitleWidth()) / 2.0f : this.getOrigin() - (super.getPixelLength() - super.getTitleWidth()) / 2.0f;
            graphics2D.setFont(axisTypeProperties.getAxisTitleChartFont().getFont().deriveFont(ChartFont.VERTICAL_ROTATION));
            graphics2D.setPaint(axisTypeProperties.getAxisTitleChartFont().getPaint());
            graphics2D.drawString(string, f, f2);
        }
    }

    public void render(Graphics2D graphics2D, AxisProperties axisProperties, String string) {
        DataAxisProperties dataAxisProperties;
        float f;
        Line2D.Float float_;
        AxisTypeProperties axisTypeProperties = axisProperties.getYAxisProperties();
        this.renderAxisTitle(string, graphics2D, axisProperties.getYAxisProperties());
        float f2 = 0.0f;
        if (axisTypeProperties instanceof DataAxisProperties) {
            float_ = new Line2D.Float(0.0f, super.getOrigin(), 0.0f, super.getOrigin());
            if (axisTypeProperties.showAxisLabels()) {
                f2 = super.getOrigin() + super.getAxisLabelsGroup().getTallestLabel() / 4.0f;
            }
        } else {
            f = super.getOrigin() - super.getScalePixelWidth() / 2.0f;
            float_ = new Line2D.Float(0.0f, f, 0.0f, f);
            if (axisTypeProperties.showAxisLabels()) {
                f2 = f + super.getAxisLabelsGroup().getTallestLabel() / 4.0f;
                super.getAxisLabelsGroup().reverse();
            }
        }
        f = super.getAxisChart().getXAxis().getOrigin() - axisTypeProperties.getAxisTickMarkPixelLength();
        float f3 = super.getAxisChart().getXAxis().getOrigin();
        float f4 = super.getAxisChart().getXAxis().getOrigin() + 1.0f;
        float f5 = super.getAxisChart().getXAxis().getOrigin() + super.getAxisChart().getXAxis().getPixelLength();
        float f6 = super.getAxisChart().getXAxis().getOrigin() - axisTypeProperties.getAxisTickMarkPixelLength();
        if (axisTypeProperties.showAxisLabels()) {
            f6 -= axisTypeProperties.getPaddingBetweenLabelsAndTicks();
        }
        int n = 0;
        while (n < super.getNumberOfScaleItems()) {
            if (axisTypeProperties.getShowGridLines() != 0 && (n > 0 || n == 0 && !(axisTypeProperties instanceof DataAxisProperties))) {
                float_.x1 = f4;
                float_.x2 = f5;
                if (n < super.getAxisLabelsGroup().size() || n == super.getAxisLabelsGroup().size() && !axisTypeProperties.getShowEndBorder()) {
                    axisTypeProperties.getGridLineChartStroke().draw(graphics2D, float_);
                } else {
                    axisProperties.getXAxisProperties().getAxisStroke().draw(graphics2D, float_);
                }
            }
            if (axisTypeProperties.getShowTicks() != 0) {
                float_.x1 = f;
                float_.x2 = f3;
                axisTypeProperties.getTickChartStroke().draw(graphics2D, float_);
            }
            this.lastTickY = float_.y1;
            float_.y1 -= super.getScalePixelWidth();
            float_.y2 = float_.y1;
            if (axisTypeProperties.showAxisLabels()) {
                super.getAxisLabelsGroup().render(n, graphics2D, f6 - super.getAxisLabelsGroup().getTextTag(n).getWidth(), f2);
            }
            f2 -= super.getScalePixelWidth();
            ++n;
        }
        float_.x2 = float_.x1 = super.getAxisChart().getXAxis().getOrigin();
        float_.y1 = super.getOrigin() - super.getPixelLength();
        float_.y2 = super.getOrigin();
        axisTypeProperties.getAxisStroke().draw(graphics2D, float_);
        if (axisTypeProperties.getShowEndBorder()) {
            float_.x1 = super.getAxisChart().getXAxis().getOrigin();
            float_.x2 = super.getAxisChart().getXAxis().getOrigin() + super.getAxisChart().getXAxis().getPixelLength();
            float_.y2 = float_.y1 = super.getOrigin() - super.getPixelLength();
            axisProperties.getXAxisProperties().getAxisStroke().draw(graphics2D, float_);
        }
        if (axisTypeProperties instanceof DataAxisProperties && (dataAxisProperties = (DataAxisProperties)axisTypeProperties).showZeroLine() && super.getScaleCalculator().getMinValue() < 0.0 && super.getScaleCalculator().getMaxValue() > 0.0) {
            float_.y2 = float_.y1 = super.getZeroLineCoordinate();
            float_.x1 = super.getAxisChart().getXAxis().getOrigin();
            float_.x2 = super.getAxisChart().getXAxis().getOrigin() + super.getAxisChart().getXAxis().getPixelLength();
            dataAxisProperties.getZeroLineChartStroke().draw(graphics2D, float_);
        }
    }

    public float computeAxisCoordinate(float f, double d, double d2) {
        double d3 = (double)f - (d - d2) * this.getOneUnitPixelSize();
        return (float)d3;
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        super.toHTML(hTMLGenerator);
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            try {
                hTMLGenerator.addField(fieldArray[n].getName(), fieldArray[n].get(this));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            ++n;
        }
        hTMLGenerator.propertiesTableEnd();
    }
}

