/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tree;

import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.cell.hint.IndexedCellContainer;
import com.github.weisj.darklaf.ui.tree.DarkTreeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TreeCellContainer
implements IndexedCellContainer<JTree, Integer> {
    private final JTree tree;
    private final DarkTreeUI ui;

    public TreeCellContainer(JTree tree, DarkTreeUI ui) {
        this.tree = tree;
        this.ui = ui;
    }

    @Override
    public Rectangle getCellBoundsAt(Integer position, boolean isEditing) {
        return isEditing ? this.ui.getEditingComponent().getBounds() : this.tree.getRowBounds(position);
    }

    @Override
    public Integer getCellPosition(Point p) {
        return this.tree.getClosestRowForLocation(p.x, p.y);
    }

    @Override
    public JTree getComponent() {
        return this.tree;
    }

    @Override
    public Color getBackgroundAt(Integer position, Component renderer) {
        if (position == null) {
            return null;
        }
        return CellUtil.getTreeBackground(this.tree, this.tree.isRowSelected(position), position);
    }

    @Override
    public boolean isEditingCell(Integer row) {
        return this.isEditing() && row != null && this.ui.getEditingRow() == row.intValue();
    }

    @Override
    public Component getCellRendererComponent(Integer row) {
        if (row == null) {
            return null;
        }
        TreeCellRenderer renderer = this.ui.getCellRenderer();
        TreePath path = this.tree.getPathForRow(row);
        boolean isExpanded = this.tree.isExpanded(row);
        boolean isLeaf = this.tree.getModel().isLeaf(path.getLastPathComponent());
        int leadIndex = this.tree.getLeadSelectionRow();
        return renderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, leadIndex == row);
    }

    @Override
    public Component getCellEditorComponent(Integer position) {
        return this.ui.getEditingComponent();
    }

    @Override
    public boolean isEditing() {
        return this.tree.isEditing();
    }
}

