/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;

public class TimerService {
    private TimerService() {
    }

    public static TimerService getInstance() {
        return TimerServiceHolder.INSTANCE;
    }

    public long adjustDelay(long initialDelay) {
        return this.adjustDelay(initialDelay, true);
    }

    public long adjustDelay(long initialDelay, boolean runTillEnd) {
        JMeterThread thread = JMeterContextService.getContext().getThread();
        long endTime = thread != null ? thread.getEndTime() : 0L;
        return this.adjustDelay(initialDelay, endTime, runTillEnd);
    }

    public long adjustDelay(long initialDelay, long endTime) {
        return this.adjustDelay(initialDelay, endTime, true);
    }

    public long adjustDelay(long initialDelay, long endTime, boolean runTillEnd) {
        long now;
        if (endTime > 0L && initialDelay > endTime - (now = System.currentTimeMillis())) {
            if (runTillEnd) {
                return endTime - now;
            }
            return -1L;
        }
        return initialDelay;
    }

    private static class TimerServiceHolder {
        public static final TimerService INSTANCE = new TimerService();

        private TimerServiceHolder() {
        }
    }
}

