/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet.jsr77;

import java.io.IOException;
import javax.management.j2ee.statistics.ServletStats;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.mortbay.jetty.servlet.jsr77.ServletStatsImpl;
import org.mortbay.jetty.servlet.jsr77.TimeStatisticImpl;

public class Jsr77Filter
implements Filter {
    private ServletStatsImpl servletStats = null;
    private String servletName = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletName = filterConfig.getInitParameter("servlet-name");
        this.servletStats = new ServletStatsImpl(this.servletName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long startTime = 0L;
        long endTime = 0L;
        try {
            startTime = System.currentTimeMillis();
            chain.doFilter(request, response);
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            endTime = System.currentTimeMillis();
            TimeStatisticImpl statistic = (TimeStatisticImpl)this.servletStats.getServiceTime();
            statistic.addSample(endTime - startTime, endTime);
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        TimeStatisticImpl statistic = (TimeStatisticImpl)this.servletStats.getServiceTime();
        statistic.addSample(endTime - startTime, endTime);
    }

    public ServletStats getServletStats() {
        return this.servletStats;
    }

    public void destroy() {
    }
}

