// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: google/api/http.proto

/*
	Package api is a generated protocol buffer package.

	It is generated from these files:
		google/api/http.proto
		google/api/annotations.proto

	It has these top-level messages:
		Http
		HttpRule
		CustomHttpPattern
*/
package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Defines the HTTP configuration for an API service. It contains a list of
// [HttpRule][google.api.HttpRule], each specifying the mapping of an RPC method
// to one or more HTTP REST API methods.
type Http struct {
	// A list of HTTP configuration rules that apply to individual API methods.
	//
	// **NOTE:** All service configuration rules follow "last one wins" order.
	Rules []*HttpRule `protobuf:"bytes,1,rep,name=rules" json:"rules,omitempty"`
	// When set to true, URL path parmeters will be fully URI-decoded except in
	// cases of single segment matches in reserved expansion, where "%2F" will be
	// left encoded.
	//
	// The default behavior is to not decode RFC 6570 reserved characters in multi
	// segment matches.
	FullyDecodeReservedExpansion bool `protobuf:"varint,2,opt,name=fully_decode_reserved_expansion,json=fullyDecodeReservedExpansion,proto3" json:"fully_decode_reserved_expansion,omitempty"`
}

func (m *Http) Reset()                    { *m = Http{} }
func (*Http) ProtoMessage()               {}
func (*Http) Descriptor() ([]byte, []int) { return fileDescriptorHttp, []int{0} }

func (m *Http) GetRules() []*HttpRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *Http) GetFullyDecodeReservedExpansion() bool {
	if m != nil {
		return m.FullyDecodeReservedExpansion
	}
	return false
}

// `HttpRule` defines the mapping of an RPC method to one or more HTTP
// REST API methods. The mapping specifies how different portions of the RPC
// request message are mapped to URL path, URL query parameters, and
// HTTP request body. The mapping is typically specified as an
// `google.api.http` annotation on the RPC method,
// see "google/api/annotations.proto" for details.
//
// The mapping consists of a field specifying the path template and
// method kind.  The path template can refer to fields in the request
// message, as in the example below which describes a REST GET
// operation on a resource collection of messages:
//
//
//     service Messaging {
//       rpc GetMessage(GetMessageRequest) returns (Message) {
//         option (google.api.http).get = "/v1/messages/{message_id}/{sub.subfield}";
//       }
//     }
//     message GetMessageRequest {
//       message SubMessage {
//         string subfield = 1;
//       }
//       string message_id = 1; // mapped to the URL
//       SubMessage sub = 2;    // `sub.subfield` is url-mapped
//     }
//     message Message {
//       string text = 1; // content of the resource
//     }
//
// The same http annotation can alternatively be expressed inside the
// `GRPC API Configuration` YAML file.
//
//     http:
//       rules:
//         - selector: <proto_package_name>.Messaging.GetMessage
//           get: /v1/messages/{message_id}/{sub.subfield}
//
// This definition enables an automatic, bidrectional mapping of HTTP
// JSON to RPC. Example:
//
// HTTP | RPC
// -----|-----
// `GET /v1/messages/123456/foo`  | `GetMessage(message_id: "123456" sub: SubMessage(subfield: "foo"))`
//
// In general, not only fields but also field paths can be referenced
// from a path pattern. Fields mapped to the path pattern cannot be
// repeated and must have a primitive (non-message) type.
//
// Any fields in the request message which are not bound by the path
// pattern automatically become (optional) HTTP query
// parameters. Assume the following definition of the request message:
//
//
//     service Messaging {
//       rpc GetMessage(GetMessageRequest) returns (Message) {
//         option (google.api.http).get = "/v1/messages/{message_id}";
//       }
//     }
//     message GetMessageRequest {
//       message SubMessage {
//         string subfield = 1;
//       }
//       string message_id = 1; // mapped to the URL
//       int64 revision = 2;    // becomes a parameter
//       SubMessage sub = 3;    // `sub.subfield` becomes a parameter
//     }
//
//
// This enables a HTTP JSON to RPC mapping as below:
//
// HTTP | RPC
// -----|-----
// `GET /v1/messages/123456?revision=2&sub.subfield=foo` | `GetMessage(message_id: "123456" revision: 2 sub: SubMessage(subfield: "foo"))`
//
// Note that fields which are mapped to HTTP parameters must have a
// primitive type or a repeated primitive type. Message types are not
// allowed. In the case of a repeated type, the parameter can be
// repeated in the URL, as in `...?param=A&param=B`.
//
// For HTTP method kinds which allow a request body, the `body` field
// specifies the mapping. Consider a REST update method on the
// message resource collection:
//
//
//     service Messaging {
//       rpc UpdateMessage(UpdateMessageRequest) returns (Message) {
//         option (google.api.http) = {
//           put: "/v1/messages/{message_id}"
//           body: "message"
//         };
//       }
//     }
//     message UpdateMessageRequest {
//       string message_id = 1; // mapped to the URL
//       Message message = 2;   // mapped to the body
//     }
//
//
// The following HTTP JSON to RPC mapping is enabled, where the
// representation of the JSON in the request body is determined by
// protos JSON encoding:
//
// HTTP | RPC
// -----|-----
// `PUT /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" message { text: "Hi!" })`
//
// The special name `*` can be used in the body mapping to define that
// every field not bound by the path template should be mapped to the
// request body.  This enables the following alternative definition of
// the update method:
//
//     service Messaging {
//       rpc UpdateMessage(Message) returns (Message) {
//         option (google.api.http) = {
//           put: "/v1/messages/{message_id}"
//           body: "*"
//         };
//       }
//     }
//     message Message {
//       string message_id = 1;
//       string text = 2;
//     }
//
//
// The following HTTP JSON to RPC mapping is enabled:
//
// HTTP | RPC
// -----|-----
// `PUT /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" text: "Hi!")`
//
// Note that when using `*` in the body mapping, it is not possible to
// have HTTP parameters, as all fields not bound by the path end in
// the body. This makes this option more rarely used in practice of
// defining REST APIs. The common usage of `*` is in custom methods
// which don't use the URL at all for transferring data.
//
// It is possible to define multiple HTTP methods for one RPC by using
// the `additional_bindings` option. Example:
//
//     service Messaging {
//       rpc GetMessage(GetMessageRequest) returns (Message) {
//         option (google.api.http) = {
//           get: "/v1/messages/{message_id}"
//           additional_bindings {
//             get: "/v1/users/{user_id}/messages/{message_id}"
//           }
//         };
//       }
//     }
//     message GetMessageRequest {
//       string message_id = 1;
//       string user_id = 2;
//     }
//
//
// This enables the following two alternative HTTP JSON to RPC
// mappings:
//
// HTTP | RPC
// -----|-----
// `GET /v1/messages/123456` | `GetMessage(message_id: "123456")`
// `GET /v1/users/me/messages/123456` | `GetMessage(user_id: "me" message_id: "123456")`
//
// # Rules for HTTP mapping
//
// The rules for mapping HTTP path, query parameters, and body fields
// to the request message are as follows:
//
// 1. The `body` field specifies either `*` or a field path, or is
//    omitted. If omitted, it indicates there is no HTTP request body.
// 2. Leaf fields (recursive expansion of nested messages in the
//    request) can be classified into three types:
//     (a) Matched in the URL template.
//     (b) Covered by body (if body is `*`, everything except (a) fields;
//         else everything under the body field)
//     (c) All other fields.
// 3. URL query parameters found in the HTTP request are mapped to (c) fields.
// 4. Any body sent with an HTTP request can contain only (b) fields.
//
// The syntax of the path template is as follows:
//
//     Template = "/" Segments [ Verb ] ;
//     Segments = Segment { "/" Segment } ;
//     Segment  = "*" | "**" | LITERAL | Variable ;
//     Variable = "{" FieldPath [ "=" Segments ] "}" ;
//     FieldPath = IDENT { "." IDENT } ;
//     Verb     = ":" LITERAL ;
//
// The syntax `*` matches a single path segment. The syntax `**` matches zero
// or more path segments, which must be the last part of the path except the
// `Verb`. The syntax `LITERAL` matches literal text in the path.
//
// The syntax `Variable` matches part of the URL path as specified by its
// template. A variable template must not contain other variables. If a variable
// matches a single path segment, its template may be omitted, e.g. `{var}`
// is equivalent to `{var=*}`.
//
// If a variable contains exactly one path segment, such as `"{var}"` or
// `"{var=*}"`, when such a variable is expanded into a URL path, all characters
// except `[-_.~0-9a-zA-Z]` are percent-encoded. Such variables show up in the
// Discovery Document as `{var}`.
//
// If a variable contains one or more path segments, such as `"{var=foo/*}"`
// or `"{var=**}"`, when such a variable is expanded into a URL path, all
// characters except `[-_.~/0-9a-zA-Z]` are percent-encoded. Such variables
// show up in the Discovery Document as `{+var}`.
//
// NOTE: While the single segment variable matches the semantics of
// [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.2
// Simple String Expansion, the multi segment variable **does not** match
// RFC 6570 Reserved Expansion. The reason is that the Reserved Expansion
// does not expand special characters like `?` and `#`, which would lead
// to invalid URLs.
//
// NOTE: the field paths in variables and in the `body` must not refer to
// repeated fields or map fields.
type HttpRule struct {
	// Selects methods to which this rule applies.
	//
	// Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
	Selector string `protobuf:"bytes,1,opt,name=selector,proto3" json:"selector,omitempty"`
	// Determines the URL pattern is matched by this rules. This pattern can be
	// used with any of the {get|put|post|delete|patch} methods. A custom method
	// can be defined using the 'custom' field.
	//
	// Types that are valid to be assigned to Pattern:
	//	*HttpRule_Get
	//	*HttpRule_Put
	//	*HttpRule_Post
	//	*HttpRule_Delete
	//	*HttpRule_Patch
	//	*HttpRule_Custom
	Pattern isHttpRule_Pattern `protobuf_oneof:"pattern"`
	// The name of the request field whose value is mapped to the HTTP body, or
	// `*` for mapping all fields not captured by the path pattern to the HTTP
	// body. NOTE: the referred field must not be a repeated field and must be
	// present at the top-level of request message type.
	Body string `protobuf:"bytes,7,opt,name=body,proto3" json:"body,omitempty"`
	// Additional HTTP bindings for the selector. Nested bindings must
	// not contain an `additional_bindings` field themselves (that is,
	// the nesting may only be one level deep).
	AdditionalBindings []*HttpRule `protobuf:"bytes,11,rep,name=additional_bindings,json=additionalBindings" json:"additional_bindings,omitempty"`
}

func (m *HttpRule) Reset()                    { *m = HttpRule{} }
func (*HttpRule) ProtoMessage()               {}
func (*HttpRule) Descriptor() ([]byte, []int) { return fileDescriptorHttp, []int{1} }

type isHttpRule_Pattern interface {
	isHttpRule_Pattern()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type HttpRule_Get struct {
	Get string `protobuf:"bytes,2,opt,name=get,proto3,oneof"`
}
type HttpRule_Put struct {
	Put string `protobuf:"bytes,3,opt,name=put,proto3,oneof"`
}
type HttpRule_Post struct {
	Post string `protobuf:"bytes,4,opt,name=post,proto3,oneof"`
}
type HttpRule_Delete struct {
	Delete string `protobuf:"bytes,5,opt,name=delete,proto3,oneof"`
}
type HttpRule_Patch struct {
	Patch string `protobuf:"bytes,6,opt,name=patch,proto3,oneof"`
}
type HttpRule_Custom struct {
	Custom *CustomHttpPattern `protobuf:"bytes,8,opt,name=custom,oneof"`
}

func (*HttpRule_Get) isHttpRule_Pattern()    {}
func (*HttpRule_Put) isHttpRule_Pattern()    {}
func (*HttpRule_Post) isHttpRule_Pattern()   {}
func (*HttpRule_Delete) isHttpRule_Pattern() {}
func (*HttpRule_Patch) isHttpRule_Pattern()  {}
func (*HttpRule_Custom) isHttpRule_Pattern() {}

func (m *HttpRule) GetPattern() isHttpRule_Pattern {
	if m != nil {
		return m.Pattern
	}
	return nil
}

func (m *HttpRule) GetSelector() string {
	if m != nil {
		return m.Selector
	}
	return ""
}

func (m *HttpRule) GetGet() string {
	if x, ok := m.GetPattern().(*HttpRule_Get); ok {
		return x.Get
	}
	return ""
}

func (m *HttpRule) GetPut() string {
	if x, ok := m.GetPattern().(*HttpRule_Put); ok {
		return x.Put
	}
	return ""
}

func (m *HttpRule) GetPost() string {
	if x, ok := m.GetPattern().(*HttpRule_Post); ok {
		return x.Post
	}
	return ""
}

func (m *HttpRule) GetDelete() string {
	if x, ok := m.GetPattern().(*HttpRule_Delete); ok {
		return x.Delete
	}
	return ""
}

func (m *HttpRule) GetPatch() string {
	if x, ok := m.GetPattern().(*HttpRule_Patch); ok {
		return x.Patch
	}
	return ""
}

func (m *HttpRule) GetCustom() *CustomHttpPattern {
	if x, ok := m.GetPattern().(*HttpRule_Custom); ok {
		return x.Custom
	}
	return nil
}

func (m *HttpRule) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func (m *HttpRule) GetAdditionalBindings() []*HttpRule {
	if m != nil {
		return m.AdditionalBindings
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HttpRule) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HttpRule_OneofMarshaler, _HttpRule_OneofUnmarshaler, _HttpRule_OneofSizer, []interface{}{
		(*HttpRule_Get)(nil),
		(*HttpRule_Put)(nil),
		(*HttpRule_Post)(nil),
		(*HttpRule_Delete)(nil),
		(*HttpRule_Patch)(nil),
		(*HttpRule_Custom)(nil),
	}
}

func _HttpRule_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HttpRule)
	// pattern
	switch x := m.Pattern.(type) {
	case *HttpRule_Get:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Get)
	case *HttpRule_Put:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Put)
	case *HttpRule_Post:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Post)
	case *HttpRule_Delete:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Delete)
	case *HttpRule_Patch:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Patch)
	case *HttpRule_Custom:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Custom); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HttpRule.Pattern has unexpected type %T", x)
	}
	return nil
}

func _HttpRule_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HttpRule)
	switch tag {
	case 2: // pattern.get
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Pattern = &HttpRule_Get{x}
		return true, err
	case 3: // pattern.put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Pattern = &HttpRule_Put{x}
		return true, err
	case 4: // pattern.post
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Pattern = &HttpRule_Post{x}
		return true, err
	case 5: // pattern.delete
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Pattern = &HttpRule_Delete{x}
		return true, err
	case 6: // pattern.patch
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Pattern = &HttpRule_Patch{x}
		return true, err
	case 8: // pattern.custom
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CustomHttpPattern)
		err := b.DecodeMessage(msg)
		m.Pattern = &HttpRule_Custom{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HttpRule_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HttpRule)
	// pattern
	switch x := m.Pattern.(type) {
	case *HttpRule_Get:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Get)))
		n += len(x.Get)
	case *HttpRule_Put:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Put)))
		n += len(x.Put)
	case *HttpRule_Post:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Post)))
		n += len(x.Post)
	case *HttpRule_Delete:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Delete)))
		n += len(x.Delete)
	case *HttpRule_Patch:
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Patch)))
		n += len(x.Patch)
	case *HttpRule_Custom:
		s := proto.Size(x.Custom)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A custom pattern is used for defining custom HTTP verb.
type CustomHttpPattern struct {
	// The name of this custom HTTP verb.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The path matched by this custom verb.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *CustomHttpPattern) Reset()                    { *m = CustomHttpPattern{} }
func (*CustomHttpPattern) ProtoMessage()               {}
func (*CustomHttpPattern) Descriptor() ([]byte, []int) { return fileDescriptorHttp, []int{2} }

func (m *CustomHttpPattern) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *CustomHttpPattern) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func init() {
	proto.RegisterType((*Http)(nil), "google.api.Http")
	proto.RegisterType((*HttpRule)(nil), "google.api.HttpRule")
	proto.RegisterType((*CustomHttpPattern)(nil), "google.api.CustomHttpPattern")
}
func (this *Http) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Http)
	if !ok {
		that2, ok := that.(Http)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Rules) != len(that1.Rules) {
		return false
	}
	for i := range this.Rules {
		if !this.Rules[i].Equal(that1.Rules[i]) {
			return false
		}
	}
	if this.FullyDecodeReservedExpansion != that1.FullyDecodeReservedExpansion {
		return false
	}
	return true
}
func (this *HttpRule) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule)
	if !ok {
		that2, ok := that.(HttpRule)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Selector != that1.Selector {
		return false
	}
	if that1.Pattern == nil {
		if this.Pattern != nil {
			return false
		}
	} else if this.Pattern == nil {
		return false
	} else if !this.Pattern.Equal(that1.Pattern) {
		return false
	}
	if this.Body != that1.Body {
		return false
	}
	if len(this.AdditionalBindings) != len(that1.AdditionalBindings) {
		return false
	}
	for i := range this.AdditionalBindings {
		if !this.AdditionalBindings[i].Equal(that1.AdditionalBindings[i]) {
			return false
		}
	}
	return true
}
func (this *HttpRule_Get) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Get)
	if !ok {
		that2, ok := that.(HttpRule_Get)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Get != that1.Get {
		return false
	}
	return true
}
func (this *HttpRule_Put) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Put)
	if !ok {
		that2, ok := that.(HttpRule_Put)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Put != that1.Put {
		return false
	}
	return true
}
func (this *HttpRule_Post) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Post)
	if !ok {
		that2, ok := that.(HttpRule_Post)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Post != that1.Post {
		return false
	}
	return true
}
func (this *HttpRule_Delete) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Delete)
	if !ok {
		that2, ok := that.(HttpRule_Delete)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Delete != that1.Delete {
		return false
	}
	return true
}
func (this *HttpRule_Patch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Patch)
	if !ok {
		that2, ok := that.(HttpRule_Patch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Patch != that1.Patch {
		return false
	}
	return true
}
func (this *HttpRule_Custom) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HttpRule_Custom)
	if !ok {
		that2, ok := that.(HttpRule_Custom)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Custom.Equal(that1.Custom) {
		return false
	}
	return true
}
func (this *CustomHttpPattern) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CustomHttpPattern)
	if !ok {
		that2, ok := that.(CustomHttpPattern)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Kind != that1.Kind {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *Http) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Http{")
	if this.Rules != nil {
		s = append(s, "Rules: "+fmt.Sprintf("%#v", this.Rules)+",\n")
	}
	s = append(s, "FullyDecodeReservedExpansion: "+fmt.Sprintf("%#v", this.FullyDecodeReservedExpansion)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HttpRule) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&api.HttpRule{")
	s = append(s, "Selector: "+fmt.Sprintf("%#v", this.Selector)+",\n")
	if this.Pattern != nil {
		s = append(s, "Pattern: "+fmt.Sprintf("%#v", this.Pattern)+",\n")
	}
	s = append(s, "Body: "+fmt.Sprintf("%#v", this.Body)+",\n")
	if this.AdditionalBindings != nil {
		s = append(s, "AdditionalBindings: "+fmt.Sprintf("%#v", this.AdditionalBindings)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HttpRule_Get) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Get{` +
		`Get:` + fmt.Sprintf("%#v", this.Get) + `}`}, ", ")
	return s
}
func (this *HttpRule_Put) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Put{` +
		`Put:` + fmt.Sprintf("%#v", this.Put) + `}`}, ", ")
	return s
}
func (this *HttpRule_Post) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Post{` +
		`Post:` + fmt.Sprintf("%#v", this.Post) + `}`}, ", ")
	return s
}
func (this *HttpRule_Delete) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Delete{` +
		`Delete:` + fmt.Sprintf("%#v", this.Delete) + `}`}, ", ")
	return s
}
func (this *HttpRule_Patch) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Patch{` +
		`Patch:` + fmt.Sprintf("%#v", this.Patch) + `}`}, ", ")
	return s
}
func (this *HttpRule_Custom) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.HttpRule_Custom{` +
		`Custom:` + fmt.Sprintf("%#v", this.Custom) + `}`}, ", ")
	return s
}
func (this *CustomHttpPattern) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.CustomHttpPattern{")
	s = append(s, "Kind: "+fmt.Sprintf("%#v", this.Kind)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringHttp(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Http) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Http) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, msg := range m.Rules {
			dAtA[i] = 0xa
			i++
			i = encodeVarintHttp(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.FullyDecodeReservedExpansion {
		dAtA[i] = 0x10
		i++
		if m.FullyDecodeReservedExpansion {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *HttpRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpRule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Selector) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHttp(dAtA, i, uint64(len(m.Selector)))
		i += copy(dAtA[i:], m.Selector)
	}
	if m.Pattern != nil {
		nn1, err := m.Pattern.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if len(m.Body) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintHttp(dAtA, i, uint64(len(m.Body)))
		i += copy(dAtA[i:], m.Body)
	}
	if len(m.AdditionalBindings) > 0 {
		for _, msg := range m.AdditionalBindings {
			dAtA[i] = 0x5a
			i++
			i = encodeVarintHttp(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *HttpRule_Get) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintHttp(dAtA, i, uint64(len(m.Get)))
	i += copy(dAtA[i:], m.Get)
	return i, nil
}
func (m *HttpRule_Put) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintHttp(dAtA, i, uint64(len(m.Put)))
	i += copy(dAtA[i:], m.Put)
	return i, nil
}
func (m *HttpRule_Post) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x22
	i++
	i = encodeVarintHttp(dAtA, i, uint64(len(m.Post)))
	i += copy(dAtA[i:], m.Post)
	return i, nil
}
func (m *HttpRule_Delete) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x2a
	i++
	i = encodeVarintHttp(dAtA, i, uint64(len(m.Delete)))
	i += copy(dAtA[i:], m.Delete)
	return i, nil
}
func (m *HttpRule_Patch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x32
	i++
	i = encodeVarintHttp(dAtA, i, uint64(len(m.Patch)))
	i += copy(dAtA[i:], m.Patch)
	return i, nil
}
func (m *HttpRule_Custom) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Custom != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintHttp(dAtA, i, uint64(m.Custom.Size()))
		n2, err := m.Custom.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}
func (m *CustomHttpPattern) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CustomHttpPattern) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHttp(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.Path) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHttp(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	return i, nil
}

func encodeVarintHttp(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedHttp(r randyHttp, easy bool) *Http {
	this := &Http{}
	if r.Intn(10) == 0 {
		v1 := r.Intn(5)
		this.Rules = make([]*HttpRule, v1)
		for i := 0; i < v1; i++ {
			this.Rules[i] = NewPopulatedHttpRule(r, easy)
		}
	}
	this.FullyDecodeReservedExpansion = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedHttpRule(r randyHttp, easy bool) *HttpRule {
	this := &HttpRule{}
	this.Selector = string(randStringHttp(r))
	oneofNumber_Pattern := []int32{2, 3, 4, 5, 6, 8}[r.Intn(6)]
	switch oneofNumber_Pattern {
	case 2:
		this.Pattern = NewPopulatedHttpRule_Get(r, easy)
	case 3:
		this.Pattern = NewPopulatedHttpRule_Put(r, easy)
	case 4:
		this.Pattern = NewPopulatedHttpRule_Post(r, easy)
	case 5:
		this.Pattern = NewPopulatedHttpRule_Delete(r, easy)
	case 6:
		this.Pattern = NewPopulatedHttpRule_Patch(r, easy)
	case 8:
		this.Pattern = NewPopulatedHttpRule_Custom(r, easy)
	}
	this.Body = string(randStringHttp(r))
	if r.Intn(10) == 0 {
		v2 := r.Intn(5)
		this.AdditionalBindings = make([]*HttpRule, v2)
		for i := 0; i < v2; i++ {
			this.AdditionalBindings[i] = NewPopulatedHttpRule(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedHttpRule_Get(r randyHttp, easy bool) *HttpRule_Get {
	this := &HttpRule_Get{}
	this.Get = string(randStringHttp(r))
	return this
}
func NewPopulatedHttpRule_Put(r randyHttp, easy bool) *HttpRule_Put {
	this := &HttpRule_Put{}
	this.Put = string(randStringHttp(r))
	return this
}
func NewPopulatedHttpRule_Post(r randyHttp, easy bool) *HttpRule_Post {
	this := &HttpRule_Post{}
	this.Post = string(randStringHttp(r))
	return this
}
func NewPopulatedHttpRule_Delete(r randyHttp, easy bool) *HttpRule_Delete {
	this := &HttpRule_Delete{}
	this.Delete = string(randStringHttp(r))
	return this
}
func NewPopulatedHttpRule_Patch(r randyHttp, easy bool) *HttpRule_Patch {
	this := &HttpRule_Patch{}
	this.Patch = string(randStringHttp(r))
	return this
}
func NewPopulatedHttpRule_Custom(r randyHttp, easy bool) *HttpRule_Custom {
	this := &HttpRule_Custom{}
	this.Custom = NewPopulatedCustomHttpPattern(r, easy)
	return this
}
func NewPopulatedCustomHttpPattern(r randyHttp, easy bool) *CustomHttpPattern {
	this := &CustomHttpPattern{}
	this.Kind = string(randStringHttp(r))
	this.Path = string(randStringHttp(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyHttp interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneHttp(r randyHttp) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringHttp(r randyHttp) string {
	v3 := r.Intn(100)
	tmps := make([]rune, v3)
	for i := 0; i < v3; i++ {
		tmps[i] = randUTF8RuneHttp(r)
	}
	return string(tmps)
}
func randUnrecognizedHttp(r randyHttp, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldHttp(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldHttp(dAtA []byte, r randyHttp, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(key))
		v4 := r.Int63()
		if r.Intn(2) == 0 {
			v4 *= -1
		}
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(v4))
	case 1:
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateHttp(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateHttp(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Http) Size() (n int) {
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovHttp(uint64(l))
		}
	}
	if m.FullyDecodeReservedExpansion {
		n += 2
	}
	return n
}

func (m *HttpRule) Size() (n int) {
	var l int
	_ = l
	l = len(m.Selector)
	if l > 0 {
		n += 1 + l + sovHttp(uint64(l))
	}
	if m.Pattern != nil {
		n += m.Pattern.Size()
	}
	l = len(m.Body)
	if l > 0 {
		n += 1 + l + sovHttp(uint64(l))
	}
	if len(m.AdditionalBindings) > 0 {
		for _, e := range m.AdditionalBindings {
			l = e.Size()
			n += 1 + l + sovHttp(uint64(l))
		}
	}
	return n
}

func (m *HttpRule_Get) Size() (n int) {
	var l int
	_ = l
	l = len(m.Get)
	n += 1 + l + sovHttp(uint64(l))
	return n
}
func (m *HttpRule_Put) Size() (n int) {
	var l int
	_ = l
	l = len(m.Put)
	n += 1 + l + sovHttp(uint64(l))
	return n
}
func (m *HttpRule_Post) Size() (n int) {
	var l int
	_ = l
	l = len(m.Post)
	n += 1 + l + sovHttp(uint64(l))
	return n
}
func (m *HttpRule_Delete) Size() (n int) {
	var l int
	_ = l
	l = len(m.Delete)
	n += 1 + l + sovHttp(uint64(l))
	return n
}
func (m *HttpRule_Patch) Size() (n int) {
	var l int
	_ = l
	l = len(m.Patch)
	n += 1 + l + sovHttp(uint64(l))
	return n
}
func (m *HttpRule_Custom) Size() (n int) {
	var l int
	_ = l
	if m.Custom != nil {
		l = m.Custom.Size()
		n += 1 + l + sovHttp(uint64(l))
	}
	return n
}
func (m *CustomHttpPattern) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovHttp(uint64(l))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovHttp(uint64(l))
	}
	return n
}

func sovHttp(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozHttp(x uint64) (n int) {
	return sovHttp(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Http) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Http{`,
		`Rules:` + strings.Replace(fmt.Sprintf("%v", this.Rules), "HttpRule", "HttpRule", 1) + `,`,
		`FullyDecodeReservedExpansion:` + fmt.Sprintf("%v", this.FullyDecodeReservedExpansion) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule{`,
		`Selector:` + fmt.Sprintf("%v", this.Selector) + `,`,
		`Pattern:` + fmt.Sprintf("%v", this.Pattern) + `,`,
		`Body:` + fmt.Sprintf("%v", this.Body) + `,`,
		`AdditionalBindings:` + strings.Replace(fmt.Sprintf("%v", this.AdditionalBindings), "HttpRule", "HttpRule", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Get) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Get{`,
		`Get:` + fmt.Sprintf("%v", this.Get) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Put) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Put{`,
		`Put:` + fmt.Sprintf("%v", this.Put) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Post) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Post{`,
		`Post:` + fmt.Sprintf("%v", this.Post) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Delete) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Delete{`,
		`Delete:` + fmt.Sprintf("%v", this.Delete) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Patch) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Patch{`,
		`Patch:` + fmt.Sprintf("%v", this.Patch) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpRule_Custom) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HttpRule_Custom{`,
		`Custom:` + strings.Replace(fmt.Sprintf("%v", this.Custom), "CustomHttpPattern", "CustomHttpPattern", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CustomHttpPattern) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CustomHttpPattern{`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringHttp(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Http) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Http: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Http: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &HttpRule{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FullyDecodeReservedExpansion", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FullyDecodeReservedExpansion = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipHttp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHttp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selector", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Selector = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Get", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HttpRule_Get{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Put", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HttpRule_Put{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Post", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HttpRule_Post{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delete", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HttpRule_Delete{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Patch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HttpRule_Patch{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Body = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Custom", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CustomHttpPattern{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Pattern = &HttpRule_Custom{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalBindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdditionalBindings = append(m.AdditionalBindings, &HttpRule{})
			if err := m.AdditionalBindings[len(m.AdditionalBindings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHttp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHttp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CustomHttpPattern) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomHttpPattern: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomHttpPattern: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttp
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHttp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHttp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipHttp(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowHttp
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHttp
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthHttp
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowHttp
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipHttp(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthHttp = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowHttp   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("google/api/http.proto", fileDescriptorHttp) }

var fileDescriptorHttp = []byte{
	// 424 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x92, 0xb1, 0x8e, 0xd3, 0x40,
	0x10, 0x86, 0xb3, 0x89, 0x93, 0x4b, 0x26, 0x12, 0x12, 0xcb, 0x81, 0x56, 0x08, 0x96, 0x28, 0x55,
	0x44, 0x91, 0x93, 0x8e, 0x82, 0x82, 0x8a, 0x40, 0xc4, 0xd1, 0x45, 0xae, 0x10, 0x4d, 0xb4, 0xf1,
	0x0e, 0xc9, 0x0a, 0x9f, 0x77, 0x65, 0x8f, 0x11, 0xe9, 0x78, 0x16, 0x2a, 0x5e, 0x80, 0x77, 0xa0,
	0xbc, 0x92, 0x12, 0xbb, 0xa2, 0xbc, 0xf2, 0x4a, 0xb4, 0x6b, 0x87, 0x8b, 0x84, 0x44, 0x37, 0xff,
	0xbf, 0x9f, 0x67, 0xc6, 0xbf, 0x06, 0xee, 0x6f, 0xad, 0xdd, 0xa6, 0x78, 0xa6, 0x9c, 0x39, 0xdb,
	0x11, 0xb9, 0xb9, 0xcb, 0x2d, 0x59, 0x0e, 0x8d, 0x3d, 0x57, 0xce, 0x4c, 0xf7, 0x10, 0x5d, 0x10,
	0x39, 0xfe, 0x14, 0xfa, 0x79, 0x99, 0x62, 0x21, 0xd8, 0xa4, 0x37, 0x1b, 0x9f, 0x9f, 0xce, 0x6f,
	0x99, 0xb9, 0x07, 0xe2, 0x32, 0xc5, 0xb8, 0x41, 0xf8, 0x12, 0x9e, 0x7c, 0x28, 0xd3, 0x74, 0xbf,
	0xd6, 0x98, 0x58, 0x8d, 0xeb, 0x1c, 0x0b, 0xcc, 0x3f, 0xa1, 0x5e, 0xe3, 0x67, 0xa7, 0xb2, 0xc2,
	0xd8, 0x4c, 0x74, 0x27, 0x6c, 0x36, 0x8c, 0x1f, 0x05, 0xec, 0x75, 0xa0, 0xe2, 0x16, 0x5a, 0x1e,
	0x98, 0xe9, 0xf7, 0x2e, 0x0c, 0x0f, 0xad, 0xf9, 0x43, 0x18, 0x16, 0x98, 0x62, 0x42, 0x36, 0x17,
	0x6c, 0xc2, 0x66, 0xa3, 0xf8, 0xaf, 0xe6, 0x1c, 0x7a, 0x5b, 0xa4, 0xd0, 0x73, 0x74, 0xd1, 0x89,
	0xbd, 0xf0, 0x9e, 0x2b, 0x49, 0xf4, 0x0e, 0x9e, 0x2b, 0x89, 0x9f, 0x42, 0xe4, 0x6c, 0x41, 0x22,
	0x6a, 0xcd, 0xa0, 0xb8, 0x80, 0x81, 0xc6, 0x14, 0x09, 0x45, 0xbf, 0xf5, 0x5b, 0xcd, 0x1f, 0x40,
	0xdf, 0x29, 0x4a, 0x76, 0x62, 0xd0, 0x3e, 0x34, 0x92, 0x73, 0x88, 0x36, 0x56, 0xef, 0xc5, 0x49,
	0xd8, 0x23, 0xd4, 0xfc, 0x39, 0x0c, 0x92, 0xb2, 0x20, 0x7b, 0x29, 0x86, 0x13, 0x36, 0x1b, 0x9f,
	0x3f, 0x3e, 0x0e, 0xe8, 0x55, 0x78, 0xf1, 0xff, 0xb2, 0x52, 0x44, 0x98, 0x67, 0x7e, 0x48, 0x83,
	0xf3, 0x25, 0xdc, 0x53, 0x5a, 0x1b, 0x32, 0x36, 0x53, 0xe9, 0x7a, 0x63, 0x32, 0x6d, 0xb2, 0x6d,
	0x21, 0xc6, 0xff, 0x89, 0x99, 0xdf, 0x7e, 0xb0, 0x68, 0xf9, 0xc5, 0x08, 0x4e, 0x5c, 0xd3, 0x7b,
	0xfa, 0x02, 0xee, 0xfe, 0x33, 0xd0, 0xef, 0xfc, 0xd1, 0x64, 0xba, 0xcd, 0x2e, 0xd4, 0xde, 0x73,
	0x8a, 0x76, 0x4d, 0x70, 0x71, 0xa8, 0x17, 0xef, 0xae, 0x2a, 0xd9, 0xf9, 0x59, 0xc9, 0xce, 0x75,
	0x25, 0xd9, 0x4d, 0x25, 0xd9, 0x97, 0x5a, 0xb2, 0x6f, 0xb5, 0x64, 0x3f, 0x6a, 0xc9, 0xae, 0x6a,
	0xc9, 0x7e, 0xd5, 0x92, 0xfd, 0xae, 0x65, 0xe7, 0xba, 0x96, 0x0c, 0xee, 0x24, 0xf6, 0xf2, 0x68,
	0xc5, 0xc5, 0x28, 0x8c, 0xf4, 0x47, 0xb4, 0x62, 0xef, 0x7b, 0xca, 0x99, 0x1b, 0xc6, 0xbe, 0x76,
	0xa3, 0x37, 0x2f, 0x57, 0x6f, 0x37, 0x83, 0x70, 0x5c, 0xcf, 0xfe, 0x04, 0x00, 0x00, 0xff, 0xff,
	0x57, 0x30, 0x55, 0xda, 0x75, 0x02, 0x00, 0x00,
}
