// Code generated by protoc-gen-validate
// source: envoy/api/v2/cluster/outlier_detection.proto
// DO NOT EDIT!!!

package cluster

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/gogo/protobuf/types"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = types.DynamicAny{}
)

// Validate checks the field values on OutlierDetection with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *OutlierDetection) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetConsecutive_5Xx()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OutlierDetectionValidationError{
				Field:  "Consecutive_5Xx",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if d := m.GetInterval(); d != nil {
		dur, err := types.DurationFromProto(d)
		if err != nil {
			return OutlierDetectionValidationError{
				Field:  "Interval",
				Reason: "value is not a valid duration",
				Cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return OutlierDetectionValidationError{
				Field:  "Interval",
				Reason: "value must be greater than 0s",
			}
		}

	}

	if d := m.GetBaseEjectionTime(); d != nil {
		dur, err := types.DurationFromProto(d)
		if err != nil {
			return OutlierDetectionValidationError{
				Field:  "BaseEjectionTime",
				Reason: "value is not a valid duration",
				Cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return OutlierDetectionValidationError{
				Field:  "BaseEjectionTime",
				Reason: "value must be greater than 0s",
			}
		}

	}

	if wrapper := m.GetMaxEjectionPercent(); wrapper != nil {

		if wrapper.GetValue() > 100 {
			return OutlierDetectionValidationError{
				Field:  "MaxEjectionPercent",
				Reason: "value must be less than or equal to 100",
			}
		}

	}

	if wrapper := m.GetEnforcingConsecutive_5Xx(); wrapper != nil {

		if wrapper.GetValue() > 100 {
			return OutlierDetectionValidationError{
				Field:  "EnforcingConsecutive_5Xx",
				Reason: "value must be less than or equal to 100",
			}
		}

	}

	if wrapper := m.GetEnforcingSuccessRate(); wrapper != nil {

		if wrapper.GetValue() > 100 {
			return OutlierDetectionValidationError{
				Field:  "EnforcingSuccessRate",
				Reason: "value must be less than or equal to 100",
			}
		}

	}

	if v, ok := interface{}(m.GetSuccessRateMinimumHosts()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OutlierDetectionValidationError{
				Field:  "SuccessRateMinimumHosts",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetSuccessRateRequestVolume()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OutlierDetectionValidationError{
				Field:  "SuccessRateRequestVolume",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetSuccessRateStdevFactor()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OutlierDetectionValidationError{
				Field:  "SuccessRateStdevFactor",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetConsecutiveGatewayFailure()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OutlierDetectionValidationError{
				Field:  "ConsecutiveGatewayFailure",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if wrapper := m.GetEnforcingConsecutiveGatewayFailure(); wrapper != nil {

		if wrapper.GetValue() > 100 {
			return OutlierDetectionValidationError{
				Field:  "EnforcingConsecutiveGatewayFailure",
				Reason: "value must be less than or equal to 100",
			}
		}

	}

	return nil
}

// OutlierDetectionValidationError is the validation error returned by
// OutlierDetection.Validate if the designated constraints aren't met.
type OutlierDetectionValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e OutlierDetectionValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOutlierDetection.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = OutlierDetectionValidationError{}
