program plugjax
  !
  ! (Copyright 2024)    S.Guilloteau   LAB/OASU CNRS   
  ! Plug in the <HEAD> section of an HTML file created by Latex2Html 
  ! the plugin to allow MathJax to be used for equations and Math symbols.
  !
  ! The original .tex file must not use \begin{equation}\end{equation}
  ! Instead it must distinguish between latex and html cases for equations
  ! which should be noted between $$ and $$
  !
  ! Examples
  !
  ! Normal use of Latex
  !  \begin{equation}
  !     A : \pi r^2
  !  \end{equation}
  ! Replace by
  !  \begin{latexonly}
  !   $$  A : \pi r^2  $$
  !  \end{latexonly}
  !  \begin{rawhtml}
  !   $$  A : \pi r^2  $$
  !  \end{rawhtml}
  !
  ! In addition, in-line Math equations should not be cut over two lines.
  !   $ a = pi r^2$     is valid
  ! while  $ a =
  !              \pi r^2 $  is NOT valid
  !
  ! This code should be compiled and is used by the makehtml.sh script
  ! for the IMAGER and VIEWER documentation, through a simple pipe
  ! plug-jax < input.html > output.html
  !
  ! This whole (clumsy) process is a workaround for failures of some
  ! versions of latex2html to do the conversion properly: inline images
  ! used for math symbols being with wrong scaling and bounding box.
  !
  character(len=1024) :: line
  character(len=80) :: comm
  character(len=256) :: fich
  integer :: nl,nd,ni,nj,ier
  !
  CALL GET_ENVIRONMENT_VARIABLE('GAG_PATH',FICH)
  !! ier = sic_getlog('$GAG_PATH',fich)
  nl = len_trim(fich)
  fich(nl+1:) = '/jaxheader.txt'
  !
  open(unit=1,file=fich,status='OLD')
  !
  read(*,'(A)',iostat=ier) line
  do while (ier.eq.0) 
    nl = len_trim(line)
    !
    ! Insert the MathJax Header
    if (index(line,'<HEAD>').ne.0) then
      write(*,'(A)') line(1:nl)
      !
      rewind(1)
      do 
        read(1,'(A)',iostat=ier) line
        if (ier.ne.0) exit
        nl = len_trim(line)
        write(*,'(A)') line(1:nl)
      enddo
      ier = 0
    else 
      ni = index(line(1:nl),'<SPAN CLASS="MATH"><IMG')
      if (ni.eq.0) then
        write(*,'(A)') line(1:nl)
        read(*,'(A)',iostat=ier) line
      else 
        if (ni.gt.1) then
          write(*,'(A)') line(1:ni-1)
        endif
        !
        ni = 0
        nj = 0
        do 
          read(*,'(A)',iostat=ier) line
          if (ier.ne.0) exit
          ni = index(line,'ALT')
          nj = index(line,'</SPAN>')
          !! write(*,*) '<!-- '//trim(line)//' [',ni,nj,'] -->' ! Comment for debug
          if (ni.ne.0) exit
          if (nj.ne.0) exit
        enddo
        if (ni.eq.0) then
          ier = 1
          Print *,'No ALT found'
          exit
        endif
        ! translate ALT=" "><SPAN>
        comm = line(ni+4:)
        !! write(*,*) '<!-- '//trim(comm)//' [#1] -->' ! Comment for debug
        nl = len_trim(comm)
        ! Replace first $ by \(
        nd = index(comm,'$')+1
        !!Print *,'NI ND ',NI,ND,NL, line(1:nl)
        comm = '\('//comm(nd:)
        ! Replace last $ by \)
        nd = index(comm(1:nl),'$')
        comm(nd:) = '\)'
        write(*,'(A)') trim(comm)
        !! write(*,*) '<!-- '//trim(comm)//' [#2] -->' ! Comment for debug
        !
        ! Now scan until </SPAN> is found
        ni = index(line,'</SPAN>')
        do while(ni.eq.0)
          read(*,'(A)',iostat=ier) line
          if (ier.ne.0) exit
          ni = index(line,'</SPAN>')
        enddo  
        !
        ! OK </SPAN> is found. Skip the whole region
        line = line(ni+7:)  ! Length of </SPAN>
      endif
    endif
  enddo
end program

