#include "Adafruit_RA8875.h"
#if defined(_CLOCK_1600x960)
const uint8_t Courier_Prime_Sans6pt7bBitmaps[] PROGMEM = {
  0x00, 0x77, 0x77, 0x77, 0x77, 0x77, 0x70, 0x6F, 0x60, 0xE7, 0xE7, 0xE7,
  0xE7, 0xE7, 0x18, 0xC1, 0x8C, 0x18, 0xC7, 0xFF, 0x7F, 0xF1, 0x8C, 0x18,
  0xC3, 0x18, 0xFF, 0xEF, 0xFE, 0x31, 0x83, 0x18, 0x31, 0x83, 0x18, 0x06,
  0x01, 0x83, 0xF1, 0xFE, 0xEC, 0xBB, 0x0E, 0xC3, 0xF0, 0x7F, 0x07, 0xE1,
  0xFC, 0x67, 0x19, 0xE6, 0xFF, 0xF9, 0xF8, 0x30, 0x0C, 0x03, 0x00, 0x70,
  0x3F, 0x86, 0x88, 0xC8, 0x8C, 0x89, 0x8F, 0xB0, 0x73, 0x00, 0x60, 0x0D,
  0xC0, 0xFE, 0x1A, 0x23, 0x22, 0x32, 0x26, 0x3E, 0xC1, 0xC0, 0x1E, 0x03,
  0xF0, 0x73, 0x87, 0x38, 0x73, 0x87, 0xF0, 0x3F, 0x03, 0xC0, 0x7E, 0xEE,
  0xFE, 0xE7, 0xEE, 0x3C, 0xF1, 0xC7, 0xFE, 0x3E, 0x70, 0xFF, 0xFE, 0x04,
  0x1C, 0x71, 0xC7, 0x0E, 0x1C, 0x70, 0xE1, 0xC3, 0x87, 0x0E, 0x0E, 0x1C,
  0x3C, 0x38, 0x38, 0x38, 0x20, 0x41, 0xC1, 0xC1, 0xC3, 0xC3, 0x87, 0x07,
  0x0E, 0x1C, 0x38, 0x70, 0xE3, 0x87, 0x0E, 0x38, 0xE3, 0x82, 0x00, 0x1C,
  0x2E, 0xBF, 0xEF, 0xE1, 0xC3, 0xFB, 0xFE, 0xBA, 0x1C, 0x00, 0x0E, 0x01,
  0xC0, 0x38, 0x07, 0x0F, 0xFF, 0xFF, 0xC3, 0x80, 0x70, 0x0E, 0x01, 0xC0,
  0x38, 0xF3, 0xC7, 0x1C, 0x6F, 0xB8, 0xFF, 0xFC, 0x6F, 0xF6, 0x00, 0xC0,
  0x38, 0x06, 0x01, 0xC0, 0x30, 0x0E, 0x01, 0x80, 0x70, 0x0E, 0x01, 0x80,
  0x70, 0x0C, 0x03, 0x80, 0x60, 0x1C, 0x03, 0x00, 0xE0, 0x00, 0x1F, 0x07,
  0xF1, 0xC7, 0x38, 0xFE, 0x1F, 0xC7, 0xF9, 0xBF, 0x67, 0xF8, 0xFE, 0x1F,
  0xC7, 0x38, 0xE3, 0xF8, 0x3E, 0x00, 0x1E, 0x1F, 0x8F, 0xE1, 0x38, 0x0E,
  0x03, 0x80, 0xE0, 0x38, 0x0E, 0x03, 0x80, 0xE0, 0x38, 0xFF, 0xFF, 0xF0,
  0x3E, 0x3F, 0xC4, 0x78, 0x0E, 0x03, 0x80, 0xE0, 0x70, 0x3C, 0x0E, 0x07,
  0x03, 0x81, 0xC0, 0xFF, 0xFF, 0xF0, 0x7E, 0x3F, 0xC8, 0x78, 0x0E, 0x03,
  0x81, 0xC3, 0xE0, 0xFE, 0x03, 0xC0, 0x70, 0x1E, 0x0F, 0xFF, 0x9F, 0x80,
  0x07, 0x81, 0xF0, 0x3E, 0x0D, 0xC3, 0xB8, 0x67, 0x1C, 0xE3, 0x1C, 0xE3,
  0x9F, 0xFF, 0xFF, 0x81, 0xC0, 0x38, 0x07, 0x00, 0xFF, 0x7F, 0xB8, 0x1C,
  0x0E, 0x07, 0xF3, 0xFC, 0x0F, 0x03, 0x81, 0xC0, 0xE0, 0xEF, 0xF7, 0xE0,
  0x0F, 0x8F, 0xE7, 0x81, 0xC0, 0xE0, 0x3B, 0xCF, 0xFB, 0xCF, 0xE1, 0xF8,
  0x7E, 0x1D, 0xCE, 0x7F, 0x87, 0x80, 0xFF, 0xFF, 0xF0, 0x1C, 0x0E, 0x03,
  0x81, 0xC0, 0x70, 0x38, 0x0E, 0x07, 0x01, 0xC0, 0xE0, 0x38, 0x1C, 0x00,
  0x3F, 0x1F, 0xEE, 0x1F, 0x87, 0xE1, 0xDF, 0xE3, 0xF0, 0xFE, 0x73, 0xF8,
  0x7E, 0x1F, 0x87, 0x7F, 0x8F, 0xC0, 0x1E, 0x1F, 0xEF, 0x3B, 0x87, 0xE1,
  0xF8, 0x7F, 0x1D, 0xFF, 0x3D, 0xC0, 0x70, 0x38, 0x1E, 0x7F, 0x1F, 0x00,
  0x6F, 0xF6, 0x00, 0x06, 0xFF, 0x60, 0x18, 0xF3, 0xC6, 0x00, 0x00, 0x0E,
  0x3C, 0xF1, 0xC7, 0x1B, 0xEE, 0x00, 0x01, 0x03, 0xC3, 0xC3, 0xC3, 0xC3,
  0xC3, 0xE0, 0x78, 0x1E, 0x07, 0x81, 0xE0, 0x20, 0xFF, 0xFF, 0xC0, 0x00,
  0x0F, 0xFF, 0xFC, 0x40, 0x78, 0x1E, 0x07, 0x81, 0xE0, 0x78, 0x3E, 0x3C,
  0x3C, 0x3C, 0x3C, 0x08, 0x00, 0xF1, 0xF0, 0x70, 0x70, 0xE1, 0xC7, 0xFE,
  0xF9, 0xC3, 0x80, 0x06, 0x1E, 0x18, 0x00, 0x07, 0x81, 0xFC, 0x38, 0xE3,
  0x06, 0x70, 0x36, 0x7B, 0x6F, 0xBD, 0xDB, 0xDB, 0xBD, 0xBB, 0xDB, 0x3D,
  0xB7, 0xDF, 0xEC, 0xDC, 0xC0, 0x06, 0x00, 0x70, 0x83, 0xF8, 0x1F, 0x00,
  0x07, 0x80, 0x7C, 0x03, 0x60, 0x1B, 0x01, 0xDC, 0x0C, 0xE0, 0x63, 0x07,
  0x1C, 0x38, 0xE1, 0xFF, 0x0F, 0xF8, 0xE0, 0xE7, 0x07, 0x30, 0x38, 0xFE,
  0x3F, 0xCE, 0x3B, 0x8E, 0xE3, 0xB9, 0xCF, 0xF3, 0xFE, 0xE3, 0xF8, 0x7E,
  0x1F, 0x8F, 0xFF, 0xBF, 0xC0, 0x0F, 0x8F, 0xF7, 0x85, 0xC0, 0xE0, 0x38,
  0x0E, 0x03, 0x80, 0xE0, 0x38, 0x07, 0x01, 0xE1, 0x3F, 0xC7, 0xE0, 0xFF,
  0x1F, 0xF3, 0x8F, 0x70, 0xEE, 0x0F, 0xC1, 0xF8, 0x3F, 0x07, 0xE0, 0xFC,
  0x1F, 0x87, 0x71, 0xEF, 0xF9, 0xFC, 0x00, 0xFF, 0xFF, 0xE0, 0xE0, 0xE0,
  0xE0, 0xFF, 0xFF, 0xE0, 0xE0, 0xE0, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0xE0, 0xE0, 0xE0, 0xFF, 0xFF, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x0F,
  0xC7, 0xFD, 0xE0, 0xB8, 0x0E, 0x01, 0xC0, 0x38, 0xFF, 0x1F, 0xE0, 0xFC,
  0x1D, 0xC3, 0xBC, 0x73, 0xFE, 0x1F, 0x80, 0xE1, 0xF8, 0x7E, 0x1F, 0x87,
  0xE1, 0xF8, 0x7F, 0xFF, 0xFF, 0xE1, 0xF8, 0x7E, 0x1F, 0x87, 0xE1, 0xF8,
  0x70, 0xFF, 0xFF, 0xC7, 0x03, 0x81, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0E,
  0x07, 0x03, 0x8F, 0xFF, 0xFC, 0xFF, 0xFF, 0x07, 0x07, 0x07, 0x07, 0x07,
  0x07, 0x07, 0x07, 0x07, 0x8F, 0xFE, 0x7C, 0xE1, 0xF8, 0xEE, 0x73, 0x9C,
  0xEE, 0x3B, 0x8F, 0xC3, 0xF0, 0xEE, 0x3B, 0x8E, 0x73, 0x8E, 0xE3, 0xB8,
  0x70, 0xE0, 0x70, 0x38, 0x1C, 0x0E, 0x07, 0x03, 0x81, 0xC0, 0xE0, 0x70,
  0x38, 0x1C, 0x0F, 0xFF, 0xFC, 0x70, 0x73, 0xC7, 0x9E, 0x3C, 0xF1, 0xE6,
  0xDB, 0x36, 0xD9, 0xB4, 0xCC, 0xE6, 0x67, 0x33, 0x31, 0x98, 0x0C, 0xC0,
  0x66, 0x03, 0x30, 0x18, 0xF0, 0xFE, 0x1F, 0xE3, 0xFC, 0x7F, 0xCF, 0xD9,
  0xFB, 0xBF, 0x77, 0xE6, 0xFC, 0xFF, 0x8F, 0xF1, 0xFE, 0x1F, 0xC3, 0xC0,
  0x1F, 0x83, 0xFC, 0x70, 0xE7, 0x0E, 0xE0, 0x7E, 0x07, 0xE0, 0x7E, 0x07,
  0xE0, 0x7E, 0x07, 0x70, 0xE7, 0x0E, 0x3F, 0xC1, 0xF8, 0xFE, 0x3F, 0xEE,
  0x3F, 0x87, 0xE1, 0xF8, 0x7E, 0x3B, 0xFE, 0xFE, 0x38, 0x0E, 0x03, 0x80,
  0xE0, 0x38, 0x00, 0x0F, 0x83, 0xFC, 0x70, 0xE7, 0x0E, 0xE0, 0x7E, 0x07,
  0xE0, 0x7E, 0x07, 0xE0, 0x7E, 0x07, 0xF0, 0xE7, 0x0E, 0x3F, 0xC1, 0xF8,
  0x07, 0x00, 0x7A, 0x03, 0xF0, 0x1E, 0xFE, 0x3F, 0xCE, 0x3B, 0x8E, 0xE3,
  0xB9, 0xEF, 0xF3, 0xF8, 0xE7, 0x39, 0xCE, 0x3B, 0x8E, 0xE3, 0xB8, 0x70,
  0x3F, 0x1F, 0xEF, 0x0B, 0x80, 0xE0, 0x3E, 0x07, 0xF0, 0x7E, 0x03, 0xC0,
  0x70, 0x1E, 0x0F, 0xFF, 0x9F, 0x80, 0xFF, 0xFF, 0xFC, 0x38, 0x07, 0x00,
  0xE0, 0x1C, 0x03, 0x80, 0x70, 0x0E, 0x01, 0xC0, 0x38, 0x07, 0x00, 0xE0,
  0x1C, 0x00, 0xE0, 0xFC, 0x1F, 0x83, 0xF0, 0x7E, 0x0F, 0xC1, 0xF8, 0x3F,
  0x07, 0xE0, 0xFC, 0x1F, 0x83, 0xF8, 0xE7, 0xFC, 0x7E, 0x00, 0x70, 0x33,
  0x83, 0x9C, 0x1C, 0x60, 0xC3, 0x8E, 0x1C, 0x70, 0xE3, 0x03, 0x98, 0x1D,
  0xC0, 0xEE, 0x03, 0x60, 0x1F, 0x00, 0xF8, 0x07, 0x80, 0x60, 0x33, 0x01,
  0x98, 0x0C, 0xC0, 0x66, 0x33, 0x33, 0x99, 0x9C, 0xCC, 0xB6, 0x6D, 0xB3,
  0x6D, 0x9E, 0x3C, 0xF1, 0xE7, 0x8F, 0x38, 0x38, 0xF0, 0xE7, 0x9C, 0x7F,
  0xC3, 0xF8, 0x1F, 0x01, 0xF0, 0x0E, 0x01, 0xF0, 0x1F, 0x03, 0xB8, 0x3B,
  0x87, 0x1C, 0x71, 0xEE, 0x0E, 0xE0, 0x3B, 0x83, 0x9C, 0x1C, 0x71, 0xC3,
  0xDE, 0x0E, 0xE0, 0x3E, 0x01, 0xF0, 0x07, 0x00, 0x38, 0x01, 0xC0, 0x0E,
  0x00, 0x70, 0x03, 0x80, 0xFF, 0xFF, 0xF0, 0x38, 0x0E, 0x07, 0x01, 0x80,
  0xE0, 0x70, 0x18, 0x0E, 0x07, 0x01, 0xC0, 0xFF, 0xFF, 0xF0, 0xFF, 0xFE,
  0x38, 0xE3, 0x8E, 0x38, 0xE3, 0x8E, 0x38, 0xE3, 0x8E, 0x38, 0xE3, 0x8F,
  0xFF, 0xE0, 0x18, 0x07, 0x00, 0xC0, 0x38, 0x0E, 0x01, 0x80, 0x70, 0x0C,
  0x03, 0x80, 0x60, 0x1C, 0x07, 0x00, 0xC0, 0x38, 0x06, 0x01, 0xC0, 0xFF,
  0xF1, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C,
  0x7F, 0xFF, 0x0E, 0x01, 0xC0, 0x6C, 0x1D, 0x83, 0x18, 0xE3, 0x9C, 0x70,
  0xFF, 0xFF, 0xFF, 0x3C, 0x1E, 0x0F, 0x00, 0x3F, 0x1F, 0xE4, 0x1C, 0x07,
  0x3F, 0xDF, 0xFF, 0x1F, 0x87, 0xE3, 0xFF, 0xF7, 0xDC, 0xE0, 0x38, 0x0E,
  0x03, 0x80, 0xEF, 0x3F, 0xEF, 0x3F, 0x87, 0xE1, 0xF8, 0x7E, 0x1F, 0x87,
  0xE3, 0xBF, 0xCF, 0xE0, 0x1F, 0x1F, 0xDC, 0x3C, 0x0E, 0x07, 0x03, 0x81,
  0xC0, 0x70, 0xBF, 0xC7, 0xC0, 0x01, 0xC0, 0x70, 0x1C, 0x07, 0x1F, 0xDF,
  0xF7, 0x1F, 0x87, 0xE1, 0xF8, 0x7E, 0x1F, 0x87, 0xF3, 0xDF, 0xF3, 0xDC,
  0x1F, 0x1F, 0xE7, 0x3F, 0x87, 0xFF, 0xFF, 0xFE, 0x03, 0x80, 0x70, 0x9F,
  0xE1, 0xF0, 0x03, 0xE0, 0xFC, 0x3C, 0x07, 0x00, 0xE0, 0x1C, 0x1F, 0xF3,
  0xFE, 0x0E, 0x01, 0xC0, 0x38, 0x07, 0x00, 0xE0, 0x1C, 0x03, 0x80, 0x1F,
  0xE7, 0xFD, 0xC7, 0x38, 0xE7, 0x1C, 0x7F, 0x0F, 0xC3, 0x80, 0x70, 0x0F,
  0xF9, 0xFF, 0xF0, 0x7E, 0x0F, 0xFF, 0x8F, 0xE0, 0xE0, 0x38, 0x0E, 0x03,
  0x80, 0xEF, 0x3F, 0xEF, 0x1F, 0x87, 0xE1, 0xF8, 0x7E, 0x1F, 0x87, 0xE1,
  0xF8, 0x7E, 0x1C, 0x18, 0x1E, 0x0F, 0x00, 0x0F, 0xC7, 0xE0, 0x70, 0x38,
  0x1C, 0x0E, 0x07, 0x03, 0x81, 0xC7, 0xFF, 0xFE, 0x03, 0x03, 0xC1, 0xE0,
  0x0F, 0xFF, 0xFC, 0x0E, 0x07, 0x03, 0x81, 0xC0, 0xE0, 0x70, 0x38, 0x1C,
  0x0E, 0x07, 0x87, 0xFF, 0x9F, 0x00, 0xE0, 0x70, 0x38, 0x1C, 0x0E, 0x3F,
  0x3B, 0xBD, 0xDC, 0xFE, 0x7F, 0x3F, 0x9D, 0xEE, 0x77, 0x3F, 0x8E, 0xFC,
  0x7E, 0x07, 0x03, 0x81, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0E, 0x07, 0x03,
  0x81, 0xC7, 0xFF, 0xFE, 0xFD, 0xDF, 0xFF, 0xBB, 0xF7, 0x7E, 0xEF, 0xDD,
  0xFB, 0xBF, 0x77, 0xEE, 0xFD, 0xDF, 0xBB, 0x80, 0xEF, 0x3F, 0xEF, 0x1F,
  0x87, 0xE1, 0xF8, 0x7E, 0x1F, 0x87, 0xE1, 0xF8, 0x7E, 0x1C, 0x1F, 0x07,
  0xF9, 0xC7, 0x70, 0x7E, 0x0F, 0xC1, 0xF8, 0x3F, 0x07, 0x71, 0xCF, 0xF0,
  0x7C, 0x00, 0xEF, 0x3F, 0xEF, 0x3F, 0x87, 0xE1, 0xF8, 0x7E, 0x1F, 0x87,
  0xE3, 0xBF, 0xEF, 0xE3, 0x80, 0xE0, 0x38, 0x0E, 0x00, 0x1F, 0xDF, 0xF7,
  0x1F, 0x87, 0xE1, 0xF8, 0x7E, 0x1F, 0x87, 0xF3, 0xDF, 0xF3, 0xDC, 0x07,
  0x01, 0xC0, 0x70, 0x1C, 0xEF, 0x3F, 0xEF, 0x1F, 0x87, 0xE0, 0x38, 0x0E,
  0x03, 0x80, 0xE0, 0x38, 0x0E, 0x00, 0x3E, 0x3F, 0xB8, 0x5C, 0x0F, 0xC3,
  0xF8, 0x3E, 0x07, 0x83, 0xFF, 0x9F, 0x80, 0x1C, 0x07, 0x01, 0xC3, 0xFF,
  0xFF, 0xC7, 0x01, 0xC0, 0x70, 0x1C, 0x07, 0x01, 0xC0, 0x70, 0x0F, 0xC1,
  0xF0, 0xE1, 0xF8, 0x7E, 0x1F, 0x87, 0xE1, 0xF8, 0x7E, 0x1F, 0x87, 0xE3,
  0xDF, 0xF3, 0xDC, 0x70, 0x33, 0x83, 0x8C, 0x18, 0x71, 0xC3, 0x8E, 0x0C,
  0x60, 0x77, 0x01, 0xB0, 0x0D, 0x80, 0x7C, 0x01, 0xC0, 0x60, 0x33, 0x01,
  0x98, 0x0C, 0xCE, 0x66, 0x73, 0x3B, 0x99, 0xF6, 0xC7, 0xBC, 0x3D, 0xE1,
  0xC7, 0x0E, 0x38, 0x78, 0x39, 0xC3, 0x87, 0x38, 0x1F, 0x80, 0x78, 0x03,
  0x80, 0x3E, 0x01, 0xB8, 0x18, 0xE1, 0xC3, 0x9C, 0x1E, 0x70, 0x73, 0x83,
  0x8C, 0x18, 0x71, 0xC3, 0x8E, 0x0C, 0x60, 0x77, 0x01, 0xB0, 0x0F, 0x80,
  0x78, 0x01, 0xC0, 0x0C, 0x00, 0xE0, 0x7E, 0x03, 0xC0, 0x00, 0xFF, 0xFF,
  0xC1, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0x70, 0x70, 0x7F, 0xFF, 0xE0, 0x07,
  0x87, 0xC7, 0x83, 0x81, 0xC0, 0xE0, 0x70, 0x38, 0x3C, 0x7C, 0x3E, 0x07,
  0x81, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0F, 0x03, 0xE0, 0xF0, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xF0, 0x7C, 0x0F, 0x03, 0x81,
  0xC0, 0xE0, 0x70, 0x38, 0x1E, 0x07, 0xC3, 0xE3, 0x81, 0xC0, 0xE0, 0x70,
  0x38, 0x1C, 0x1E, 0x3E, 0x1E, 0x00, 0x78, 0x0F, 0x8F, 0x39, 0xE3, 0xE0,
  0x3C };

const GFXglyph Courier_Prime_Sans6pt7bGlyphs[] PROGMEM = {
  {      0,   1,   1,  12,    0,   12 },   // 0x20 ' '
  {      1,   4,  15,  12,    4,   -2 },   // 0x21 '!'
  {      9,   8,   5,  12,    2,   -2 },   // 0x22 '"'
  {     14,  12,  14,  12,    0,   -1 },   // 0x23 '#'
  {     35,  10,  19,  12,    1,   -3 },   // 0x24 '$'
  {     59,  12,  15,  12,    0,   -2 },   // 0x25 '%'
  {     82,  12,  15,  12,    0,   -2 },   // 0x26 '&'
  {    105,   3,   5,  12,    5,   -2 },   // 0x27 '''
  {    107,   7,  20,  12,    3,   -3 },   // 0x28 '('
  {    125,   7,  20,  12,    2,   -3 },   // 0x29 ')'
  {    143,   9,   9,  12,    2,   -2 },   // 0x2A '*'
  {    154,  11,  10,  12,    1,    2 },   // 0x2B '+'
  {    168,   6,   8,  12,    2,    9 },   // 0x2C ','
  {    174,   7,   2,  12,    3,    6 },   // 0x2D '-'
  {    176,   4,   4,  12,    4,    9 },   // 0x2E '.'
  {    178,  11,  17,  12,    1,   -2 },   // 0x2F '/'
  {    202,  11,  14,  12,    1,   -1 },   // 0x30 '0'
  {    222,  10,  14,  12,    1,   -1 },   // 0x31 '1'
  {    240,  10,  14,  12,    1,   -1 },   // 0x32 '2'
  {    258,  10,  14,  12,    2,   -1 },   // 0x33 '3'
  {    276,  11,  14,  12,    0,   -1 },   // 0x34 '4'
  {    296,   9,  14,  12,    2,   -1 },   // 0x35 '5'
  {    312,  10,  14,  12,    1,   -1 },   // 0x36 '6'
  {    330,  10,  14,  12,    1,   -1 },   // 0x37 '7'
  {    348,  10,  14,  12,    1,   -1 },   // 0x38 '8'
  {    366,  10,  14,  12,    1,   -1 },   // 0x39 '9'
  {    384,   4,  11,  12,    4,    2 },   // 0x3A ':'
  {    390,   6,  15,  12,    2,    2 },   // 0x3B ';'
  {    402,   9,  12,  12,    1,    1 },   // 0x3C '<'
  {    416,   9,   6,  12,    1,    4 },   // 0x3D '='
  {    423,   9,  12,  12,    2,    1 },   // 0x3E '>'
  {    437,   7,  15,  12,    3,   -2 },   // 0x3F '?'
  {    451,  12,  19,  12,    0,   -2 },   // 0x40 '@'
  {    480,  13,  14,  12,   -1,   -1 },   // 0x41 'A'
  {    503,  10,  14,  12,    1,   -1 },   // 0x42 'B'
  {    521,  10,  14,  12,    1,   -1 },   // 0x43 'C'
  {    539,  11,  14,  12,    1,   -1 },   // 0x44 'D'
  {    559,   8,  14,  12,    2,   -1 },   // 0x45 'E'
  {    573,   8,  14,  12,    2,   -1 },   // 0x46 'F'
  {    587,  11,  14,  12,    1,   -1 },   // 0x47 'G'
  {    607,  10,  14,  12,    1,   -1 },   // 0x48 'H'
  {    625,   9,  14,  12,    2,   -1 },   // 0x49 'I'
  {    641,   8,  14,  12,    2,   -1 },   // 0x4A 'J'
  {    655,  10,  14,  12,    1,   -1 },   // 0x4B 'K'
  {    673,   9,  14,  12,    2,   -1 },   // 0x4C 'L'
  {    689,  13,  14,  12,   -1,   -1 },   // 0x4D 'M'
  {    712,  11,  14,  12,    1,   -1 },   // 0x4E 'N'
  {    732,  12,  14,  12,    0,   -1 },   // 0x4F 'O'
  {    753,  10,  14,  12,    1,   -1 },   // 0x50 'P'
  {    771,  12,  18,  12,    0,   -1 },   // 0x51 'Q'
  {    798,  10,  14,  12,    1,   -1 },   // 0x52 'R'
  {    816,  10,  14,  12,    1,   -1 },   // 0x53 'S'
  {    834,  11,  14,  12,    1,   -1 },   // 0x54 'T'
  {    854,  11,  14,  12,    1,   -1 },   // 0x55 'U'
  {    874,  13,  14,  12,    0,   -1 },   // 0x56 'V'
  {    897,  13,  14,  12,   -1,   -1 },   // 0x57 'W'
  {    920,  12,  14,  12,    0,   -1 },   // 0x58 'X'
  {    941,  13,  14,  12,    0,   -1 },   // 0x59 'Y'
  {    964,  10,  14,  12,    1,   -1 },   // 0x5A 'Z'
  {    982,   6,  20,  12,    3,   -3 },   // 0x5B '['
  {    997,  10,  17,  12,    1,   -2 },   // 0x5C '\'
  {   1019,   6,  20,  12,    3,   -3 },   // 0x5D ']'
  {   1034,  11,   7,  12,    0,   -1 },   // 0x5E '^'
  {   1044,  12,   2,  12,    0,   15 },   // 0x5F '_'
  {   1047,   8,   4,  12,    0,   -2 },   // 0x60 '`'
  {   1051,  10,  11,  12,    1,    2 },   // 0x61 'a'
  {   1065,  10,  15,  12,    2,   -2 },   // 0x62 'b'
  {   1084,   9,  11,  12,    1,    2 },   // 0x63 'c'
  {   1097,  10,  15,  12,    1,   -2 },   // 0x64 'd'
  {   1116,  10,  11,  12,    1,    2 },   // 0x65 'e'
  {   1130,  11,  15,  12,    0,   -2 },   // 0x66 'f'
  {   1151,  11,  15,  12,    1,    2 },   // 0x67 'g'
  {   1172,  10,  15,  12,    2,   -2 },   // 0x68 'h'
  {   1191,   9,  15,  12,    2,   -2 },   // 0x69 'i'
  {   1208,   9,  19,  12,    1,   -2 },   // 0x6A 'j'
  {   1230,   9,  15,  12,    2,   -2 },   // 0x6B 'k'
  {   1247,   9,  15,  12,    2,   -2 },   // 0x6C 'l'
  {   1264,  11,  11,  12,    1,    2 },   // 0x6D 'm'
  {   1280,  10,  11,  12,    2,    2 },   // 0x6E 'n'
  {   1294,  11,  11,  12,    1,    2 },   // 0x6F 'o'
  {   1310,  10,  15,  12,    2,    2 },   // 0x70 'p'
  {   1329,  10,  15,  12,    1,    2 },   // 0x71 'q'
  {   1348,  10,  11,  12,    2,    2 },   // 0x72 'r'
  {   1362,   9,  11,  12,    2,    2 },   // 0x73 's'
  {   1375,  10,  14,  12,    1,   -1 },   // 0x74 't'
  {   1393,  10,  11,  12,    1,    2 },   // 0x75 'u'
  {   1407,  13,  11,  12,    0,    2 },   // 0x76 'v'
  {   1425,  13,  11,  12,   -1,    2 },   // 0x77 'w'
  {   1443,  13,  11,  12,   -1,    2 },   // 0x78 'x'
  {   1461,  13,  15,  12,    0,    2 },   // 0x79 'y'
  {   1486,   9,  11,  12,    2,    2 },   // 0x7A 'z'
  {   1499,   9,  20,  12,    1,   -3 },   // 0x7B '{'
  {   1522,   3,  22,  12,    5,   -5 },   // 0x7C '|'
  {   1531,   9,  20,  12,    2,   -3 },   // 0x7D '}'
  {   1554,  11,   5,  12,    1,    5 } }; // 0x7E '~'

const GFXfont Courier_Prime_Sans6pt7b PROGMEM = {
  (uint8_t  *)Courier_Prime_Sans6pt7bBitmaps,
  (GFXglyph *)Courier_Prime_Sans6pt7bGlyphs,
  0x20, 0x7E, 25 };

// Approx. 2233 bytes
#elif defined(_CLOCK_2400x1440)
const uint8_t Courier_Prime_Sans6pt7bBitmaps[] PROGMEM = {
  0x00, 0x7B, 0xDE, 0xF7, 0xBD, 0xEF, 0x7B, 0xDE, 0xF7, 0xBD, 0xEF, 0x00,
  0x1D, 0xFF, 0xB8, 0xF3, 0xFC, 0xFF, 0x3F, 0xCF, 0xF3, 0xFC, 0xFF, 0x3F,
  0xCF, 0x0E, 0x0E, 0x07, 0x07, 0x03, 0x83, 0x81, 0xC1, 0xC0, 0xE0, 0xE3,
  0xFF, 0xFD, 0xFF, 0xFE, 0xFF, 0xFF, 0x1C, 0x1C, 0x0E, 0x0E, 0x07, 0x07,
  0x03, 0x83, 0x81, 0xC1, 0xC7, 0xFF, 0xFB, 0xFF, 0xFD, 0xFF, 0xFE, 0x38,
  0x38, 0x1C, 0x1C, 0x0E, 0x0E, 0x07, 0x07, 0x03, 0x83, 0x80, 0x00, 0xE0,
  0x01, 0xC0, 0x03, 0x80, 0x3F, 0x83, 0xFF, 0x8F, 0xFF, 0x1E, 0x72, 0x78,
  0xE0, 0xF1, 0xC1, 0xE3, 0x83, 0xF6, 0x03, 0xFC, 0x07, 0xFE, 0x03, 0xFF,
  0x01, 0xFF, 0x01, 0xFF, 0x03, 0xBE, 0x06, 0x3C, 0x1C, 0x78, 0x38, 0xFC,
  0x73, 0xDF, 0xFF, 0xBF, 0xFC, 0x1F, 0xE0, 0x06, 0x00, 0x1C, 0x00, 0x38,
  0x00, 0x70, 0x00, 0x1F, 0x01, 0xCF, 0xE0, 0xE3, 0xBC, 0x71, 0xC7, 0x1C,
  0x71, 0xCE, 0x1C, 0x77, 0x07, 0x1D, 0xC1, 0xEE, 0xE0, 0x3F, 0xF0, 0x07,
  0xDC, 0x00, 0x0E, 0x00, 0x07, 0x00, 0x03, 0xDF, 0x00, 0xEF, 0xE0, 0x77,
  0xBC, 0x3D, 0xC7, 0x0E, 0x71, 0xC7, 0x1C, 0x73, 0xC7, 0x1C, 0xE1, 0xEE,
  0x70, 0x3F, 0xBC, 0x07, 0xC0, 0x07, 0xE0, 0x01, 0xFF, 0x00, 0x7F, 0xE0,
  0x1F, 0x3E, 0x03, 0xC3, 0xC0, 0x78, 0x78, 0x0F, 0x0F, 0x01, 0xF3, 0xC0,
  0x1F, 0xF0, 0x01, 0xFC, 0x00, 0x3F, 0x00, 0x1F, 0xE3, 0xC7, 0xDE, 0x78,
  0xF3, 0xEF, 0x3C, 0x3F, 0xE7, 0x83, 0xF8, 0xF0, 0x3F, 0x1E, 0x03, 0xE3,
  0xF0, 0x7C, 0x3F, 0xFF, 0xC3, 0xFF, 0xFC, 0x1F, 0xE3, 0xC0, 0xFF, 0xFF,
  0xFF, 0xFF, 0x01, 0x00, 0xE0, 0x7C, 0x3E, 0x0F, 0x07, 0x83, 0xC0, 0xF0,
  0x78, 0x1E, 0x07, 0x83, 0xC0, 0xF0, 0x3C, 0x0F, 0x03, 0xC0, 0xF0, 0x3C,
  0x0F, 0x01, 0xE0, 0x78, 0x1E, 0x03, 0xC0, 0xF0, 0x1E, 0x07, 0xC0, 0xF8,
  0x1F, 0x03, 0x80, 0x40, 0x20, 0x1C, 0x0F, 0x81, 0xF0, 0x3E, 0x07, 0x80,
  0xF0, 0x3C, 0x07, 0x81, 0xE0, 0x78, 0x0F, 0x03, 0xC0, 0xF0, 0x3C, 0x0F,
  0x03, 0xC0, 0xF0, 0x3C, 0x1E, 0x07, 0x81, 0xE0, 0xF0, 0x3C, 0x1E, 0x0F,
  0x07, 0xC3, 0xE0, 0x70, 0x08, 0x00, 0x07, 0xC0, 0x0F, 0x81, 0x1F, 0x13,
  0xBE, 0xEF, 0xFF, 0xEF, 0xFF, 0x87, 0xFC, 0x0F, 0xF8, 0x7F, 0xFD, 0xFF,
  0xFD, 0xDF, 0x72, 0x3E, 0x20, 0x7C, 0x00, 0xF8, 0x00, 0x03, 0xC0, 0x03,
  0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03,
  0xC0, 0x03, 0xC0, 0x0E, 0x0F, 0x87, 0xE3, 0xF0, 0xF8, 0x3C, 0x1E, 0x0E,
  0x1F, 0x7F, 0x3F, 0x1E, 0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x7B, 0xFF, 0xFF,
  0xFD, 0xE0, 0x00, 0x1E, 0x00, 0x78, 0x00, 0xF0, 0x03, 0xC0, 0x07, 0x80,
  0x0E, 0x00, 0x3C, 0x00, 0x78, 0x01, 0xE0, 0x03, 0xC0, 0x0F, 0x00, 0x1E,
  0x00, 0x78, 0x00, 0xF0, 0x01, 0xC0, 0x07, 0x80, 0x0F, 0x00, 0x3C, 0x00,
  0x78, 0x01, 0xE0, 0x03, 0xC0, 0x07, 0x00, 0x1E, 0x00, 0x3C, 0x00, 0xF0,
  0x00, 0x07, 0xE0, 0x1F, 0xF8, 0x3F, 0xFC, 0x3C, 0x3E, 0x78, 0x1E, 0x78,
  0x1E, 0xF8, 0x1F, 0xF0, 0x3F, 0xF0, 0xFF, 0xF1, 0xEF, 0xF3, 0xCF, 0xF7,
  0x8F, 0xFF, 0x0F, 0xFC, 0x0F, 0xF8, 0x0F, 0x78, 0x1E, 0x78, 0x1E, 0x7C,
  0x3C, 0x3F, 0xFC, 0x1F, 0xF8, 0x07, 0xE0, 0x03, 0xC0, 0x1F, 0x80, 0x7F,
  0x03, 0xFE, 0x0F, 0xFC, 0x0E, 0x78, 0x10, 0xF0, 0x01, 0xE0, 0x03, 0xC0,
  0x07, 0x80, 0x0F, 0x00, 0x1E, 0x00, 0x3C, 0x00, 0x78, 0x00, 0xF0, 0x01,
  0xE0, 0x03, 0xC0, 0x07, 0x81, 0xFF, 0xFB, 0xFF, 0xF7, 0xFF, 0xE0, 0x1F,
  0x81, 0xFF, 0x8F, 0xFF, 0x1C, 0x3E, 0x20, 0x78, 0x01, 0xE0, 0x07, 0x80,
  0x1E, 0x00, 0x78, 0x03, 0xC0, 0x1F, 0x00, 0xF8, 0x03, 0xC0, 0x1E, 0x00,
  0xF0, 0x07, 0x80, 0x3C, 0x01, 0xE0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x1F, 0xC1, 0xFF, 0x87, 0xFF, 0x18, 0x3E, 0x00, 0x78, 0x01, 0xE0, 0x07,
  0x80, 0x1E, 0x01, 0xF0, 0x7F, 0x81, 0xFE, 0x07, 0xFE, 0x00, 0xF8, 0x00,
  0xF0, 0x03, 0xC0, 0x0F, 0x00, 0x7E, 0x03, 0xEF, 0xFF, 0xBF, 0xF8, 0x7F,
  0x80, 0x00, 0xFC, 0x00, 0xFE, 0x00, 0x7F, 0x00, 0x7F, 0x80, 0x3F, 0xC0,
  0x3D, 0xE0, 0x1C, 0xF0, 0x1E, 0x78, 0x1E, 0x3C, 0x0F, 0x1E, 0x0F, 0x0F,
  0x07, 0x07, 0x87, 0x83, 0xC7, 0x81, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x80, 0x1E, 0x00, 0x0F, 0x00, 0x07, 0x80, 0x03, 0xC0, 0xFF, 0xF7,
  0xFF, 0xBF, 0xFD, 0xE0, 0x0F, 0x00, 0x78, 0x03, 0xC0, 0x1E, 0x00, 0xFF,
  0x87, 0xFF, 0x3F, 0xFC, 0x03, 0xF0, 0x0F, 0x80, 0x3C, 0x01, 0xE0, 0x0F,
  0x00, 0xFC, 0x0F, 0xBF, 0xF9, 0xFF, 0x87, 0xF0, 0x00, 0x01, 0xF8, 0x1F,
  0xF0, 0x7F, 0xE1, 0xF0, 0x07, 0xC0, 0x0F, 0x00, 0x1E, 0x00, 0x78, 0x00,
  0xF7, 0xE1, 0xFF, 0xF3, 0xFF, 0xF7, 0xC1, 0xFF, 0x01, 0xFE, 0x03, 0xFC,
  0x07, 0xF8, 0x0F, 0x78, 0x3E, 0xF8, 0xF8, 0xFF, 0xE0, 0xFF, 0x80, 0xFE,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x01, 0xF0, 0x03, 0xC0, 0x0F,
  0x80, 0x1E, 0x00, 0x7C, 0x00, 0xF0, 0x03, 0xE0, 0x07, 0x80, 0x1F, 0x00,
  0x3C, 0x00, 0xF8, 0x01, 0xE0, 0x07, 0xC0, 0x0F, 0x00, 0x3E, 0x00, 0x78,
  0x01, 0xF0, 0x03, 0xC0, 0x00, 0x0F, 0xE0, 0x7F, 0xF1, 0xFF, 0xF7, 0xC1,
  0xFF, 0x01, 0xFE, 0x03, 0xFE, 0x0F, 0xBE, 0x1E, 0x7F, 0xF8, 0x7F, 0xE0,
  0x3F, 0xC1, 0xFF, 0xC7, 0xCF, 0xCF, 0x07, 0xFC, 0x07, 0xF8, 0x0F, 0xF0,
  0x1F, 0xF0, 0x7D, 0xFF, 0xF1, 0xFF, 0xC0, 0xFE, 0x00, 0x07, 0xE0, 0x3F,
  0xE1, 0xFF, 0xE3, 0xE3, 0xEF, 0x83, 0xDE, 0x03, 0xFC, 0x07, 0xF8, 0x0F,
  0xF0, 0x1F, 0xF0, 0x7D, 0xFF, 0xF9, 0xFF, 0xF1, 0xFD, 0xE0, 0x03, 0xC0,
  0x0F, 0x00, 0x1E, 0x00, 0x7C, 0x03, 0xF1, 0xFF, 0xC3, 0xFF, 0x07, 0xF0,
  0x00, 0x7B, 0xFF, 0xFF, 0xFD, 0xE0, 0x00, 0x00, 0x07, 0xBF, 0xFF, 0xFF,
  0xDE, 0x0F, 0x0F, 0xC7, 0xE3, 0xF1, 0xF8, 0x78, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x83, 0xE1, 0xF8, 0xFC, 0x3E, 0x0F, 0x07, 0x83, 0x87, 0xDF, 0xCF,
  0xC7, 0x80, 0x00, 0x20, 0x03, 0x80, 0x3E, 0x07, 0xE0, 0x7E, 0x07, 0xC0,
  0x7C, 0x07, 0xC0, 0xFC, 0x03, 0xE0, 0x0F, 0x80, 0x3E, 0x00, 0xF8, 0x03,
  0xF0, 0x0F, 0xC0, 0x1F, 0x00, 0x70, 0x01, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x20, 0x03, 0x80, 0x3E, 0x00, 0xFC, 0x03, 0xF0, 0x07, 0xC0, 0x1F, 0x00,
  0x7C, 0x01, 0xF8, 0x0F, 0x80, 0xF8, 0x0F, 0x80, 0xF8, 0x1F, 0x81, 0xF8,
  0x1F, 0x00, 0x70, 0x01, 0x00, 0x00, 0xF8, 0x1F, 0xE3, 0xFE, 0x07, 0xE0,
  0x3C, 0x03, 0xC0, 0x78, 0x0F, 0x01, 0xE0, 0x7C, 0xFF, 0x1F, 0xC3, 0xF0,
  0x78, 0x0F, 0x01, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x3E, 0x07, 0xC0, 0x70,
  0x00, 0x00, 0xF8, 0x00, 0xFF, 0x80, 0x7F, 0xF0, 0x3C, 0x3C, 0x1E, 0x07,
  0x8F, 0x00, 0xE3, 0x80, 0x3C, 0xE0, 0x07, 0x71, 0xFD, 0xDC, 0xFF, 0x77,
  0x7F, 0xDF, 0xDC, 0xF7, 0xEF, 0x3D, 0xFB, 0x8E, 0x7E, 0xE3, 0x9F, 0xB8,
  0xE7, 0xEE, 0x3B, 0xBB, 0x9E, 0xEE, 0xFF, 0xFB, 0x9F, 0xFC, 0xE7, 0x9E,
  0x1C, 0x00, 0x07, 0x00, 0x01, 0xE0, 0x10, 0x3C, 0x1C, 0x0F, 0xFF, 0x01,
  0xFF, 0xC0, 0x1F, 0xC0, 0x01, 0xF8, 0x00, 0x7F, 0x00, 0x0F, 0xE0, 0x01,
  0xDC, 0x00, 0x3B, 0xC0, 0x0F, 0x78, 0x01, 0xEF, 0x00, 0x38, 0xF0, 0x0F,
  0x1E, 0x01, 0xE3, 0xC0, 0x38, 0x78, 0x0F, 0x07, 0x81, 0xE0, 0xF0, 0x3C,
  0x1E, 0x0F, 0xFF, 0xE1, 0xFF, 0xFC, 0x3F, 0xFF, 0x87, 0x00, 0xF1, 0xE0,
  0x1F, 0x3C, 0x01, 0xE7, 0x80, 0x3C, 0xFF, 0xE1, 0xFF, 0xE3, 0xFF, 0xE7,
  0x83, 0xEF, 0x03, 0xDE, 0x07, 0xBC, 0x0F, 0x78, 0x1E, 0xF0, 0x79, 0xFF,
  0xE3, 0xFF, 0xC7, 0xFF, 0xEF, 0x07, 0xDE, 0x03, 0xFC, 0x07, 0xF8, 0x0F,
  0xF0, 0x3F, 0xE0, 0xFB, 0xFF, 0xF7, 0xFF, 0xCF, 0xFE, 0x00, 0x03, 0xFC,
  0x1F, 0xFC, 0x7F, 0xF9, 0xF0, 0x37, 0xC0, 0x0F, 0x00, 0x1E, 0x00, 0x78,
  0x00, 0xF0, 0x01, 0xE0, 0x03, 0xC0, 0x07, 0x80, 0x0F, 0x00, 0x1E, 0x00,
  0x3E, 0x00, 0x3C, 0x00, 0x7C, 0x00, 0x7C, 0x0C, 0x7F, 0xF8, 0x7F, 0xF0,
  0x3F, 0x80, 0xFF, 0xC0, 0xFF, 0xF0, 0xFF, 0xFC, 0xF0, 0x7C, 0xF0, 0x3E,
  0xF0, 0x1E, 0xF0, 0x1F, 0xF0, 0x0F, 0xF0, 0x0F, 0xF0, 0x0F, 0xF0, 0x0F,
  0xF0, 0x0F, 0xF0, 0x0F, 0xF0, 0x0F, 0xF0, 0x1E, 0xF0, 0x1E, 0xF0, 0x3E,
  0xF0, 0x7C, 0xFF, 0xF8, 0xFF, 0xF0, 0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xE0, 0x0F, 0x00, 0x78, 0x03, 0xC0, 0x1E, 0x00, 0xF0, 0x07, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x78, 0x03, 0xC0, 0x1E, 0x00, 0xF0, 0x07,
  0x80, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00, 0xF0, 0x0F,
  0x00, 0xF0, 0x00, 0x01, 0xFC, 0x0F, 0xFF, 0x1F, 0xFF, 0x3F, 0x03, 0x7C,
  0x00, 0x78, 0x00, 0x78, 0x00, 0xF0, 0x00, 0xF0, 0x00, 0xF0, 0xFF, 0xF0,
  0xFF, 0xF0, 0xFF, 0xF0, 0x0F, 0xF0, 0x0F, 0xF8, 0x0F, 0x78, 0x0F, 0x7C,
  0x0F, 0x3E, 0x0F, 0x1F, 0xFF, 0x0F, 0xFF, 0x03, 0xFC, 0xF0, 0x1F, 0xE0,
  0x3F, 0xC0, 0x7F, 0x80, 0xFF, 0x01, 0xFE, 0x03, 0xFC, 0x07, 0xF8, 0x0F,
  0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0xFE, 0x03, 0xFC,
  0x07, 0xF8, 0x0F, 0xF0, 0x1F, 0xE0, 0x3F, 0xC0, 0x7F, 0x80, 0xFF, 0x01,
  0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xE0, 0x07, 0x80, 0x1E, 0x00,
  0x78, 0x01, 0xE0, 0x07, 0x80, 0x1E, 0x00, 0x78, 0x01, 0xE0, 0x07, 0x80,
  0x1E, 0x00, 0x78, 0x01, 0xE0, 0x07, 0x80, 0x1E, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00,
  0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00,
  0xF0, 0x0F, 0x81, 0xFC, 0x3E, 0xFF, 0xE7, 0xFC, 0x3F, 0x00, 0xF0, 0x3F,
  0xE0, 0xFB, 0xC1, 0xE7, 0x87, 0xCF, 0x1F, 0x1E, 0x3C, 0x3C, 0xF8, 0x79,
  0xE0, 0xF7, 0x81, 0xFE, 0x03, 0xFC, 0x07, 0xFC, 0x0F, 0x78, 0x1E, 0x78,
  0x3C, 0xF8, 0x78, 0xF0, 0xF1, 0xF1, 0xE1, 0xF3, 0xC1, 0xE7, 0x83, 0xEF,
  0x03, 0xE0, 0xF0, 0x07, 0x80, 0x3C, 0x01, 0xE0, 0x0F, 0x00, 0x78, 0x03,
  0xC0, 0x1E, 0x00, 0xF0, 0x07, 0x80, 0x3C, 0x01, 0xE0, 0x0F, 0x00, 0x78,
  0x03, 0xC0, 0x1E, 0x00, 0xF0, 0x07, 0x80, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF,
  0x80, 0x7C, 0x1F, 0x3E, 0x0F, 0x9F, 0x07, 0xCF, 0xC7, 0xE7, 0xE3, 0xF3,
  0xF1, 0xF9, 0xDD, 0xDC, 0xEE, 0xEE, 0x77, 0x77, 0x3B, 0xB3, 0x9C, 0xF9,
  0xCE, 0x7C, 0xE7, 0x3C, 0x73, 0x8E, 0x39, 0xC7, 0x1C, 0xE0, 0x0E, 0x70,
  0x07, 0x38, 0x03, 0x9C, 0x01, 0xCE, 0x00, 0xE7, 0x00, 0x70, 0xF8, 0x0F,
  0xFC, 0x0F, 0xFC, 0x0F, 0xFE, 0x0F, 0xFE, 0x0F, 0xFF, 0x0F, 0xFF, 0x0F,
  0xF7, 0x8F, 0xF7, 0x8F, 0xF3, 0xCF, 0xF3, 0xCF, 0xF1, 0xCF, 0xF1, 0xEF,
  0xF1, 0xEF, 0xF0, 0xFF, 0xF0, 0xFF, 0xF0, 0x7F, 0xF0, 0x7F, 0xF0, 0x3F,
  0xF0, 0x3F, 0xF0, 0x1F, 0x03, 0xF0, 0x07, 0xFE, 0x07, 0xFF, 0x87, 0x83,
  0xC7, 0x80, 0xF3, 0xC0, 0x7B, 0xC0, 0x1F, 0xE0, 0x0F, 0xF0, 0x07, 0xF8,
  0x03, 0xFC, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0x7F, 0x80, 0x3F, 0xC0, 0x1E,
  0xF0, 0x1E, 0x78, 0x0F, 0x3E, 0x0F, 0x0F, 0xFF, 0x03, 0xFF, 0x00, 0x7E,
  0x00, 0xFF, 0xC3, 0xFF, 0xCF, 0xFF, 0xBC, 0x3E, 0xF0, 0x7F, 0xC0, 0xFF,
  0x03, 0xFC, 0x0F, 0xF0, 0x3F, 0xC1, 0xFF, 0x0F, 0xBF, 0xFC, 0xFF, 0xE3,
  0xFE, 0x0F, 0x00, 0x3C, 0x00, 0xF0, 0x03, 0xC0, 0x0F, 0x00, 0x3C, 0x00,
  0xF0, 0x00, 0x03, 0xF0, 0x03, 0xFF, 0x01, 0xFF, 0xE0, 0xF0, 0x78, 0x78,
  0x0F, 0x1E, 0x03, 0xCF, 0x00, 0x7B, 0xC0, 0x1E, 0xF0, 0x07, 0xBC, 0x01,
  0xEF, 0x00, 0x7B, 0xC0, 0x1E, 0xF0, 0x07, 0xBC, 0x01, 0xEF, 0x00, 0x79,
  0xE0, 0x3C, 0x78, 0x0F, 0x1F, 0x07, 0x83, 0xFF, 0xE0, 0x7F, 0xF0, 0x0F,
  0xF0, 0x00, 0xF0, 0x00, 0x3C, 0x00, 0x0F, 0x80, 0x01, 0xF1, 0x00, 0x7F,
  0xE0, 0x0F, 0xFC, 0x00, 0xFC, 0xFF, 0xC0, 0xFF, 0xF0, 0xFF, 0xF8, 0xF0,
  0x7C, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0x3C, 0xF0, 0xF8, 0xFF,
  0xF0, 0xFF, 0xC0, 0xFF, 0xC0, 0xF3, 0xE0, 0xF1, 0xF0, 0xF0, 0xF0, 0xF0,
  0xF8, 0xF0, 0x78, 0xF0, 0x7C, 0xF0, 0x3C, 0xF0, 0x3E, 0xF0, 0x1E, 0x0F,
  0xE0, 0xFF, 0xE7, 0xFF, 0xBE, 0x06, 0xF0, 0x03, 0xC0, 0x0F, 0x00, 0x3F,
  0x00, 0x7F, 0x01, 0xFF, 0x81, 0xFF, 0x01, 0xFE, 0x01, 0xFC, 0x01, 0xF0,
  0x03, 0xC0, 0x0F, 0x00, 0x3F, 0x01, 0xEF, 0xFF, 0xBF, 0xFC, 0x7F, 0x80,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0,
  0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0,
  0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0,
  0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0xF0, 0x1F, 0xE0, 0x3F, 0xC0, 0x7F,
  0x80, 0xFF, 0x01, 0xFE, 0x03, 0xFC, 0x07, 0xF8, 0x0F, 0xF0, 0x1F, 0xE0,
  0x3F, 0xC0, 0x7F, 0x80, 0xFF, 0x01, 0xFE, 0x03, 0xFC, 0x07, 0xF8, 0x0F,
  0xF8, 0x3C, 0xF8, 0x79, 0xFF, 0xE1, 0xFF, 0x80, 0xFE, 0x00, 0x78, 0x03,
  0xCF, 0x00, 0x79, 0xF0, 0x0F, 0x1E, 0x03, 0xC3, 0xC0, 0x78, 0x78, 0x0F,
  0x0F, 0x83, 0xC0, 0xF0, 0x78, 0x1E, 0x0F, 0x03, 0xE1, 0xE0, 0x3C, 0x78,
  0x07, 0x8F, 0x00, 0xF1, 0xE0, 0x0F, 0x78, 0x01, 0xEF, 0x00, 0x3D, 0xE0,
  0x07, 0xB8, 0x00, 0x7F, 0x00, 0x0F, 0xE0, 0x01, 0xF8, 0x00, 0x1F, 0x00,
  0x70, 0x03, 0x9C, 0x00, 0xE7, 0x00, 0x39, 0xC0, 0x0E, 0x70, 0x03, 0x9C,
  0x00, 0xE7, 0x1C, 0x39, 0xC7, 0x0E, 0x71, 0xE3, 0x9E, 0x78, 0xE7, 0xBE,
  0x39, 0xED, 0xDE, 0x7B, 0x77, 0x9E, 0xDD, 0xE3, 0xB3, 0x70, 0xFC, 0xFC,
  0x3E, 0x3F, 0x0F, 0x8F, 0xC3, 0xE1, 0xF0, 0xF8, 0x7C, 0x3E, 0x1F, 0x00,
  0xF8, 0x0F, 0x9F, 0x07, 0xC7, 0xE1, 0xF0, 0xFC, 0xF8, 0x1F, 0x3C, 0x07,
  0xFF, 0x00, 0xFF, 0x80, 0x3F, 0xE0, 0x07, 0xF0, 0x00, 0xF8, 0x00, 0x3E,
  0x00, 0x1F, 0xC0, 0x07, 0xF0, 0x03, 0xFE, 0x00, 0xF7, 0xC0, 0x78, 0xF0,
  0x3E, 0x3E, 0x0F, 0x07, 0x87, 0xC1, 0xF1, 0xE0, 0x3E, 0xF8, 0x0F, 0x80,
  0xF0, 0x03, 0xDE, 0x01, 0xE7, 0x80, 0x78, 0xF0, 0x3C, 0x3C, 0x0F, 0x07,
  0x87, 0x81, 0xE3, 0xE0, 0x3C, 0xF0, 0x0F, 0x3C, 0x01, 0xFE, 0x00, 0x7F,
  0x80, 0x0F, 0xC0, 0x03, 0xF0, 0x00, 0x78, 0x00, 0x1E, 0x00, 0x07, 0x80,
  0x01, 0xE0, 0x00, 0x78, 0x00, 0x1E, 0x00, 0x07, 0x80, 0x01, 0xE0, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x01, 0xE0, 0x07, 0xC0, 0x1F, 0x00,
  0x3C, 0x00, 0xF8, 0x01, 0xE0, 0x07, 0x80, 0x1F, 0x00, 0x3C, 0x00, 0xF0,
  0x03, 0xE0, 0x07, 0x80, 0x1F, 0x00, 0x3C, 0x00, 0xF0, 0x03, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0x07, 0x83, 0xC1,
  0xE0, 0xF0, 0x78, 0x3C, 0x1E, 0x0F, 0x07, 0x83, 0xC1, 0xE0, 0xF0, 0x78,
  0x3C, 0x1E, 0x0F, 0x07, 0x83, 0xC1, 0xE0, 0xF0, 0x78, 0x3C, 0x1F, 0xFF,
  0xFF, 0xFC, 0xF0, 0x00, 0xE0, 0x01, 0xE0, 0x01, 0xC0, 0x03, 0xC0, 0x07,
  0x80, 0x07, 0x80, 0x0F, 0x00, 0x0F, 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x3C,
  0x00, 0x38, 0x00, 0x78, 0x00, 0xF0, 0x00, 0xF0, 0x01, 0xE0, 0x01, 0xE0,
  0x03, 0xC0, 0x03, 0xC0, 0x07, 0x80, 0x07, 0x00, 0x0F, 0x00, 0x1E, 0x00,
  0x1E, 0xFF, 0xFF, 0xFF, 0xE0, 0xF0, 0x78, 0x3C, 0x1E, 0x0F, 0x07, 0x83,
  0xC1, 0xE0, 0xF0, 0x78, 0x3C, 0x1E, 0x0F, 0x07, 0x83, 0xC1, 0xE0, 0xF0,
  0x78, 0x3C, 0x1E, 0x0F, 0x07, 0x83, 0xC1, 0xFF, 0xFF, 0xFF, 0xFC, 0x01,
  0xC0, 0x01, 0xF0, 0x01, 0xFC, 0x00, 0xEE, 0x00, 0xF7, 0x80, 0xF1, 0xE0,
  0x78, 0x70, 0x7C, 0x3C, 0x7C, 0x0F, 0x3E, 0x07, 0x80, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0x3E, 0x03, 0xE0, 0x1E, 0x01, 0xE0, 0x00, 0x00,
  0x00, 0x1F, 0xE1, 0xFF, 0xE7, 0xFF, 0x98, 0x1F, 0x00, 0x3C, 0x00, 0xF0,
  0xFF, 0xCF, 0xFF, 0x7F, 0xFF, 0xE0, 0xFF, 0x03, 0xFC, 0x1F, 0xF8, 0xFF,
  0xFF, 0xF7, 0xFD, 0xCF, 0xC7, 0xF0, 0x01, 0xE0, 0x03, 0xC0, 0x07, 0x80,
  0x0F, 0x00, 0x1E, 0x00, 0x3C, 0xF8, 0x7B, 0xFC, 0xFF, 0xFD, 0xF8, 0x7B,
  0xE0, 0xFF, 0x80, 0xFF, 0x01, 0xFE, 0x03, 0xFC, 0x07, 0xF8, 0x0F, 0xF0,
  0x3F, 0xE0, 0x7B, 0xC1, 0xF7, 0xFF, 0xCF, 0xFF, 0x07, 0xF8, 0x00, 0x07,
  0xF0, 0xFF, 0xCF, 0xFE, 0xF8, 0x17, 0x80, 0x7C, 0x03, 0xC0, 0x1E, 0x00,
  0xF0, 0x07, 0x80, 0x3C, 0x00, 0xF0, 0x07, 0xC0, 0x9F, 0xFC, 0x7F, 0xE0,
  0xFE, 0x00, 0x1E, 0x00, 0x3C, 0x00, 0x78, 0x00, 0xF0, 0x01, 0xE0, 0x03,
  0xC1, 0xFF, 0x8F, 0xFF, 0x3F, 0xFE, 0xF8, 0x3D, 0xE0, 0x7F, 0xC0, 0xFF,
  0x01, 0xFE, 0x03, 0xFC, 0x07, 0xF8, 0x0F, 0xF0, 0x1F, 0xF0, 0x7D, 0xE1,
  0xFB, 0xFF, 0xF3, 0xFF, 0xE1, 0xF1, 0xC0, 0x07, 0xE0, 0x3F, 0xF0, 0xFF,
  0xF3, 0xE1, 0xE7, 0x81, 0xFE, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xE0, 0x03, 0xC0, 0x07, 0xC0, 0x07, 0xC0, 0xC7, 0xFF, 0x87, 0xFF, 0x03,
  0xF8, 0x00, 0x3F, 0x00, 0x7F, 0xC0, 0x7F, 0xE0, 0x3C, 0x10, 0x3C, 0x00,
  0x1E, 0x00, 0x0F, 0x00, 0x07, 0x80, 0x03, 0xC0, 0x3F, 0xFF, 0x9F, 0xFF,
  0xCF, 0xFF, 0xE0, 0x3C, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x07, 0x80, 0x03,
  0xC0, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0x78, 0x00, 0x3C, 0x00, 0x1E, 0x00,
  0x07, 0xFF, 0x1F, 0xFF, 0x3F, 0xFF, 0x7C, 0x78, 0x78, 0x3C, 0x78, 0x3C,
  0x78, 0x3C, 0x7C, 0x7C, 0x3F, 0xF8, 0x3F, 0xF0, 0x7F, 0xE0, 0x7C, 0x00,
  0x7E, 0x00, 0x7F, 0xFC, 0x3F, 0xFE, 0x3F, 0xFF, 0x78, 0x0F, 0xF0, 0x0F,
  0xF8, 0x1F, 0xFF, 0xFE, 0x7F, 0xFC, 0x1F, 0xF0, 0xF0, 0x03, 0xC0, 0x0F,
  0x00, 0x3C, 0x00, 0xF0, 0x03, 0xC0, 0x0F, 0x3E, 0x3D, 0xFE, 0xFF, 0xFB,
  0xF1, 0xFF, 0x83, 0xFC, 0x0F, 0xF0, 0x3F, 0xC0, 0xFF, 0x03, 0xFC, 0x0F,
  0xF0, 0x3F, 0xC0, 0xFF, 0x03, 0xFC, 0x0F, 0xF0, 0x3F, 0xC0, 0xF0, 0x07,
  0x00, 0x3E, 0x00, 0xF8, 0x01, 0xC0, 0x00, 0x00, 0x00, 0x07, 0xF8, 0x1F,
  0xE0, 0x7F, 0x80, 0x1E, 0x00, 0x78, 0x01, 0xE0, 0x07, 0x80, 0x1E, 0x00,
  0x78, 0x01, 0xE0, 0x07, 0x80, 0x1E, 0x00, 0x78, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0xE0, 0x1F, 0x01, 0xF0, 0x0E, 0x00, 0x00, 0x00, 0x7F,
  0xF7, 0xFF, 0x7F, 0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00,
  0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00, 0xF0, 0x0F, 0x00,
  0xF0, 0x0F, 0x81, 0xEF, 0xFE, 0xFF, 0xC7, 0xF0, 0xF0, 0x01, 0xE0, 0x03,
  0xC0, 0x07, 0x80, 0x0F, 0x00, 0x1E, 0x00, 0x3C, 0x0F, 0x78, 0x3C, 0xF0,
  0xF1, 0xE3, 0xC3, 0xCF, 0x07, 0xBC, 0x0F, 0xF0, 0x1F, 0xE0, 0x3F, 0xE0,
  0x7B, 0xE0, 0xF3, 0xC1, 0xE3, 0xC3, 0xC7, 0xC7, 0x87, 0xCF, 0x07, 0xDE,
  0x07, 0xC0, 0x7F, 0x81, 0xFE, 0x07, 0xF8, 0x01, 0xE0, 0x07, 0x80, 0x1E,
  0x00, 0x78, 0x01, 0xE0, 0x07, 0x80, 0x1E, 0x00, 0x78, 0x01, 0xE0, 0x07,
  0x80, 0x1E, 0x00, 0x78, 0x01, 0xE0, 0x07, 0x80, 0x1E, 0x00, 0x78, 0x3F,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFB, 0xCE, 0x7F, 0xEF, 0xBF, 0xFF, 0xFF,
  0x7D, 0xFF, 0xBE, 0xFF, 0xDF, 0x7F, 0xEF, 0xBF, 0xF7, 0xDF, 0xFB, 0xEF,
  0xFD, 0xF7, 0xFE, 0xFB, 0xFF, 0x7D, 0xFF, 0xBE, 0xFF, 0xDF, 0x7F, 0xEF,
  0xBF, 0xF7, 0xDF, 0xE3, 0xE3, 0xFF, 0xEF, 0xFF, 0xBF, 0x1F, 0xF8, 0x3F,
  0xC0, 0xFF, 0x03, 0xFC, 0x0F, 0xF0, 0x3F, 0xC0, 0xFF, 0x03, 0xFC, 0x0F,
  0xF0, 0x3F, 0xC0, 0xFF, 0x03, 0xFC, 0x0F, 0x07, 0xE0, 0x1F, 0xF8, 0x3F,
  0xFC, 0x7C, 0x3E, 0x78, 0x1E, 0xF0, 0x0F, 0xF0, 0x0F, 0xF0, 0x0F, 0xF0,
  0x0F, 0xF0, 0x0F, 0xF0, 0x0F, 0x78, 0x1E, 0x7C, 0x3E, 0x3F, 0xFC, 0x1F,
  0xF8, 0x07, 0xE0, 0xE3, 0xE1, 0xFF, 0xF3, 0xFF, 0xF7, 0xE1, 0xEF, 0x83,
  0xFE, 0x03, 0xFC, 0x07, 0xF8, 0x0F, 0xF0, 0x1F, 0xE0, 0x3F, 0xC0, 0xFF,
  0x81, 0xEF, 0x07, 0xDF, 0xFF, 0x3F, 0xFC, 0x7F, 0xE0, 0xF0, 0x01, 0xE0,
  0x03, 0xC0, 0x07, 0x80, 0x0F, 0x00, 0x1E, 0x00, 0x00, 0x07, 0xF6, 0x3F,
  0xFC, 0xFF, 0xFB, 0xE0, 0xF7, 0x81, 0xFF, 0x03, 0xFC, 0x07, 0xF8, 0x0F,
  0xF0, 0x1F, 0xE0, 0x3F, 0xC0, 0x7F, 0xC1, 0xF7, 0x87, 0xEF, 0xFF, 0xCF,
  0xFF, 0x87, 0xCF, 0x00, 0x1E, 0x00, 0x3C, 0x00, 0x78, 0x00, 0xF0, 0x01,
  0xE0, 0x03, 0xC0, 0xF3, 0xE3, 0xDF, 0xEF, 0xFF, 0xBF, 0x1F, 0xF8, 0x3F,
  0xC0, 0xFF, 0x00, 0x3C, 0x00, 0xF0, 0x03, 0xC0, 0x0F, 0x00, 0x3C, 0x00,
  0xF0, 0x03, 0xC0, 0x0F, 0x00, 0x3C, 0x00, 0x0F, 0xC1, 0xFF, 0x9F, 0xFD,
  0xF0, 0x6F, 0x00, 0x7C, 0x03, 0xFC, 0x0F, 0xFC, 0x1F, 0xF0, 0x1F, 0xC0,
  0x3E, 0x00, 0xFC, 0x0F, 0xFF, 0xFB, 0xFF, 0x8F, 0xF0, 0x03, 0x00, 0x3C,
  0x00, 0xF0, 0x03, 0xC0, 0x0F, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F,
  0x00, 0x3C, 0x00, 0xF0, 0x03, 0xC0, 0x0F, 0x00, 0x3C, 0x00, 0xF0, 0x03,
  0xC0, 0x0F, 0x00, 0x3E, 0x10, 0x7F, 0xC1, 0xFF, 0x01, 0xF8, 0xF0, 0x3F,
  0xC0, 0xFF, 0x03, 0xFC, 0x0F, 0xF0, 0x3F, 0xC0, 0xFF, 0x03, 0xFC, 0x0F,
  0xF0, 0x3F, 0xC0, 0xFF, 0x03, 0xFC, 0x1F, 0xF8, 0xFD, 0xFF, 0xF7, 0xFF,
  0xC7, 0xC7, 0x78, 0x03, 0xCF, 0x00, 0x78, 0xF0, 0x1E, 0x1E, 0x03, 0xC3,
  0xE0, 0x78, 0x3C, 0x1E, 0x07, 0x83, 0xC0, 0x78, 0xF0, 0x0F, 0x1E, 0x01,
  0xE3, 0x80, 0x1E, 0xF0, 0x03, 0xDE, 0x00, 0x3B, 0x80, 0x07, 0xF0, 0x00,
  0x7C, 0x00, 0x0F, 0x80, 0x70, 0x01, 0xCE, 0x00, 0x39, 0xE0, 0x07, 0x3C,
  0x00, 0xE7, 0x8E, 0x3C, 0xF1, 0xE7, 0x8E, 0x7C, 0xE1, 0xCF, 0x9C, 0x39,
  0xB3, 0x87, 0x77, 0x70, 0xFE, 0xEE, 0x1F, 0xDD, 0xC3, 0xF1, 0xF8, 0x3E,
  0x3E, 0x07, 0xC7, 0xC0, 0xF8, 0xF8, 0x7C, 0x07, 0xCF, 0x81, 0xE1, 0xF0,
  0xF0, 0x3C, 0x78, 0x0F, 0x9C, 0x01, 0xFF, 0x00, 0x3F, 0x80, 0x07, 0xC0,
  0x01, 0xF0, 0x00, 0xFE, 0x00, 0x7B, 0xC0, 0x3E, 0xF8, 0x1F, 0x1E, 0x07,
  0x83, 0xC3, 0xC0, 0xF9, 0xF0, 0x1F, 0x78, 0x03, 0xCF, 0x00, 0x78, 0xF0,
  0x1E, 0x1E, 0x03, 0xC3, 0xE0, 0xF8, 0x3C, 0x1E, 0x07, 0x83, 0xC0, 0x78,
  0xF0, 0x0F, 0x1E, 0x01, 0xE7, 0x80, 0x1E, 0xF0, 0x03, 0xDC, 0x00, 0x3F,
  0x80, 0x07, 0xF0, 0x00, 0x7C, 0x00, 0x0F, 0x80, 0x01, 0xE0, 0x00, 0x7C,
  0x00, 0x1F, 0x00, 0x3F, 0xC0, 0x07, 0xF0, 0x00, 0xF8, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x03, 0xE0, 0x1E, 0x01, 0xF0, 0x1F, 0x00, 0xF0,
  0x0F, 0x00, 0xF8, 0x07, 0x80, 0x78, 0x07, 0xC0, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0xF8, 0x1F, 0xC1, 0xFE, 0x0F, 0x80, 0xF8, 0x07, 0xC0, 0x3E,
  0x01, 0xF0, 0x0F, 0x80, 0x7C, 0x03, 0xE0, 0x1F, 0x01, 0xF8, 0x7F, 0x83,
  0xF0, 0x1F, 0xE0, 0x1F, 0x80, 0x7C, 0x03, 0xE0, 0x1F, 0x00, 0xF8, 0x07,
  0xC0, 0x3E, 0x01, 0xF0, 0x0F, 0x80, 0x7C, 0x01, 0xF0, 0x0F, 0xF0, 0x3F,
  0x80, 0x7C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF8, 0x07, 0xF0, 0x3F, 0xC0,
  0x3E, 0x00, 0xF8, 0x07, 0xC0, 0x3E, 0x01, 0xF0, 0x0F, 0x80, 0x7C, 0x03,
  0xE0, 0x1F, 0x00, 0xFC, 0x03, 0xFC, 0x07, 0xE0, 0xFF, 0x0F, 0xC0, 0x7C,
  0x03, 0xE0, 0x1F, 0x00, 0xF8, 0x07, 0xC0, 0x3E, 0x01, 0xF0, 0x0F, 0x80,
  0x7C, 0x07, 0xC1, 0xFE, 0x0F, 0xE0, 0x7C, 0x00, 0x1E, 0x00, 0x7F, 0x07,
  0x7F, 0x87, 0xF3, 0xCF, 0xE1, 0xFE, 0xE0, 0xFE, 0x00, 0x78 };

const GFXglyph Courier_Prime_Sans6pt7bGlyphs[] PROGMEM = {
  {      0,   1,   1,  18,    0,   18 },   // 0x20 ' '
  {      1,   5,  22,  18,    7,   -3 },   // 0x21 '!'
  {     15,  10,   8,  18,    4,   -3 },   // 0x22 '"'
  {     25,  17,  21,  18,    1,   -2 },   // 0x23 '#'
  {     70,  15,  28,  18,    1,   -5 },   // 0x24 '$'
  {    123,  18,  22,  18,    0,   -3 },   // 0x25 '%'
  {    173,  19,  22,  18,    1,   -3 },   // 0x26 '&'
  {    226,   4,   8,  18,    7,   -3 },   // 0x27 '''
  {    230,  10,  30,  18,    4,   -5 },   // 0x28 '('
  {    268,  10,  30,  18,    4,   -5 },   // 0x29 ')'
  {    306,  15,  14,  18,    2,   -3 },   // 0x2A '*'
  {    333,  16,  15,  18,    1,    3 },   // 0x2B '+'
  {    363,   9,  12,  18,    3,   13 },   // 0x2C ','
  {    377,  10,   3,  18,    4,    9 },   // 0x2D '-'
  {    381,   6,   6,  18,    6,   13 },   // 0x2E '.'
  {    386,  15,  25,  18,    1,   -3 },   // 0x2F '/'
  {    433,  16,  21,  18,    1,   -2 },   // 0x30 '0'
  {    475,  15,  21,  18,    2,   -2 },   // 0x31 '1'
  {    515,  14,  21,  18,    2,   -2 },   // 0x32 '2'
  {    552,  14,  21,  18,    2,   -2 },   // 0x33 '3'
  {    589,  17,  21,  18,    1,   -2 },   // 0x34 '4'
  {    634,  13,  21,  18,    3,   -2 },   // 0x35 '5'
  {    669,  15,  21,  18,    2,   -2 },   // 0x36 '6'
  {    709,  15,  21,  18,    2,   -2 },   // 0x37 '7'
  {    749,  15,  21,  18,    2,   -2 },   // 0x38 '8'
  {    789,  15,  21,  18,    1,   -2 },   // 0x39 '9'
  {    829,   6,  16,  18,    6,    3 },   // 0x3A ':'
  {    841,   9,  22,  18,    3,    3 },   // 0x3B ';'
  {    866,  13,  18,  18,    2,    1 },   // 0x3C '<'
  {    896,  14,   9,  18,    2,    6 },   // 0x3D '='
  {    912,  13,  18,  18,    3,    1 },   // 0x3E '>'
  {    942,  11,  22,  18,    5,   -3 },   // 0x3F '?'
  {    973,  18,  28,  18,    0,   -3 },   // 0x40 '@'
  {   1036,  19,  21,  18,   -1,   -2 },   // 0x41 'A'
  {   1086,  15,  21,  18,    2,   -2 },   // 0x42 'B'
  {   1126,  15,  21,  18,    1,   -2 },   // 0x43 'C'
  {   1166,  16,  21,  18,    1,   -2 },   // 0x44 'D'
  {   1208,  13,  21,  18,    3,   -2 },   // 0x45 'E'
  {   1243,  12,  21,  18,    3,   -2 },   // 0x46 'F'
  {   1275,  16,  21,  18,    1,   -2 },   // 0x47 'G'
  {   1317,  15,  21,  18,    2,   -2 },   // 0x48 'H'
  {   1357,  14,  21,  18,    2,   -2 },   // 0x49 'I'
  {   1394,  12,  21,  18,    3,   -2 },   // 0x4A 'J'
  {   1426,  15,  21,  18,    2,   -2 },   // 0x4B 'K'
  {   1466,  13,  21,  18,    3,   -2 },   // 0x4C 'L'
  {   1501,  17,  21,  18,    0,   -2 },   // 0x4D 'M'
  {   1546,  16,  21,  18,    2,   -2 },   // 0x4E 'N'
  {   1588,  17,  21,  18,    1,   -2 },   // 0x4F 'O'
  {   1633,  14,  21,  18,    2,   -2 },   // 0x50 'P'
  {   1670,  18,  28,  18,    1,   -2 },   // 0x51 'Q'
  {   1733,  16,  21,  18,    2,   -2 },   // 0x52 'R'
  {   1775,  14,  21,  18,    2,   -2 },   // 0x53 'S'
  {   1812,  16,  21,  18,    1,   -2 },   // 0x54 'T'
  {   1854,  15,  21,  18,    1,   -2 },   // 0x55 'U'
  {   1894,  19,  21,  18,    0,   -2 },   // 0x56 'V'
  {   1944,  18,  21,  18,    0,   -2 },   // 0x57 'W'
  {   1992,  18,  21,  18,    0,   -2 },   // 0x58 'X'
  {   2040,  18,  21,  18,    0,   -2 },   // 0x59 'Y'
  {   2088,  15,  21,  18,    2,   -2 },   // 0x5A 'Z'
  {   2128,   9,  30,  18,    5,   -5 },   // 0x5B '['
  {   2162,  15,  25,  18,    2,   -3 },   // 0x5C '\'
  {   2209,   9,  30,  18,    4,   -5 },   // 0x5D ']'
  {   2243,  17,  10,  18,    0,   -2 },   // 0x5E '^'
  {   2265,  18,   3,  18,    0,   23 },   // 0x5F '_'
  {   2272,  11,   6,  18,    0,   -3 },   // 0x60 '`'
  {   2281,  14,  16,  18,    2,    3 },   // 0x61 'a'
  {   2309,  15,  22,  18,    2,   -3 },   // 0x62 'b'
  {   2351,  13,  16,  18,    2,    3 },   // 0x63 'c'
  {   2377,  15,  22,  18,    1,   -3 },   // 0x64 'd'
  {   2419,  15,  16,  18,    2,    3 },   // 0x65 'e'
  {   2449,  17,  22,  18,    0,   -3 },   // 0x66 'f'
  {   2496,  16,  22,  18,    1,    3 },   // 0x67 'g'
  {   2540,  14,  22,  18,    2,   -3 },   // 0x68 'h'
  {   2579,  14,  22,  18,    2,   -3 },   // 0x69 'i'
  {   2618,  12,  28,  18,    2,   -3 },   // 0x6A 'j'
  {   2660,  15,  22,  18,    2,   -3 },   // 0x6B 'k'
  {   2702,  14,  22,  18,    2,   -3 },   // 0x6C 'l'
  {   2741,  17,  16,  18,    1,    3 },   // 0x6D 'm'
  {   2775,  14,  16,  18,    2,    3 },   // 0x6E 'n'
  {   2803,  16,  16,  18,    1,    3 },   // 0x6F 'o'
  {   2835,  15,  22,  18,    2,    3 },   // 0x70 'p'
  {   2877,  15,  22,  18,    1,    3 },   // 0x71 'q'
  {   2919,  14,  16,  18,    3,    3 },   // 0x72 'r'
  {   2947,  13,  16,  18,    3,    3 },   // 0x73 's'
  {   2973,  14,  21,  18,    1,   -2 },   // 0x74 't'
  {   3010,  14,  16,  18,    2,    3 },   // 0x75 'u'
  {   3038,  19,  16,  18,    0,    3 },   // 0x76 'v'
  {   3076,  19,  16,  18,   -1,    3 },   // 0x77 'w'
  {   3114,  18,  16,  18,   -1,    3 },   // 0x78 'x'
  {   3150,  19,  22,  18,    0,    3 },   // 0x79 'y'
  {   3203,  13,  16,  18,    2,    3 },   // 0x7A 'z'
  {   3229,  13,  30,  18,    1,   -5 },   // 0x7B '{'
  {   3278,   4,  33,  18,    7,   -7 },   // 0x7C '|'
  {   3295,  13,  30,  18,    4,   -5 },   // 0x7D '}'
  {   3344,  16,   7,  18,    1,    6 } }; // 0x7E '~'

const GFXfont Courier_Prime_Sans6pt7b PROGMEM = {
  (uint8_t  *)Courier_Prime_Sans6pt7bBitmaps,
  (GFXglyph *)Courier_Prime_Sans6pt7bGlyphs,
  0x20, 0x7E, 39 };

// Approx. 4030 bytes
#elif defined(_CLOCK_3200x1920)
const uint8_t Courier_Prime_Sans6pt7bBitmaps[] PROGMEM = {
  0x00, 0x7E, 0xFD, 0xFB, 0xF7, 0xEF, 0xDF, 0xBF, 0x7E, 0xFD, 0xFB, 0xF7,
  0xE7, 0xCF, 0x1E, 0x3C, 0x78, 0xF1, 0xE3, 0xC0, 0x00, 0x1C, 0x7D, 0xFF,
  0xFF, 0xF7, 0xC7, 0x00, 0xF8, 0xFF, 0xC7, 0xFE, 0x3F, 0xF1, 0xFF, 0x8F,
  0xFC, 0x7F, 0xE3, 0xFF, 0x1F, 0x70, 0x73, 0x83, 0x80, 0x03, 0xC1, 0xE0,
  0x0F, 0x07, 0x80, 0x3C, 0x1E, 0x00, 0xF0, 0x78, 0x07, 0xC3, 0xC0, 0x1E,
  0x0F, 0x07, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFD, 0xFF, 0xFF,
  0xF0, 0x78, 0x3C, 0x01, 0xE0, 0xF0, 0x07, 0x83, 0xC0, 0x3C, 0x1E, 0x00,
  0xF0, 0x78, 0x03, 0xC1, 0xE0, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xEF, 0xFF,
  0xFF, 0xBF, 0xFF, 0xFE, 0x0F, 0x07, 0x80, 0x3C, 0x1E, 0x00, 0xE0, 0x70,
  0x07, 0x83, 0xC0, 0x1E, 0x0F, 0x00, 0x78, 0x3C, 0x01, 0xE0, 0xF0, 0x00,
  0x00, 0x3C, 0x00, 0x07, 0x80, 0x00, 0xF0, 0x00, 0x1E, 0x00, 0x03, 0x80,
  0x07, 0xFC, 0x03, 0xFF, 0xE1, 0xFF, 0xFC, 0x7F, 0xFF, 0x8F, 0xCF, 0x33,
  0xF1, 0xE0, 0x7C, 0x38, 0x0F, 0x87, 0x01, 0xF9, 0xE0, 0x3F, 0xBC, 0x03,
  0xFF, 0x80, 0x7F, 0xF8, 0x07, 0xFF, 0xC0, 0x3F, 0xFE, 0x01, 0xFF, 0xE0,
  0x1F, 0xFC, 0x03, 0xFF, 0xC0, 0x79, 0xF8, 0x0F, 0x1F, 0x01, 0xE3, 0xE0,
  0x38, 0x7C, 0x0F, 0x1F, 0xF1, 0xE7, 0xEF, 0xFF, 0xF9, 0xFF, 0xFF, 0x3F,
  0xFF, 0x81, 0xFF, 0x80, 0x03, 0x80, 0x00, 0xF0, 0x00, 0x1E, 0x00, 0x03,
  0xC0, 0x00, 0x78, 0x00, 0x0F, 0xC0, 0x1E, 0x1F, 0xE0, 0x3C, 0x3F, 0xF0,
  0x7C, 0x3C, 0xF8, 0x78, 0x78, 0x78, 0xF0, 0x78, 0x79, 0xF0, 0x78, 0x79,
  0xE0, 0x78, 0x7B, 0xC0, 0x78, 0x7B, 0xC0, 0x7C, 0xF7, 0x80, 0x3F, 0xFF,
  0x80, 0x1F, 0xEF, 0x00, 0x0F, 0x9E, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x3C,
  0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0xF1, 0xF8, 0x01, 0xE3,
  0xFC, 0x01, 0xE7, 0xFE, 0x03, 0xC7, 0x9F, 0x07, 0xCF, 0x0F, 0x07, 0x8F,
  0x0F, 0x0F, 0x0F, 0x0F, 0x1F, 0x0F, 0x0F, 0x1E, 0x0F, 0x0F, 0x3C, 0x0F,
  0x9E, 0x3C, 0x07, 0xFE, 0x78, 0x03, 0xFC, 0xF8, 0x01, 0xF0, 0x01, 0xF8,
  0x00, 0x07, 0xFE, 0x00, 0x0F, 0xFF, 0x80, 0x1F, 0xFF, 0x80, 0x1F, 0x0F,
  0xC0, 0x3E, 0x07, 0xC0, 0x3E, 0x07, 0xC0, 0x3E, 0x07, 0xC0, 0x3E, 0x07,
  0xC0, 0x3F, 0x0F, 0x80, 0x1F, 0x1F, 0x80, 0x1F, 0xFF, 0x00, 0x0F, 0xFE,
  0x00, 0x07, 0xF8, 0x00, 0x0F, 0xF0, 0x00, 0x1F, 0xF0, 0x7C, 0x3F, 0xF8,
  0x7C, 0x7E, 0xFC, 0x7C, 0x7C, 0x7E, 0x7C, 0xF8, 0x3F, 0xFC, 0xF8, 0x3F,
  0xF8, 0xF8, 0x1F, 0xF8, 0xF8, 0x0F, 0xF0, 0xF8, 0x07, 0xF0, 0xFC, 0x03,
  0xF0, 0x7E, 0x0F, 0xF0, 0x7F, 0xFF, 0xF8, 0x3F, 0xFF, 0xFC, 0x1F, 0xFF,
  0x7E, 0x03, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0x79, 0xE0,
  0x00, 0x20, 0x03, 0x80, 0x3E, 0x03, 0xE0, 0x3E, 0x03, 0xE0, 0x3F, 0x01,
  0xF0, 0x1F, 0x01, 0xF8, 0x0F, 0x80, 0xFC, 0x07, 0xC0, 0x3E, 0x01, 0xF0,
  0x1F, 0x00, 0xF8, 0x07, 0xC0, 0x3E, 0x01, 0xF0, 0x0F, 0x80, 0x7C, 0x03,
  0xE0, 0x1F, 0x00, 0x7C, 0x03, 0xE0, 0x1F, 0x00, 0xFC, 0x03, 0xE0, 0x1F,
  0x80, 0x7C, 0x03, 0xF0, 0x0F, 0xC0, 0x3F, 0x00, 0xF8, 0x07, 0xE0, 0x1F,
  0x80, 0x78, 0x00, 0x80, 0x20, 0x03, 0xC0, 0x3F, 0x00, 0xFC, 0x03, 0xE0,
  0x0F, 0x80, 0x7E, 0x01, 0xF8, 0x07, 0xC0, 0x3F, 0x00, 0xF8, 0x07, 0xE0,
  0x1F, 0x00, 0xF8, 0x07, 0xC0, 0x1F, 0x00, 0xF8, 0x07, 0xC0, 0x3E, 0x01,
  0xF0, 0x0F, 0x80, 0x7C, 0x03, 0xE0, 0x1F, 0x01, 0xF0, 0x0F, 0x80, 0x7C,
  0x07, 0xE0, 0x3E, 0x03, 0xF0, 0x1F, 0x01, 0xF8, 0x1F, 0x80, 0xF8, 0x0F,
  0x80, 0xF8, 0x0F, 0x80, 0x38, 0x00, 0x80, 0x00, 0x01, 0xF0, 0x00, 0x3E,
  0x00, 0x07, 0xC0, 0x10, 0xF8, 0x47, 0x1F, 0x1C, 0xFB, 0xEF, 0xBF, 0xFF,
  0xF9, 0xFF, 0xFC, 0x07, 0xFC, 0x00, 0xFF, 0x80, 0xFF, 0xFE, 0x7F, 0x7F,
  0xF7, 0xDE, 0x7C, 0xE3, 0xE3, 0x88, 0x7C, 0x20, 0x0F, 0x80, 0x01, 0xF0,
  0x00, 0x3E, 0x00, 0x00, 0xF8, 0x00, 0x07, 0xC0, 0x00, 0x3E, 0x00, 0x01,
  0xF0, 0x00, 0x0F, 0x80, 0x00, 0x7C, 0x00, 0x03, 0xE0, 0x00, 0x1F, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F,
  0x80, 0x00, 0x7C, 0x00, 0x03, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0xF8, 0x00,
  0x07, 0xC0, 0x00, 0x3E, 0x00, 0x01, 0xF0, 0x00, 0x03, 0x80, 0xFE, 0x0F,
  0xE0, 0xFF, 0x0F, 0xF0, 0x7F, 0x03, 0xF0, 0x3F, 0x03, 0xF0, 0x3E, 0x0F,
  0xEF, 0xFC, 0xFF, 0x8F, 0xE0, 0xF8, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x3C, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0x3C, 0x00, 0x01,
  0xF0, 0x00, 0x3E, 0x00, 0x03, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xC0, 0x00,
  0x7C, 0x00, 0x0F, 0x80, 0x00, 0xF8, 0x00, 0x1F, 0x00, 0x01, 0xF0, 0x00,
  0x3F, 0x00, 0x03, 0xE0, 0x00, 0x3E, 0x00, 0x07, 0xC0, 0x00, 0x7C, 0x00,
  0x0F, 0x80, 0x00, 0xF8, 0x00, 0x1F, 0x00, 0x01, 0xF0, 0x00, 0x1F, 0x00,
  0x03, 0xE0, 0x00, 0x3E, 0x00, 0x07, 0xC0, 0x00, 0x7C, 0x00, 0x0F, 0x80,
  0x00, 0xF8, 0x00, 0x0F, 0x80, 0x01, 0xF0, 0x00, 0x1F, 0x00, 0x03, 0xE0,
  0x00, 0x3E, 0x00, 0x07, 0xC0, 0x00, 0x7C, 0x00, 0x07, 0xC0, 0x00, 0xF8,
  0x00, 0x00, 0x01, 0xFC, 0x00, 0x3F, 0xF8, 0x03, 0xFF, 0xF0, 0x3F, 0xFF,
  0x83, 0xF0, 0x7E, 0x1F, 0x01, 0xF9, 0xF0, 0x07, 0xCF, 0x80, 0x3E, 0x7C,
  0x01, 0xFF, 0xC0, 0x3F, 0xFE, 0x03, 0xFF, 0xF0, 0x7F, 0xFF, 0x87, 0xEF,
  0xFC, 0xFE, 0x7F, 0xEF, 0xC3, 0xFF, 0xFC, 0x1F, 0xFF, 0x80, 0xFF, 0xF8,
  0x07, 0xFF, 0x80, 0x7C, 0xF8, 0x03, 0xE7, 0xC0, 0x1F, 0x3F, 0x01, 0xF0,
  0xFC, 0x3F, 0x83, 0xFF, 0xF8, 0x1F, 0xFF, 0x80, 0x3F, 0xF8, 0x00, 0x7F,
  0x00, 0x00, 0xF8, 0x00, 0x7F, 0x00, 0x3F, 0xE0, 0x0F, 0xFC, 0x07, 0xFF,
  0x81, 0xFF, 0xF0, 0x1F, 0x3E, 0x03, 0x87, 0xC0, 0x20, 0xF8, 0x00, 0x1F,
  0x00, 0x03, 0xE0, 0x00, 0x7C, 0x00, 0x0F, 0x80, 0x01, 0xF0, 0x00, 0x3E,
  0x00, 0x07, 0xC0, 0x00, 0xF8, 0x00, 0x1F, 0x00, 0x03, 0xE0, 0x00, 0x7C,
  0x00, 0x0F, 0x80, 0x01, 0xF0, 0x00, 0x3E, 0x03, 0xFF, 0xFF, 0x7F, 0xFF,
  0xEF, 0xFF, 0xFD, 0xFF, 0xFF, 0x80, 0x07, 0xF8, 0x03, 0xFF, 0xC1, 0xFF,
  0xFC, 0x7F, 0xFF, 0xC7, 0xC1, 0xF8, 0x70, 0x1F, 0x88, 0x01, 0xF0, 0x00,
  0x3E, 0x00, 0x07, 0xC0, 0x00, 0xF8, 0x00, 0x1F, 0x00, 0x07, 0xC0, 0x01,
  0xF8, 0x00, 0x3E, 0x00, 0x0F, 0x80, 0x03, 0xF0, 0x00, 0xFC, 0x00, 0x3F,
  0x00, 0x1F, 0x80, 0x07, 0xE0, 0x01, 0xF8, 0x00, 0x7E, 0x00, 0x1F, 0x80,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x1F,
  0xF0, 0x1F, 0xFF, 0x07, 0xFF, 0xF1, 0xFF, 0xFC, 0x60, 0x3F, 0x80, 0x03,
  0xE0, 0x00, 0xF8, 0x00, 0x3E, 0x00, 0x0F, 0x80, 0x07, 0xC0, 0x07, 0xF0,
  0x7F, 0xF8, 0x1F, 0xF8, 0x07, 0xFF, 0x81, 0xFF, 0xF8, 0x00, 0xFE, 0x00,
  0x0F, 0xC0, 0x01, 0xF0, 0x00, 0x7C, 0x00, 0x1F, 0x00, 0x07, 0xC0, 0x03,
  0xEC, 0x03, 0xFB, 0xFF, 0xFC, 0xFF, 0xFE, 0x3F, 0xFF, 0x03, 0xFE, 0x00,
  0x00, 0x1F, 0xC0, 0x00, 0xFF, 0x00, 0x07, 0xFC, 0x00, 0x1F, 0xF0, 0x00,
  0xFF, 0xC0, 0x07, 0xFF, 0x00, 0x1F, 0x7C, 0x00, 0xF9, 0xF0, 0x07, 0xE7,
  0xC0, 0x1F, 0x1F, 0x00, 0xF8, 0x7C, 0x03, 0xE1, 0xF0, 0x1F, 0x07, 0xC0,
  0xF8, 0x1F, 0x03, 0xE0, 0x7C, 0x1F, 0x01, 0xF0, 0xF8, 0x07, 0xC3, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x1F,
  0x00, 0x00, 0x7C, 0x00, 0x01, 0xF0, 0x00, 0x07, 0xC0, 0x00, 0x1F, 0x00,
  0x00, 0x7C, 0x00, 0xFF, 0xFF, 0x7F, 0xFF, 0xBF, 0xFF, 0xDF, 0xFF, 0xEF,
  0x80, 0x07, 0xC0, 0x03, 0xE0, 0x01, 0xF0, 0x00, 0xF8, 0x00, 0x7C, 0x00,
  0x3F, 0xF8, 0x1F, 0xFF, 0x8F, 0xFF, 0xE7, 0xFF, 0xF8, 0x01, 0xFC, 0x00,
  0x3F, 0x00, 0x0F, 0x80, 0x07, 0xC0, 0x03, 0xE0, 0x01, 0xF0, 0x01, 0xF8,
  0x00, 0xFB, 0x01, 0xFD, 0xFF, 0xFC, 0xFF, 0xFC, 0x7F, 0xF8, 0x0F, 0xF0,
  0x00, 0x00, 0x3F, 0xC0, 0x1F, 0xFC, 0x07, 0xFF, 0xC0, 0xFF, 0xFC, 0x1F,
  0xC0, 0x03, 0xF0, 0x00, 0x3E, 0x00, 0x07, 0xC0, 0x00, 0x7C, 0x00, 0x07,
  0x80, 0x00, 0xF9, 0xFE, 0x0F, 0xFF, 0xF8, 0xFF, 0xFF, 0xCF, 0xFF, 0xFE,
  0xFE, 0x07, 0xEF, 0x80, 0x3F, 0xF8, 0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x01,
  0xFF, 0xC0, 0x1F, 0x7C, 0x01, 0xF7, 0xE0, 0x3E, 0x7F, 0x0F, 0xE3, 0xFF,
  0xFC, 0x1F, 0xFF, 0x80, 0xFF, 0xF0, 0x03, 0xF8, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x7E, 0x00, 0x1F, 0x80,
  0x03, 0xF0, 0x00, 0xFC, 0x00, 0x1F, 0x80, 0x07, 0xE0, 0x00, 0xFC, 0x00,
  0x1F, 0x00, 0x07, 0xE0, 0x00, 0xF8, 0x00, 0x3F, 0x00, 0x07, 0xC0, 0x01,
  0xF8, 0x00, 0x3E, 0x00, 0x0F, 0xC0, 0x01, 0xF8, 0x00, 0x7E, 0x00, 0x0F,
  0xC0, 0x03, 0xF0, 0x00, 0x7E, 0x00, 0x1F, 0x80, 0x03, 0xF0, 0x00, 0xFC,
  0x00, 0x00, 0x03, 0xF8, 0x01, 0xFF, 0xE0, 0x7F, 0xFE, 0x1F, 0xFF, 0xC7,
  0xE0, 0xFC, 0xF8, 0x0F, 0x9F, 0x01, 0xF3, 0xE0, 0x3E, 0x7E, 0x0F, 0xC7,
  0xE1, 0xF0, 0xFE, 0xFC, 0x0F, 0xFF, 0x00, 0xFF, 0xC0, 0x0F, 0xFC, 0x07,
  0xFF, 0xE1, 0xFF, 0xFE, 0x7E, 0x1F, 0xCF, 0x80, 0xFF, 0xE0, 0x0F, 0xFC,
  0x01, 0xFF, 0x80, 0x3F, 0xF0, 0x07, 0xFF, 0x83, 0xF3, 0xFF, 0xFE, 0x3F,
  0xFF, 0x83, 0xFF, 0xE0, 0x1F, 0xE0, 0x00, 0x03, 0xF8, 0x01, 0xFF, 0xC0,
  0x7F, 0xFC, 0x1F, 0xFF, 0xC7, 0xE0, 0xFC, 0xF8, 0x0F, 0xBE, 0x01, 0xF7,
  0xC0, 0x1F, 0xF8, 0x03, 0xFF, 0x00, 0x7F, 0xE0, 0x0F, 0xFE, 0x01, 0xF7,
  0xE0, 0xFE, 0xFF, 0xFF, 0xCF, 0xFF, 0xF8, 0xFF, 0xFF, 0x07, 0xF3, 0xE0,
  0x00, 0x7C, 0x00, 0x1F, 0x00, 0x03, 0xE0, 0x00, 0x7C, 0x00, 0x1F, 0x00,
  0x1F, 0xE1, 0xFF, 0xF8, 0x3F, 0xFE, 0x07, 0xFF, 0x00, 0xFF, 0x00, 0x00,
  0x3C, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0x3C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x3C, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0x3C, 0x03, 0xC0, 0x7E,
  0x0F, 0xF0, 0xFF, 0x0F, 0xF0, 0xFF, 0x07, 0xE0, 0x3C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x0F, 0xE0, 0xFE, 0x0F, 0xF0, 0xFF,
  0x07, 0xF0, 0x3F, 0x03, 0xF0, 0x3F, 0x03, 0xE0, 0xFE, 0xFF, 0xCF, 0xF8,
  0xFE, 0x0F, 0x80, 0x00, 0x04, 0x00, 0x07, 0x00, 0x07, 0xC0, 0x07, 0xF0,
  0x07, 0xF0, 0x0F, 0xF0, 0x0F, 0xE0, 0x0F, 0xE0, 0x0F, 0xE0, 0x0F, 0xE0,
  0x0F, 0xE0, 0x1F, 0xE0, 0x07, 0xF0, 0x01, 0xFC, 0x00, 0x7F, 0x00, 0x1F,
  0xC0, 0x07, 0xF0, 0x01, 0xFC, 0x00, 0x7F, 0x80, 0x0F, 0xE0, 0x03, 0xF8,
  0x00, 0xF8, 0x00, 0x38, 0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10, 0x00, 0x1C,
  0x00, 0x1F, 0x00, 0x1F, 0xC0, 0x07, 0xF0, 0x01, 0xFE, 0x00, 0x3F, 0x80,
  0x0F, 0xE0, 0x03, 0xF8, 0x00, 0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xF0, 0x07,
  0xF0, 0x07, 0xF0, 0x07, 0xF0, 0x07, 0xF0, 0x07, 0xF0, 0x07, 0xF0, 0x0F,
  0xF0, 0x0F, 0xE0, 0x0F, 0xE0, 0x03, 0xE0, 0x00, 0xE0, 0x00, 0x20, 0x00,
  0xFC, 0x01, 0xFF, 0x03, 0xFF, 0x87, 0xFF, 0x80, 0x7F, 0x80, 0x3F, 0x80,
  0x3F, 0x80, 0x3F, 0x00, 0x7E, 0x00, 0xFC, 0x01, 0xF8, 0x07, 0xF0, 0x1F,
  0xC7, 0xFF, 0x8F, 0xFE, 0x1F, 0xF8, 0x3F, 0x80, 0x7C, 0x00, 0xF8, 0x01,
  0xF0, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x3E, 0x00, 0xFE,
  0x01, 0xFC, 0x03, 0xF8, 0x03, 0xE0, 0x03, 0x80, 0x00, 0x00, 0x3F, 0x00,
  0x01, 0xFF, 0x80, 0x07, 0xFF, 0xC0, 0x1F, 0xFF, 0x80, 0x7E, 0x1F, 0x81,
  0xF8, 0x0F, 0x03, 0xE0, 0x1F, 0x0F, 0x80, 0x1E, 0x1E, 0x00, 0x3C, 0x7C,
  0x00, 0x3C, 0xF0, 0xFF, 0x7B, 0xE3, 0xFE, 0xF7, 0x8F, 0xFD, 0xEF, 0x3F,
  0xFB, 0xDE, 0x79, 0xF7, 0xBC, 0xF3, 0xCF, 0xF3, 0xC7, 0x9F, 0xE7, 0x8F,
  0x3F, 0xCF, 0x1E, 0x7F, 0x9E, 0x3C, 0xFF, 0x3C, 0x79, 0xFE, 0x78, 0xF3,
  0xBC, 0xF3, 0xEF, 0x79, 0xE7, 0xDE, 0xF3, 0xFF, 0xFD, 0xE3, 0xFF, 0xF3,
  0xC7, 0xEF, 0xC7, 0xC7, 0x8F, 0x07, 0x80, 0x00, 0x0F, 0x00, 0x00, 0x1F,
  0x00, 0x00, 0x3E, 0x00, 0x00, 0x3E, 0x00, 0x40, 0x7F, 0x07, 0x80, 0x7F,
  0xFF, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xF8, 0x00, 0x3F, 0xC0, 0x00, 0x00,
  0x7F, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x3F, 0xE0, 0x00, 0x1F, 0xF0, 0x00,
  0x0F, 0x7C, 0x00, 0x0F, 0xBE, 0x00, 0x07, 0xDF, 0x00, 0x03, 0xEF, 0xC0,
  0x03, 0xE3, 0xE0, 0x01, 0xF1, 0xF0, 0x00, 0xF8, 0xFC, 0x00, 0xF8, 0x7E,
  0x00, 0x7C, 0x1F, 0x00, 0x3E, 0x0F, 0x80, 0x3E, 0x07, 0xE0, 0x1F, 0x01,
  0xF0, 0x0F, 0x80, 0xF8, 0x07, 0xC0, 0x7E, 0x07, 0xFF, 0xFF, 0x03, 0xFF,
  0xFF, 0x81, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xF0, 0xF8, 0x00, 0xF8, 0x7C,
  0x00, 0x7C, 0x7C, 0x00, 0x3F, 0x3E, 0x00, 0x1F, 0x9F, 0x00, 0x07, 0xC0,
  0xFF, 0xF8, 0x1F, 0xFF, 0xE3, 0xFF, 0xFE, 0x7F, 0xFF, 0xCF, 0x81, 0xFD,
  0xF0, 0x1F, 0xBE, 0x01, 0xF7, 0xC0, 0x3E, 0xF8, 0x07, 0xDF, 0x01, 0xF3,
  0xE0, 0x7E, 0x7F, 0xFF, 0x8F, 0xFF, 0xC1, 0xFF, 0xFF, 0x3F, 0xFF, 0xF7,
  0xC0, 0x7E, 0xF8, 0x07, 0xFF, 0x00, 0x7F, 0xE0, 0x0F, 0xFC, 0x01, 0xFF,
  0x80, 0x3F, 0xF0, 0x0F, 0xFE, 0x07, 0xF7, 0xFF, 0xFE, 0xFF, 0xFF, 0x9F,
  0xFF, 0xC3, 0xFF, 0xE0, 0x00, 0x00, 0x7F, 0x00, 0x7F, 0xF8, 0x1F, 0xFF,
  0x8F, 0xFF, 0xF1, 0xFC, 0x0E, 0x7F, 0x00, 0x5F, 0xC0, 0x03, 0xF0, 0x00,
  0x7E, 0x00, 0x1F, 0x80, 0x03, 0xF0, 0x00, 0x7E, 0x00, 0x0F, 0xC0, 0x01,
  0xF8, 0x00, 0x3F, 0x00, 0x07, 0xE0, 0x00, 0xFC, 0x00, 0x1F, 0x80, 0x03,
  0xF8, 0x00, 0x3F, 0x00, 0x07, 0xF0, 0x00, 0x7F, 0x00, 0x4F, 0xF0, 0x38,
  0xFF, 0xFF, 0x0F, 0xFF, 0xE0, 0xFF, 0xF8, 0x03, 0xFC, 0x00, 0xFF, 0xF0,
  0x0F, 0xFF, 0xE0, 0xFF, 0xFF, 0x0F, 0xFF, 0xF8, 0xF8, 0x1F, 0xCF, 0x80,
  0x7E, 0xF8, 0x07, 0xEF, 0x80, 0x3E, 0xF8, 0x03, 0xFF, 0x80, 0x1F, 0xF8,
  0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x01, 0xFF,
  0x80, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x03, 0xEF, 0x80, 0x3E,
  0xF8, 0x07, 0xEF, 0x80, 0xFC, 0xF8, 0x3F, 0x8F, 0xFF, 0xF8, 0xFF, 0xFE,
  0x0F, 0xFF, 0xC0, 0xFF, 0xE0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xC0, 0x03, 0xE0, 0x01, 0xF0, 0x00, 0xF8,
  0x00, 0x7C, 0x00, 0x3E, 0x00, 0x1F, 0xFF, 0xEF, 0xFF, 0xF7, 0xFF, 0xFB,
  0xFF, 0xFD, 0xF0, 0x00, 0xF8, 0x00, 0x7C, 0x00, 0x3E, 0x00, 0x1F, 0x00,
  0x0F, 0x80, 0x07, 0xC0, 0x03, 0xE0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00,
  0xF8, 0x00, 0xF8, 0x00, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE,
  0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00,
  0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0x00, 0x7F,
  0x80, 0x0F, 0xFF, 0x81, 0xFF, 0xFE, 0x1F, 0xFF, 0xF1, 0xFC, 0x07, 0x9F,
  0x80, 0x04, 0xF8, 0x00, 0x0F, 0x80, 0x00, 0x7C, 0x00, 0x07, 0xE0, 0x00,
  0x3E, 0x00, 0x01, 0xF0, 0x3F, 0xFF, 0x81, 0xFF, 0xFC, 0x0F, 0xFF, 0xE0,
  0x7F, 0xFF, 0x00, 0x1F, 0xF8, 0x00, 0xFF, 0xC0, 0x07, 0xDF, 0x00, 0x3E,
  0xF8, 0x01, 0xF7, 0xE0, 0x0F, 0x9F, 0x80, 0x7C, 0xFF, 0x03, 0xE3, 0xFF,
  0xFF, 0x0F, 0xFF, 0xF8, 0x1F, 0xFF, 0xC0, 0x3F, 0xE0, 0xF8, 0x03, 0xFF,
  0x00, 0x7F, 0xE0, 0x0F, 0xFC, 0x01, 0xFF, 0x80, 0x3F, 0xF0, 0x07, 0xFE,
  0x00, 0xFF, 0xC0, 0x1F, 0xF8, 0x03, 0xFF, 0x00, 0x7F, 0xE0, 0x0F, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x1F, 0xF8,
  0x03, 0xFF, 0x00, 0x7F, 0xE0, 0x0F, 0xFC, 0x01, 0xFF, 0x80, 0x3F, 0xF0,
  0x07, 0xFE, 0x00, 0xFF, 0xC0, 0x1F, 0xF8, 0x03, 0xFF, 0x00, 0x7F, 0xE0,
  0x0F, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x3E,
  0x00, 0x1F, 0x00, 0x0F, 0x80, 0x07, 0xC0, 0x03, 0xE0, 0x01, 0xF0, 0x00,
  0xF8, 0x00, 0x7C, 0x00, 0x3E, 0x00, 0x1F, 0x00, 0x0F, 0x80, 0x07, 0xC0,
  0x03, 0xE0, 0x01, 0xF0, 0x00, 0xF8, 0x00, 0x7C, 0x00, 0x3E, 0x00, 0x1F,
  0x00, 0x0F, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x03, 0xE0, 0x07, 0xC0,
  0x0F, 0x80, 0x1F, 0x00, 0x3E, 0x00, 0x7C, 0x00, 0xF8, 0x01, 0xF0, 0x03,
  0xE0, 0x07, 0xC0, 0x0F, 0x80, 0x1F, 0x00, 0x3E, 0x00, 0x7C, 0x00, 0xF8,
  0x01, 0xF0, 0x03, 0xF0, 0x0F, 0xF8, 0x3F, 0x7F, 0xFE, 0xFF, 0xF8, 0xFF,
  0xE0, 0x7E, 0x00, 0xF8, 0x07, 0xF7, 0xC0, 0x3F, 0x3E, 0x03, 0xF1, 0xF0,
  0x3F, 0x0F, 0x81, 0xF8, 0x7C, 0x1F, 0x83, 0xE1, 0xF8, 0x1F, 0x0F, 0x80,
  0xF8, 0xFC, 0x07, 0xCF, 0xC0, 0x3E, 0x7C, 0x01, 0xF7, 0xC0, 0x0F, 0xFE,
  0x00, 0x7F, 0xE0, 0x03, 0xFF, 0x80, 0x1F, 0x7E, 0x00, 0xF9, 0xF8, 0x07,
  0xCF, 0xC0, 0x3E, 0x3F, 0x01, 0xF0, 0xFC, 0x0F, 0x83, 0xF0, 0x7C, 0x1F,
  0xC3, 0xE0, 0x7E, 0x1F, 0x01, 0xF8, 0xF8, 0x0F, 0xE7, 0xC0, 0x3F, 0xBE,
  0x00, 0xFC, 0xF8, 0x00, 0x7C, 0x00, 0x3E, 0x00, 0x1F, 0x00, 0x0F, 0x80,
  0x07, 0xC0, 0x03, 0xE0, 0x01, 0xF0, 0x00, 0xF8, 0x00, 0x7C, 0x00, 0x3E,
  0x00, 0x1F, 0x00, 0x0F, 0x80, 0x07, 0xC0, 0x03, 0xE0, 0x01, 0xF0, 0x00,
  0xF8, 0x00, 0x7C, 0x00, 0x3E, 0x00, 0x1F, 0x00, 0x0F, 0x80, 0x07, 0xC0,
  0x03, 0xE0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x3F, 0x01, 0xF8, 0x7E, 0x03, 0xF0, 0xFE, 0x0F, 0xE1, 0xFC, 0x1F, 0xC3,
  0xF8, 0x3F, 0x87, 0xF8, 0xFF, 0x0F, 0xF1, 0xFE, 0x1F, 0xE3, 0xBC, 0x3D,
  0xC7, 0x78, 0xFB, 0xDE, 0xF9, 0xF7, 0xB9, 0xF3, 0xCF, 0x73, 0xE7, 0x8E,
  0xE7, 0xCF, 0x1F, 0xCF, 0x9E, 0x3F, 0x1F, 0x3C, 0x3E, 0x3E, 0x78, 0x7C,
  0x3C, 0xF0, 0xF0, 0x79, 0xE0, 0xE0, 0xF3, 0xC0, 0x01, 0xE7, 0x80, 0x03,
  0xCF, 0x00, 0x07, 0x9E, 0x00, 0x0F, 0x3C, 0x00, 0x1E, 0x78, 0x00, 0x3C,
  0xF0, 0x00, 0x79, 0xE0, 0x00, 0xF0, 0xFE, 0x01, 0xFF, 0xE0, 0x1F, 0xFF,
  0x01, 0xFF, 0xF0, 0x1F, 0xFF, 0x81, 0xFF, 0xF8, 0x1F, 0xFF, 0x81, 0xFF,
  0xFC, 0x1F, 0xFF, 0xC1, 0xFF, 0xBE, 0x1F, 0xFB, 0xE1, 0xFF, 0x9F, 0x1F,
  0xF9, 0xF1, 0xFF, 0x8F, 0x9F, 0xF8, 0xF9, 0xFF, 0x8F, 0x9F, 0xF8, 0x7D,
  0xFF, 0x87, 0xDF, 0xF8, 0x3F, 0xFF, 0x83, 0xFF, 0xF8, 0x1F, 0xFF, 0x81,
  0xFF, 0xF8, 0x1F, 0xFF, 0x80, 0xFF, 0xF8, 0x0F, 0xFF, 0x80, 0x7F, 0xF8,
  0x07, 0xF0, 0x00, 0xFE, 0x00, 0x1F, 0xFE, 0x00, 0xFF, 0xFC, 0x07, 0xFF,
  0xF8, 0x3F, 0x87, 0xF0, 0xF8, 0x07, 0xE7, 0xC0, 0x0F, 0x9F, 0x00, 0x3E,
  0x7C, 0x00, 0xFF, 0xE0, 0x01, 0xFF, 0x80, 0x07, 0xFE, 0x00, 0x1F, 0xF8,
  0x00, 0x7F, 0xE0, 0x01, 0xFF, 0x80, 0x07, 0xFE, 0x00, 0x1F, 0xF8, 0x00,
  0x7F, 0xE0, 0x01, 0xFF, 0xC0, 0x0F, 0x9F, 0x00, 0x3E, 0x7C, 0x00, 0xF9,
  0xF8, 0x07, 0xC3, 0xF8, 0x7F, 0x07, 0xFF, 0xF8, 0x0F, 0xFF, 0xC0, 0x1F,
  0xFE, 0x00, 0x1F, 0xC0, 0x00, 0xFF, 0xF8, 0x1F, 0xFF, 0xC3, 0xFF, 0xFE,
  0x7F, 0xFF, 0xCF, 0x81, 0xFD, 0xF0, 0x0F, 0xFE, 0x01, 0xFF, 0xC0, 0x1F,
  0xF8, 0x03, 0xFF, 0x00, 0x7F, 0xE0, 0x0F, 0xFC, 0x03, 0xFF, 0x80, 0x7D,
  0xF0, 0x3F, 0xBF, 0xFF, 0xE7, 0xFF, 0xF8, 0xFF, 0xFC, 0x1F, 0xFE, 0x03,
  0xE0, 0x00, 0x7C, 0x00, 0x0F, 0x80, 0x01, 0xF0, 0x00, 0x3E, 0x00, 0x07,
  0xC0, 0x00, 0xF8, 0x00, 0x1F, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0xFE,
  0x00, 0x0F, 0xFF, 0x00, 0x3F, 0xFF, 0x00, 0xFF, 0xFF, 0x03, 0xF8, 0x7F,
  0x07, 0xC0, 0x3F, 0x1F, 0x00, 0x3E, 0x3E, 0x00, 0x7C, 0x7C, 0x00, 0xFD,
  0xF0, 0x00, 0xFB, 0xE0, 0x01, 0xF7, 0xC0, 0x03, 0xEF, 0x80, 0x07, 0xDF,
  0x00, 0x0F, 0xBE, 0x00, 0x1F, 0x7C, 0x00, 0x3E, 0xF8, 0x00, 0x7D, 0xF0,
  0x00, 0xFB, 0xF0, 0x03, 0xE3, 0xE0, 0x07, 0xC7, 0xC0, 0x0F, 0x8F, 0xC0,
  0x3E, 0x0F, 0xE1, 0xFC, 0x1F, 0xFF, 0xF0, 0x1F, 0xFF, 0xC0, 0x1F, 0xFF,
  0x00, 0x0F, 0xF8, 0x00, 0x07, 0xC0, 0x00, 0x0F, 0x80, 0x00, 0x1F, 0x80,
  0x00, 0x1F, 0x00, 0x00, 0x3F, 0x04, 0x00, 0x7F, 0xFC, 0x00, 0x7F, 0xFC,
  0x00, 0x7F, 0xF0, 0x00, 0x3F, 0x80, 0xFF, 0xF8, 0x0F, 0xFF, 0xE0, 0xFF,
  0xFF, 0x0F, 0xFF, 0xF8, 0xF8, 0x1F, 0x8F, 0x80, 0xFC, 0xF8, 0x07, 0xCF,
  0x80, 0x7C, 0xF8, 0x07, 0xCF, 0x80, 0x7C, 0xF8, 0x0F, 0x8F, 0x83, 0xF8,
  0xFF, 0xFF, 0x0F, 0xFF, 0xC0, 0xFF, 0xF0, 0x0F, 0xFF, 0x80, 0xF8, 0xFC,
  0x0F, 0x87, 0xE0, 0xF8, 0x3E, 0x0F, 0x83, 0xF0, 0xF8, 0x1F, 0x8F, 0x81,
  0xF8, 0xF8, 0x0F, 0xCF, 0x80, 0xFC, 0xF8, 0x07, 0xEF, 0x80, 0x7E, 0xF8,
  0x03, 0xF0, 0x03, 0xFE, 0x01, 0xFF, 0xF0, 0xFF, 0xFE, 0x3F, 0xFF, 0xC7,
  0xE0, 0x19, 0xF0, 0x00, 0x3E, 0x00, 0x07, 0xC0, 0x00, 0xFC, 0x00, 0x1F,
  0xC0, 0x01, 0xFF, 0x00, 0x3F, 0xF8, 0x03, 0xFF, 0xE0, 0x3F, 0xFE, 0x01,
  0xFF, 0xE0, 0x07, 0xFE, 0x00, 0x3F, 0xE0, 0x01, 0xFC, 0x00, 0x1F, 0x80,
  0x03, 0xF0, 0x00, 0x7F, 0x00, 0x1F, 0xFC, 0x07, 0xF7, 0xFF, 0xFC, 0xFF,
  0xFF, 0x0F, 0xFF, 0xC0, 0x3F, 0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0x80, 0x00, 0x7C, 0x00, 0x03,
  0xE0, 0x00, 0x1F, 0x00, 0x00, 0xF8, 0x00, 0x07, 0xC0, 0x00, 0x3E, 0x00,
  0x01, 0xF0, 0x00, 0x0F, 0x80, 0x00, 0x7C, 0x00, 0x03, 0xE0, 0x00, 0x1F,
  0x00, 0x00, 0xF8, 0x00, 0x07, 0xC0, 0x00, 0x3E, 0x00, 0x01, 0xF0, 0x00,
  0x0F, 0x80, 0x00, 0x7C, 0x00, 0x03, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0xF8,
  0x00, 0x07, 0xC0, 0x00, 0x3E, 0x00, 0xF8, 0x01, 0xFF, 0x80, 0x1F, 0xF8,
  0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x01, 0xFF,
  0x80, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x1F,
  0xF8, 0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x01,
  0xFF, 0x80, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x03, 0xF7, 0xC0,
  0x3E, 0x7E, 0x07, 0xE7, 0xFF, 0xFC, 0x3F, 0xFF, 0x81, 0xFF, 0xF0, 0x03,
  0xF8, 0x00, 0x7E, 0x00, 0x1F, 0x3F, 0x00, 0x0F, 0x9F, 0x80, 0x0F, 0xC7,
  0xC0, 0x07, 0xC3, 0xF0, 0x03, 0xE1, 0xF8, 0x03, 0xF0, 0x7C, 0x01, 0xF0,
  0x3F, 0x00, 0xF8, 0x1F, 0x80, 0xFC, 0x0F, 0xC0, 0x7C, 0x03, 0xE0, 0x3E,
  0x01, 0xF8, 0x3F, 0x00, 0xFC, 0x1F, 0x00, 0x3E, 0x0F, 0x80, 0x1F, 0x07,
  0xC0, 0x0F, 0xC7, 0xC0, 0x03, 0xE3, 0xE0, 0x01, 0xF1, 0xF0, 0x00, 0xFD,
  0xF8, 0x00, 0x3E, 0xF8, 0x00, 0x1F, 0x7C, 0x00, 0x0F, 0xBE, 0x00, 0x07,
  0xFE, 0x00, 0x01, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x7F, 0x80, 0x00,
  0x1F, 0xC0, 0x00, 0x78, 0x00, 0x3C, 0xF0, 0x00, 0x79, 0xE0, 0x00, 0xF3,
  0xC0, 0x01, 0xE7, 0x80, 0x03, 0xCF, 0x00, 0x07, 0x9E, 0x00, 0x0F, 0x3C,
  0x00, 0x1E, 0x78, 0x3C, 0x3C, 0xF0, 0x78, 0x79, 0xE1, 0xF0, 0xF3, 0xC3,
  0xE1, 0xE7, 0xC7, 0xE3, 0xCF, 0x9F, 0xC7, 0x9F, 0x3B, 0x8F, 0x3E, 0x77,
  0x1E, 0x7C, 0xEF, 0x3C, 0xFB, 0xDE, 0xF8, 0xF7, 0x1D, 0xE1, 0xEE, 0x3F,
  0xC3, 0xFC, 0x7F, 0x87, 0xF8, 0xFF, 0x0F, 0xE0, 0xFE, 0x1F, 0xC1, 0xFC,
  0x3F, 0x83, 0xF8, 0x7E, 0x03, 0xF0, 0xFC, 0x07, 0xE0, 0xFC, 0x00, 0xFC,
  0xFC, 0x03, 0xF1, 0xFC, 0x0F, 0xE1, 0xF8, 0x1F, 0x81, 0xF8, 0x7E, 0x03,
  0xF8, 0xFC, 0x03, 0xF3, 0xF0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0x80, 0x07,
  0xFE, 0x00, 0x0F, 0xFC, 0x00, 0x0F, 0xF0, 0x00, 0x1F, 0xE0, 0x00, 0x1F,
  0x80, 0x00, 0x7F, 0x80, 0x00, 0xFF, 0x80, 0x03, 0xFF, 0x00, 0x0F, 0xBF,
  0x00, 0x1F, 0x7E, 0x00, 0x7C, 0x7E, 0x00, 0xF8, 0xFE, 0x03, 0xF0, 0xFC,
  0x0F, 0xC0, 0xFC, 0x1F, 0x81, 0xF8, 0x7E, 0x01, 0xF8, 0xFC, 0x03, 0xFB,
  0xF0, 0x03, 0xF0, 0xFC, 0x00, 0x3E, 0xFC, 0x00, 0xF9, 0xF8, 0x01, 0xF1,
  0xF8, 0x07, 0xC3, 0xF0, 0x0F, 0x83, 0xF0, 0x3E, 0x07, 0xE0, 0xFC, 0x07,
  0xC1, 0xF0, 0x0F, 0xC7, 0xE0, 0x0F, 0x8F, 0x80, 0x1F, 0xBF, 0x00, 0x1F,
  0x7C, 0x00, 0x3F, 0xF8, 0x00, 0x3F, 0xE0, 0x00, 0x7F, 0xC0, 0x00, 0x7F,
  0x00, 0x00, 0xFC, 0x00, 0x00, 0xF8, 0x00, 0x01, 0xF0, 0x00, 0x03, 0xE0,
  0x00, 0x07, 0xC0, 0x00, 0x0F, 0x80, 0x00, 0x1F, 0x00, 0x00, 0x3E, 0x00,
  0x00, 0x7C, 0x00, 0x00, 0xF8, 0x00, 0x01, 0xF0, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0xFC, 0x00, 0x1F, 0x00,
  0x07, 0xE0, 0x01, 0xF8, 0x00, 0x3F, 0x00, 0x0F, 0xC0, 0x03, 0xF0, 0x00,
  0x7E, 0x00, 0x1F, 0x80, 0x03, 0xE0, 0x00, 0xFC, 0x00, 0x3F, 0x00, 0x07,
  0xE0, 0x01, 0xF8, 0x00, 0x3E, 0x00, 0x0F, 0xC0, 0x03, 0xF0, 0x00, 0x7C,
  0x00, 0x1F, 0x80, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x81, 0xF0, 0x3E, 0x07,
  0xC0, 0xF8, 0x1F, 0x03, 0xE0, 0x7C, 0x0F, 0x81, 0xF0, 0x3E, 0x07, 0xC0,
  0xF8, 0x1F, 0x03, 0xE0, 0x7C, 0x0F, 0x81, 0xF0, 0x3E, 0x07, 0xC0, 0xF8,
  0x1F, 0x03, 0xE0, 0x7C, 0x0F, 0x81, 0xF0, 0x3E, 0x07, 0xC0, 0xF8, 0x1F,
  0x03, 0xE0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xF8, 0x00, 0x0F, 0x80,
  0x01, 0xF0, 0x00, 0x3E, 0x00, 0x03, 0xE0, 0x00, 0x7C, 0x00, 0x07, 0xC0,
  0x00, 0xF8, 0x00, 0x1F, 0x00, 0x01, 0xF0, 0x00, 0x3E, 0x00, 0x03, 0xE0,
  0x00, 0x7C, 0x00, 0x0F, 0x80, 0x00, 0xF8, 0x00, 0x1F, 0x00, 0x01, 0xF0,
  0x00, 0x3E, 0x00, 0x07, 0xC0, 0x00, 0x7C, 0x00, 0x0F, 0x80, 0x00, 0xF8,
  0x00, 0x1F, 0x00, 0x03, 0xE0, 0x00, 0x3E, 0x00, 0x07, 0xC0, 0x00, 0x7C,
  0x00, 0x0F, 0x80, 0x01, 0xF0, 0x00, 0x1F, 0x00, 0x03, 0xE0, 0x00, 0x3E,
  0x00, 0x07, 0xC0, 0x00, 0xF8, 0x00, 0x0F, 0x80, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x3E, 0x07, 0xC0, 0xF8, 0x1F, 0x03, 0xE0, 0x7C, 0x0F, 0x81,
  0xF0, 0x3E, 0x07, 0xC0, 0xF8, 0x1F, 0x03, 0xE0, 0x7C, 0x0F, 0x81, 0xF0,
  0x3E, 0x07, 0xC0, 0xF8, 0x1F, 0x03, 0xE0, 0x7C, 0x0F, 0x81, 0xF0, 0x3E,
  0x07, 0xC0, 0xF8, 0x1F, 0x03, 0xE0, 0x7C, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF8, 0x00, 0xF8, 0x00, 0x07, 0xC0, 0x00, 0x7F, 0x00, 0x07, 0xFC,
  0x00, 0x3D, 0xE0, 0x03, 0xC7, 0x80, 0x3E, 0x3C, 0x01, 0xE0, 0xF0, 0x1F,
  0x07, 0xC0, 0xF0, 0x1E, 0x0F, 0x80, 0xF8, 0xF8, 0x03, 0xE7, 0xC0, 0x1F,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x1F, 0x80, 0x3F, 0x00, 0x7E, 0x00, 0xFC, 0x01, 0xF8, 0x03, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, 0x0F, 0xFF, 0xC3, 0xFF, 0xF8,
  0xFF, 0xFE, 0x30, 0x0F, 0xC0, 0x01, 0xF0, 0x00, 0x7C, 0x00, 0x1F, 0x03,
  0xFF, 0xC7, 0xFF, 0xF3, 0xFF, 0xFD, 0xFF, 0xFF, 0xFE, 0x07, 0xFE, 0x01,
  0xFF, 0x80, 0x7F, 0xE0, 0x3F, 0xFC, 0x3F, 0xFF, 0xFF, 0xF7, 0xFF, 0xBC,
  0xFF, 0xCF, 0x0F, 0xC3, 0xC0, 0xF8, 0x00, 0x1F, 0x00, 0x03, 0xE0, 0x00,
  0x7C, 0x00, 0x0F, 0x80, 0x01, 0xF0, 0x00, 0x3E, 0x00, 0x07, 0xC0, 0x00,
  0xF8, 0x00, 0x1F, 0x1F, 0x83, 0xE7, 0xFC, 0x7F, 0xFF, 0xCF, 0xFF, 0xF9,
  0xFE, 0x1F, 0xBF, 0x81, 0xF7, 0xE0, 0x3F, 0xF8, 0x03, 0xFF, 0x00, 0x7F,
  0xE0, 0x0F, 0xFC, 0x01, 0xFF, 0x80, 0x3F, 0xF0, 0x07, 0xFE, 0x01, 0xFF,
  0xC0, 0x3E, 0xF8, 0x0F, 0xDF, 0x03, 0xF3, 0xFF, 0xFE, 0x7F, 0xFF, 0x8F,
  0xFF, 0xC0, 0x3F, 0xE0, 0x00, 0x01, 0xFE, 0x03, 0xFF, 0xC7, 0xFF, 0xE7,
  0xFF, 0xF3, 0xF8, 0x1B, 0xF0, 0x01, 0xF0, 0x01, 0xF8, 0x00, 0xF8, 0x00,
  0x7C, 0x00, 0x3E, 0x00, 0x1F, 0x00, 0x0F, 0x80, 0x07, 0xE0, 0x03, 0xF0,
  0x00, 0xFC, 0x00, 0x7F, 0x81, 0x9F, 0xFF, 0xC7, 0xFF, 0xE1, 0xFF, 0xF0,
  0x1F, 0xE0, 0x00, 0x03, 0xE0, 0x00, 0x7C, 0x00, 0x0F, 0x80, 0x01, 0xF0,
  0x00, 0x3E, 0x00, 0x07, 0xC0, 0x00, 0xF8, 0x00, 0x1F, 0x00, 0x03, 0xE0,
  0x3F, 0xFC, 0x1F, 0xFF, 0x8F, 0xFF, 0xF3, 0xFF, 0xFE, 0x7E, 0x07, 0xDF,
  0x80, 0xFB, 0xE0, 0x1F, 0xFC, 0x03, 0xFF, 0x00, 0x7F, 0xE0, 0x0F, 0xFC,
  0x01, 0xFF, 0x80, 0x3F, 0xF0, 0x07, 0xFE, 0x00, 0xFF, 0xC0, 0x3F, 0x7C,
  0x0F, 0xEF, 0xC3, 0xFC, 0xFF, 0xFF, 0x9F, 0xFE, 0xF1, 0xFF, 0x9E, 0x0F,
  0xC3, 0xC0, 0x01, 0xF8, 0x01, 0xFF, 0xC0, 0x7F, 0xFE, 0x1F, 0xFF, 0xC3,
  0xE0, 0xFC, 0xF8, 0x0F, 0x9F, 0x00, 0xFF, 0xC0, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0xF0, 0x00, 0x3F,
  0x00, 0x03, 0xE0, 0x00, 0x7F, 0x00, 0xC7, 0xFF, 0xF8, 0x7F, 0xFF, 0x07,
  0xFF, 0xE0, 0x3F, 0xF0, 0x00, 0x07, 0xF0, 0x00, 0x7F, 0xF0, 0x03, 0xFF,
  0xC0, 0x1F, 0xFF, 0x00, 0x7E, 0x04, 0x03, 0xF0, 0x00, 0x0F, 0x80, 0x00,
  0x3E, 0x00, 0x00, 0xF8, 0x00, 0x03, 0xE0, 0x00, 0x0F, 0x80, 0x00, 0x3E,
  0x00, 0x3F, 0xFF, 0xF8, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0x8F, 0xFF, 0xFE,
  0x00, 0xF8, 0x00, 0x03, 0xE0, 0x00, 0x0F, 0x80, 0x00, 0x3E, 0x00, 0x00,
  0xF8, 0x00, 0x03, 0xE0, 0x00, 0x0F, 0x80, 0x00, 0x3E, 0x00, 0x00, 0xF8,
  0x00, 0x03, 0xE0, 0x00, 0x0F, 0x80, 0x00, 0x3E, 0x00, 0x00, 0xF8, 0x00,
  0x03, 0xE0, 0x00, 0x03, 0xFF, 0xF0, 0xFF, 0xFF, 0x1F, 0xFF, 0xF3, 0xFF,
  0xFF, 0x7E, 0x0F, 0x87, 0xC0, 0x7C, 0x7C, 0x07, 0xC7, 0xC0, 0x7C, 0x7C,
  0x07, 0xC7, 0xE0, 0xFC, 0x3F, 0xFF, 0x81, 0xFF, 0xF0, 0x3F, 0xFE, 0x03,
  0xFF, 0x80, 0x7C, 0x00, 0x07, 0xC0, 0x00, 0x7E, 0x00, 0x07, 0xFF, 0xF0,
  0x3F, 0xFF, 0xC3, 0xFF, 0xFE, 0x3F, 0xFF, 0xF7, 0xC0, 0x3F, 0xF8, 0x01,
  0xFF, 0x80, 0x1F, 0xFC, 0x07, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xC3, 0xFF,
  0xF8, 0x07, 0xFC, 0x00, 0xF8, 0x00, 0x3E, 0x00, 0x0F, 0x80, 0x03, 0xE0,
  0x00, 0xF8, 0x00, 0x3E, 0x00, 0x0F, 0x80, 0x03, 0xE0, 0x00, 0xF8, 0x00,
  0x3E, 0x3F, 0x0F, 0xBF, 0xF3, 0xFF, 0xFE, 0xFF, 0xFF, 0xBF, 0xC3, 0xFF,
  0xE0, 0x7F, 0xF0, 0x1F, 0xF8, 0x07, 0xFE, 0x01, 0xFF, 0x80, 0x7F, 0xE0,
  0x1F, 0xF8, 0x07, 0xFE, 0x01, 0xFF, 0x80, 0x7F, 0xE0, 0x1F, 0xF8, 0x07,
  0xFE, 0x01, 0xFF, 0x80, 0x7F, 0xE0, 0x1F, 0xF8, 0x07, 0xFE, 0x01, 0xF0,
  0x01, 0xC0, 0x00, 0x7C, 0x00, 0x1F, 0xC0, 0x03, 0xF8, 0x00, 0x7F, 0x00,
  0x07, 0xC0, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xFF, 0xC0, 0x3F, 0xF8, 0x07, 0xFF, 0x00, 0xFF, 0xE0, 0x00, 0x7C, 0x00,
  0x0F, 0x80, 0x01, 0xF0, 0x00, 0x3E, 0x00, 0x07, 0xC0, 0x00, 0xF8, 0x00,
  0x1F, 0x00, 0x03, 0xE0, 0x00, 0x7C, 0x00, 0x0F, 0x80, 0x01, 0xF0, 0x00,
  0x3E, 0x00, 0x07, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF8, 0x00, 0x1C, 0x00, 0x3E, 0x00, 0x7F, 0x00, 0x7F, 0x00, 0x7F,
  0x00, 0x3E, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF,
  0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F,
  0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F,
  0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F,
  0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F, 0x80, 0x3E, 0xE0, 0x7E,
  0xFF, 0xFC, 0xFF, 0xFC, 0x7F, 0xF0, 0x1F, 0xC0, 0xF8, 0x00, 0x0F, 0x80,
  0x00, 0xF8, 0x00, 0x0F, 0x80, 0x00, 0xF8, 0x00, 0x0F, 0x80, 0x00, 0xF8,
  0x00, 0x0F, 0x80, 0x00, 0xF8, 0x00, 0x0F, 0x80, 0x7E, 0xF8, 0x0F, 0xCF,
  0x81, 0xF8, 0xF8, 0x3F, 0x0F, 0x87, 0xE0, 0xF8, 0xFC, 0x0F, 0x9F, 0x80,
  0xFB, 0xF0, 0x0F, 0xFE, 0x00, 0xFF, 0xC0, 0x0F, 0xFE, 0x00, 0xFB, 0xF0,
  0x0F, 0x9F, 0x00, 0xF9, 0xF8, 0x0F, 0x8F, 0xC0, 0xF8, 0x7E, 0x0F, 0x83,
  0xF0, 0xF8, 0x3F, 0x8F, 0x81, 0xFC, 0xF8, 0x0F, 0xCF, 0x80, 0x7E, 0x7F,
  0xF0, 0x1F, 0xFC, 0x07, 0xFF, 0x01, 0xFF, 0xC0, 0x01, 0xF0, 0x00, 0x7C,
  0x00, 0x1F, 0x00, 0x07, 0xC0, 0x01, 0xF0, 0x00, 0x7C, 0x00, 0x1F, 0x00,
  0x07, 0xC0, 0x01, 0xF0, 0x00, 0x7C, 0x00, 0x1F, 0x00, 0x07, 0xC0, 0x01,
  0xF0, 0x00, 0x7C, 0x00, 0x1F, 0x00, 0x07, 0xC0, 0x01, 0xF0, 0x00, 0x7C,
  0x00, 0x1F, 0x00, 0x07, 0xC0, 0x01, 0xF0, 0x00, 0x7C, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF1, 0xE1, 0xE7, 0xBF, 0xBF,
  0xBD, 0xFD, 0xFD, 0xFF, 0xFF, 0xFF, 0xCF, 0xCF, 0xFE, 0x7E, 0x7F, 0xE3,
  0xE3, 0xFF, 0x1F, 0x1F, 0xF8, 0xF8, 0xFF, 0xC7, 0xC7, 0xFE, 0x3E, 0x3F,
  0xF1, 0xF1, 0xFF, 0x8F, 0x8F, 0xFC, 0x7C, 0x7F, 0xE3, 0xE3, 0xFF, 0x1F,
  0x1F, 0xF8, 0xF8, 0xFF, 0xC7, 0xC7, 0xFE, 0x3E, 0x3F, 0xF1, 0xF1, 0xFF,
  0x8F, 0x8F, 0x80, 0xF0, 0xFC, 0x3C, 0xFF, 0xCF, 0x7F, 0xFB, 0xFF, 0xFE,
  0xFF, 0x0F, 0xFF, 0x81, 0xFF, 0xC0, 0x7F, 0xE0, 0x1F, 0xF8, 0x07, 0xFE,
  0x01, 0xFF, 0x80, 0x7F, 0xE0, 0x1F, 0xF8, 0x07, 0xFE, 0x01, 0xFF, 0x80,
  0x7F, 0xE0, 0x1F, 0xF8, 0x07, 0xFE, 0x01, 0xFF, 0x80, 0x7F, 0xE0, 0x1F,
  0xF8, 0x07, 0xC0, 0x01, 0xFC, 0x00, 0xFF, 0xF0, 0x1F, 0xFF, 0x83, 0xFF,
  0xFC, 0x3F, 0x0F, 0xE7, 0xC0, 0x3E, 0x7C, 0x03, 0xFF, 0x80, 0x1F, 0xF8,
  0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x1F, 0xF8, 0x01, 0xFF,
  0x80, 0x1F, 0xFC, 0x03, 0xE7, 0xC0, 0x3E, 0x7F, 0x0F, 0xC3, 0xFF, 0xFC,
  0x1F, 0xFF, 0x80, 0xFF, 0xF0, 0x03, 0xF8, 0x00, 0xF0, 0xFC, 0x1E, 0x7F,
  0xE3, 0xDF, 0xFE, 0x7F, 0xFF, 0xCF, 0xF0, 0xFD, 0xFC, 0x0F, 0xBF, 0x01,
  0xFF, 0xC0, 0x1F, 0xF8, 0x03, 0xFF, 0x00, 0x7F, 0xE0, 0x0F, 0xFC, 0x01,
  0xFF, 0x80, 0x3F, 0xF0, 0x0F, 0xFE, 0x01, 0xF7, 0xC0, 0x7E, 0xF8, 0x1F,
  0x9F, 0xFF, 0xF3, 0xFF, 0xFC, 0x7F, 0xFE, 0x0F, 0xFF, 0x01, 0xF0, 0x00,
  0x3E, 0x00, 0x07, 0xC0, 0x00, 0xF8, 0x00, 0x1F, 0x00, 0x03, 0xE0, 0x00,
  0x7C, 0x00, 0x0F, 0x80, 0x00, 0x01, 0xFE, 0x60, 0xFF, 0xFC, 0x7F, 0xFF,
  0x9F, 0xFF, 0xF3, 0xF0, 0x3E, 0xFC, 0x07, 0xDF, 0x00, 0xFF, 0xE0, 0x1F,
  0xF8, 0x03, 0xFF, 0x00, 0x7F, 0xE0, 0x0F, 0xFC, 0x01, 0xFF, 0x80, 0x3F,
  0xF0, 0x07, 0xFE, 0x01, 0xFB, 0xE0, 0x7F, 0x7E, 0x1F, 0xE7, 0xFF, 0xFC,
  0xFF, 0xFF, 0x8F, 0xFD, 0xF0, 0x7E, 0x3E, 0x00, 0x07, 0xC0, 0x00, 0xF8,
  0x00, 0x1F, 0x00, 0x03, 0xE0, 0x00, 0x7C, 0x00, 0x0F, 0x80, 0x01, 0xF0,
  0x00, 0x3E, 0xF0, 0xFC, 0x3C, 0x7F, 0xCF, 0xBF, 0xFB, 0xFF, 0xFE, 0xFF,
  0x0F, 0xFF, 0x81, 0xFF, 0xC0, 0x7F, 0xE0, 0x1F, 0xF8, 0x00, 0x3E, 0x00,
  0x0F, 0x80, 0x03, 0xE0, 0x00, 0xF8, 0x00, 0x3E, 0x00, 0x0F, 0x80, 0x03,
  0xE0, 0x00, 0xF8, 0x00, 0x3E, 0x00, 0x0F, 0x80, 0x03, 0xE0, 0x00, 0xF8,
  0x00, 0x00, 0x07, 0xFC, 0x07, 0xFF, 0xC3, 0xFF, 0xF1, 0xFF, 0xFC, 0xFC,
  0x03, 0x3E, 0x00, 0x0F, 0x80, 0x03, 0xF8, 0x00, 0x7F, 0xC0, 0x1F, 0xFF,
  0x03, 0xFF, 0xF0, 0x1F, 0xFE, 0x00, 0xFF, 0xC0, 0x07, 0xF0, 0x00, 0xFE,
  0x00, 0x3F, 0xF0, 0x1F, 0xFF, 0xFF, 0xEF, 0xFF, 0xF1, 0xFF, 0xF8, 0x0F,
  0xF8, 0x00, 0x00, 0x60, 0x00, 0x3E, 0x00, 0x03, 0xE0, 0x00, 0x3E, 0x00,
  0x03, 0xE0, 0x00, 0x3E, 0x00, 0x03, 0xE0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x3E, 0x00, 0x03, 0xE0, 0x00, 0x3E,
  0x00, 0x03, 0xE0, 0x00, 0x3E, 0x00, 0x03, 0xE0, 0x00, 0x3E, 0x00, 0x03,
  0xE0, 0x00, 0x3E, 0x00, 0x03, 0xE0, 0x00, 0x3E, 0x00, 0x03, 0xE0, 0x00,
  0x3F, 0x03, 0x01, 0xFF, 0xF0, 0x1F, 0xFF, 0x00, 0xFF, 0xF0, 0x03, 0xFC,
  0xF8, 0x07, 0xFE, 0x01, 0xFF, 0x80, 0x7F, 0xE0, 0x1F, 0xF8, 0x07, 0xFE,
  0x01, 0xFF, 0x80, 0x7F, 0xE0, 0x1F, 0xF8, 0x07, 0xFE, 0x01, 0xFF, 0x80,
  0x7F, 0xE0, 0x1F, 0xF8, 0x07, 0xFE, 0x01, 0xFF, 0x80, 0xFF, 0xE0, 0x7F,
  0xFC, 0x3F, 0xDF, 0xFF, 0xF7, 0xFF, 0xBC, 0xFF, 0xCF, 0x0F, 0xC3, 0xC0,
  0x7C, 0x00, 0x7C, 0xFC, 0x01, 0xF9, 0xF8, 0x03, 0xF1, 0xF0, 0x07, 0xC3,
  0xF0, 0x1F, 0x83, 0xE0, 0x3E, 0x07, 0xC0, 0x7C, 0x0F, 0xC1, 0xF8, 0x0F,
  0x83, 0xE0, 0x1F, 0x07, 0xC0, 0x3F, 0x1F, 0x00, 0x3E, 0x3E, 0x00, 0x7C,
  0x7C, 0x00, 0x7D, 0xF0, 0x00, 0xFB, 0xE0, 0x01, 0xF7, 0xC0, 0x01, 0xFF,
  0x00, 0x03, 0xFE, 0x00, 0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, 0x0F, 0xE0,
  0x00, 0x78, 0x00, 0x0F, 0x3E, 0x00, 0x07, 0x9F, 0x00, 0x03, 0xCF, 0x80,
  0x03, 0xE7, 0xC0, 0x01, 0xF3, 0xE0, 0x00, 0xF8, 0xF0, 0xF8, 0x78, 0x78,
  0x7C, 0x3C, 0x3E, 0x3E, 0x1E, 0x1F, 0x1F, 0x8F, 0x0F, 0x9F, 0xCF, 0x87,
  0xCE, 0xE7, 0xC1, 0xE7, 0x7B, 0xC0, 0xF7, 0xBD, 0xE0, 0x7B, 0xDE, 0xF0,
  0x3F, 0xC7, 0xF8, 0x1F, 0xE3, 0xFC, 0x0F, 0xF1, 0xFE, 0x03, 0xF0, 0x7E,
  0x01, 0xF8, 0x3F, 0x00, 0xFC, 0x1F, 0x80, 0x7F, 0x00, 0x7E, 0x7E, 0x01,
  0xF8, 0x7E, 0x07, 0xE0, 0x7E, 0x0F, 0x80, 0xFC, 0x3F, 0x00, 0xFC, 0xFC,
  0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xE0, 0x01, 0xFF, 0x80, 0x01, 0xFE, 0x00,
  0x01, 0xF8, 0x00, 0x07, 0xF8, 0x00, 0x1F, 0xF8, 0x00, 0x7D, 0xF8, 0x00,
  0xFB, 0xF0, 0x03, 0xE3, 0xF0, 0x0F, 0xC3, 0xF0, 0x3F, 0x07, 0xF0, 0xFC,
  0x07, 0xE1, 0xF8, 0x07, 0xE7, 0xE0, 0x0F, 0xE0, 0x7C, 0x00, 0x7C, 0xFC,
  0x01, 0xF9, 0xF8, 0x03, 0xF1, 0xF0, 0x07, 0xC3, 0xF0, 0x1F, 0x83, 0xE0,
  0x3E, 0x07, 0xC0, 0x7C, 0x0F, 0xC1, 0xF8, 0x0F, 0x83, 0xE0, 0x1F, 0x07,
  0xC0, 0x3F, 0x1F, 0x00, 0x3E, 0x3E, 0x00, 0x7C, 0x7C, 0x00, 0x7D, 0xF0,
  0x00, 0xFB, 0xE0, 0x01, 0xF7, 0x80, 0x01, 0xFF, 0x00, 0x03, 0xFE, 0x00,
  0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, 0x0F, 0xC0, 0x00, 0x1F, 0x80, 0x00,
  0x3E, 0x00, 0x00, 0xFC, 0x00, 0x07, 0xF0, 0x01, 0xFF, 0xC0, 0x03, 0xFF,
  0x00, 0x07, 0xFC, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x03, 0xF0, 0x03, 0xF0, 0x03, 0xF0, 0x01,
  0xF8, 0x01, 0xF8, 0x01, 0xF8, 0x00, 0xFC, 0x00, 0xFC, 0x00, 0xFC, 0x00,
  0xFC, 0x00, 0x7E, 0x00, 0x7E, 0x00, 0x7E, 0x00, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x1F, 0x80, 0x3F, 0xC0, 0x3F, 0xE0,
  0x3F, 0xF0, 0x1F, 0x80, 0x1F, 0x80, 0x0F, 0x80, 0x07, 0xC0, 0x03, 0xE0,
  0x01, 0xF0, 0x00, 0xF8, 0x00, 0x7C, 0x00, 0x3E, 0x00, 0x1F, 0x00, 0x0F,
  0x80, 0x0F, 0xC0, 0x0F, 0xC0, 0x7F, 0xE0, 0x3F, 0xC0, 0x1F, 0xE0, 0x0F,
  0xFC, 0x00, 0x7E, 0x00, 0x1F, 0x80, 0x07, 0xC0, 0x03, 0xE0, 0x01, 0xF0,
  0x00, 0xF8, 0x00, 0x7C, 0x00, 0x3E, 0x00, 0x1F, 0x00, 0x0F, 0x80, 0x07,
  0xC0, 0x03, 0xE0, 0x01, 0xF8, 0x00, 0x7E, 0x00, 0x3F, 0xF0, 0x0F, 0xF8,
  0x03, 0xFC, 0x00, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFC, 0x00, 0x7F, 0x80, 0x3F,
  0xE0, 0x1F, 0xF8, 0x00, 0xFC, 0x00, 0x3F, 0x00, 0x0F, 0x80, 0x07, 0xC0,
  0x03, 0xE0, 0x01, 0xF0, 0x00, 0xF8, 0x00, 0x7C, 0x00, 0x3E, 0x00, 0x1F,
  0x00, 0x0F, 0x80, 0x07, 0xE0, 0x01, 0xF8, 0x00, 0xFF, 0xC0, 0x1F, 0xE0,
  0x0F, 0xF0, 0x1F, 0xF8, 0x0F, 0xC0, 0x0F, 0xC0, 0x07, 0xC0, 0x03, 0xE0,
  0x01, 0xF0, 0x00, 0xF8, 0x00, 0x7C, 0x00, 0x3E, 0x00, 0x1F, 0x00, 0x0F,
  0x80, 0x07, 0xC0, 0x03, 0xE0, 0x03, 0xF0, 0x03, 0xF0, 0x1F, 0xF8, 0x0F,
  0xF8, 0x07, 0xF8, 0x03, 0xF0, 0x00, 0x0F, 0x80, 0x00, 0xFF, 0x80, 0x07,
  0xFF, 0x03, 0xDF, 0xFE, 0x0F, 0xF9, 0xFC, 0x3F, 0xC3, 0xF9, 0xFF, 0x07,
  0xFF, 0xBC, 0x0F, 0xFE, 0x00, 0x1F, 0xF0, 0x00, 0x1F, 0x00 };

const GFXglyph Courier_Prime_Sans6pt7bGlyphs[] PROGMEM = {
  {      0,   1,   1,  24,    0,   24 },   // 0x20 ' '
  {      1,   7,  30,  24,    9,   -5 },   // 0x21 '!'
  {     28,  13,  10,  24,    5,   -5 },   // 0x22 '"'
  {     45,  22,  27,  24,    1,   -2 },   // 0x23 '#'
  {    120,  19,  37,  24,    2,   -7 },   // 0x24 '$'
  {    208,  24,  30,  24,    0,   -5 },   // 0x25 '%'
  {    298,  24,  30,  24,    1,   -5 },   // 0x26 '&'
  {    388,   6,  10,  24,    9,   -5 },   // 0x27 '''
  {    396,  13,  39,  24,    6,   -6 },   // 0x28 '('
  {    460,  13,  39,  24,    5,   -6 },   // 0x29 ')'
  {    524,  19,  18,  24,    3,   -5 },   // 0x2A '*'
  {    567,  21,  20,  24,    2,    4 },   // 0x2B '+'
  {    620,  12,  15,  24,    4,   17 },   // 0x2C ','
  {    643,  13,   4,  24,    5,   12 },   // 0x2D '-'
  {    650,   8,   8,  24,    8,   17 },   // 0x2E '.'
  {    658,  20,  35,  24,    2,   -5 },   // 0x2F '/'
  {    746,  21,  27,  24,    1,   -2 },   // 0x30 '0'
  {    817,  19,  27,  24,    2,   -2 },   // 0x31 '1'
  {    882,  19,  27,  24,    3,   -2 },   // 0x32 '2'
  {    947,  18,  27,  24,    3,   -2 },   // 0x33 '3'
  {   1008,  22,  27,  24,    1,   -2 },   // 0x34 '4'
  {   1083,  17,  27,  24,    3,   -2 },   // 0x35 '5'
  {   1141,  20,  27,  24,    2,   -2 },   // 0x36 '6'
  {   1209,  19,  27,  24,    2,   -2 },   // 0x37 '7'
  {   1274,  19,  27,  24,    2,   -2 },   // 0x38 '8'
  {   1339,  19,  27,  24,    2,   -2 },   // 0x39 '9'
  {   1404,   8,  21,  24,    8,    4 },   // 0x3A ':'
  {   1425,  12,  28,  24,    4,    4 },   // 0x3B ';'
  {   1467,  17,  24,  24,    2,    1 },   // 0x3C '<'
  {   1518,  18,  12,  24,    3,    7 },   // 0x3D '='
  {   1545,  17,  24,  24,    4,    1 },   // 0x3E '>'
  {   1596,  15,  30,  24,    6,   -5 },   // 0x3F '?'
  {   1653,  23,  38,  24,    0,   -5 },   // 0x40 '@'
  {   1763,  25,  27,  24,   -1,   -2 },   // 0x41 'A'
  {   1848,  19,  27,  24,    3,   -2 },   // 0x42 'B'
  {   1913,  19,  27,  24,    2,   -2 },   // 0x43 'C'
  {   1978,  20,  27,  24,    2,   -2 },   // 0x44 'D'
  {   2046,  17,  27,  24,    4,   -2 },   // 0x45 'E'
  {   2104,  16,  27,  24,    4,   -2 },   // 0x46 'F'
  {   2158,  21,  27,  24,    1,   -2 },   // 0x47 'G'
  {   2229,  19,  27,  24,    2,   -2 },   // 0x48 'H'
  {   2294,  17,  27,  24,    3,   -2 },   // 0x49 'I'
  {   2352,  15,  27,  24,    4,   -2 },   // 0x4A 'J'
  {   2403,  21,  27,  24,    3,   -2 },   // 0x4B 'K'
  {   2474,  17,  27,  24,    4,   -2 },   // 0x4C 'L'
  {   2532,  23,  27,  24,    0,   -2 },   // 0x4D 'M'
  {   2610,  20,  27,  24,    2,   -2 },   // 0x4E 'N'
  {   2678,  22,  27,  24,    1,   -2 },   // 0x4F 'O'
  {   2753,  19,  27,  24,    3,   -2 },   // 0x50 'P'
  {   2818,  23,  36,  24,    1,   -2 },   // 0x51 'Q'
  {   2922,  20,  27,  24,    3,   -2 },   // 0x52 'R'
  {   2990,  19,  27,  24,    2,   -2 },   // 0x53 'S'
  {   3055,  21,  27,  24,    1,   -2 },   // 0x54 'T'
  {   3126,  20,  27,  24,    2,   -2 },   // 0x55 'U'
  {   3194,  25,  27,  24,    0,   -2 },   // 0x56 'V'
  {   3279,  23,  27,  24,    0,   -2 },   // 0x57 'W'
  {   3357,  23,  27,  24,    1,   -2 },   // 0x58 'X'
  {   3435,  23,  27,  24,    0,   -2 },   // 0x59 'Y'
  {   3513,  19,  27,  24,    2,   -2 },   // 0x5A 'Z'
  {   3578,  11,  39,  24,    6,   -6 },   // 0x5B '['
  {   3632,  19,  35,  24,    3,   -5 },   // 0x5C '\'
  {   3716,  11,  39,  24,    6,   -6 },   // 0x5D ']'
  {   3770,  21,  13,  24,    1,   -2 },   // 0x5E '^'
  {   3805,  24,   4,  24,    0,   30 },   // 0x5F '_'
  {   3817,  14,   9,  24,    0,   -5 },   // 0x60 '`'
  {   3833,  18,  21,  24,    2,    4 },   // 0x61 'a'
  {   3881,  19,  30,  24,    3,   -5 },   // 0x62 'b'
  {   3953,  17,  21,  24,    3,    4 },   // 0x63 'c'
  {   3998,  19,  30,  24,    2,   -5 },   // 0x64 'd'
  {   4070,  19,  21,  24,    2,    4 },   // 0x65 'e'
  {   4120,  22,  30,  24,    0,   -5 },   // 0x66 'f'
  {   4203,  20,  29,  24,    2,    4 },   // 0x67 'g'
  {   4276,  18,  30,  24,    3,   -5 },   // 0x68 'h'
  {   4344,  19,  31,  24,    3,   -6 },   // 0x69 'i'
  {   4418,  16,  39,  24,    3,   -6 },   // 0x6A 'j'
  {   4496,  20,  30,  24,    3,   -5 },   // 0x6B 'k'
  {   4571,  18,  30,  24,    3,   -5 },   // 0x6C 'l'
  {   4639,  21,  21,  24,    2,    4 },   // 0x6D 'm'
  {   4695,  18,  21,  24,    3,    4 },   // 0x6E 'n'
  {   4743,  20,  21,  24,    2,    4 },   // 0x6F 'o'
  {   4796,  19,  29,  24,    3,    4 },   // 0x70 'p'
  {   4865,  19,  29,  24,    2,    4 },   // 0x71 'q'
  {   4934,  18,  21,  24,    4,    4 },   // 0x72 'r'
  {   4982,  18,  21,  24,    3,    4 },   // 0x73 's'
  {   5030,  20,  28,  24,    1,   -3 },   // 0x74 't'
  {   5100,  18,  21,  24,    3,    4 },   // 0x75 'u'
  {   5148,  23,  21,  24,    1,    4 },   // 0x76 'v'
  {   5209,  25,  21,  24,   -1,    4 },   // 0x77 'w'
  {   5275,  23,  21,  24,    0,    4 },   // 0x78 'x'
  {   5336,  23,  29,  24,    1,    4 },   // 0x79 'y'
  {   5420,  17,  21,  24,    3,    4 },   // 0x7A 'z'
  {   5465,  17,  39,  24,    2,   -6 },   // 0x7B '{'
  {   5548,   5,  43,  24,    9,   -9 },   // 0x7C '|'
  {   5575,  17,  39,  24,    4,   -6 },   // 0x7D '}'
  {   5658,  22,  10,  24,    1,    9 } }; // 0x7E '~'

const GFXfont Courier_Prime_Sans6pt7b PROGMEM = {
  (uint8_t  *)Courier_Prime_Sans6pt7bBitmaps,
  (GFXglyph *)Courier_Prime_Sans6pt7bGlyphs,
  0x20, 0x7E, 50 };

// Approx. 6358 bytes
#else  // original 800x480
const uint8_t Courier_Prime_Sans6pt7bBitmaps[] PROGMEM = {
  0x00, 0xFA, 0xB4, 0x31, 0xBE, 0xAF, 0xB1, 0x80, 0x23, 0xA8, 0xC3, 0x15, 
  0xC4, 0x46, 0xA5, 0x04, 0x29, 0x58, 0x80, 0x31, 0x24, 0x08, 0x55, 0x23, 
  0x40, 0xC0, 0x2A, 0x49, 0x22, 0x20, 0x88, 0x92, 0x4A, 0x80, 0x23, 0x9C, 
  0x40, 0x21, 0x3E, 0x42, 0x00, 0x6D, 0xE0, 0xE0, 0xF0, 0x11, 0x22, 0x44, 
  0x88, 0x74, 0xEB, 0x5C, 0xB8, 0x00, 0x6A, 0x22, 0x2F, 0x69, 0x12, 0x4F, 
  0xE1, 0x61, 0x1E, 0x11, 0x95, 0x2F, 0x88, 0x00, 0xF8, 0xE1, 0x1E, 0x74, 
  0x3D, 0x18, 0xB8, 0x00, 0xF1, 0x22, 0x44, 0x69, 0x69, 0x96, 0x74, 0x62, 
  0xF0, 0xB8, 0x00, 0xD8, 0x48, 0x36, 0xF0, 0x16, 0x86, 0x10, 0xF0, 0xF0, 
  0x86, 0x16, 0x80, 0xC4, 0xF8, 0x20, 0x74, 0x6B, 0x6A, 0x45, 0xC0, 0x10, 
  0x50, 0xA2, 0x27, 0xC8, 0x80, 0xE9, 0xE9, 0x9E, 0x78, 0x88, 0x87, 0xE9, 
  0x99, 0x9E, 0xF8, 0xE8, 0x8F, 0xF8, 0xE8, 0x88, 0x3A, 0x16, 0x94, 0x9C, 
  0x00, 0x99, 0xF9, 0x99, 0xE9, 0x25, 0xC0, 0x11, 0x11, 0x96, 0x9A, 0xCC, 
  0xA9, 0x88, 0x88, 0x8F, 0x8E, 0xEB, 0x18, 0xC4, 0x00, 0x8E, 0x6B, 0x59, 
  0xC4, 0x00, 0x74, 0x63, 0x18, 0xB8, 0xE9, 0x9E, 0x88, 0x74, 0x63, 0x18, 
  0xB8, 0x60, 0xE9, 0x9E, 0x99, 0x78, 0x42, 0x1E, 0xF9, 0x08, 0x42, 0x10, 
  0x8C, 0x63, 0x18, 0xB8, 0x8C, 0x62, 0xA5, 0x10, 0x00, 0x8C, 0x6B, 0x5D, 
  0xC4, 0x00, 0x8A, 0x88, 0x45, 0x44, 0x00, 0x8A, 0x94, 0x42, 0x10, 0xF1, 
  0x24, 0x8F, 0xF2, 0x49, 0x24, 0xE0, 0x88, 0x44, 0x22, 0x21, 0xE4, 0x92, 
  0x49, 0xE0, 0x22, 0x94, 0xFC, 0x63, 0x00, 0xF1, 0xF9, 0xF0, 0x88, 0xF9, 
  0x99, 0xE0, 0x78, 0x88, 0x70, 0x11, 0x79, 0x99, 0x70, 0x69, 0xF8, 0x70, 
  0x18, 0x87, 0x08, 0x20, 0x82, 0x00, 0x74, 0x63, 0x17, 0x85, 0xC0, 0x88, 
  0xF9, 0x99, 0x90, 0x20, 0xE2, 0x22, 0xF0, 0x23, 0x92, 0x49, 0xC0, 0x88, 
  0x9A, 0xCA, 0x90, 0xE2, 0x22, 0x22, 0xF0, 0xFD, 0x6B, 0x5A, 0x80, 0xF9, 
  0x99, 0x90, 0x74, 0x63, 0x17, 0x00, 0x69, 0x99, 0xE8, 0x80, 0x69, 0x99, 
  0x71, 0x10, 0xF9, 0x88, 0x80, 0x78, 0x61, 0xE0, 0x44, 0xF4, 0x44, 0x30, 
  0x99, 0x99, 0x60, 0x52, 0x94, 0xA2, 0x00, 0x8C, 0x6B, 0x57, 0x00, 0x8A, 
  0x88, 0xA8, 0x80, 0x52, 0x94, 0xE1, 0x09, 0x80, 0xF1, 0x24, 0xF0, 0x69, 
  0x28, 0x92, 0x60, 0xFF, 0xC0, 0xC9, 0x22, 0x92, 0xC0, 0xED, 0xC0
};

const GFXglyph Courier_Prime_Sans6pt7bGlyphs[] PROGMEM = {
  {     0,   1,   1,   6,    0,    6 },   // 0x20 ' '
  {     1,   1,   7,   6,    2,    0 },   // 0x21 '!'
  {     2,   3,   2,   6,    2,    0 },   // 0x22 '"'
  {     3,   5,   7,   6,    1,    0 },   // 0x23 '#'
  {     8,   5,   8,   6,    1,    0 },   // 0x24 '$'
  {    13,   6,   7,   6,    0,    0 },   // 0x25 '%'
  {    19,   6,   7,   6,    0,    0 },   // 0x26 '&'
  {    25,   1,   2,   6,    2,    0 },   // 0x27 '''
  {    26,   3,   9,   6,    1,    0 },   // 0x28 '('
  {    30,   3,   9,   6,    1,    0 },   // 0x29 ')'
  {    34,   5,   4,   6,    1,    0 },   // 0x2A '*'
  {    37,   5,   5,   6,    1,    2 },   // 0x2B '+'
  {    41,   3,   4,   6,    1,    5 },   // 0x2C ','
  {    43,   3,   1,   6,    1,    4 },   // 0x2D '-'
  {    44,   2,   2,   6,    2,    5 },   // 0x2E '.'
  {    45,   4,   8,   6,    1,    0 },   // 0x2F '/'
  {    49,   5,   6,   6,    1,    1 },   // 0x30 '0'
  {    54,   4,   6,   6,    1,    1 },   // 0x31 '1'
  {    57,   4,   6,   6,    1,    1 },   // 0x32 '2'
  {    60,   4,   6,   6,    1,    1 },   // 0x33 '3'
  {    63,   5,   6,   6,    1,    1 },   // 0x34 '4'
  {    68,   4,   6,   6,    1,    1 },   // 0x35 '5'
  {    71,   5,   6,   6,    1,    1 },   // 0x36 '6'
  {    76,   4,   6,   6,    1,    1 },   // 0x37 '7'
  {    79,   4,   6,   6,    1,    1 },   // 0x38 '8'
  {    82,   5,   6,   6,    0,    1 },   // 0x39 '9'
  {    87,   1,   5,   6,    2,    2 },   // 0x3A ':'
  {    88,   3,   7,   6,    1,    2 },   // 0x3B ';'
  {    91,   4,   5,   6,    1,    2 },   // 0x3C '<'
  {    94,   4,   3,   6,    1,    3 },   // 0x3D '='
  {    96,   4,   5,   6,    1,    2 },   // 0x3E '>'
  {    99,   3,   7,   6,    1,    0 },   // 0x3F '?'
  {   102,   5,   8,   6,    1,    1 },   // 0x40 '@'
  {   107,   7,   6,   6,   -1,    1 },   // 0x41 'A'
  {   113,   4,   6,   6,    1,    1 },   // 0x42 'B'
  {   116,   4,   6,   6,    1,    1 },   // 0x43 'C'
  {   119,   4,   6,   6,    1,    1 },   // 0x44 'D'
  {   122,   4,   6,   6,    1,    1 },   // 0x45 'E'
  {   125,   4,   6,   6,    1,    1 },   // 0x46 'F'
  {   128,   5,   6,   6,    0,    1 },   // 0x47 'G'
  {   133,   4,   6,   6,    1,    1 },   // 0x48 'H'
  {   136,   3,   6,   6,    2,    1 },   // 0x49 'I'
  {   139,   4,   6,   6,    1,    1 },   // 0x4A 'J'
  {   142,   4,   6,   6,    1,    1 },   // 0x4B 'K'
  {   145,   4,   6,   6,    1,    1 },   // 0x4C 'L'
  {   148,   5,   6,   6,    1,    1 },   // 0x4D 'M'
  {   153,   5,   6,   6,    1,    1 },   // 0x4E 'N'
  {   158,   5,   6,   6,    1,    1 },   // 0x4F 'O'
  {   162,   4,   6,   6,    1,    1 },   // 0x50 'P'
  {   165,   5,   7,   6,    1,    1 },   // 0x51 'Q'
  {   170,   4,   6,   6,    1,    1 },   // 0x52 'R'
  {   173,   4,   6,   6,    1,    1 },   // 0x53 'S'
  {   176,   5,   6,   6,    0,    1 },   // 0x54 'T'
  {   180,   5,   6,   6,    1,    1 },   // 0x55 'U'
  {   184,   5,   6,   6,    1,    1 },   // 0x56 'V'
  {   189,   5,   6,   6,    1,    1 },   // 0x57 'W'
  {   194,   5,   6,   6,    1,    1 },   // 0x58 'X'
  {   199,   5,   6,   6,    1,    1 },   // 0x59 'Y'
  {   203,   4,   6,   6,    1,    1 },   // 0x5A 'Z'
  {   206,   3,   9,   6,    2,    0 },   // 0x5B '['
  {   210,   4,   8,   6,    1,    0 },   // 0x5C '\'
  {   214,   3,   9,   6,    1,    0 },   // 0x5D ']'
  {   218,   5,   3,   6,    0,    1 },   // 0x5E '^'
  {   220,   6,   1,   6,    0,    8 },   // 0x5F '_'
  {   221,   4,   3,   6,    0,   -1 },   // 0x60 '`'
  {   223,   4,   5,   6,    1,    2 },   // 0x61 'a'
  {   226,   4,   7,   6,    1,    0 },   // 0x62 'b'
  {   230,   4,   5,   6,    1,    2 },   // 0x63 'c'
  {   233,   4,   7,   6,    1,    0 },   // 0x64 'd'
  {   237,   4,   5,   6,    1,    2 },   // 0x65 'e'
  {   240,   6,   7,   6,    0,    0 },   // 0x66 'f'
  {   246,   5,   7,   6,    1,    2 },   // 0x67 'g'
  {   251,   4,   7,   6,    1,    0 },   // 0x68 'h'
  {   255,   4,   7,   6,    1,    0 },   // 0x69 'i'
  {   259,   3,   9,   6,    1,    0 },   // 0x6A 'j'
  {   263,   4,   7,   6,    1,    0 },   // 0x6B 'k'
  {   267,   4,   7,   6,    1,    0 },   // 0x6C 'l'
  {   271,   5,   5,   6,    1,    2 },   // 0x6D 'm'
  {   275,   4,   5,   6,    1,    2 },   // 0x6E 'n'
  {   278,   5,   5,   6,    0,    2 },   // 0x6F 'o'
  {   282,   4,   7,   6,    1,    2 },   // 0x70 'p'
  {   286,   4,   7,   6,    1,    2 },   // 0x71 'q'
  {   290,   4,   5,   6,    1,    2 },   // 0x72 'r'
  {   293,   4,   5,   6,    1,    2 },   // 0x73 's'
  {   296,   4,   7,   6,    1,    0 },   // 0x74 't'
  {   300,   4,   5,   6,    1,    2 },   // 0x75 'u'
  {   303,   5,   5,   6,    1,    2 },   // 0x76 'v'
  {   307,   5,   5,   6,    1,    2 },   // 0x77 'w'
  {   311,   5,   5,   6,    1,    2 },   // 0x78 'x'
  {   315,   5,   7,   6,    1,    2 },   // 0x79 'y'
  {   320,   4,   5,   6,    1,    2 },   // 0x7A 'z'
  {   323,   3,   9,   6,    1,    0 },   // 0x7B '{'
  {   327,   1,  10,   6,    2,   -1 },   // 0x7C '|'
  {   329,   3,   9,   6,    1,    0 },   // 0x7D '}'
  {   333,   5,   2,   6,    0,    3 }    // 0x7E '~'
};

const GFXfont Courier_Prime_Sans6pt7b PROGMEM = {
  (uint8_t  *)Courier_Prime_Sans6pt7bBitmaps,   
  (GFXglyph *)Courier_Prime_Sans6pt7bGlyphs, 0x20, 0x7E,    11 };

// Approx. 1004 bytes
#endif
