/*
 * Copyright (c) 2010  Leo Singer
 *
 * Colormap data from Matplotlib's matplotlib.cm module, which is
 * Copyright (c) 2002-2009 John D. Hunter; All Rights Reserved
 *
 */


#include "colormap.h"
#include <glib.h>
#include <glib-object.h>

gboolean
colormap_get_data_by_name (enum cairovis_colormap_name key,
    colormap_data * data)
{
  switch (key) {
    case CAIROVIS_COLORMAP_Accent:{
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.49803921580314636, 0.7450980544090271, 0.99215686321258545, 1.0,
              0.21960784494876862, 0.94117647409439087, 0.74901962280273438,
              0.40000000596046448 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.78823530673980713, 0.68235296010971069, 0.75294119119644165,
              1.0, 0.42352941632270813, 0.0078431377187371254,
              0.35686275362968445, 0.40000000596046448 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.49803921580314636, 0.83137255907058716, 0.52549022436141968,
              0.60000002384185791, 0.69019609689712524, 0.49803921580314636,
              0.090196080505847931, 0.40000000596046448 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Accent_r:{
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.40000000596046448, 0.74901962280273438, 0.94117647409439087,
              0.21960784494876862, 1.0, 0.99215686321258545, 0.7450980544090271,
              0.49803921580314636 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.40000000596046448, 0.35686275362968445, 0.0078431377187371254,
              0.42352941632270813, 1.0, 0.75294119119644165,
              0.68235296010971069, 0.78823530673980713 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.40000000596046448, 0.090196080505847931, 0.49803921580314636,
              0.69019609689712524, 0.60000002384185791, 0.52549022436141968,
              0.83137255907058716, 0.49803921580314636 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Blues:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9686274528503418, 0.87058824300765991, 0.7764706015586853,
              0.61960786581039429, 0.41960784792900085, 0.25882354378700256,
              0.12941177189350128, 0.031372550874948502, 0.031372550874948502 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9843137264251709, 0.92156863212585449, 0.85882353782653809,
              0.7921568751335144, 0.68235296010971069, 0.57254904508590698,
              0.44313725829124451, 0.31764706969261169, 0.18823529779911041 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.9686274528503418, 0.93725490570068359, 0.88235294818878174,
              0.83921569585800171, 0.7764706015586853, 0.70980393886566162,
              0.61176472902297974, 0.41960784792900085 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Blues_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.031372550874948502, 0.031372550874948502, 0.12941177189350128,
              0.25882354378700256, 0.41960784792900085, 0.61960786581039429,
              0.7764706015586853, 0.87058824300765991, 0.9686274528503418 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.18823529779911041, 0.31764706969261169, 0.44313725829124451,
              0.57254904508590698, 0.68235296010971069, 0.7921568751335144,
              0.85882353782653809, 0.92156863212585449, 0.9843137264251709 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.41960784792900085, 0.61176472902297974, 0.70980393886566162,
              0.7764706015586853, 0.83921569585800171, 0.88235294818878174,
              0.93725490570068359, 0.9686274528503418, 1.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_BrBG:{
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.32941177487373352, 0.54901963472366333, 0.74901962280273438,
              0.87450981140136719, 0.96470588445663452, 0.96078431606292725,
              0.78039216995239258, 0.50196081399917603, 0.20784313976764679,
              0.0039215688593685627, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.18823529779911041, 0.31764706969261169, 0.5058823823928833,
              0.7607843279838562, 0.90980392694473267, 0.96078431606292725,
              0.91764706373214722, 0.80392158031463623, 0.59215688705444336,
              0.40000000596046448, 0.23529411852359772 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.019607843831181526, 0.039215687662363052, 0.17647059261798859,
              0.49019607901573181, 0.76470589637756348, 0.96078431606292725,
              0.89803922176361084, 0.75686275959014893, 0.56078433990478516,
              0.36862745881080627, 0.18823529779911041 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_BrBG_r:{
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.0, 0.0039215688593685627, 0.20784313976764679,
              0.50196081399917603, 0.78039216995239258, 0.96078431606292725,
              0.96470588445663452, 0.87450981140136719, 0.74901962280273438,
              0.54901963472366333, 0.32941177487373352 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.23529411852359772, 0.40000000596046448, 0.59215688705444336,
              0.80392158031463623, 0.91764706373214722, 0.96078431606292725,
              0.90980392694473267, 0.7607843279838562, 0.5058823823928833,
              0.31764706969261169, 0.18823529779911041 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.18823529779911041, 0.36862745881080627, 0.56078433990478516,
              0.75686275959014893, 0.89803922176361084, 0.96078431606292725,
              0.76470589637756348, 0.49019607901573181, 0.17647059261798859,
              0.039215687662363052, 0.019607843831181526 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_BuGn:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9686274528503418, 0.89803922176361084, 0.80000001192092896,
              0.60000002384185791, 0.40000000596046448, 0.25490197539329529,
              0.13725490868091583, 0.0, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.98823529481887817, 0.96078431606292725, 0.92549020051956177,
              0.84705883264541626, 0.7607843279838562, 0.68235296010971069,
              0.54509806632995605, 0.42745098471641541, 0.26666668057441711 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.99215686321258545, 0.97647058963775635, 0.90196079015731812,
              0.78823530673980713, 0.64313727617263794, 0.46274510025978088,
              0.27058824896812439, 0.17254902422428131, 0.10588235408067703 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_BuGn_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.0, 0.13725490868091583, 0.25490197539329529,
              0.40000000596046448, 0.60000002384185791, 0.80000001192092896,
              0.89803922176361084, 0.9686274528503418 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.26666668057441711, 0.42745098471641541, 0.54509806632995605,
              0.68235296010971069, 0.7607843279838562, 0.84705883264541626,
              0.92549020051956177, 0.96078431606292725, 0.98823529481887817 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.10588235408067703, 0.17254902422428131, 0.27058824896812439,
              0.46274510025978088, 0.64313727617263794, 0.78823530673980713,
              0.90196079015731812, 0.97647058963775635, 0.99215686321258545 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_BuPu:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9686274528503418, 0.87843137979507446, 0.74901962280273438,
              0.61960786581039429, 0.54901963472366333, 0.54901963472366333,
              0.53333336114883423, 0.5058823823928833, 0.30196079611778259 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.98823529481887817, 0.92549020051956177, 0.82745099067687988,
              0.73725491762161255, 0.58823531866073608, 0.41960784792900085,
              0.25490197539329529, 0.058823529630899429, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.99215686321258545, 0.95686274766921997, 0.90196079015731812,
              0.85490196943283081, 0.7764706015586853, 0.69411766529083252,
              0.61568629741668701, 0.48627451062202454, 0.29411765933036804 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_BuPu_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.30196079611778259, 0.5058823823928833, 0.53333336114883423,
              0.54901963472366333, 0.54901963472366333, 0.61960786581039429,
              0.74901962280273438, 0.87843137979507446, 0.9686274528503418 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.058823529630899429, 0.25490197539329529,
              0.41960784792900085, 0.58823531866073608, 0.73725491762161255,
              0.82745099067687988, 0.92549020051956177, 0.98823529481887817 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.29411765933036804, 0.48627451062202454, 0.61568629741668701,
              0.69411766529083252, 0.7764706015586853, 0.85490196943283081,
              0.90196079015731812, 0.95686274766921997, 0.99215686321258545 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Dark2:{
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.10588235408067703, 0.85098040103912354, 0.45882353186607361,
              0.90588235855102539, 0.40000000596046448, 0.90196079015731812,
              0.65098041296005249, 0.40000000596046448 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.61960786581039429, 0.37254902720451355, 0.43921568989753723,
              0.16078431904315948, 0.65098041296005249, 0.67058825492858887,
              0.46274510025978088, 0.40000000596046448 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.46666666865348816, 0.0078431377187371254, 0.70196080207824707,
              0.54117649793624878, 0.11764705926179886, 0.0078431377187371254,
              0.11372549086809158, 0.40000000596046448 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Dark2_r:{
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.40000000596046448, 0.65098041296005249, 0.90196079015731812,
              0.40000000596046448, 0.90588235855102539, 0.45882353186607361,
              0.85098040103912354, 0.10588235408067703 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.40000000596046448, 0.46274510025978088, 0.67058825492858887,
              0.65098041296005249, 0.16078431904315948, 0.43921568989753723,
              0.37254902720451355, 0.61960786581039429 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.40000000596046448, 0.11372549086809158, 0.0078431377187371254,
              0.11764705926179886, 0.54117649793624878, 0.70196080207824707,
              0.0078431377187371254, 0.46666666865348816 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_GnBu:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9686274528503418, 0.87843137979507446, 0.80000001192092896,
              0.65882354974746704, 0.48235294222831726, 0.30588236451148987,
              0.16862745583057404, 0.031372550874948502, 0.031372550874948502 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.98823529481887817, 0.9529411792755127, 0.92156863212585449,
              0.86666667461395264, 0.80000001192092896, 0.70196080207824707,
              0.54901963472366333, 0.40784314274787903, 0.25098040699958801 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.94117647409439087, 0.85882353782653809, 0.77254903316497803,
              0.70980393886566162, 0.76862746477127075, 0.82745099067687988,
              0.7450980544090271, 0.67450982332229614, 0.5058823823928833 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_GnBu_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.031372550874948502, 0.031372550874948502, 0.16862745583057404,
              0.30588236451148987, 0.48235294222831726, 0.65882354974746704,
              0.80000001192092896, 0.87843137979507446, 0.9686274528503418 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.25098040699958801, 0.40784314274787903, 0.54901963472366333,
              0.70196080207824707, 0.80000001192092896, 0.86666667461395264,
              0.92156863212585449, 0.9529411792755127, 0.98823529481887817 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.5058823823928833, 0.67450982332229614, 0.7450980544090271,
              0.82745099067687988, 0.76862746477127075, 0.70980393886566162,
              0.77254903316497803, 0.85882353782653809, 0.94117647409439087 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Greens:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9686274528503418, 0.89803922176361084, 0.78039216995239258,
              0.63137257099151611, 0.45490196347236633, 0.25490197539329529,
              0.13725490868091583, 0.0, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.98823529481887817, 0.96078431606292725, 0.91372549533843994,
              0.85098040103912354, 0.76862746477127075, 0.67058825492858887,
              0.54509806632995605, 0.42745098471641541, 0.26666668057441711 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.96078431606292725, 0.87843137979507446, 0.75294119119644165,
              0.60784316062927246, 0.46274510025978088, 0.364705890417099,
              0.27058824896812439, 0.17254902422428131, 0.10588235408067703 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Greens_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.0, 0.13725490868091583, 0.25490197539329529,
              0.45490196347236633, 0.63137257099151611, 0.78039216995239258,
              0.89803922176361084, 0.9686274528503418 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.26666668057441711, 0.42745098471641541, 0.54509806632995605,
              0.67058825492858887, 0.76862746477127075, 0.85098040103912354,
              0.91372549533843994, 0.96078431606292725, 0.98823529481887817 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.10588235408067703, 0.17254902422428131, 0.27058824896812439,
              0.364705890417099, 0.46274510025978088, 0.60784316062927246,
              0.75294119119644165, 0.87843137979507446, 0.96078431606292725 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Greys:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.94117647409439087, 0.85098040103912354,
              0.74117648601531982, 0.58823531866073608, 0.45098039507865906,
              0.32156863808631897, 0.14509804546833038, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.94117647409439087, 0.85098040103912354,
              0.74117648601531982, 0.58823531866073608, 0.45098039507865906,
              0.32156863808631897, 0.14509804546833038, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.94117647409439087, 0.85098040103912354,
              0.74117648601531982, 0.58823531866073608, 0.45098039507865906,
              0.32156863808631897, 0.14509804546833038, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Greys_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.14509804546833038, 0.32156863808631897,
              0.45098039507865906, 0.58823531866073608, 0.74117648601531982,
              0.85098040103912354, 0.94117647409439087, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.14509804546833038, 0.32156863808631897,
              0.45098039507865906, 0.58823531866073608, 0.74117648601531982,
              0.85098040103912354, 0.94117647409439087, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.14509804546833038, 0.32156863808631897,
              0.45098039507865906, 0.58823531866073608, 0.74117648601531982,
              0.85098040103912354, 0.94117647409439087, 1.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_OrRd:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.99607843160629272, 0.99215686321258545,
              0.99215686321258545, 0.98823529481887817, 0.93725490570068359,
              0.84313726425170898, 0.70196080207824707, 0.49803921580314636 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9686274528503418, 0.90980392694473267, 0.83137255907058716,
              0.73333334922790527, 0.55294120311737061, 0.3960784375667572,
              0.18823529779911041, 0.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.92549020051956177, 0.78431373834609985, 0.61960786581039429,
              0.51764708757400513, 0.3490196168422699, 0.28235295414924622,
              0.12156862765550613, 0.0, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_OrRd_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.49803921580314636, 0.70196080207824707, 0.84313726425170898,
              0.93725490570068359, 0.98823529481887817, 0.99215686321258545,
              0.99215686321258545, 0.99607843160629272, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.0, 0.18823529779911041, 0.3960784375667572,
              0.55294120311737061, 0.73333334922790527, 0.83137255907058716,
              0.90980392694473267, 0.9686274528503418 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.0, 0.12156862765550613, 0.28235295414924622,
              0.3490196168422699, 0.51764708757400513, 0.61960786581039429,
              0.78431373834609985, 0.92549020051956177 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Oranges:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.99607843160629272, 0.99215686321258545,
              0.99215686321258545, 0.99215686321258545, 0.94509804248809814,
              0.85098040103912354, 0.65098041296005249, 0.49803921580314636 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.96078431606292725, 0.90196079015731812, 0.81568628549575806,
              0.68235296010971069, 0.55294120311737061, 0.4117647111415863,
              0.28235295414924622, 0.21176470816135406, 0.15294118225574493 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.92156863212585449, 0.80784314870834351, 0.63529413938522339,
              0.41960784792900085, 0.23529411852359772, 0.074509806931018829,
              0.0039215688593685627, 0.011764706112444401,
              0.015686275437474251 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Oranges_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.49803921580314636, 0.65098041296005249, 0.85098040103912354,
              0.94509804248809814, 0.99215686321258545, 0.99215686321258545,
              0.99215686321258545, 0.99607843160629272, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.15294118225574493, 0.21176470816135406, 0.28235295414924622,
              0.4117647111415863, 0.55294120311737061, 0.68235296010971069,
              0.81568628549575806, 0.90196079015731812, 0.96078431606292725 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.015686275437474251, 0.011764706112444401, 0.0039215688593685627,
              0.074509806931018829, 0.23529411852359772, 0.41960784792900085,
              0.63529413938522339, 0.80784314870834351, 0.92156863212585449 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PRGn:{
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.25098040699958801, 0.46274510025978088, 0.60000002384185791,
              0.7607843279838562, 0.90588235855102539, 0.9686274528503418,
              0.85098040103912354, 0.65098041296005249, 0.35294118523597717,
              0.10588235408067703, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.0, 0.16470588743686676, 0.43921568989753723,
              0.64705884456634521, 0.83137255907058716, 0.9686274528503418,
              0.94117647409439087, 0.85882353782653809, 0.68235296010971069,
              0.47058823704719543, 0.26666668057441711 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.29411765933036804, 0.51372551918029785, 0.67058825492858887,
              0.81176471710205078, 0.90980392694473267, 0.9686274528503418,
              0.82745099067687988, 0.62745100259780884, 0.3803921639919281,
              0.21568627655506134, 0.10588235408067703 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PRGn_r:{
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.0, 0.10588235408067703, 0.35294118523597717,
              0.65098041296005249, 0.85098040103912354, 0.9686274528503418,
              0.90588235855102539, 0.7607843279838562, 0.60000002384185791,
              0.46274510025978088, 0.25098040699958801 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.26666668057441711, 0.47058823704719543, 0.68235296010971069,
              0.85882353782653809, 0.94117647409439087, 0.9686274528503418,
              0.83137255907058716, 0.64705884456634521, 0.43921568989753723,
              0.16470588743686676, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.10588235408067703, 0.21568627655506134, 0.3803921639919281,
              0.62745100259780884, 0.82745099067687988, 0.9686274528503418,
              0.90980392694473267, 0.81176471710205078, 0.67058825492858887,
              0.51372551918029785, 0.29411765933036804 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Paired:{
      {
        const double x[] =
            { 0.0, 0.090909090909090912, 0.18181818181818182,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545453,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181823, 0.90909090909090906, 1.0 };
        const double y[] =
            { 0.65098041296005249, 0.12156862765550613, 0.69803923368453979,
              0.20000000298023224, 0.9843137264251709, 0.89019608497619629,
              0.99215686321258545, 1.0, 0.7921568751335144, 0.41568627953529358,
              1.0, 0.69411766529083252 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.090909090909090912, 0.18181818181818182,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545453,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181823, 0.90909090909090906, 1.0 };
        const double y[] =
            { 0.80784314870834351, 0.47058823704719543, 0.87450981140136719,
              0.62745100259780884, 0.60392159223556519, 0.10196078568696976,
              0.74901962280273438, 0.49803921580314636, 0.69803923368453979,
              0.23921568691730499, 1.0, 0.3490196168422699 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.090909090909090912, 0.18181818181818182,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545453,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181823, 0.90909090909090906, 1.0 };
        const double y[] =
            { 0.89019608497619629, 0.70588237047195435, 0.54117649793624878,
              0.17254902422428131, 0.60000002384185791, 0.10980392247438431,
              0.43529412150382996, 0.0, 0.83921569585800171,
              0.60392159223556519, 0.60000002384185791, 0.15686275064945221 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Paired_r:{
      {
        const double x[] =
            { 0.0, 0.090909090909090939, 0.18181818181818177,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545459,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181812, 0.90909090909090906, 1.0 };
        const double y[] =
            { 0.69411766529083252, 1.0, 0.41568627953529358, 0.7921568751335144,
              1.0, 0.99215686321258545, 0.89019608497619629, 0.9843137264251709,
              0.20000000298023224, 0.69803923368453979, 0.12156862765550613,
              0.65098041296005249 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.090909090909090939, 0.18181818181818177,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545459,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181812, 0.90909090909090906, 1.0 };
        const double y[] =
            { 0.3490196168422699, 1.0, 0.23921568691730499, 0.69803923368453979,
              0.49803921580314636, 0.74901962280273438, 0.10196078568696976,
              0.60392159223556519, 0.62745100259780884, 0.87450981140136719,
              0.47058823704719543, 0.80784314870834351 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.090909090909090939, 0.18181818181818177,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545459,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181812, 0.90909090909090906, 1.0 };
        const double y[] =
            { 0.15686275064945221, 0.60000002384185791, 0.60392159223556519,
              0.83921569585800171, 0.0, 0.43529412150382996,
              0.10980392247438431, 0.60000002384185791, 0.17254902422428131,
              0.54117649793624878, 0.70588237047195435, 0.89019608497619629 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Pastel1:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9843137264251709, 0.70196080207824707, 0.80000001192092896,
              0.87058824300765991, 0.99607843160629272, 1.0,
              0.89803922176361084, 0.99215686321258545, 0.94901961088180542 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.70588237047195435, 0.80392158031463623, 0.92156863212585449,
              0.79607844352722168, 0.85098040103912354, 1.0,
              0.84705883264541626, 0.85490196943283081, 0.94901961088180542 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.68235296010971069, 0.89019608497619629, 0.77254903316497803,
              0.89411765336990356, 0.65098041296005249, 0.80000001192092896,
              0.74117648601531982, 0.92549020051956177, 0.94901961088180542 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Pastel1_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.94901961088180542, 0.99215686321258545, 0.89803922176361084,
              1.0, 0.99607843160629272, 0.87058824300765991,
              0.80000001192092896, 0.70196080207824707, 0.9843137264251709 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.94901961088180542, 0.85490196943283081, 0.84705883264541626,
              1.0, 0.85098040103912354, 0.79607844352722168,
              0.92156863212585449, 0.80392158031463623, 0.70588237047195435 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.94901961088180542, 0.92549020051956177, 0.74117648601531982,
              0.80000001192092896, 0.65098041296005249, 0.89411765336990356,
              0.77254903316497803, 0.89019608497619629, 0.68235296010971069 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Pastel2:{
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.70196080207824707, 0.99215686321258545, 0.79607844352722168,
              0.95686274766921997, 0.90196079015731812, 1.0,
              0.94509804248809814, 0.80000001192092896 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.88627451658248901, 0.80392158031463623, 0.83529412746429443,
              0.7921568751335144, 0.96078431606292725, 0.94901961088180542,
              0.88627451658248901, 0.80000001192092896 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.80392158031463623, 0.67450982332229614, 0.90980392694473267,
              0.89411765336990356, 0.78823530673980713, 0.68235296010971069,
              0.80000001192092896, 0.80000001192092896 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Pastel2_r:{
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.80000001192092896, 0.94509804248809814, 1.0,
              0.90196079015731812, 0.95686274766921997, 0.79607844352722168,
              0.99215686321258545, 0.70196080207824707 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.80000001192092896, 0.88627451658248901, 0.94901961088180542,
              0.96078431606292725, 0.7921568751335144, 0.83529412746429443,
              0.80392158031463623, 0.88627451658248901 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.80000001192092896, 0.80000001192092896, 0.68235296010971069,
              0.78823530673980713, 0.89411765336990356, 0.90980392694473267,
              0.67450982332229614, 0.80392158031463623 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PiYG:{
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.55686277151107788, 0.77254903316497803, 0.87058824300765991,
              0.94509804248809814, 0.99215686321258545, 0.9686274528503418,
              0.90196079015731812, 0.72156864404678345, 0.49803921580314636,
              0.30196079611778259, 0.15294118225574493 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.0039215688593685627, 0.10588235408067703, 0.46666666865348816,
              0.7137255072593689, 0.87843137979507446, 0.9686274528503418,
              0.96078431606292725, 0.88235294818878174, 0.73725491762161255,
              0.57254904508590698, 0.39215686917304993 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.32156863808631897, 0.49019607901573181, 0.68235296010971069,
              0.85490196943283081, 0.93725490570068359, 0.9686274528503418,
              0.81568628549575806, 0.52549022436141968, 0.25490197539329529,
              0.12941177189350128, 0.098039217293262482 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PiYG_r:{
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.15294118225574493, 0.30196079611778259, 0.49803921580314636,
              0.72156864404678345, 0.90196079015731812, 0.9686274528503418,
              0.99215686321258545, 0.94509804248809814, 0.87058824300765991,
              0.77254903316497803, 0.55686277151107788 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.39215686917304993, 0.57254904508590698, 0.73725491762161255,
              0.88235294818878174, 0.96078431606292725, 0.9686274528503418,
              0.87843137979507446, 0.7137255072593689, 0.46666666865348816,
              0.10588235408067703, 0.0039215688593685627 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.098039217293262482, 0.12941177189350128, 0.25490197539329529,
              0.52549022436141968, 0.81568628549575806, 0.9686274528503418,
              0.93725490570068359, 0.85490196943283081, 0.68235296010971069,
              0.49019607901573181, 0.32156863808631897 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PuBu:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.92549020051956177, 0.81568628549575806,
              0.65098041296005249, 0.45490196347236633, 0.21176470816135406,
              0.019607843831181526, 0.015686275437474251,
              0.0078431377187371254 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9686274528503418, 0.90588235855102539, 0.81960785388946533,
              0.74117648601531982, 0.66274511814117432, 0.56470590829849243,
              0.43921568989753723, 0.35294118523597717, 0.21960784494876862 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9843137264251709, 0.94901961088180542, 0.90196079015731812,
              0.85882353782653809, 0.81176471710205078, 0.75294119119644165,
              0.69019609689712524, 0.55294120311737061, 0.34509804844856262 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PuBuGn:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.92549020051956177, 0.81568628549575806,
              0.65098041296005249, 0.40392157435417175, 0.21176470816135406,
              0.0078431377187371254, 0.0039215688593685627,
              0.0039215688593685627 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9686274528503418, 0.88627451658248901, 0.81960785388946533,
              0.74117648601531982, 0.66274511814117432, 0.56470590829849243,
              0.5058823823928833, 0.42352941632270813, 0.27450981736183167 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9843137264251709, 0.94117647409439087, 0.90196079015731812,
              0.85882353782653809, 0.81176471710205078, 0.75294119119644165,
              0.54117649793624878, 0.3490196168422699, 0.21176470816135406 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PuBuGn_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0039215688593685627, 0.0039215688593685627,
              0.0078431377187371254, 0.21176470816135406, 0.40392157435417175,
              0.65098041296005249, 0.81568628549575806, 0.92549020051956177,
              1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.27450981736183167, 0.42352941632270813, 0.5058823823928833,
              0.56470590829849243, 0.66274511814117432, 0.74117648601531982,
              0.81960785388946533, 0.88627451658248901, 0.9686274528503418 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.21176470816135406, 0.3490196168422699, 0.54117649793624878,
              0.75294119119644165, 0.81176471710205078, 0.85882353782653809,
              0.90196079015731812, 0.94117647409439087, 0.9843137264251709 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PuBu_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0078431377187371254, 0.015686275437474251, 0.019607843831181526,
              0.21176470816135406, 0.45490196347236633, 0.65098041296005249,
              0.81568628549575806, 0.92549020051956177, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.21960784494876862, 0.35294118523597717, 0.43921568989753723,
              0.56470590829849243, 0.66274511814117432, 0.74117648601531982,
              0.81960785388946533, 0.90588235855102539, 0.9686274528503418 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.34509804844856262, 0.55294120311737061, 0.69019609689712524,
              0.75294119119644165, 0.81176471710205078, 0.85882353782653809,
              0.90196079015731812, 0.94901961088180542, 0.9843137264251709 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PuOr:{
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.49803921580314636, 0.70196080207824707, 0.87843137979507446,
              0.99215686321258545, 0.99607843160629272, 0.9686274528503418,
              0.84705883264541626, 0.69803923368453979, 0.50196081399917603,
              0.32941177487373352, 0.17647059261798859 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.23137255012989044, 0.34509804844856262, 0.50980395078659058,
              0.72156864404678345, 0.87843137979507446, 0.9686274528503418,
              0.85490196943283081, 0.67058825492858887, 0.45098039507865906,
              0.15294118225574493, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.031372550874948502, 0.023529412224888802, 0.078431375324726105,
              0.38823530077934265, 0.7137255072593689, 0.9686274528503418,
              0.92156863212585449, 0.82352942228317261, 0.67450982332229614,
              0.53333336114883423, 0.29411765933036804 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PuOr_r:{
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.17647059261798859, 0.32941177487373352, 0.50196081399917603,
              0.69803923368453979, 0.84705883264541626, 0.9686274528503418,
              0.99607843160629272, 0.99215686321258545, 0.87843137979507446,
              0.70196080207824707, 0.49803921580314636 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.0, 0.15294118225574493, 0.45098039507865906,
              0.67058825492858887, 0.85490196943283081, 0.9686274528503418,
              0.87843137979507446, 0.72156864404678345, 0.50980395078659058,
              0.34509804844856262, 0.23137255012989044 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.29411765933036804, 0.53333336114883423, 0.67450982332229614,
              0.82352942228317261, 0.92156863212585449, 0.9686274528503418,
              0.7137255072593689, 0.38823530077934265, 0.078431375324726105,
              0.023529412224888802, 0.031372550874948502 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PuRd:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9686274528503418, 0.90588235855102539, 0.83137255907058716,
              0.78823530673980713, 0.87450981140136719, 0.90588235855102539,
              0.80784314870834351, 0.59607845544815063, 0.40392157435417175 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.95686274766921997, 0.88235294818878174, 0.72549021244049072,
              0.58039218187332153, 0.3960784375667572, 0.16078431904315948,
              0.070588238537311554, 0.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.97647058963775635, 0.93725490570068359, 0.85490196943283081,
              0.78039216995239258, 0.69019609689712524, 0.54117649793624878,
              0.33725491166114807, 0.26274511218070984, 0.12156862765550613 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_PuRd_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.40392157435417175, 0.59607845544815063, 0.80784314870834351,
              0.90588235855102539, 0.87450981140136719, 0.78823530673980713,
              0.83137255907058716, 0.90588235855102539, 0.9686274528503418 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.0, 0.070588238537311554, 0.16078431904315948,
              0.3960784375667572, 0.58039218187332153, 0.72549021244049072,
              0.88235294818878174, 0.95686274766921997 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.12156862765550613, 0.26274511218070984, 0.33725491166114807,
              0.54117649793624878, 0.69019609689712524, 0.78039216995239258,
              0.85490196943283081, 0.93725490570068359, 0.97647058963775635 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Purples:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.98823529481887817, 0.93725490570068359, 0.85490196943283081,
              0.73725491762161255, 0.61960786581039429, 0.50196081399917603,
              0.41568627953529358, 0.32941177487373352, 0.24705882370471954 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9843137264251709, 0.92941176891326904, 0.85490196943283081,
              0.74117648601531982, 0.60392159223556519, 0.49019607901573181,
              0.31764706969261169, 0.15294118225574493, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.99215686321258545, 0.96078431606292725, 0.92156863212585449,
              0.86274510622024536, 0.78431373834609985, 0.729411780834198,
              0.63921570777893066, 0.56078433990478516, 0.49019607901573181 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Purples_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.24705882370471954, 0.32941177487373352, 0.41568627953529358,
              0.50196081399917603, 0.61960786581039429, 0.73725491762161255,
              0.85490196943283081, 0.93725490570068359, 0.98823529481887817 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.15294118225574493, 0.31764706969261169,
              0.49019607901573181, 0.60392159223556519, 0.74117648601531982,
              0.85490196943283081, 0.92941176891326904, 0.9843137264251709 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.49019607901573181, 0.56078433990478516, 0.63921570777893066,
              0.729411780834198, 0.78431373834609985, 0.86274510622024536,
              0.92156863212585449, 0.96078431606292725, 0.99215686321258545 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_RdBu:{
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.40392157435417175, 0.69803923368453979, 0.83921569585800171,
              0.95686274766921997, 0.99215686321258545, 0.9686274528503418,
              0.81960785388946533, 0.57254904508590698, 0.26274511218070984,
              0.12941177189350128, 0.019607843831181526 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.0, 0.094117648899555206, 0.37647059559822083,
              0.64705884456634521, 0.85882353782653809, 0.9686274528503418,
              0.89803922176361084, 0.77254903316497803, 0.57647061347961426,
              0.40000000596046448, 0.18823529779911041 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.12156862765550613, 0.16862745583057404, 0.30196079611778259,
              0.50980395078659058, 0.78039216995239258, 0.9686274528503418,
              0.94117647409439087, 0.87058824300765991, 0.76470589637756348,
              0.67450982332229614, 0.3803921639919281 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_RdBu_r:{
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.019607843831181526, 0.12941177189350128, 0.26274511218070984,
              0.57254904508590698, 0.81960785388946533, 0.9686274528503418,
              0.99215686321258545, 0.95686274766921997, 0.83921569585800171,
              0.69803923368453979, 0.40392157435417175 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.18823529779911041, 0.40000000596046448, 0.57647061347961426,
              0.77254903316497803, 0.89803922176361084, 0.9686274528503418,
              0.85882353782653809, 0.64705884456634521, 0.37647059559822083,
              0.094117648899555206, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.3803921639919281, 0.67450982332229614, 0.76470589637756348,
              0.87058824300765991, 0.94117647409439087, 0.9686274528503418,
              0.78039216995239258, 0.50980395078659058, 0.30196079611778259,
              0.16862745583057404, 0.12156862765550613 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_RdGy:{
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.40392157435417175, 0.69803923368453979, 0.83921569585800171,
              0.95686274766921997, 0.99215686321258545, 1.0,
              0.87843137979507446, 0.729411780834198, 0.52941179275512695,
              0.30196079611778259, 0.10196078568696976 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.0, 0.094117648899555206, 0.37647059559822083,
              0.64705884456634521, 0.85882353782653809, 1.0,
              0.87843137979507446, 0.729411780834198, 0.52941179275512695,
              0.30196079611778259, 0.10196078568696976 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.12156862765550613, 0.16862745583057404, 0.30196079611778259,
              0.50980395078659058, 0.78039216995239258, 1.0,
              0.87843137979507446, 0.729411780834198, 0.52941179275512695,
              0.30196079611778259, 0.10196078568696976 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_RdGy_r:{
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.10196078568696976, 0.30196079611778259, 0.52941179275512695,
              0.729411780834198, 0.87843137979507446, 1.0, 0.99215686321258545,
              0.95686274766921997, 0.83921569585800171, 0.69803923368453979,
              0.40392157435417175 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.10196078568696976, 0.30196079611778259, 0.52941179275512695,
              0.729411780834198, 0.87843137979507446, 1.0, 0.85882353782653809,
              0.64705884456634521, 0.37647059559822083, 0.094117648899555206,
              0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.10196078568696976, 0.30196079611778259, 0.52941179275512695,
              0.729411780834198, 0.87843137979507446, 1.0, 0.78039216995239258,
              0.50980395078659058, 0.30196079611778259, 0.16862745583057404,
              0.12156862765550613 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_RdPu:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.99215686321258545, 0.98823529481887817,
              0.98039215803146362, 0.9686274528503418, 0.86666667461395264,
              0.68235296010971069, 0.47843137383460999, 0.28627452254295349 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9686274528503418, 0.87843137979507446, 0.77254903316497803,
              0.62352943420410156, 0.40784314274787903, 0.20392157137393951,
              0.0039215688593685627, 0.0039215688593685627, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.9529411792755127, 0.86666667461395264, 0.75294119119644165,
              0.70980393886566162, 0.63137257099151611, 0.59215688705444336,
              0.49411764740943909, 0.46666666865348816, 0.41568627953529358 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_RdPu_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.28627452254295349, 0.47843137383460999, 0.68235296010971069,
              0.86666667461395264, 0.9686274528503418, 0.98039215803146362,
              0.98823529481887817, 0.99215686321258545, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.0039215688593685627, 0.0039215688593685627,
              0.20392157137393951, 0.40784314274787903, 0.62352943420410156,
              0.77254903316497803, 0.87843137979507446, 0.9686274528503418 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.41568627953529358, 0.46666666865348816, 0.49411764740943909,
              0.59215688705444336, 0.63137257099151611, 0.70980393886566162,
              0.75294119119644165, 0.86666667461395264, 0.9529411792755127 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_RdYlBu:{
      {
        const double x[] =
            { 0.0, 0.10000000149011612, 0.20000000298023224,
              0.30000001192092896, 0.40000000596046448, 0.5,
              0.60000002384185791, 0.69999998807907104, 0.80000001192092896,
              0.89999997615814209, 1.0 };
        const double y[] =
            { 0.64705884456634521, 0.84313726425170898, 0.95686274766921997,
              0.99215686321258545, 0.99607843160629272, 1.0,
              0.87843137979507446, 0.67058825492858887, 0.45490196347236633,
              0.27058824896812439, 0.19215686619281769 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000149011612, 0.20000000298023224,
              0.30000001192092896, 0.40000000596046448, 0.5,
              0.60000002384185791, 0.69999998807907104, 0.80000001192092896,
              0.89999997615814209, 1.0 };
        const double y[] =
            { 0.0, 0.18823529779911041, 0.42745098471641541,
              0.68235296010971069, 0.87843137979507446, 1.0, 0.9529411792755127,
              0.85098040103912354, 0.67843139171600342, 0.45882353186607361,
              0.21176470816135406 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000149011612, 0.20000000298023224,
              0.30000001192092896, 0.40000000596046448, 0.5,
              0.60000002384185791, 0.69999998807907104, 0.80000001192092896,
              0.89999997615814209, 1.0 };
        const double y[] =
            { 0.14901961386203766, 0.15294118225574493, 0.26274511218070984,
              0.3803921639919281, 0.56470590829849243, 0.74901962280273438,
              0.97254902124404907, 0.91372549533843994, 0.81960785388946533,
              0.70588237047195435, 0.58431375026702881 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_RdYlBu_r:{
      {
        const double x[] =
            { 0.0, 0.10000002384185791, 0.19999998807907104,
              0.30000001192092896, 0.39999997615814209, 0.5,
              0.59999999403953552, 0.69999998807907104, 0.79999999701976776,
              0.89999999850988388, 1.0 };
        const double y[] =
            { 0.19215686619281769, 0.27058824896812439, 0.45490196347236633,
              0.67058825492858887, 0.87843137979507446, 1.0,
              0.99607843160629272, 0.99215686321258545, 0.95686274766921997,
              0.84313726425170898, 0.64705884456634521 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000002384185791, 0.19999998807907104,
              0.30000001192092896, 0.39999997615814209, 0.5,
              0.59999999403953552, 0.69999998807907104, 0.79999999701976776,
              0.89999999850988388, 1.0 };
        const double y[] =
            { 0.21176470816135406, 0.45882353186607361, 0.67843139171600342,
              0.85098040103912354, 0.9529411792755127, 1.0, 0.87843137979507446,
              0.68235296010971069, 0.42745098471641541, 0.18823529779911041,
              0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000002384185791, 0.19999998807907104,
              0.30000001192092896, 0.39999997615814209, 0.5,
              0.59999999403953552, 0.69999998807907104, 0.79999999701976776,
              0.89999999850988388, 1.0 };
        const double y[] =
            { 0.58431375026702881, 0.70588237047195435, 0.81960785388946533,
              0.91372549533843994, 0.97254902124404907, 0.74901962280273438,
              0.56470590829849243, 0.3803921639919281, 0.26274511218070984,
              0.15294118225574493, 0.14901961386203766 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_RdYlGn:{
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.64705884456634521, 0.84313726425170898, 0.95686274766921997,
              0.99215686321258545, 0.99607843160629272, 1.0,
              0.85098040103912354, 0.65098041296005249, 0.40000000596046448,
              0.10196078568696976, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.0, 0.18823529779911041, 0.42745098471641541,
              0.68235296010971069, 0.87843137979507446, 1.0,
              0.93725490570068359, 0.85098040103912354, 0.74117648601531982,
              0.59607845544815063, 0.40784314274787903 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.14901961386203766, 0.15294118225574493, 0.26274511218070984,
              0.3803921639919281, 0.54509806632995605, 0.74901962280273438,
              0.54509806632995605, 0.41568627953529358, 0.38823530077934265,
              0.31372550129890442, 0.21568627655506134 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_RdYlGn_r:{
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.0, 0.10196078568696976, 0.40000000596046448,
              0.65098041296005249, 0.85098040103912354, 1.0,
              0.99607843160629272, 0.99215686321258545, 0.95686274766921997,
              0.84313726425170898, 0.64705884456634521 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.40784314274787903, 0.59607845544815063, 0.74117648601531982,
              0.85098040103912354, 0.93725490570068359, 1.0,
              0.87843137979507446, 0.68235296010971069, 0.42745098471641541,
              0.18823529779911041, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.21568627655506134, 0.31372550129890442, 0.38823530077934265,
              0.41568627953529358, 0.54509806632995605, 0.74901962280273438,
              0.54509806632995605, 0.3803921639919281, 0.26274511218070984,
              0.15294118225574493, 0.14901961386203766 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Reds:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.99607843160629272, 0.98823529481887817,
              0.98823529481887817, 0.9843137264251709, 0.93725490570068359,
              0.79607844352722168, 0.64705884456634521, 0.40392157435417175 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.96078431606292725, 0.87843137979507446, 0.73333334922790527,
              0.57254904508590698, 0.41568627953529358, 0.23137255012989044,
              0.094117648899555206, 0.058823529630899429, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.94117647409439087, 0.82352942228317261, 0.63137257099151611,
              0.44705882668495178, 0.29019609093666077, 0.17254902422428131,
              0.11372549086809158, 0.08235294371843338, 0.050980392843484879 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Reds_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.40392157435417175, 0.64705884456634521, 0.79607844352722168,
              0.93725490570068359, 0.9843137264251709, 0.98823529481887817,
              0.98823529481887817, 0.99607843160629272, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.058823529630899429, 0.094117648899555206,
              0.23137255012989044, 0.41568627953529358, 0.57254904508590698,
              0.73333334922790527, 0.87843137979507446, 0.96078431606292725 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.050980392843484879, 0.08235294371843338, 0.11372549086809158,
              0.17254902422428131, 0.29019609093666077, 0.44705882668495178,
              0.63137257099151611, 0.82352942228317261, 0.94117647409439087 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Set1:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.89411765336990356, 0.21568627655506134, 0.30196079611778259,
              0.59607845544815063, 1.0, 1.0, 0.65098041296005249,
              0.9686274528503418, 0.60000002384185791 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.10196078568696976, 0.49411764740943909, 0.68627452850341797,
              0.30588236451148987, 0.49803921580314636, 1.0,
              0.33725491166114807, 0.5058823823928833, 0.60000002384185791 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.10980392247438431, 0.72156864404678345, 0.29019609093666077,
              0.63921570777893066, 0.0, 0.20000000298023224,
              0.15686275064945221, 0.74901962280273438, 0.60000002384185791 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Set1_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.60000002384185791, 0.9686274528503418, 0.65098041296005249, 1.0,
              1.0, 0.59607845544815063, 0.30196079611778259,
              0.21568627655506134, 0.89411765336990356 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.60000002384185791, 0.5058823823928833, 0.33725491166114807, 1.0,
              0.49803921580314636, 0.30588236451148987, 0.68627452850341797,
              0.49411764740943909, 0.10196078568696976 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.60000002384185791, 0.74901962280273438, 0.15686275064945221,
              0.20000000298023224, 0.0, 0.63921570777893066,
              0.29019609093666077, 0.72156864404678345, 0.10980392247438431 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Set2:{
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.40000000596046448, 0.98823529481887817, 0.55294120311737061,
              0.90588235855102539, 0.65098041296005249, 1.0,
              0.89803922176361084, 0.70196080207824707 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.7607843279838562, 0.55294120311737061, 0.62745100259780884,
              0.54117649793624878, 0.84705883264541626, 0.85098040103912354,
              0.76862746477127075, 0.70196080207824707 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.14285714285714285, 0.2857142857142857, 0.42857142857142855,
              0.5714285714285714, 0.7142857142857143, 0.8571428571428571, 1.0 };
        const double y[] =
            { 0.64705884456634521, 0.38431373238563538, 0.79607844352722168,
              0.76470589637756348, 0.32941177487373352, 0.18431372940540314,
              0.58039218187332153, 0.70196080207824707 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Set2_r:{
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.70196080207824707, 0.89803922176361084, 1.0,
              0.65098041296005249, 0.90588235855102539, 0.55294120311737061,
              0.98823529481887817, 0.40000000596046448 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.70196080207824707, 0.76862746477127075, 0.85098040103912354,
              0.84705883264541626, 0.54117649793624878, 0.62745100259780884,
              0.55294120311737061, 0.7607843279838562 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.1428571428571429, 0.2857142857142857, 0.4285714285714286,
              0.5714285714285714, 0.7142857142857143, 0.85714285714285721,
              1.0 };
        const double y[] =
            { 0.70196080207824707, 0.58039218187332153, 0.18431372940540314,
              0.32941177487373352, 0.76470589637756348, 0.79607844352722168,
              0.38431373238563538, 0.64705884456634521 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Set3:{
      {
        const double x[] =
            { 0.0, 0.090909090909090912, 0.18181818181818182,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545453,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181823, 0.90909090909090906, 1.0 };
        const double y[] =
            { 0.55294120311737061, 1.0, 0.7450980544090271, 0.9843137264251709,
              0.50196081399917603, 0.99215686321258545, 0.70196080207824707,
              0.98823529481887817, 0.85098040103912354, 0.73725491762161255,
              0.80000001192092896, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.090909090909090912, 0.18181818181818182,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545453,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181823, 0.90909090909090906, 1.0 };
        const double y[] =
            { 0.82745099067687988, 1.0, 0.729411780834198, 0.50196081399917603,
              0.69411766529083252, 0.70588237047195435, 0.87058824300765991,
              0.80392158031463623, 0.85098040103912354, 0.50196081399917603,
              0.92156863212585449, 0.92941176891326904 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.090909090909090912, 0.18181818181818182,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545453,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181823, 0.90909090909090906, 1.0 };
        const double y[] =
            { 0.78039216995239258, 0.70196080207824707, 0.85490196943283081,
              0.44705882668495178, 0.82745099067687988, 0.38431373238563538,
              0.4117647111415863, 0.89803922176361084, 0.85098040103912354,
              0.74117648601531982, 0.77254903316497803, 0.43529412150382996 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Set3_r:{
      {
        const double x[] =
            { 0.0, 0.090909090909090939, 0.18181818181818177,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545459,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181812, 0.90909090909090906, 1.0 };
        const double y[] =
            { 1.0, 0.80000001192092896, 0.73725491762161255,
              0.85098040103912354, 0.98823529481887817, 0.70196080207824707,
              0.99215686321258545, 0.50196081399917603, 0.9843137264251709,
              0.7450980544090271, 1.0, 0.55294120311737061 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.090909090909090939, 0.18181818181818177,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545459,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181812, 0.90909090909090906, 1.0 };
        const double y[] =
            { 0.92941176891326904, 0.92156863212585449, 0.50196081399917603,
              0.85098040103912354, 0.80392158031463623, 0.87058824300765991,
              0.70588237047195435, 0.69411766529083252, 0.50196081399917603,
              0.729411780834198, 1.0, 0.82745099067687988 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.090909090909090939, 0.18181818181818177,
              0.27272727272727271, 0.36363636363636365, 0.45454545454545459,
              0.54545454545454541, 0.63636363636363635, 0.72727272727272729,
              0.81818181818181812, 0.90909090909090906, 1.0 };
        const double y[] =
            { 0.43529412150382996, 0.77254903316497803, 0.74117648601531982,
              0.85098040103912354, 0.89803922176361084, 0.4117647111415863,
              0.38431373238563538, 0.82745099067687988, 0.44705882668495178,
              0.85490196943283081, 0.70196080207824707, 0.78039216995239258 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Spectral:{
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.61960786581039429, 0.83529412746429443, 0.95686274766921997,
              0.99215686321258545, 0.99607843160629272, 1.0,
              0.90196079015731812, 0.67058825492858887, 0.40000000596046448,
              0.19607843458652496, 0.36862745881080627 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.0039215688593685627, 0.24313725531101227, 0.42745098471641541,
              0.68235296010971069, 0.87843137979507446, 1.0,
              0.96078431606292725, 0.86666667461395264, 0.7607843279838562,
              0.53333336114883423, 0.30980393290519714 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10000000000000001, 0.20000000000000001,
              0.29999999999999999, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.25882354378700256, 0.30980393290519714, 0.26274511218070984,
              0.3803921639919281, 0.54509806632995605, 0.74901962280273438,
              0.59607845544815063, 0.64313727617263794, 0.64705884456634521,
              0.74117648601531982, 0.63529413938522339 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_Spectral_r:{
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.36862745881080627, 0.19607843458652496, 0.40000000596046448,
              0.67058825492858887, 0.90196079015731812, 1.0,
              0.99607843160629272, 0.99215686321258545, 0.95686274766921997,
              0.83529412746429443, 0.61960786581039429 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.30980393290519714, 0.53333336114883423, 0.7607843279838562,
              0.86666667461395264, 0.96078431606292725, 1.0,
              0.87843137979507446, 0.68235296010971069, 0.42745098471641541,
              0.24313725531101227, 0.0039215688593685627 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.099999999999999978, 0.19999999999999996,
              0.30000000000000004, 0.40000000000000002, 0.5,
              0.59999999999999998, 0.69999999999999996, 0.80000000000000004,
              0.90000000000000002, 1.0 };
        const double y[] =
            { 0.63529413938522339, 0.74117648601531982, 0.64705884456634521,
              0.64313727617263794, 0.59607845544815063, 0.74901962280273438,
              0.54509806632995605, 0.3803921639919281, 0.26274511218070984,
              0.30980393290519714, 0.25882354378700256 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_YlGn:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.9686274528503418, 0.85098040103912354, 0.67843139171600342,
              0.47058823704719543, 0.25490197539329529, 0.13725490868091583,
              0.0, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.98823529481887817, 0.94117647409439087,
              0.86666667461395264, 0.7764706015586853, 0.67058825492858887,
              0.51764708757400513, 0.40784314274787903, 0.27058824896812439 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.89803922176361084, 0.72549021244049072, 0.63921570777893066,
              0.55686277151107788, 0.47450980544090271, 0.364705890417099,
              0.26274511218070984, 0.21568627655506134, 0.16078431904315948 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_YlGnBu:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.92941176891326904, 0.78039216995239258,
              0.49803921580314636, 0.25490197539329529, 0.11372549086809158,
              0.13333334028720856, 0.14509804546833038, 0.031372550874948502 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.97254902124404907, 0.91372549533843994,
              0.80392158031463623, 0.7137255072593689, 0.56862747669219971,
              0.36862745881080627, 0.20392157137393951, 0.11372549086809158 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.85098040103912354, 0.69411766529083252, 0.70588237047195435,
              0.73333334922790527, 0.76862746477127075, 0.75294119119644165,
              0.65882354974746704, 0.58039218187332153, 0.34509804844856262 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_YlGnBu_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.031372550874948502, 0.14509804546833038, 0.13333334028720856,
              0.11372549086809158, 0.25490197539329529, 0.49803921580314636,
              0.78039216995239258, 0.92941176891326904, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.11372549086809158, 0.20392157137393951, 0.36862745881080627,
              0.56862747669219971, 0.7137255072593689, 0.80392158031463623,
              0.91372549533843994, 0.97254902124404907, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.34509804844856262, 0.58039218187332153, 0.65882354974746704,
              0.75294119119644165, 0.76862746477127075, 0.73333334922790527,
              0.70588237047195435, 0.69411766529083252, 0.85098040103912354 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_YlGn_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.0, 0.13725490868091583, 0.25490197539329529,
              0.47058823704719543, 0.67843139171600342, 0.85098040103912354,
              0.9686274528503418, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.27058824896812439, 0.40784314274787903, 0.51764708757400513,
              0.67058825492858887, 0.7764706015586853, 0.86666667461395264,
              0.94117647409439087, 0.98823529481887817, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.16078431904315948, 0.21568627655506134, 0.26274511218070984,
              0.364705890417099, 0.47450980544090271, 0.55686277151107788,
              0.63921570777893066, 0.72549021244049072, 0.89803922176361084 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_YlOrBr:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 1.0, 0.99607843160629272, 0.99607843160629272,
              0.99607843160629272, 0.92549020051956177, 0.80000001192092896,
              0.60000002384185791, 0.40000000596046448 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.9686274528503418, 0.89019608497619629, 0.76862746477127075,
              0.60000002384185791, 0.43921568989753723, 0.29803922772407532,
              0.20392157137393951, 0.14509804546833038 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.89803922176361084, 0.73725491762161255, 0.56862747669219971,
              0.30980393290519714, 0.16078431904315948, 0.078431375324726105,
              0.0078431377187371254, 0.015686275437474251,
              0.023529412224888802 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_YlOrBr_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.40000000596046448, 0.60000002384185791, 0.80000001192092896,
              0.92549020051956177, 0.99607843160629272, 0.99607843160629272,
              0.99607843160629272, 1.0, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.14509804546833038, 0.20392157137393951, 0.29803922772407532,
              0.43921568989753723, 0.60000002384185791, 0.76862746477127075,
              0.89019608497619629, 0.9686274528503418, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.023529412224888802, 0.015686275437474251, 0.0078431377187371254,
              0.078431375324726105, 0.16078431904315948, 0.30980393290519714,
              0.56862747669219971, 0.73725491762161255, 0.89803922176361084 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_YlOrRd:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 1.0, 0.99607843160629272, 0.99607843160629272,
              0.99215686321258545, 0.98823529481887817, 0.89019608497619629,
              0.74117648601531982, 0.50196081399917603 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 1.0, 0.92941176891326904, 0.85098040103912354,
              0.69803923368453979, 0.55294120311737061, 0.30588236451148987,
              0.10196078568696976, 0.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.80000001192092896, 0.62745100259780884, 0.46274510025978088,
              0.29803922772407532, 0.23529411852359772, 0.16470588743686676,
              0.10980392247438431, 0.14901961386203766, 0.14901961386203766 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_YlOrRd_r:{
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.50196081399917603, 0.74117648601531982, 0.89019608497619629,
              0.98823529481887817, 0.99215686321258545, 0.99607843160629272,
              0.99607843160629272, 1.0, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.0, 0.0, 0.10196078568696976, 0.30588236451148987,
              0.55294120311737061, 0.69803923368453979, 0.85098040103912354,
              0.92941176891326904, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0 };
        const double y[] =
            { 0.14901961386203766, 0.14901961386203766, 0.10980392247438431,
              0.16470588743686676, 0.23529411852359772, 0.29803922772407532,
              0.46274510025978088, 0.62745100259780884, 0.80000001192092896 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_autumn:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_autumn_r:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_binary:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_binary_r:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 1.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_bone:{
      {
        const double x[] = { 0.0, 0.74603200000000003, 1.0 };
        const double y[] = { 0.0, 0.65277799999999997, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.36507899999999999, 0.74603200000000003, 1.0 };
        const double y[] =
            { 0.0, 0.31944400000000001, 0.77777799999999997, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 0.36507899999999999, 1.0 };
        const double y[] = { 0.0, 0.44444400000000001, 1.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_bone_r:{
      {
        const double x[] = { 0.0, 0.25396799999999997, 1.0 };
        const double y[] = { 1.0, 0.65277799999999997, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.25396799999999997, 0.63492100000000007, 1.0 };
        const double y[] =
            { 1.0, 0.77777799999999997, 0.31944400000000001, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 0.63492100000000007, 1.0 };
        const double y[] = { 1.0, 0.44444400000000001, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_cool:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 1.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_cool_r:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 1.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_copper:{
      {
        const double x[] = { 0.0, 0.80952400000000002, 1.0 };
        const double y[] = { 0.0, 1.0, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 0.78120000000000001 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 0.4975 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_copper_r:{
      {
        const double x[] = { 0.0, 0.19047599999999998, 1.0 };
        const double y[] = { 1.0, 1.0, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.78120000000000001, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.4975, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_gist_earth:{
      {
        const double x[] =
            { 0.0, 0.28239999999999998, 0.45879999999999999,
              0.54900000000000004, 0.69799999999999995, 0.78820000000000001,
              1.0 };
        const double y[] =
            { 0.0, 0.18820000000000001, 0.27139999999999997,
              0.47189999999999999, 0.71760000000000002, 0.75529999999999997,
              0.99219999999999997 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.0275, 0.10979999999999999, 0.16470000000000001,
              0.20780000000000001, 0.28239999999999998, 0.52159999999999995,
              0.69799999999999995, 0.78820000000000001, 0.79220000000000002,
              0.80000000000000004, 0.80779999999999996, 0.81569999999999998,
              0.86670000000000003, 0.87450000000000006, 0.88239999999999996,
              0.89019999999999999, 0.89800000000000002, 0.94120000000000004,
              0.95689999999999997, 0.9647, 0.99609999999999999, 1.0 };
        const double y[] =
            { 0.0, 0.0, 0.1893, 0.30349999999999999, 0.3841, 0.502,
              0.63970000000000005, 0.71709999999999996, 0.63919999999999999,
              0.64129999999999998, 0.64470000000000005, 0.64810000000000001,
              0.65490000000000004, 0.69910000000000005, 0.71030000000000004,
              0.72160000000000002, 0.73229999999999995, 0.74299999999999999,
              0.82750000000000001, 0.86350000000000005, 0.88160000000000005,
              0.97330000000000005, 0.98429999999999995 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.0038999999999999998, 0.0077999999999999996, 0.0275,
              0.031399999999999997, 0.28239999999999998, 0.4667,
              0.54510000000000003, 0.7843, 0.89410000000000001, 1.0 };
        const double y[] =
            { 0.0, 0.16839999999999999, 0.22120000000000001,
              0.43290000000000001, 0.45490000000000003, 0.50039999999999996,
              0.27479999999999999, 0.32050000000000001, 0.39610000000000001,
              0.66510000000000002, 0.98429999999999995 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_gist_earth_r:{
      {
        const double x[] =
            { 0.0, 0.21179999999999999, 0.30200000000000005,
              0.45099999999999996, 0.54120000000000001, 0.71760000000000002,
              1.0 };
        const double y[] =
            { 0.99219999999999997, 0.75529999999999997, 0.71760000000000002,
              0.47189999999999999, 0.27139999999999997, 0.18820000000000001,
              0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.0039000000000000146, 0.035299999999999998,
              0.043100000000000027, 0.058799999999999963, 0.10199999999999998,
              0.10980000000000001, 0.11760000000000004, 0.12549999999999994,
              0.13329999999999997, 0.18430000000000002, 0.19220000000000004,
              0.19999999999999996, 0.20779999999999998, 0.21179999999999999,
              0.30200000000000005, 0.47840000000000005, 0.71760000000000002,
              0.79220000000000002, 0.83529999999999993, 0.89019999999999999,
              0.97250000000000003, 1.0 };
        const double y[] =
            { 0.98429999999999995, 0.97330000000000005, 0.88160000000000005,
              0.86350000000000005, 0.82750000000000001, 0.74299999999999999,
              0.73229999999999995, 0.72160000000000002, 0.71030000000000004,
              0.69910000000000005, 0.65490000000000004, 0.64810000000000001,
              0.64470000000000005, 0.64129999999999998, 0.63919999999999999,
              0.71709999999999996, 0.63970000000000005, 0.502, 0.3841,
              0.30349999999999999, 0.1893, 0.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10589999999999999, 0.2157, 0.45489999999999997, 0.5333,
              0.71760000000000002, 0.96860000000000002, 0.97250000000000003,
              0.99219999999999997, 0.99609999999999999, 1.0 };
        const double y[] =
            { 0.98429999999999995, 0.66510000000000002, 0.39610000000000001,
              0.32050000000000001, 0.27479999999999999, 0.50039999999999996,
              0.45490000000000003, 0.43290000000000001, 0.22120000000000001,
              0.16839999999999999, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_gist_ncar:{
      {
        const double x[] =
            { 0.0, 0.30980000000000002, 0.3725, 0.42349999999999999, 0.5333,
              0.79220000000000002, 0.84709999999999996, 0.89800000000000002,
              1.0 };
        const double y[] =
            { 0.0, 0.0, 0.39929999999999999, 0.50029999999999997, 1.0, 1.0,
              0.62180000000000002, 0.92349999999999999, 0.99609999999999999 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.050999999999999997, 0.10589999999999999,
              0.15690000000000001, 0.1608, 0.16470000000000001, 0.2157,
              0.25879999999999997, 0.27060000000000001, 0.31759999999999999,
              0.36859999999999998, 0.42749999999999999, 0.52159999999999995,
              0.63139999999999996, 0.68630000000000002, 0.74509999999999998,
              0.79220000000000002, 0.84309999999999996, 0.89800000000000002,
              1.0 };
        const double y[] =
            { 0.0, 0.37219999999999998, 0.0, 0.72019999999999995,
              0.75370000000000004, 0.7752, 1.0, 0.98040000000000005,
              0.98040000000000005, 1.0, 0.80810000000000004, 1.0, 1.0,
              0.72919999999999996, 0.27960000000000002, 0.0, 0.0,
              0.17530000000000001, 0.5, 0.97250000000000003 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.050999999999999997, 0.10979999999999999, 0.2039,
              0.26269999999999999, 0.3216, 0.41570000000000001,
              0.47449999999999998, 0.5333, 0.58040000000000003,
              0.63139999999999996, 0.69020000000000004, 0.73729999999999996,
              0.79220000000000002, 0.80000000000000004, 0.84309999999999996,
              0.89800000000000002, 1.0 };
        const double y[] =
            { 0.502, 0.022200000000000001, 1.0, 1.0, 0.61450000000000005, 0.0,
              0.0, 0.23419999999999999, 0.0, 0.0, 0.054899999999999997, 0.0,
              0.0, 0.9738, 1.0, 1.0, 0.93410000000000004, 0.99609999999999999 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_gist_ncar_r:{
      {
        const double x[] =
            { 0.0, 0.10199999999999998, 0.15290000000000004,
              0.20779999999999998, 0.4667, 0.57650000000000001,
              0.62749999999999995, 0.69019999999999992, 1.0 };
        const double y[] =
            { 0.99609999999999999, 0.92349999999999999, 0.62180000000000002,
              1.0, 1.0, 0.50029999999999997, 0.39929999999999999, 0.0, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10199999999999998, 0.15690000000000004,
              0.20779999999999998, 0.25490000000000002, 0.31369999999999998,
              0.36860000000000004, 0.47840000000000005, 0.57250000000000001,
              0.63139999999999996, 0.68240000000000001, 0.72940000000000005,
              0.74120000000000008, 0.7843, 0.83529999999999993,
              0.83919999999999995, 0.84309999999999996, 0.89410000000000001,
              0.94899999999999995, 1.0 };
        const double y[] =
            { 0.97250000000000003, 0.5, 0.17530000000000001, 0.0, 0.0,
              0.27960000000000002, 0.72919999999999996, 1.0, 1.0,
              0.80810000000000004, 1.0, 0.98040000000000005,
              0.98040000000000005, 1.0, 0.7752, 0.75370000000000004,
              0.72019999999999995, 0.0, 0.37219999999999998, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.10199999999999998, 0.15690000000000004,
              0.19999999999999996, 0.20779999999999998, 0.26270000000000004,
              0.30979999999999996, 0.36860000000000004, 0.41959999999999997,
              0.4667, 0.52550000000000008, 0.58430000000000004, 0.6784,
              0.73730000000000007, 0.79610000000000003, 0.89019999999999999,
              0.94899999999999995, 1.0 };
        const double y[] =
            { 0.99609999999999999, 0.93410000000000004, 1.0, 1.0, 0.9738, 0.0,
              0.0, 0.054899999999999997, 0.0, 0.0, 0.23419999999999999, 0.0,
              0.0, 0.61450000000000005, 1.0, 1.0, 0.022200000000000001, 0.502 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_gist_stern:{
      {
        const double x[] = { 0.0, 0.054699999999999999, 0.25, 1.0 };
        const double y[] = { 0.0, 1.0, 0.25, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0, 1 };
        const double y[] = { 0, 0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 0.5, 0.73499999999999999, 1.0 };
        const double y[] = { 0.0, 1.0, 0.0, 1.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_gist_stern_r:{
      {
        const double x[] = { 0.0, 0.75, 0.94530000000000003, 1.0 };
        const double y[] = { 1.0, 0.25, 1.0, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0, 0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 0.26500000000000001, 0.5, 1.0 };
        const double y[] = { 1.0, 0.0, 1.0, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_gray:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0, 1 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0, 1 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0, 1 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_gray_r:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1, 0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1, 0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1, 0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_hot:{
      {
        const double x[] = { 0.0, 0.36507899999999999, 1.0 };
        const double y[] = { 0.041599999999999998, 1.0, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.36507899999999999, 0.74603200000000003, 1.0 };
        const double y[] = { 0.0, 0.0, 1.0, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 0.74603200000000003, 1.0 };
        const double y[] = { 0.0, 0.0, 1.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_hot_r:{
      {
        const double x[] = { 0.0, 0.63492100000000007, 1.0 };
        const double y[] = { 1.0, 1.0, 0.041599999999999998 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.25396799999999997, 0.63492100000000007, 1.0 };
        const double y[] = { 1.0, 1.0, 0.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 0.25396799999999997, 1.0 };
        const double y[] = { 1.0, 0.0, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_hsv:{
      {
        const double x[] =
            { 0.0, 0.15873000000000001, 0.17460300000000001,
              0.33333299999999999, 0.34920600000000002, 0.66666700000000001,
              0.68254000000000004, 0.84126999999999996, 0.85714299999999999,
              1.0 };
        const double y[] =
            { 1.0, 1.0, 0.96875, 0.03125, 0.0, 0.0, 0.03125, 0.96875, 1.0,
              1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.15873000000000001, 0.17460300000000001,
              0.50793699999999997, 0.66666700000000001, 0.68254000000000004,
              1.0 };
        const double y[] = { 0.0, 0.9375, 1.0, 1.0, 0.0625, 0.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.33333299999999999, 0.34920600000000002,
              0.50793699999999997, 0.84126999999999996, 0.85714299999999999,
              1.0 };
        const double y[] = { 0.0, 0.0, 0.0625, 1.0, 1.0, 0.9375, 0.09375 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_hsv_r:{
      {
        const double x[] =
            { 0.0, 0.14285700000000001, 0.15873000000000004,
              0.31745999999999996, 0.33333299999999999, 0.65079399999999998,
              0.66666700000000001, 0.82539699999999994, 0.84126999999999996,
              1.0 };
        const double y[] =
            { 1.0, 1.0, 0.96875, 0.03125, 0.0, 0.0, 0.03125, 0.96875, 1.0,
              1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.31745999999999996, 0.33333299999999999,
              0.49206300000000003, 0.82539699999999994, 0.84126999999999996,
              1.0 };
        const double y[] = { 0.0, 0.0, 0.0625, 1.0, 1.0, 0.9375, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.14285700000000001, 0.15873000000000004,
              0.49206300000000003, 0.65079399999999998, 0.66666700000000001,
              1.0 };
        const double y[] = { 0.09375, 0.9375, 1.0, 1.0, 0.0625, 0.0, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_jet:{
      {
        const double x[] =
            { 0.0, 0.34999999999999998, 0.66000000000000003,
              0.89000000000000001, 1 };
        const double y[] = { 0, 0, 1, 1, 0.5 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.125, 0.375, 0.64000000000000001, 0.91000000000000003, 1 };
        const double y[] = { 0, 0, 1, 1, 0, 0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.11, 0.34000000000000002, 0.65000000000000002, 1 };
        const double y[] = { 0.5, 1, 1, 0, 0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_jet_r:{
      {
        const double x[] =
            { 0.0, 0.10999999999999999, 0.33999999999999997,
              0.65000000000000002, 1.0 };
        const double y[] = { 0.5, 1, 1, 0, 0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.089999999999999969, 0.35999999999999999, 0.625, 0.875,
              1.0 };
        const double y[] = { 0, 0, 1, 1, 0, 0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.34999999999999998, 0.65999999999999992,
              0.89000000000000001, 1.0 };
        const double y[] = { 0, 0, 1, 1, 0.5 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_pink:{
      {
        const double x[] =
            { 0.0, 0.015873000000000002, 0.031746000000000003,
              0.047619000000000002, 0.063492000000000007, 0.079365000000000005,
              0.095238000000000003, 0.111111, 0.12698400000000001,
              0.14285700000000001, 0.15873000000000001, 0.17460300000000001,
              0.19047600000000001, 0.206349, 0.222222, 0.238095,
              0.25396800000000003, 0.269841, 0.28571400000000002,
              0.30158699999999999, 0.31746000000000002, 0.33333299999999999,
              0.34920600000000002, 0.36507899999999999, 0.38095200000000001,
              0.39682499999999998, 0.41269800000000001, 0.42857099999999998,
              0.44444400000000001, 0.46031699999999998, 0.47619,
              0.49206299999999997, 0.50793699999999997, 0.52381,
              0.53968300000000002, 0.55555600000000005, 0.57142899999999996,
              0.58730199999999999, 0.60317500000000002, 0.61904800000000004,
              0.63492099999999996, 0.65079399999999998, 0.66666700000000001,
              0.68254000000000004, 0.69841299999999995, 0.71428599999999998,
              0.730159, 0.74603200000000003, 0.76190500000000005,
              0.77777799999999997, 0.793651, 0.80952400000000002,
              0.82539700000000005, 0.84126999999999996, 0.85714299999999999,
              0.87301600000000001, 0.88888900000000004, 0.90476199999999996,
              0.92063499999999998, 0.93650800000000001, 0.95238100000000003,
              0.96825399999999995, 0.98412699999999997, 1.0 };
        const double y[] =
            { 0.1178, 0.195857, 0.25066100000000002, 0.29546800000000001,
              0.33432400000000001, 0.369112, 0.40089200000000003,
              0.43033100000000002, 0.45788200000000001, 0.48386699999999999,
              0.508525, 0.53204200000000001, 0.55456300000000003,
              0.57620400000000005, 0.59706099999999995, 0.61721300000000001,
              0.63672899999999999, 0.655663, 0.67406600000000005,
              0.69198000000000004, 0.70944099999999999, 0.72648299999999999,
              0.74313399999999996, 0.75942100000000001, 0.76635600000000004,
              0.77322900000000006, 0.78004200000000001, 0.78679600000000005,
              0.79349199999999998, 0.80013199999999995, 0.80671800000000005,
              0.81325000000000003, 0.81972999999999996, 0.82616000000000001,
              0.83253900000000003, 0.83887, 0.84515399999999996,
              0.85139200000000004, 0.85758400000000001, 0.86373100000000003,
              0.86983500000000002, 0.87589700000000004, 0.88191699999999995,
              0.88789600000000002, 0.89383500000000005, 0.89973499999999995,
              0.90559699999999999, 0.91142100000000004, 0.91720800000000002,
              0.92295799999999995, 0.92867299999999997, 0.93435299999999999,
              0.93999900000000003, 0.94561099999999998, 0.95118999999999998,
              0.95673600000000003, 0.96225000000000005, 0.96773299999999995,
              0.97318499999999997, 0.978607, 0.98399899999999996,
              0.98936100000000005, 0.994695, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.015873000000000002, 0.031746000000000003,
              0.047619000000000002, 0.063492000000000007, 0.079365000000000005,
              0.095238000000000003, 0.111111, 0.12698400000000001,
              0.14285700000000001, 0.15873000000000001, 0.17460300000000001,
              0.19047600000000001, 0.206349, 0.222222, 0.238095,
              0.25396800000000003, 0.269841, 0.28571400000000002,
              0.30158699999999999, 0.31746000000000002, 0.33333299999999999,
              0.34920600000000002, 0.36507899999999999, 0.38095200000000001,
              0.39682499999999998, 0.41269800000000001, 0.42857099999999998,
              0.44444400000000001, 0.46031699999999998, 0.47619,
              0.49206299999999997, 0.50793699999999997, 0.52381,
              0.53968300000000002, 0.55555600000000005, 0.57142899999999996,
              0.58730199999999999, 0.60317500000000002, 0.61904800000000004,
              0.63492099999999996, 0.65079399999999998, 0.66666700000000001,
              0.68254000000000004, 0.69841299999999995, 0.71428599999999998,
              0.730159, 0.74603200000000003, 0.76190500000000005,
              0.77777799999999997, 0.793651, 0.80952400000000002,
              0.82539700000000005, 0.84126999999999996, 0.85714299999999999,
              0.87301600000000001, 0.88888900000000004, 0.90476199999999996,
              0.92063499999999998, 0.93650800000000001, 0.95238100000000003,
              0.96825399999999995, 0.98412699999999997, 1.0 };
        const double y[] =
            { 0.0, 0.102869, 0.145479, 0.178174, 0.205738, 0.230022,
              0.25197599999999998, 0.27216600000000002, 0.29095700000000002,
              0.30860700000000002, 0.32529999999999998, 0.34117799999999998,
              0.356348, 0.37089899999999998, 0.38490000000000002,
              0.39840999999999999, 0.41147600000000001, 0.42413899999999999,
              0.43643599999999999, 0.44839499999999999, 0.46004400000000001,
              0.47140500000000002, 0.48249799999999998, 0.493342,
              0.51754900000000004, 0.54067399999999999, 0.56284900000000004,
              0.58418300000000001, 0.604765, 0.62466900000000003,
              0.64395800000000003, 0.66268700000000003, 0.68089999999999995,
              0.69863799999999998, 0.71593700000000005, 0.73282800000000003,
              0.74933799999999995, 0.76549299999999998, 0.78131300000000004,
              0.79681900000000006, 0.812029, 0.82696000000000003,
              0.84162499999999996, 0.85604000000000002, 0.87021599999999999,
              0.88416399999999995, 0.89789600000000003, 0.91142100000000004,
              0.91720800000000002, 0.92295799999999995, 0.92867299999999997,
              0.93435299999999999, 0.93999900000000003, 0.94561099999999998,
              0.95118999999999998, 0.95673600000000003, 0.96225000000000005,
              0.96773299999999995, 0.97318499999999997, 0.978607,
              0.98399899999999996, 0.98936100000000005, 0.994695, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.015873000000000002, 0.031746000000000003,
              0.047619000000000002, 0.063492000000000007, 0.079365000000000005,
              0.095238000000000003, 0.111111, 0.12698400000000001,
              0.14285700000000001, 0.15873000000000001, 0.17460300000000001,
              0.19047600000000001, 0.206349, 0.222222, 0.238095,
              0.25396800000000003, 0.269841, 0.28571400000000002,
              0.30158699999999999, 0.31746000000000002, 0.33333299999999999,
              0.34920600000000002, 0.36507899999999999, 0.38095200000000001,
              0.39682499999999998, 0.41269800000000001, 0.42857099999999998,
              0.44444400000000001, 0.46031699999999998, 0.47619,
              0.49206299999999997, 0.50793699999999997, 0.52381,
              0.53968300000000002, 0.55555600000000005, 0.57142899999999996,
              0.58730199999999999, 0.60317500000000002, 0.61904800000000004,
              0.63492099999999996, 0.65079399999999998, 0.66666700000000001,
              0.68254000000000004, 0.69841299999999995, 0.71428599999999998,
              0.730159, 0.74603200000000003, 0.76190500000000005,
              0.77777799999999997, 0.793651, 0.80952400000000002,
              0.82539700000000005, 0.84126999999999996, 0.85714299999999999,
              0.87301600000000001, 0.88888900000000004, 0.90476199999999996,
              0.92063499999999998, 0.93650800000000001, 0.95238100000000003,
              0.96825399999999995, 0.98412699999999997, 1.0 };
        const double y[] =
            { 0.0, 0.102869, 0.145479, 0.178174, 0.205738, 0.230022,
              0.25197599999999998, 0.27216600000000002, 0.29095700000000002,
              0.30860700000000002, 0.32529999999999998, 0.34117799999999998,
              0.356348, 0.37089899999999998, 0.38490000000000002,
              0.39840999999999999, 0.41147600000000001, 0.42413899999999999,
              0.43643599999999999, 0.44839499999999999, 0.46004400000000001,
              0.47140500000000002, 0.48249799999999998, 0.493342,
              0.50395299999999998, 0.51434400000000002, 0.52453099999999997,
              0.53452200000000005, 0.54433100000000001, 0.55396599999999996,
              0.56343600000000005, 0.57274999999999998, 0.58191400000000004,
              0.59093700000000005, 0.59982400000000002, 0.60858100000000004,
              0.61721300000000001, 0.62572700000000003, 0.63412599999999997,
              0.64241599999999999, 0.65059999999999996, 0.65868199999999999,
              0.66666700000000001, 0.67455600000000004, 0.68235500000000004,
              0.69006599999999996, 0.69769099999999995, 0.70523400000000003,
              0.72716599999999998, 0.74845499999999998, 0.76915599999999995,
              0.78931399999999996, 0.80896900000000005, 0.82815899999999998,
              0.84691300000000003, 0.86526099999999995, 0.88322900000000004,
              0.900837, 0.91810899999999995, 0.93506100000000003,
              0.95171099999999997, 0.96807500000000002, 0.98416700000000001,
              1.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_pink_r:{
      {
        const double x[] =
            { 0.0, 0.015873000000000026, 0.031746000000000052,
              0.047618999999999967, 0.063491999999999993, 0.079365000000000019,
              0.095238000000000045, 0.11111099999999996, 0.12698399999999999,
              0.14285700000000001, 0.15873000000000004, 0.17460299999999995,
              0.19047599999999998, 0.206349, 0.22222200000000003,
              0.23809499999999995, 0.25396799999999997, 0.269841,
              0.28571400000000002, 0.30158700000000005, 0.31745999999999996,
              0.33333299999999999, 0.34920600000000002, 0.36507900000000004,
              0.38095199999999996, 0.39682499999999998, 0.41269800000000001,
              0.42857100000000004, 0.44444399999999995, 0.46031699999999998,
              0.47619, 0.49206300000000003, 0.50793700000000008, 0.52381,
              0.53968300000000002, 0.55555599999999994, 0.57142899999999996,
              0.58730199999999999, 0.60317500000000002, 0.61904800000000004,
              0.63492100000000007, 0.65079399999999998, 0.66666700000000001,
              0.68253999999999992, 0.69841299999999995, 0.71428599999999998,
              0.730159, 0.74603200000000003, 0.76190500000000005,
              0.77777799999999997, 0.793651, 0.80952400000000002,
              0.82539699999999994, 0.84126999999999996, 0.85714299999999999,
              0.87301600000000001, 0.88888900000000004, 0.90476199999999996,
              0.92063499999999998, 0.93650800000000001, 0.95238100000000003,
              0.96825399999999995, 0.98412699999999997, 1.0 };
        const double y[] =
            { 1.0, 0.994695, 0.98936100000000005, 0.98399899999999996, 0.978607,
              0.97318499999999997, 0.96773299999999995, 0.96225000000000005,
              0.95673600000000003, 0.95118999999999998, 0.94561099999999998,
              0.93999900000000003, 0.93435299999999999, 0.92867299999999997,
              0.92295799999999995, 0.91720800000000002, 0.91142100000000004,
              0.90559699999999999, 0.89973499999999995, 0.89383500000000005,
              0.88789600000000002, 0.88191699999999995, 0.87589700000000004,
              0.86983500000000002, 0.86373100000000003, 0.85758400000000001,
              0.85139200000000004, 0.84515399999999996, 0.83887,
              0.83253900000000003, 0.82616000000000001, 0.81972999999999996,
              0.81325000000000003, 0.80671800000000005, 0.80013199999999995,
              0.79349199999999998, 0.78679600000000005, 0.78004200000000001,
              0.77322900000000006, 0.76635600000000004, 0.75942100000000001,
              0.74313399999999996, 0.72648299999999999, 0.70944099999999999,
              0.69198000000000004, 0.67406600000000005, 0.655663,
              0.63672899999999999, 0.61721300000000001, 0.59706099999999995,
              0.57620400000000005, 0.55456300000000003, 0.53204200000000001,
              0.508525, 0.48386699999999999, 0.45788200000000001,
              0.43033100000000002, 0.40089200000000003, 0.369112,
              0.33432400000000001, 0.29546800000000001, 0.25066100000000002,
              0.195857, 0.1178 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.015873000000000026, 0.031746000000000052,
              0.047618999999999967, 0.063491999999999993, 0.079365000000000019,
              0.095238000000000045, 0.11111099999999996, 0.12698399999999999,
              0.14285700000000001, 0.15873000000000004, 0.17460299999999995,
              0.19047599999999998, 0.206349, 0.22222200000000003,
              0.23809499999999995, 0.25396799999999997, 0.269841,
              0.28571400000000002, 0.30158700000000005, 0.31745999999999996,
              0.33333299999999999, 0.34920600000000002, 0.36507900000000004,
              0.38095199999999996, 0.39682499999999998, 0.41269800000000001,
              0.42857100000000004, 0.44444399999999995, 0.46031699999999998,
              0.47619, 0.49206300000000003, 0.50793700000000008, 0.52381,
              0.53968300000000002, 0.55555599999999994, 0.57142899999999996,
              0.58730199999999999, 0.60317500000000002, 0.61904800000000004,
              0.63492100000000007, 0.65079399999999998, 0.66666700000000001,
              0.68253999999999992, 0.69841299999999995, 0.71428599999999998,
              0.730159, 0.74603200000000003, 0.76190500000000005,
              0.77777799999999997, 0.793651, 0.80952400000000002,
              0.82539699999999994, 0.84126999999999996, 0.85714299999999999,
              0.87301600000000001, 0.88888900000000004, 0.90476199999999996,
              0.92063499999999998, 0.93650800000000001, 0.95238100000000003,
              0.96825399999999995, 0.98412699999999997, 1.0 };
        const double y[] =
            { 1.0, 0.994695, 0.98936100000000005, 0.98399899999999996, 0.978607,
              0.97318499999999997, 0.96773299999999995, 0.96225000000000005,
              0.95673600000000003, 0.95118999999999998, 0.94561099999999998,
              0.93999900000000003, 0.93435299999999999, 0.92867299999999997,
              0.92295799999999995, 0.91720800000000002, 0.91142100000000004,
              0.89789600000000003, 0.88416399999999995, 0.87021599999999999,
              0.85604000000000002, 0.84162499999999996, 0.82696000000000003,
              0.812029, 0.79681900000000006, 0.78131300000000004,
              0.76549299999999998, 0.74933799999999995, 0.73282800000000003,
              0.71593700000000005, 0.69863799999999998, 0.68089999999999995,
              0.66268700000000003, 0.64395800000000003, 0.62466900000000003,
              0.604765, 0.58418300000000001, 0.56284900000000004,
              0.54067399999999999, 0.51754900000000004, 0.493342,
              0.48249799999999998, 0.47140500000000002, 0.46004400000000001,
              0.44839499999999999, 0.43643599999999999, 0.42413899999999999,
              0.41147600000000001, 0.39840999999999999, 0.38490000000000002,
              0.37089899999999998, 0.356348, 0.34117799999999998,
              0.32529999999999998, 0.30860700000000002, 0.29095700000000002,
              0.27216600000000002, 0.25197599999999998, 0.230022, 0.205738,
              0.178174, 0.145479, 0.102869, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.015873000000000026, 0.031746000000000052,
              0.047618999999999967, 0.063491999999999993, 0.079365000000000019,
              0.095238000000000045, 0.11111099999999996, 0.12698399999999999,
              0.14285700000000001, 0.15873000000000004, 0.17460299999999995,
              0.19047599999999998, 0.206349, 0.22222200000000003,
              0.23809499999999995, 0.25396799999999997, 0.269841,
              0.28571400000000002, 0.30158700000000005, 0.31745999999999996,
              0.33333299999999999, 0.34920600000000002, 0.36507900000000004,
              0.38095199999999996, 0.39682499999999998, 0.41269800000000001,
              0.42857100000000004, 0.44444399999999995, 0.46031699999999998,
              0.47619, 0.49206300000000003, 0.50793700000000008, 0.52381,
              0.53968300000000002, 0.55555599999999994, 0.57142899999999996,
              0.58730199999999999, 0.60317500000000002, 0.61904800000000004,
              0.63492100000000007, 0.65079399999999998, 0.66666700000000001,
              0.68253999999999992, 0.69841299999999995, 0.71428599999999998,
              0.730159, 0.74603200000000003, 0.76190500000000005,
              0.77777799999999997, 0.793651, 0.80952400000000002,
              0.82539699999999994, 0.84126999999999996, 0.85714299999999999,
              0.87301600000000001, 0.88888900000000004, 0.90476199999999996,
              0.92063499999999998, 0.93650800000000001, 0.95238100000000003,
              0.96825399999999995, 0.98412699999999997, 1.0 };
        const double y[] =
            { 1.0, 0.98416700000000001, 0.96807500000000002,
              0.95171099999999997, 0.93506100000000003, 0.91810899999999995,
              0.900837, 0.88322900000000004, 0.86526099999999995,
              0.84691300000000003, 0.82815899999999998, 0.80896900000000005,
              0.78931399999999996, 0.76915599999999995, 0.74845499999999998,
              0.72716599999999998, 0.70523400000000003, 0.69769099999999995,
              0.69006599999999996, 0.68235500000000004, 0.67455600000000004,
              0.66666700000000001, 0.65868199999999999, 0.65059999999999996,
              0.64241599999999999, 0.63412599999999997, 0.62572700000000003,
              0.61721300000000001, 0.60858100000000004, 0.59982400000000002,
              0.59093700000000005, 0.58191400000000004, 0.57274999999999998,
              0.56343600000000005, 0.55396599999999996, 0.54433100000000001,
              0.53452200000000005, 0.52453099999999997, 0.51434400000000002,
              0.50395299999999998, 0.493342, 0.48249799999999998,
              0.47140500000000002, 0.46004400000000001, 0.44839499999999999,
              0.43643599999999999, 0.42413899999999999, 0.41147600000000001,
              0.39840999999999999, 0.38490000000000002, 0.37089899999999998,
              0.356348, 0.34117799999999998, 0.32529999999999998,
              0.30860700000000002, 0.29095700000000002, 0.27216600000000002,
              0.25197599999999998, 0.230022, 0.205738, 0.178174, 0.145479,
              0.102869, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_spectral:{
      {
        const double x[] =
            { 0.0, 0.050000000000000003, 0.10000000000000001,
              0.14999999999999999, 0.20000000000000001, 0.25,
              0.29999999999999999, 0.34999999999999998, 0.40000000000000002,
              0.45000000000000001, 0.5, 0.55000000000000004,
              0.59999999999999998, 0.65000000000000002, 0.69999999999999996,
              0.75, 0.80000000000000004, 0.84999999999999998,
              0.90000000000000002, 0.94999999999999996, 1.0 };
        const double y[] =
            { 0.0, 0.4667, 0.5333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
              0.0, 0.73329999999999995, 0.93330000000000002, 1.0, 1.0, 1.0,
              0.86670000000000003, 0.80000000000000004, 0.80000000000000004 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.050000000000000003, 0.10000000000000001,
              0.14999999999999999, 0.20000000000000001, 0.25,
              0.29999999999999999, 0.34999999999999998, 0.40000000000000002,
              0.45000000000000001, 0.5, 0.55000000000000004,
              0.59999999999999998, 0.65000000000000002, 0.69999999999999996,
              0.75, 0.80000000000000004, 0.84999999999999998,
              0.90000000000000002, 0.94999999999999996, 1.0 };
        const double y[] =
            { 0.0, 0.0, 0.0, 0.0, 0.0, 0.4667, 0.59999999999999998,
              0.66669999999999996, 0.66669999999999996, 0.59999999999999998,
              0.73329999999999995, 0.86670000000000003, 1.0, 1.0,
              0.93330000000000002, 0.80000000000000004, 0.59999999999999998,
              0.0, 0.0, 0.0, 0.80000000000000004 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.050000000000000003, 0.10000000000000001,
              0.14999999999999999, 0.20000000000000001, 0.25,
              0.29999999999999999, 0.34999999999999998, 0.40000000000000002,
              0.45000000000000001, 0.5, 0.55000000000000004,
              0.59999999999999998, 0.65000000000000002, 0.69999999999999996,
              0.75, 0.80000000000000004, 0.84999999999999998,
              0.90000000000000002, 0.94999999999999996, 1.0 };
        const double y[] =
            { 0.0, 0.5333, 0.59999999999999998, 0.66669999999999996,
              0.86670000000000003, 0.86670000000000003, 0.86670000000000003,
              0.66669999999999996, 0.5333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
              0.0, 0.0, 0.0, 0.0, 0.80000000000000004 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_spectral_r:{
      {
        const double x[] =
            { 0.0, 0.050000000000000044, 0.099999999999999978,
              0.15000000000000002, 0.19999999999999996, 0.25,
              0.30000000000000004, 0.34999999999999998, 0.40000000000000002,
              0.44999999999999996, 0.5, 0.55000000000000004,
              0.59999999999999998, 0.65000000000000002, 0.69999999999999996,
              0.75, 0.80000000000000004, 0.84999999999999998,
              0.90000000000000002, 0.94999999999999996, 1.0 };
        const double y[] =
            { 0.80000000000000004, 0.80000000000000004, 0.86670000000000003,
              1.0, 1.0, 1.0, 0.93330000000000002, 0.73329999999999995, 0.0, 0.0,
              0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.5333, 0.4667, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.050000000000000044, 0.099999999999999978,
              0.15000000000000002, 0.19999999999999996, 0.25,
              0.30000000000000004, 0.34999999999999998, 0.40000000000000002,
              0.44999999999999996, 0.5, 0.55000000000000004,
              0.59999999999999998, 0.65000000000000002, 0.69999999999999996,
              0.75, 0.80000000000000004, 0.84999999999999998,
              0.90000000000000002, 0.94999999999999996, 1.0 };
        const double y[] =
            { 0.80000000000000004, 0.0, 0.0, 0.0, 0.59999999999999998,
              0.80000000000000004, 0.93330000000000002, 1.0, 1.0,
              0.86670000000000003, 0.73329999999999995, 0.59999999999999998,
              0.66669999999999996, 0.66669999999999996, 0.59999999999999998,
              0.4667, 0.0, 0.0, 0.0, 0.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] =
            { 0.0, 0.050000000000000044, 0.099999999999999978,
              0.15000000000000002, 0.19999999999999996, 0.25,
              0.30000000000000004, 0.34999999999999998, 0.40000000000000002,
              0.44999999999999996, 0.5, 0.55000000000000004,
              0.59999999999999998, 0.65000000000000002, 0.69999999999999996,
              0.75, 0.80000000000000004, 0.84999999999999998,
              0.90000000000000002, 0.94999999999999996, 1.0 };
        const double y[] =
            { 0.80000000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
              0.0, 0.0, 0.5333, 0.66669999999999996, 0.86670000000000003,
              0.86670000000000003, 0.86670000000000003, 0.66669999999999996,
              0.59999999999999998, 0.5333, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_spring:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_spring_r:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 1.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_summer:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 1.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.5, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.40000000000000002, 0.40000000000000002 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_summer_r:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.5 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.40000000000000002, 0.40000000000000002 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_winter:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 1.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.5 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    case CAIROVIS_COLORMAP_winter_r:{
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.0, 0.0 };
        data->red.len = sizeof (x) / sizeof (double);
        data->red.x = g_memdup (x, sizeof (x));
        data->red.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 1.0, 0.0 };
        data->green.len = sizeof (x) / sizeof (double);
        data->green.x = g_memdup (x, sizeof (x));
        data->green.y = g_memdup (y, sizeof (y));
      }
      {
        const double x[] = { 0.0, 1.0 };
        const double y[] = { 0.5, 1.0 };
        data->blue.len = sizeof (x) / sizeof (double);
        data->blue.x = g_memdup (x, sizeof (x));
        data->blue.y = g_memdup (y, sizeof (y));
      }
    }
      return TRUE;
      break;
    default:
      return FALSE;
  }
}


GType
cairovis_colormap_get_type (void)
{
  static GType tp = 0;
  static const GEnumValue values[] = {
    {CAIROVIS_COLORMAP_Accent, "Accent", "Accent"},
    {CAIROVIS_COLORMAP_Accent_r, "Accent_r", "Accent_r"},
    {CAIROVIS_COLORMAP_Blues, "Blues", "Blues"},
    {CAIROVIS_COLORMAP_Blues_r, "Blues_r", "Blues_r"},
    {CAIROVIS_COLORMAP_BrBG, "BrBG", "BrBG"},
    {CAIROVIS_COLORMAP_BrBG_r, "BrBG_r", "BrBG_r"},
    {CAIROVIS_COLORMAP_BuGn, "BuGn", "BuGn"},
    {CAIROVIS_COLORMAP_BuGn_r, "BuGn_r", "BuGn_r"},
    {CAIROVIS_COLORMAP_BuPu, "BuPu", "BuPu"},
    {CAIROVIS_COLORMAP_BuPu_r, "BuPu_r", "BuPu_r"},
    {CAIROVIS_COLORMAP_Dark2, "Dark2", "Dark2"},
    {CAIROVIS_COLORMAP_Dark2_r, "Dark2_r", "Dark2_r"},
    {CAIROVIS_COLORMAP_GnBu, "GnBu", "GnBu"},
    {CAIROVIS_COLORMAP_GnBu_r, "GnBu_r", "GnBu_r"},
    {CAIROVIS_COLORMAP_Greens, "Greens", "Greens"},
    {CAIROVIS_COLORMAP_Greens_r, "Greens_r", "Greens_r"},
    {CAIROVIS_COLORMAP_Greys, "Greys", "Greys"},
    {CAIROVIS_COLORMAP_Greys_r, "Greys_r", "Greys_r"},
    {CAIROVIS_COLORMAP_OrRd, "OrRd", "OrRd"},
    {CAIROVIS_COLORMAP_OrRd_r, "OrRd_r", "OrRd_r"},
    {CAIROVIS_COLORMAP_Oranges, "Oranges", "Oranges"},
    {CAIROVIS_COLORMAP_Oranges_r, "Oranges_r", "Oranges_r"},
    {CAIROVIS_COLORMAP_PRGn, "PRGn", "PRGn"},
    {CAIROVIS_COLORMAP_PRGn_r, "PRGn_r", "PRGn_r"},
    {CAIROVIS_COLORMAP_Paired, "Paired", "Paired"},
    {CAIROVIS_COLORMAP_Paired_r, "Paired_r", "Paired_r"},
    {CAIROVIS_COLORMAP_Pastel1, "Pastel1", "Pastel1"},
    {CAIROVIS_COLORMAP_Pastel1_r, "Pastel1_r", "Pastel1_r"},
    {CAIROVIS_COLORMAP_Pastel2, "Pastel2", "Pastel2"},
    {CAIROVIS_COLORMAP_Pastel2_r, "Pastel2_r", "Pastel2_r"},
    {CAIROVIS_COLORMAP_PiYG, "PiYG", "PiYG"},
    {CAIROVIS_COLORMAP_PiYG_r, "PiYG_r", "PiYG_r"},
    {CAIROVIS_COLORMAP_PuBu, "PuBu", "PuBu"},
    {CAIROVIS_COLORMAP_PuBuGn, "PuBuGn", "PuBuGn"},
    {CAIROVIS_COLORMAP_PuBuGn_r, "PuBuGn_r", "PuBuGn_r"},
    {CAIROVIS_COLORMAP_PuBu_r, "PuBu_r", "PuBu_r"},
    {CAIROVIS_COLORMAP_PuOr, "PuOr", "PuOr"},
    {CAIROVIS_COLORMAP_PuOr_r, "PuOr_r", "PuOr_r"},
    {CAIROVIS_COLORMAP_PuRd, "PuRd", "PuRd"},
    {CAIROVIS_COLORMAP_PuRd_r, "PuRd_r", "PuRd_r"},
    {CAIROVIS_COLORMAP_Purples, "Purples", "Purples"},
    {CAIROVIS_COLORMAP_Purples_r, "Purples_r", "Purples_r"},
    {CAIROVIS_COLORMAP_RdBu, "RdBu", "RdBu"},
    {CAIROVIS_COLORMAP_RdBu_r, "RdBu_r", "RdBu_r"},
    {CAIROVIS_COLORMAP_RdGy, "RdGy", "RdGy"},
    {CAIROVIS_COLORMAP_RdGy_r, "RdGy_r", "RdGy_r"},
    {CAIROVIS_COLORMAP_RdPu, "RdPu", "RdPu"},
    {CAIROVIS_COLORMAP_RdPu_r, "RdPu_r", "RdPu_r"},
    {CAIROVIS_COLORMAP_RdYlBu, "RdYlBu", "RdYlBu"},
    {CAIROVIS_COLORMAP_RdYlBu_r, "RdYlBu_r", "RdYlBu_r"},
    {CAIROVIS_COLORMAP_RdYlGn, "RdYlGn", "RdYlGn"},
    {CAIROVIS_COLORMAP_RdYlGn_r, "RdYlGn_r", "RdYlGn_r"},
    {CAIROVIS_COLORMAP_Reds, "Reds", "Reds"},
    {CAIROVIS_COLORMAP_Reds_r, "Reds_r", "Reds_r"},
    {CAIROVIS_COLORMAP_Set1, "Set1", "Set1"},
    {CAIROVIS_COLORMAP_Set1_r, "Set1_r", "Set1_r"},
    {CAIROVIS_COLORMAP_Set2, "Set2", "Set2"},
    {CAIROVIS_COLORMAP_Set2_r, "Set2_r", "Set2_r"},
    {CAIROVIS_COLORMAP_Set3, "Set3", "Set3"},
    {CAIROVIS_COLORMAP_Set3_r, "Set3_r", "Set3_r"},
    {CAIROVIS_COLORMAP_Spectral, "Spectral", "Spectral"},
    {CAIROVIS_COLORMAP_Spectral_r, "Spectral_r", "Spectral_r"},
    {CAIROVIS_COLORMAP_YlGn, "YlGn", "YlGn"},
    {CAIROVIS_COLORMAP_YlGnBu, "YlGnBu", "YlGnBu"},
    {CAIROVIS_COLORMAP_YlGnBu_r, "YlGnBu_r", "YlGnBu_r"},
    {CAIROVIS_COLORMAP_YlGn_r, "YlGn_r", "YlGn_r"},
    {CAIROVIS_COLORMAP_YlOrBr, "YlOrBr", "YlOrBr"},
    {CAIROVIS_COLORMAP_YlOrBr_r, "YlOrBr_r", "YlOrBr_r"},
    {CAIROVIS_COLORMAP_YlOrRd, "YlOrRd", "YlOrRd"},
    {CAIROVIS_COLORMAP_YlOrRd_r, "YlOrRd_r", "YlOrRd_r"},
    {CAIROVIS_COLORMAP_autumn, "autumn", "autumn"},
    {CAIROVIS_COLORMAP_autumn_r, "autumn_r", "autumn_r"},
    {CAIROVIS_COLORMAP_binary, "binary", "binary"},
    {CAIROVIS_COLORMAP_binary_r, "binary_r", "binary_r"},
    {CAIROVIS_COLORMAP_bone, "bone", "bone"},
    {CAIROVIS_COLORMAP_bone_r, "bone_r", "bone_r"},
    {CAIROVIS_COLORMAP_cool, "cool", "cool"},
    {CAIROVIS_COLORMAP_cool_r, "cool_r", "cool_r"},
    {CAIROVIS_COLORMAP_copper, "copper", "copper"},
    {CAIROVIS_COLORMAP_copper_r, "copper_r", "copper_r"},
    {CAIROVIS_COLORMAP_gist_earth, "gist_earth", "gist_earth"},
    {CAIROVIS_COLORMAP_gist_earth_r, "gist_earth_r", "gist_earth_r"},
    {CAIROVIS_COLORMAP_gist_ncar, "gist_ncar", "gist_ncar"},
    {CAIROVIS_COLORMAP_gist_ncar_r, "gist_ncar_r", "gist_ncar_r"},
    {CAIROVIS_COLORMAP_gist_stern, "gist_stern", "gist_stern"},
    {CAIROVIS_COLORMAP_gist_stern_r, "gist_stern_r", "gist_stern_r"},
    {CAIROVIS_COLORMAP_gray, "gray", "gray"},
    {CAIROVIS_COLORMAP_gray_r, "gray_r", "gray_r"},
    {CAIROVIS_COLORMAP_hot, "hot", "hot"},
    {CAIROVIS_COLORMAP_hot_r, "hot_r", "hot_r"},
    {CAIROVIS_COLORMAP_hsv, "hsv", "hsv"},
    {CAIROVIS_COLORMAP_hsv_r, "hsv_r", "hsv_r"},
    {CAIROVIS_COLORMAP_jet, "jet", "jet"},
    {CAIROVIS_COLORMAP_jet_r, "jet_r", "jet_r"},
    {CAIROVIS_COLORMAP_pink, "pink", "pink"},
    {CAIROVIS_COLORMAP_pink_r, "pink_r", "pink_r"},
    {CAIROVIS_COLORMAP_spectral, "spectral", "spectral"},
    {CAIROVIS_COLORMAP_spectral_r, "spectral_r", "spectral_r"},
    {CAIROVIS_COLORMAP_spring, "spring", "spring"},
    {CAIROVIS_COLORMAP_spring_r, "spring_r", "spring_r"},
    {CAIROVIS_COLORMAP_summer, "summer", "summer"},
    {CAIROVIS_COLORMAP_summer_r, "summer_r", "summer_r"},
    {CAIROVIS_COLORMAP_winter, "winter", "winter"},
    {CAIROVIS_COLORMAP_winter_r, "winter_r", "winter_r"},
    {0, NULL, NULL},
  };

  if (G_UNLIKELY (tp == 0)) {
    tp = g_enum_register_static ("CairoVisColormap", values);
  }
  return tp;
}
