/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import org.springframework.binding.collection.SharedMap;
import org.springframework.binding.collection.SharedMapDecorator;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.LocalSharedAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;
import org.springframework.webflow.test.MockParameterMap;

public class MockExternalContext
implements ExternalContext {
    private String contextPath;
    private ParameterMap requestParameterMap = new MockParameterMap();
    private MutableAttributeMap requestMap = new LocalAttributeMap();
    private SharedAttributeMap sessionMap;
    private SharedAttributeMap globalSessionMap = this.sessionMap = new LocalSharedAttributeMap((SharedMap)new SharedMapDecorator(new HashMap()));
    private SharedAttributeMap applicationMap = new LocalSharedAttributeMap((SharedMap)new SharedMapDecorator(new HashMap()));
    private Object nativeContext = new Object();
    private Object nativeRequest = new Object();
    private Object nativeResponse = new Object();
    private Principal currentUser;
    private Locale locale;
    private StringWriter responseWriter = new StringWriter();
    private boolean ajaxRequest;
    private Boolean responseAllowed;
    private boolean responseComplete;
    private boolean flowExecutionRedirectRequested;
    private String flowDefinitionRedirectFlowId;
    private MutableAttributeMap flowDefinitionRedirectFlowInput;
    private String externalRedirectUrl;
    private boolean redirectInPopup;

    public MockExternalContext() {
    }

    public MockExternalContext(ParameterMap requestParameterMap) {
        if (requestParameterMap != null) {
            this.requestParameterMap = requestParameterMap;
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ParameterMap getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public MutableAttributeMap getRequestMap() {
        return this.requestMap;
    }

    public SharedAttributeMap getSessionMap() {
        return this.sessionMap;
    }

    public SharedAttributeMap getGlobalSessionMap() {
        return this.globalSessionMap;
    }

    public SharedAttributeMap getApplicationMap() {
        return this.applicationMap;
    }

    public Principal getCurrentUser() {
        return this.currentUser;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object getNativeContext() {
        return this.nativeContext;
    }

    public Object getNativeRequest() {
        return this.nativeRequest;
    }

    public Object getNativeResponse() {
        return this.nativeResponse;
    }

    public boolean isAjaxRequest() {
        return this.ajaxRequest;
    }

    public String getFlowExecutionUrl(String flowId, String flowExecutionKey) {
        return "/" + flowId + "?execution=" + flowExecutionKey;
    }

    public Writer getResponseWriter() {
        this.assertResponseAllowed();
        return this.responseWriter;
    }

    public boolean isResponseAllowed() {
        if (this.responseAllowed != null) {
            return this.responseAllowed;
        }
        return !this.responseComplete;
    }

    public boolean isResponseComplete() {
        return this.responseComplete;
    }

    public void recordResponseComplete() {
        this.responseComplete = true;
    }

    public boolean isResponseCompleteFlowExecutionRedirect() {
        return this.flowExecutionRedirectRequested;
    }

    public void requestFlowExecutionRedirect() throws IllegalStateException {
        this.flowExecutionRedirectRequested = true;
        this.recordResponseComplete();
    }

    public void requestFlowDefinitionRedirect(String flowId, MutableAttributeMap input) throws IllegalStateException {
        this.flowDefinitionRedirectFlowId = flowId;
        this.flowDefinitionRedirectFlowInput = input;
        this.recordResponseComplete();
    }

    public void requestExternalRedirect(String uri) throws IllegalStateException {
        this.externalRedirectUrl = uri;
        this.recordResponseComplete();
    }

    public void requestRedirectInPopup() throws IllegalStateException {
        if (!this.isRedirectRequested()) {
            throw new IllegalStateException("Only call requestRedirectInPopup after a redirect has been requested by calling requestFlowExecutionRedirect, requestFlowDefinitionRedirect, or requestExternalRedirect");
        }
        this.redirectInPopup = true;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setRequestParameterMap(ParameterMap requestParameterMap) {
        this.requestParameterMap = requestParameterMap;
    }

    public void setRequestMap(MutableAttributeMap requestMap) {
        this.requestMap = requestMap;
    }

    public void setSessionMap(SharedAttributeMap sessionMap) {
        this.sessionMap = sessionMap;
    }

    public void setGlobalSessionMap(SharedAttributeMap globalSessionMap) {
        this.globalSessionMap = globalSessionMap;
    }

    public void setApplicationMap(SharedAttributeMap applicationMap) {
        this.applicationMap = applicationMap;
    }

    public void setNativeContext(Object nativeContext) {
        this.nativeContext = nativeContext;
    }

    public void setNativeRequest(Object nativeRequest) {
        this.nativeRequest = nativeRequest;
    }

    public void setNativeResponse(Object nativeResponse) {
        this.nativeResponse = nativeResponse;
    }

    public void setCurrentUser(Principal currentUser) {
        this.currentUser = currentUser;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = new MockPrincipal(currentUser);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public MockParameterMap getMockRequestParameterMap() {
        return (MockParameterMap)this.requestParameterMap;
    }

    public void putRequestParameter(String parameterName, String parameterValue) {
        this.getMockRequestParameterMap().put(parameterName, parameterValue);
    }

    public void putRequestParameter(String parameterName, String[] parameterValues) {
        this.getMockRequestParameterMap().put(parameterName, parameterValues);
    }

    public void putRequestParameter(String parameterName, MultipartFile parameterValue) {
        this.getMockRequestParameterMap().put(parameterName, parameterValue);
    }

    public void setEventId(String eventId) {
        this.putRequestParameter("_eventId", eventId);
    }

    public void setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    public void setResponseAllowed(boolean responseAllowed) {
        this.responseAllowed = responseAllowed;
    }

    public StringWriter getMockResponseWriter() {
        return this.responseWriter;
    }

    public boolean getFlowExecutionRedirectRequested() {
        return this.flowExecutionRedirectRequested;
    }

    public boolean getFlowDefinitionRedirectRequested() {
        return this.flowDefinitionRedirectFlowId != null;
    }

    public String getFlowRedirectFlowId() {
        return this.flowDefinitionRedirectFlowId;
    }

    public MutableAttributeMap getFlowRedirectFlowInput() {
        return this.flowDefinitionRedirectFlowInput;
    }

    public boolean getExternalRedirectRequested() {
        return this.externalRedirectUrl != null;
    }

    public String getExternalRedirectUrl() {
        return this.externalRedirectUrl;
    }

    public boolean getRedirectInPopup() {
        return this.redirectInPopup;
    }

    private void assertResponseAllowed() throws IllegalStateException {
        if (!this.isResponseAllowed()) {
            if (this.getFlowExecutionRedirectRequested()) {
                throw new IllegalStateException("A response is not allowed because a redirect has already been requested on this ExternalContext");
            }
            if (this.getFlowDefinitionRedirectRequested()) {
                throw new IllegalStateException("A response is not allowed because a flowRedirect has already been requested on this ExternalContext");
            }
            if (this.getExternalRedirectRequested()) {
                throw new IllegalStateException("A response is not allowed because an externalRedirect has already been requested on this ExternalContext");
            }
            if (this.responseComplete) {
                throw new IllegalStateException("A response is not allowed because one has already been completed on this ExternalContext");
            }
            throw new IllegalStateException("A response is not allowed");
        }
    }

    public boolean isRedirectRequested() {
        return this.getFlowExecutionRedirectRequested() || this.getFlowDefinitionRedirectRequested() || this.getExternalRedirectRequested();
    }

    private class MockPrincipal
    implements Principal {
        private String name;

        private MockPrincipal(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

