/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.tomcat;

import javax.servlet.ServletException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.http11.Http11NioProtocol;
import org.grails.plugins.tomcat.TomcatKillSwitch;

public class IsolatedTomcat {
    public static void main(String[] args) {
        Connector connector;
        if (args.length < 3) {
            System.err.println("Usage: IsolatedTomcat [tomcat_path] [war_path] [context_path] [host] [httpPort] [httpsPort] [keystorePath] [keystorePassword]");
            System.exit(1);
        }
        String tomcatDir = args[0];
        String warPath = args[1];
        String contextPath = args[2];
        String host = "localhost";
        if (args.length > 3) {
            host = args[3];
        }
        int port = IsolatedTomcat.argToNumber(args, 4, 8080);
        int httpsPort = IsolatedTomcat.argToNumber(args, 5, 0);
        String keystorePath = "";
        String keystorePassword = "";
        if (httpsPort > 0) {
            keystorePath = args[6];
            keystorePassword = args[7];
        }
        Tomcat tomcat = new Tomcat();
        tomcat.setPort(port);
        if (Boolean.getBoolean("tomcat.nio")) {
            System.out.println("Enabling Tomcat NIO Connector");
            connector = new Connector(Http11NioProtocol.class.getName());
            connector.setPort(port);
            tomcat.getService().addConnector(connector);
            tomcat.setConnector(connector);
        }
        tomcat.setBaseDir(tomcatDir);
        try {
            tomcat.addWebapp(contextPath, warPath);
        }
        catch (ServletException e) {
            e.printStackTrace();
            System.err.println("Error loading Tomcat: " + e.getMessage());
            System.exit(1);
        }
        tomcat.enableNaming();
        connector = tomcat.getConnector();
        if (!host.equals("localhost")) {
            connector.setAttribute("address", (Object)host);
        }
        connector.setURIEncoding("UTF-8");
        if (httpsPort > 0) {
            Connector sslConnector;
            try {
                sslConnector = new Connector();
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't create HTTPS connector", e);
            }
            sslConnector.setScheme("https");
            sslConnector.setSecure(true);
            sslConnector.setPort(httpsPort);
            sslConnector.setProperty("SSLEnabled", "true");
            sslConnector.setAttribute("keystoreFile", (Object)keystorePath);
            sslConnector.setAttribute("keystorePass", (Object)keystorePassword);
            sslConnector.setURIEncoding("UTF-8");
            if (!host.equals("localhost")) {
                sslConnector.setAttribute("address", (Object)host);
            }
            tomcat.getService().addConnector(sslConnector);
        }
        int serverPort = port;
        IsolatedTomcat.startKillSwitch(tomcat, serverPort);
        try {
            tomcat.start();
            String message = "Server running. Browse to http://" + (host != null ? host : "localhost") + ":" + port + contextPath;
            System.out.println(message);
        }
        catch (LifecycleException e) {
            e.printStackTrace(System.err);
            System.err.println("Error loading Tomcat: " + e.getMessage());
            System.exit(1);
        }
    }

    public static void startKillSwitch(Tomcat tomcat, int serverPort) {
        new Thread(new TomcatKillSwitch(tomcat, serverPort)).start();
    }

    private static int argToNumber(String[] args, int i, int orDefault) {
        if (args.length > i) {
            try {
                return Integer.parseInt(args[i]);
            }
            catch (NumberFormatException e) {
                return orDefault;
            }
        }
        return orDefault;
    }
}

