/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.agent;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Map;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.LoadtimeInstrumentationPlugin;
import org.springsource.loaded.ReloadEventProcessorPlugin;
import sun.awt.AppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVMPlugin
implements ReloadEventProcessorPlugin,
LoadtimeInstrumentationPlugin {
    private boolean pluginBroken = false;
    private boolean introspectorLoaded = false;
    private boolean threadGroupContextLoaded = false;
    private Field beanInfoCacheField;
    private Field declaredMethodCacheField;
    private Method putMethod;
    private Class<?> threadGroupContextClass;
    private Field threadGroupContext_contextsField;
    private Method threadGroupContext_removeBeanInfoMethod;

    @Override
    public void reloadEvent(String typename, Class<?> clazz, String encodedTimestamp) {
        if (this.pluginBroken) {
            return;
        }
        if (this.introspectorLoaded) {
            boolean beanInfoCacheCleared = false;
            if (this.threadGroupContextLoaded) {
                try {
                    if (this.threadGroupContextClass == null) {
                        this.threadGroupContextClass = Class.forName("java.beans.ThreadGroupContext", true, Introspector.class.getClassLoader());
                    }
                    if (this.threadGroupContextClass != null) {
                        if (this.threadGroupContext_contextsField == null) {
                            this.threadGroupContext_contextsField = this.threadGroupContextClass.getDeclaredField("contexts");
                            this.threadGroupContext_removeBeanInfoMethod = this.threadGroupContextClass.getDeclaredMethod("removeBeanInfo", Class.class);
                        }
                        if (this.threadGroupContext_contextsField != null) {
                            this.threadGroupContext_contextsField.setAccessible(true);
                            Map m = (Map)this.threadGroupContext_contextsField.get(null);
                            Collection threadGroupContexts = m.values();
                            for (Object o : threadGroupContexts) {
                                this.threadGroupContext_removeBeanInfoMethod.setAccessible(true);
                                this.threadGroupContext_removeBeanInfoMethod.invoke(o, clazz);
                            }
                            beanInfoCacheCleared = true;
                        }
                    }
                }
                catch (Throwable t) {
                    System.err.println("Unexpected problem clearing ThreadGroupContext beaninfo: ");
                    t.printStackTrace();
                }
            }
            if (!beanInfoCacheCleared) {
                try {
                    if (this.beanInfoCacheField == null) {
                        this.beanInfoCacheField = Introspector.class.getDeclaredField("BEANINFO_CACHE");
                    }
                    this.beanInfoCacheField.setAccessible(true);
                    Object key = this.beanInfoCacheField.get(null);
                    Map map = (Map)AppContext.getAppContext().get(key);
                    if (map != null) {
                        if (GlobalConfiguration.debugplugins) {
                            System.err.println("JVMPlugin: clearing out BeanInfo for " + clazz.getName());
                        }
                        map.remove(clazz);
                    }
                    Introspector.flushFromCaches(clazz);
                }
                catch (NoSuchFieldException nsfe) {
                    System.out.println("Reloading: JVMPlugin: warning: unable to clear BEANINFO_CACHE, cant find field");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                if (this.declaredMethodCacheField == null) {
                    this.declaredMethodCacheField = Introspector.class.getDeclaredField("declaredMethodCache");
                }
                this.declaredMethodCacheField.setAccessible(true);
                Object theCache = this.declaredMethodCacheField.get(null);
                if (this.putMethod == null) {
                    this.putMethod = theCache.getClass().getDeclaredMethod("put", Object.class, Object.class);
                }
                this.putMethod.setAccessible(true);
                if (GlobalConfiguration.debugplugins) {
                    System.err.println("JVMPlugin: clearing out declaredMethodCache in Introspector for class " + clazz.getName());
                }
                this.putMethod.invoke(theCache, clazz, null);
            }
            catch (NoSuchFieldException nsfe) {
                this.pluginBroken = true;
                System.out.println("Reloading: JVMPlugin: warning: unable to clear declaredMethodCache, cant find field (JDK update may fix it)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean accept(String slashedTypeName, ClassLoader classLoader, ProtectionDomain protectionDomain, byte[] bytes) {
        if (slashedTypeName != null) {
            if (slashedTypeName.equals("java/beans/Introspector")) {
                this.introspectorLoaded = true;
            } else if (slashedTypeName.equals("java/beans/ThreadGroupContext")) {
                this.threadGroupContextLoaded = true;
            }
        }
        return false;
    }

    @Override
    public byte[] modify(String slashedClassName, ClassLoader classLoader, byte[] bytes) {
        return null;
    }

    @Override
    public boolean shouldRerunStaticInitializer(String typename, Class<?> clazz, String encodedTimestamp) {
        return false;
    }
}

