/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.macro.Macro;
import org.radeox.macro.MacroLoader;
import org.radeox.macro.PluginRepository;

public class MacroRepository
extends PluginRepository {
    private static Log log = LogFactory.getLog(MacroRepository.class);
    protected static MacroRepository instance;
    protected List loaders = new ArrayList();

    public static synchronized MacroRepository getInstance() {
        if (null == instance) {
            instance = new MacroRepository();
        }
        return instance;
    }

    private void initialize(InitialRenderContext context) {
        for (Macro macro : this.list) {
            macro.setInitialContext(context);
        }
        this.init();
    }

    public void setInitialContext(InitialRenderContext context) {
        this.initialize(context);
    }

    private void init() {
        HashMap<String, Macro> newPlugins = new HashMap<String, Macro>();
        for (Macro macro : this.list) {
            newPlugins.put(macro.getName(), macro);
        }
        this.plugins = newPlugins;
    }

    private void load() {
        for (MacroLoader loader : this.loaders) {
            loader.setRepository(this);
            log.debug((Object)("Loading from: " + loader.getClass()));
            loader.loadPlugins(this);
        }
    }

    public void addLoader(MacroLoader loader) {
        loader.setRepository(this);
        this.loaders.add(loader);
        this.plugins = new HashMap();
        this.list = new ArrayList();
        this.load();
    }

    private MacroRepository() {
        this.loaders.add(new MacroLoader());
        this.load();
    }
}

