/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection.test;

import grails.test.mixin.TestFor;
import grails.test.mixin.domain.DomainClassUnitTestMixin;
import grails.test.mixin.services.ServiceUnitTestMixin;
import grails.test.mixin.support.MixinMethod;
import grails.test.mixin.web.ControllerUnitTestMixin;
import grails.test.mixin.web.FiltersUnitTestMixin;
import grails.test.mixin.web.GroovyPageUnitTestMixin;
import grails.test.mixin.web.UrlMappingsUnitTestMixin;
import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.GrailsNameUtils;
import groovy.util.GroovyTestCase;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.injection.test.TestMixinTransformation;
import org.codehaus.groovy.grails.compiler.logging.LoggingTransformer;
import org.codehaus.groovy.grails.core.io.DefaultResourceLocator;
import org.codehaus.groovy.grails.core.io.ResourceLocator;
import org.codehaus.groovy.grails.io.support.FileSystemResource;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.io.support.Resource;
import org.codehaus.groovy.grails.plugins.web.filters.FiltersConfigArtefactHandler;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class TestForTransformation
extends TestMixinTransformation {
    private static final ClassNode MY_TYPE = new ClassNode(TestFor.class);
    private static final Token ASSIGN = Token.newSymbol((String)"=", (int)-1, (int)-1);
    protected static final Map<String, Class> artefactTypeToTestMap = new HashMap<String, Class>();
    public static final String DOMAIN_TYPE = "Domain";
    public static final ClassNode BEFORE_CLASS_NODE;
    public static final AnnotationNode BEFORE_ANNOTATION;
    public static final ClassNode AFTER_CLASS_NODE;
    public static final AnnotationNode AFTER_ANNOTATION;
    public static final AnnotationNode TEST_ANNOTATION;
    public static final ClassNode GROOVY_TEST_CASE_CLASS;
    private ResourceLocator resourceLocator;
    private Map<ClassNode, List<Class>> wovenMixins = new HashMap<ClassNode, List<Class>>();

    public ResourceLocator getResourceLocator() {
        if (this.resourceLocator == null) {
            this.resourceLocator = new DefaultResourceLocator();
            BuildSettings buildSettings = BuildSettingsHolder.getSettings();
            String basedir = buildSettings != null ? buildSettings.getBaseDir().getAbsolutePath() : ".";
            this.resourceLocator.setSearchLocation(basedir);
        }
        return this.resourceLocator;
    }

    public void visit(ASTNode[] astNodes, SourceUnit source) {
        block17: {
            if (!(astNodes[0] instanceof AnnotationNode) || !(astNodes[1] instanceof AnnotatedNode)) {
                throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
            }
            AnnotatedNode parent = (AnnotatedNode)astNodes[1];
            AnnotationNode node = (AnnotationNode)astNodes[0];
            if (!MY_TYPE.equals((Object)node.getClassNode()) || !(parent instanceof ClassNode)) {
                return;
            }
            ClassNode classNode = (ClassNode)parent;
            if (classNode.isInterface() || Modifier.isAbstract(classNode.getModifiers())) {
                return;
            }
            boolean junit3Test = TestForTransformation.isJunit3Test(classNode);
            boolean spockTest = TestForTransformation.isSpockTest(classNode);
            boolean isJunit = classNode.getName().endsWith("Tests");
            if (!(junit3Test || spockTest || isJunit)) {
                return;
            }
            Expression value = node.getMember("value");
            if (value instanceof ClassExpression) {
                ClassExpression ce = (ClassExpression)value;
                this.testFor(classNode, ce);
            } else if (!junit3Test) {
                List annotations = classNode.getAnnotations(MY_TYPE);
                if (annotations.size() > 0) {
                    return;
                }
                String fileName = source.getName();
                String className = GrailsResourceUtils.getClassName((Resource)new FileSystemResource(fileName));
                if (className != null) {
                    org.springframework.core.io.Resource targetResource;
                    boolean isSpock = className.endsWith("Spec");
                    String targetClassName = null;
                    if (isJunit) {
                        targetClassName = className.substring(0, className.indexOf("Tests"));
                    } else if (isSpock) {
                        targetClassName = className.substring(0, className.indexOf("Spec"));
                    }
                    if (targetClassName != null && (targetResource = this.getResourceLocator().findResourceForClassName(targetClassName)) != null) {
                        try {
                            if (GrailsResourceUtils.isDomainClass((URL)targetResource.getURL())) {
                                this.testFor(classNode, new ClassExpression(new ClassNode(targetClassName, 0, ClassHelper.OBJECT_TYPE)));
                                break block17;
                            }
                            for (String artefactType : artefactTypeToTestMap.keySet()) {
                                if (!targetClassName.endsWith(artefactType)) continue;
                                this.testFor(classNode, new ClassExpression(new ClassNode(targetClassName, 0, ClassHelper.OBJECT_TYPE)));
                                break;
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public void testFor(ClassNode classNode, ClassExpression ce) {
        MethodNode methodToAdd;
        boolean isSpockTest;
        this.autoAnnotateSetupTeardown(classNode);
        boolean junit3Test = TestForTransformation.isJunit3Test(classNode);
        FieldNode log = classNode.getField("log");
        if (log == null || log.getDeclaringClass().equals((Object)GROOVY_TEST_CASE_CLASS)) {
            LoggingTransformer.addLogField((ClassNode)classNode, (String)classNode.getName());
        }
        if (!(isSpockTest = TestForTransformation.isSpockTest(classNode)) && !junit3Test) {
            Map declaredMethodsMap = classNode.getDeclaredMethodsMap();
            for (String methodName : declaredMethodsMap.keySet()) {
                MethodNode methodNode = (MethodNode)declaredMethodsMap.get(methodName);
                if (!this.isCandidateMethod(methodNode) || !methodNode.getName().startsWith("test") || methodNode.getAnnotations().size() != 0) continue;
                methodNode.addAnnotation(TEST_ANNOTATION);
            }
        }
        if ((methodToAdd = this.weaveMock(classNode, ce, true)) != null && junit3Test) {
            this.addMethodCallsToMethod(classNode, "setUp", Arrays.asList(methodToAdd));
        }
    }

    private void autoAnnotateSetupTeardown(ClassNode classNode) {
        MethodNode tearDown;
        MethodNode setupMethod = classNode.getMethod("setUp", GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (setupMethod != null && setupMethod.getAnnotations(BEFORE_CLASS_NODE).size() == 0) {
            setupMethod.addAnnotation(BEFORE_ANNOTATION);
        }
        if ((tearDown = classNode.getMethod("tearDown", GrailsArtefactClassInjector.ZERO_PARAMETERS)) != null && tearDown.getAnnotations(AFTER_CLASS_NODE).size() == 0) {
            tearDown.addAnnotation(AFTER_ANNOTATION);
        }
    }

    protected MethodNode weaveMock(ClassNode classNode, ClassExpression value, boolean isClassUnderTest) {
        ClassNode testTarget = value.getType();
        String className = testTarget.getName();
        MethodNode testForMethod = null;
        for (String artefactType : artefactTypeToTestMap.keySet()) {
            if (!className.endsWith(artefactType)) continue;
            Class mixinClass = artefactTypeToTestMap.get(artefactType);
            if (!this.isAlreadyWoven(classNode, mixinClass)) {
                this.weaveMixinClass(classNode, mixinClass);
                if (isClassUnderTest) {
                    testForMethod = this.addClassUnderTestMethod(classNode, value, artefactType);
                } else {
                    this.addMockCollaboratorToSetup(classNode, value, artefactType);
                }
                return testForMethod;
            }
            this.addMockCollaboratorToSetup(classNode, value, artefactType);
            return null;
        }
        this.weaveMixinClass(classNode, DomainClassUnitTestMixin.class);
        if (isClassUnderTest) {
            testForMethod = this.addClassUnderTestMethod(classNode, value, DOMAIN_TYPE);
        } else {
            this.addMockCollaboratorToSetup(classNode, value, DOMAIN_TYPE);
        }
        return testForMethod;
    }

    private void addMockCollaboratorToSetup(ClassNode classNode, ClassExpression targetClassExpression, String artefactType) {
        if (TestForTransformation.isJunit3Test(classNode)) {
            BlockStatement methodBody = this.getJunit3Setup(classNode);
            this.addMockCollaborator(artefactType, targetClassExpression, methodBody);
        } else {
            this.addToJunit4BeforeMethods(classNode, artefactType, targetClassExpression);
        }
    }

    private void addToJunit4BeforeMethods(ClassNode classNode, String artefactType, ClassExpression targetClassExpression) {
        Map declaredMethodsMap = classNode.getDeclaredMethodsMap();
        boolean weavedIntoBeforeMethods = false;
        for (MethodNode methodNode : declaredMethodsMap.values()) {
            if (!this.isDeclaredBeforeMethod(methodNode)) continue;
            Statement code = this.getMethodBody(methodNode);
            this.addMockCollaborator(artefactType, targetClassExpression, (BlockStatement)code);
            weavedIntoBeforeMethods = true;
        }
        if (!weavedIntoBeforeMethods) {
            BlockStatement junit4Setup = this.getJunit4Setup(classNode);
            this.addMockCollaborator(artefactType, targetClassExpression, junit4Setup);
        }
    }

    private Statement getMethodBody(MethodNode methodNode) {
        Statement code = methodNode.getCode();
        if (!(code instanceof BlockStatement)) {
            BlockStatement body = new BlockStatement();
            body.addStatement(code);
            code = body;
        }
        return code;
    }

    private boolean isDeclaredBeforeMethod(MethodNode methodNode) {
        return this.isPublicInstanceMethod(methodNode) && this.hasAnnotation(methodNode, Before.class) && !this.hasAnnotation(methodNode, MixinMethod.class);
    }

    private boolean isPublicInstanceMethod(MethodNode methodNode) {
        return !methodNode.isSynthetic() && !methodNode.isStatic() && methodNode.isPublic();
    }

    private BlockStatement getJunit4Setup(ClassNode classNode) {
        MethodNode setupMethod = classNode.getMethod("setUp", GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (setupMethod == null) {
            setupMethod = new MethodNode("setUp", 1, ClassHelper.VOID_TYPE, GrailsArtefactClassInjector.ZERO_PARAMETERS, null, (Statement)new BlockStatement());
            setupMethod.addAnnotation(MIXIN_METHOD_ANNOTATION);
            classNode.addMethod(setupMethod);
        }
        if (setupMethod.getAnnotations(BEFORE_CLASS_NODE).size() == 0) {
            setupMethod.addAnnotation(BEFORE_ANNOTATION);
        }
        return this.getOrCreateMethodBody(classNode, setupMethod, "setUp");
    }

    private BlockStatement getJunit3Setup(ClassNode classNode) {
        return this.getOrCreateNoArgsMethodBody(classNode, "setUp");
    }

    private boolean isAlreadyWoven(ClassNode classNode, Class mixinClass) {
        List<Class> mixinClasses = this.wovenMixins.get(classNode);
        if (mixinClasses == null) {
            mixinClasses = new ArrayList<Class>();
            mixinClasses.add(mixinClass);
            this.wovenMixins.put(classNode, mixinClasses);
        } else {
            if (mixinClasses.contains(mixinClass)) {
                return true;
            }
            mixinClasses.add(mixinClass);
        }
        return false;
    }

    protected void weaveMixinClass(ClassNode classNode, Class mixinClass) {
        ListExpression listExpression = new ListExpression();
        listExpression.addExpression((Expression)new ClassExpression(new ClassNode(mixinClass)));
        this.weaveMixinsIntoClass(classNode, listExpression);
    }

    protected MethodNode addClassUnderTestMethod(ClassNode classNode, ClassExpression targetClass, String type) {
        MethodNode getter;
        String methodName = "setup" + type + "UnderTest";
        String fieldName = GrailsNameUtils.getPropertyName((String)type);
        String getterName = GrailsNameUtils.getGetterName((String)fieldName);
        fieldName = '$' + fieldName;
        if (classNode.getField(fieldName) == null) {
            classNode.addField(fieldName, 2, targetClass.getType(), null);
        }
        MethodNode methodNode = classNode.getMethod(methodName, GrailsArtefactClassInjector.ZERO_PARAMETERS);
        VariableExpression fieldExpression = new VariableExpression(fieldName);
        if (methodNode == null) {
            BlockStatement setupMethodBody = new BlockStatement();
            this.addMockCollaborator(type, targetClass, setupMethodBody);
            methodNode = new MethodNode(methodName, 1, ClassHelper.VOID_TYPE, GrailsArtefactClassInjector.ZERO_PARAMETERS, null, (Statement)setupMethodBody);
            methodNode.addAnnotation(BEFORE_ANNOTATION);
            methodNode.addAnnotation(MIXIN_METHOD_ANNOTATION);
            classNode.addMethod(methodNode);
        }
        if ((getter = classNode.getMethod(getterName, GrailsArtefactClassInjector.ZERO_PARAMETERS)) == null) {
            BlockStatement getterBody = new BlockStatement();
            getter = new MethodNode(getterName, 1, targetClass.getType().getPlainNodeReference(), GrailsArtefactClassInjector.ZERO_PARAMETERS, null, (Statement)getterBody);
            BinaryExpression testTargetAssignment = new BinaryExpression((Expression)fieldExpression, ASSIGN, (Expression)new ConstructorCallExpression(targetClass.getType(), (Expression)GrailsArtefactClassInjector.ZERO_ARGS));
            IfStatement autowiringIfStatement = this.getAutowiringIfStatement(targetClass, fieldExpression, testTargetAssignment);
            getterBody.addStatement((Statement)autowiringIfStatement);
            getterBody.addStatement((Statement)new ReturnStatement((Expression)fieldExpression));
            classNode.addMethod(getter);
        }
        return methodNode;
    }

    private IfStatement getAutowiringIfStatement(ClassExpression targetClass, VariableExpression fieldExpression, BinaryExpression testTargetAssignment) {
        VariableExpression appCtxVar = new VariableExpression("applicationContext");
        BooleanExpression applicationContextCheck = new BooleanExpression((Expression)new BinaryExpression((Expression)new BinaryExpression((Expression)fieldExpression, GrailsASTUtils.EQUALS_OPERATOR, (Expression)GrailsASTUtils.NULL_EXPRESSION), Token.newSymbol((String)"&&", (int)0, (int)0), (Expression)new BinaryExpression((Expression)appCtxVar, GrailsASTUtils.NOT_EQUALS_OPERATOR, (Expression)GrailsASTUtils.NULL_EXPRESSION)));
        BlockStatement performAutowireBlock = new BlockStatement();
        ArgumentListExpression arguments = new ArgumentListExpression();
        arguments.addExpression((Expression)fieldExpression);
        arguments.addExpression((Expression)new ConstantExpression((Object)1));
        arguments.addExpression((Expression)new ConstantExpression((Object)false));
        BlockStatement assignFromApplicationContext = new BlockStatement();
        ArgumentListExpression argWithClassName = new ArgumentListExpression();
        MethodCallExpression getClassNameMethodCall = new MethodCallExpression((Expression)targetClass, "getName", (Expression)new ArgumentListExpression());
        argWithClassName.addExpression((Expression)getClassNameMethodCall);
        assignFromApplicationContext.addStatement((Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)fieldExpression, ASSIGN, (Expression)new MethodCallExpression((Expression)appCtxVar, "getBean", (Expression)argWithClassName))));
        BlockStatement elseBlock = new BlockStatement();
        elseBlock.addStatement((Statement)new ExpressionStatement((Expression)testTargetAssignment));
        performAutowireBlock.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)new MethodCallExpression((Expression)appCtxVar, "containsBean", (Expression)argWithClassName)), (Statement)assignFromApplicationContext, (Statement)elseBlock));
        performAutowireBlock.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new PropertyExpression((Expression)appCtxVar, "autowireCapableBeanFactory"), "autowireBeanProperties", (Expression)arguments)));
        return new IfStatement(applicationContextCheck, (Statement)performAutowireBlock, (Statement)new BlockStatement());
    }

    protected void addMockCollaborator(String mockType, ClassExpression targetClass, BlockStatement methodBody) {
        ArgumentListExpression args = new ArgumentListExpression();
        args.addExpression((Expression)targetClass);
        methodBody.getStatements().add(0, new ExpressionStatement((Expression)new MethodCallExpression((Expression)THIS_EXPRESSION, "mock" + mockType, (Expression)args)));
    }

    static {
        artefactTypeToTestMap.put("Controller", ControllerUnitTestMixin.class);
        artefactTypeToTestMap.put("TagLib", GroovyPageUnitTestMixin.class);
        artefactTypeToTestMap.put(FiltersConfigArtefactHandler.getTYPE().toString(), FiltersUnitTestMixin.class);
        artefactTypeToTestMap.put("UrlMappings", UrlMappingsUnitTestMixin.class);
        artefactTypeToTestMap.put("Service", ServiceUnitTestMixin.class);
        BEFORE_CLASS_NODE = new ClassNode(Before.class);
        BEFORE_ANNOTATION = new AnnotationNode(BEFORE_CLASS_NODE);
        AFTER_CLASS_NODE = new ClassNode(After.class);
        AFTER_ANNOTATION = new AnnotationNode(AFTER_CLASS_NODE);
        TEST_ANNOTATION = new AnnotationNode(new ClassNode(Test.class));
        GROOVY_TEST_CASE_CLASS = new ClassNode(GroovyTestCase.class);
    }
}

