/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.uaa.client.internal;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.springframework.uaa.client.UaaService;
import org.springframework.uaa.client.VersionHelper;
import org.springframework.uaa.client.internal.UaaConfigurationProcessor;
import org.springframework.uaa.client.protobuf.UaaClient;
import org.springframework.uaa.client.util.Assert;
import org.springframework.uaa.client.util.Base64;
import org.springframework.uaa.client.util.PreferencesUtils;
import org.springframework.uaa.client.util.StringUtils;

public class UaaServiceImpl
implements UaaService {
    static final Preferences P = PreferencesUtils.getPreferencesFor(UaaServiceImpl.class);
    private static final byte[] EMPTY = new byte[0];
    private static final String EMPTY_STRING = "";
    private static final String PRODUCT_PREFIX_VERSION_1 = "_UAA_";
    private static final String PRODUCT_PREFIX_VERSION_2 = "_UAA/2_";
    private static final String PRODUCT_CHUNK_PREFIX = "_CHUNK_";
    private static final String UIID_KEY = "uiid";
    private static final String PRIVACY_LEVEL_KEY = "privacy_level";
    private static final String UNCHANGED_SINCE_LAST_USER_AGENT_REQUEST = "unchanged_since_last_user_agent_request";
    private static final String MAXIMUM_DATA_AGE_KEY = "maximum_data_age";
    private static final String COMMUNICATION_RESTRICTED_DOMAINS = "communication_restricted_domains";
    static long MAXIMUM_DATA_AGE_DEFAULT = 15552000000L;
    private static final char SEPARATOR_CHAR = '_';
    private static final String SEPARATOR = Character.toString('_');
    private static final int UUID_LENGTH = 36;
    private static final int UUID_AND_SEPARATOR_LENGTH = 36 + SEPARATOR.length();
    private static final int MAX_VALUE_LENGTH = 8192 - UUID_AND_SEPARATOR_LENGTH;

    public UaaServiceImpl() {
        UaaConfigurationProcessor.updateConfiguration(UaaConfigurationProcessor.class.getResourceAsStream("/org/springframework/uaa/client/uaa-client.xml"), UaaConfigurationProcessor.class.getResourceAsStream("/org/springframework/uaa/client/uaa-client.xml.asc"));
    }

    public boolean isCommunicationRestricted(URL url) {
        if (url == null) {
            throw new IllegalStateException("URL required");
        }
        String data = P.get(COMMUNICATION_RESTRICTED_DOMAINS, EMPTY_STRING);
        if (EMPTY_STRING.equals(data)) {
            return true;
        }
        for (String domain : data.split(",")) {
            if (!url.getHost().endsWith(domain)) continue;
            return true;
        }
        return false;
    }

    public boolean isUaaTermsOfUseAccepted() {
        UaaClient.Privacy.PrivacyLevel privacyLevel = this.getPrivacyLevel();
        return privacyLevel != UaaClient.Privacy.PrivacyLevel.DECLINE_TOU && privacyLevel != UaaClient.Privacy.PrivacyLevel.UNDECIDED_TOU;
    }

    public void registerProductUsage(UaaClient.Product product) {
        this.registerProductUsage(product, null, null, false, false);
    }

    public void registerProductUsage(UaaClient.Product product, String projectId) {
        this.registerProductUsage(product, null, projectId, false, false);
    }

    public void registerProductUsage(UaaClient.Product product, byte[] productData) {
        this.registerProductUsage(product, productData, null, true, false);
    }

    public void registerProductUsage(UaaClient.Product product, byte[] productData, String projectId) {
        this.registerProductUsage(product, productData, projectId, true, false);
    }

    public void registerFeatureUsage(UaaClient.Product product, UaaClient.FeatureUse feature) {
        this.registerFeatureUsage(product, feature, null, false);
    }

    public void registerFeatureUsage(UaaClient.Product product, UaaClient.FeatureUse feature, byte[] featureData) {
        this.registerFeatureUsage(product, feature, featureData, true);
    }

    public String getReadablePayload() {
        return StringUtils.toString(this.createUaaEnvelope());
    }

    UaaClient.Privacy getPrivacy() {
        byte[] data = P.getByteArray(PRIVACY_LEVEL_KEY, EMPTY);
        if (EMPTY != data) {
            try {
                return UaaClient.Privacy.parseFrom(data);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
        return this.addDefaultPrivacyConfiguration();
    }

    public UaaClient.Privacy.PrivacyLevel getPrivacyLevel() {
        return this.getPrivacy().getPrivacyLevel();
    }

    public Date getPrivacyLevelLastChanged() {
        return new Date(this.getPrivacy().getDateLastChanged());
    }

    private UaaClient.Privacy addDefaultPrivacyConfiguration() {
        UaaClient.Privacy.Builder pb = UaaClient.Privacy.newBuilder();
        pb.setPrivacyLevel(UaaClient.Privacy.PrivacyLevel.UNDECIDED_TOU);
        pb.setDateLastChanged(new Date().getTime());
        UaaClient.Privacy privacy = pb.build();
        P.putByteArray(PRIVACY_LEVEL_KEY, privacy.toByteArray());
        this.recordChangesToStorage();
        return privacy;
    }

    public void setPrivacyLevel(UaaClient.Privacy.PrivacyLevel privacyLevel) {
        UaaClient.Privacy.Builder pb = UaaClient.Privacy.newBuilder();
        pb.setPrivacyLevel(privacyLevel);
        pb.setDateLastChanged(new Date().getTime());
        P.putByteArray(PRIVACY_LEVEL_KEY, pb.build().toByteArray());
        this.recordChangesToStorage();
    }

    protected UaaClient.UaaEnvelope createUaaEnvelope() {
        UaaClient.UaaEnvelope.Builder builder = UaaClient.UaaEnvelope.newBuilder();
        UUID installUuid = this.getUiid();
        builder.setInstallationIdentifierMostSignificantBits(installUuid.getMostSignificantBits());
        builder.setInstallationIdentifierLeastSignificantBits(installUuid.getLeastSignificantBits());
        builder.setPrivacy(this.getPrivacy());
        if (this.isUaaTermsOfUseAccepted()) {
            builder.setUserAgent(this.rebuildPersistedDetails(false));
        }
        this.recordNoChangesToStorage();
        return builder.build();
    }

    private UaaClient.UserAgent rebuildPersistedDetails(boolean deleteAll) {
        String[] keys;
        long time = System.currentTimeMillis();
        long deleteEntriesOlderThan = time - P.getLong(MAXIMUM_DATA_AGE_KEY, MAXIMUM_DATA_AGE_DEFAULT);
        if (deleteAll) {
            deleteEntriesOlderThan = System.currentTimeMillis();
        }
        UaaClient.UserAgent.Builder builder = UaaClient.UserAgent.newBuilder();
        UaaClient.Privacy.PrivacyLevel privacyLevel = this.getPrivacyLevel();
        this.getUiid();
        if (privacyLevel.equals((Object)UaaClient.Privacy.PrivacyLevel.ENABLE_UAA) || privacyLevel.equals((Object)UaaClient.Privacy.PrivacyLevel.LIMITED_DATA)) {
            builder.setUserCountry(System.getProperty("user.country"));
            builder.setUserLanguage(System.getProperty("user.language"));
        }
        this.registerInfrastructureProducts();
        try {
            P.sync();
            keys = P.keys();
        }
        catch (BackingStoreException bse) {
            throw new IllegalStateException("Backing store failure for UAA", bse);
        }
        for (String key : keys) {
            UaaClient.ProductUse pu;
            String data;
            if (!key.startsWith(PRODUCT_PREFIX_VERSION_1) && !key.startsWith(PRODUCT_PREFIX_VERSION_2) || key.startsWith(PRODUCT_PREFIX_VERSION_2) && key.contains(PRODUCT_CHUNK_PREFIX) || EMPTY_STRING.equals(data = P.get(key, EMPTY_STRING))) continue;
            try {
                pu = this.loadProductUse(key);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not decode '" + key + "' from preferences", e);
            }
            if (pu.getDateLastUsed() < deleteEntriesOlderThan) {
                P.remove(key);
                continue;
            }
            UaaClient.ProductUse.Builder replacementProductUse = UaaClient.ProductUse.newBuilder(pu);
            ArrayList<UaaClient.FeatureUse> newFeatures = new ArrayList<UaaClient.FeatureUse>();
            for (UaaClient.FeatureUse existing : replacementProductUse.getFeatureUseList()) {
                if (existing.getDateLastUsed() < deleteEntriesOlderThan) continue;
                newFeatures.add(existing);
            }
            replacementProductUse.clearFeatureUse();
            replacementProductUse.addAllFeatureUse(newFeatures);
            ArrayList<UaaClient.Project> newProjects = new ArrayList<UaaClient.Project>();
            for (UaaClient.Project existing : replacementProductUse.getProjectsUsingList()) {
                if (existing.getDateLastUsed() < deleteEntriesOlderThan) continue;
                newProjects.add(existing);
            }
            replacementProductUse.clearProjectsUsing();
            replacementProductUse.addAllProjectsUsing(newProjects);
            pu = this.saveProductUse(replacementProductUse);
            if (privacyLevel.equals((Object)UaaClient.Privacy.PrivacyLevel.ENABLE_UAA)) {
                builder.addProductUse(pu);
                continue;
            }
            if (!privacyLevel.equals((Object)UaaClient.Privacy.PrivacyLevel.LIMITED_DATA)) continue;
            UaaClient.ProductUse.Builder reducedProductUse = UaaClient.ProductUse.newBuilder(pu);
            reducedProductUse.clearProductData();
            reducedProductUse.clearDateLastUsed();
            reducedProductUse.clearProjectsUsing();
            reducedProductUse.clearFeatureUse();
            List<UaaClient.FeatureUse> features = pu.getFeatureUseList();
            for (UaaClient.FeatureUse feature : features) {
                UaaClient.FeatureUse.Builder fub = UaaClient.FeatureUse.newBuilder(feature);
                fub.clearDateLastUsed();
                fub.clearFeatureData();
                reducedProductUse.addFeatureUse(fub.build());
            }
            builder.addProductUse(reducedProductUse.build());
        }
        return builder.build();
    }

    UUID getUiid() {
        String uuidString = P.get(UIID_KEY, EMPTY_STRING);
        if (!EMPTY_STRING.equals(uuidString)) {
            try {
                return UUID.fromString(uuidString);
            }
            catch (RuntimeException ignoreAndRecreateBelow) {
                // empty catch block
            }
        }
        UUID uuid = UUID.randomUUID();
        P.put(UIID_KEY, uuid.toString());
        this.recordChangesToStorage();
        return uuid;
    }

    String getKey(UaaClient.Product product) {
        Assert.notNull((Object)product, "Product required");
        Assert.hasLength(product.getName(), "Product name missing");
        Assert.notNull(product.getReleaseQualifier(), "Product release qualifier null for '" + ((Object)((Object)product)).toString() + "'");
        String ver = product.getMajorVersion() + "." + product.getMinorVersion() + "." + product.getPatchVersion() + "." + "." + product.getReleaseQualifier();
        String key = product.getName() + " " + ver;
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] digest = sha1.digest(key.getBytes("UTF-8"));
            return PRODUCT_PREFIX_VERSION_2 + Base64.encodeBytes(digest);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return key;
    }

    private UaaClient.ProductUse.Builder loadProductUse(UaaClient.Product product) {
        String key = this.getKey(product);
        UaaClient.ProductUse pu = this.loadProductUse(key);
        if (pu != null) {
            return pu.toBuilder();
        }
        UaaClient.ProductUse.Builder result = UaaClient.ProductUse.newBuilder();
        result.setProduct(product);
        return result;
    }

    private UaaClient.ProductUse loadProductUse(String key) {
        String data = P.get(key, EMPTY_STRING);
        if (!EMPTY_STRING.equals(data)) {
            try {
                StringBuilder builder = new StringBuilder();
                while (!EMPTY_STRING.equals(data)) {
                    if (data.length() > UUID_AND_SEPARATOR_LENGTH && data.charAt(36) == '_') {
                        String uuid = data.substring(0, 36);
                        builder.append(data.substring(UUID_AND_SEPARATOR_LENGTH));
                        data = P.get(key + PRODUCT_CHUNK_PREFIX + uuid, EMPTY_STRING);
                        continue;
                    }
                    builder.append(data);
                    data = EMPTY_STRING;
                }
                return UaaClient.ProductUse.parseFrom(Base64.decode(builder.toString()));
            }
            catch (InvalidProtocolBufferException ipe) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private UaaClient.ProductUse saveProductUse(UaaClient.ProductUse.Builder productUse) {
        UaaClient.ProductUse pu = productUse.build();
        String key = this.getKey(pu.getProduct());
        try {
            byte[] bytes = pu.toByteArray();
            String compressed = Base64.encodeBytes(bytes, 2);
            String uncompressed = Base64.encodeBytes(bytes, 0);
            String productUseBase64 = null;
            productUseBase64 = compressed.length() < uncompressed.length() ? compressed : uncompressed;
            String uuid = null;
            for (int i = 0; i < productUseBase64.length(); i += MAX_VALUE_LENGTH) {
                String chunkKey;
                String chunk = productUseBase64.substring(i, Math.min(productUseBase64.length(), i + MAX_VALUE_LENGTH));
                String string = chunkKey = uuid != null ? key + PRODUCT_CHUNK_PREFIX + uuid : key;
                if (i + MAX_VALUE_LENGTH < productUseBase64.length()) {
                    uuid = UUID.randomUUID().toString();
                    P.put(chunkKey, uuid + SEPARATOR + chunk);
                    continue;
                }
                uuid = null;
                P.put(chunkKey, chunk);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error zipping base64 encoded byte[]", e);
        }
        return pu;
    }

    private void registerInfrastructureProducts() {
        this.registerProductUsage(VersionHelper.getJvm(), null, null, false, true);
        this.registerProductUsage(VersionHelper.getOs(), null, null, false, true);
        this.registerProductUsage(VersionHelper.getUaa(), null, null, false, true);
    }

    private void registerProductUsage(UaaClient.Product product, byte[] productData, String projectId, boolean replace, boolean infrastructure) {
        Assert.notNull((Object)product, "Product required");
        if (projectId == null) {
            projectId = EMPTY_STRING;
        }
        this.recordChangesToStorage();
        this.getUiid();
        UaaClient.Privacy.PrivacyLevel privacyLevel = this.getPrivacyLevel();
        if (privacyLevel.equals((Object)UaaClient.Privacy.PrivacyLevel.UNDECIDED_TOU) || privacyLevel.equals((Object)UaaClient.Privacy.PrivacyLevel.DECLINE_TOU)) {
            return;
        }
        if (!infrastructure) {
            this.registerInfrastructureProducts();
        }
        UaaClient.ProductUse.Builder builder = this.loadProductUse(product);
        long time = System.currentTimeMillis();
        builder.setDateLastUsed(time);
        if (!EMPTY_STRING.equals(projectId)) {
            UaaClient.Project.Builder projectBuilder = UaaClient.Project.newBuilder();
            projectBuilder.setDateLastUsed(time);
            try {
                MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                byte[] digest = sha256.digest(projectId.getBytes());
                projectBuilder.setProjectSha256Hash(ByteString.copyFrom((byte[])digest));
            }
            catch (Throwable hashingFailure) {
                projectBuilder.setProjectSha256Hash(ByteString.copyFrom((byte[])"0000000000000000000".getBytes()));
            }
            boolean replaced = false;
            for (int i = 0; i < builder.getProjectsUsingCount(); ++i) {
                UaaClient.Project existing = builder.getProjectsUsing(i);
                if (!existing.getProjectSha256Hash().equals((Object)projectBuilder.getProjectSha256Hash())) continue;
                builder.setProjectsUsing(i, projectBuilder);
                replaced = true;
                break;
            }
            if (!replaced) {
                builder.addProjectsUsing(projectBuilder);
            }
        }
        if (replace && productData != null) {
            builder.setProductData(ByteString.copyFrom((byte[])productData));
        }
        this.saveProductUse(builder);
    }

    private void registerFeatureUsage(UaaClient.Product product, UaaClient.FeatureUse feature, byte[] featureData, boolean replace) {
        Assert.notNull((Object)product, "Product required");
        Assert.notNull((Object)feature, "Feature required for product '" + product.getName() + "'");
        Assert.isTrue(!"__PRODUCT__".equals(feature.getName()), "Feature name is reserved for UAA internal use");
        this.recordChangesToStorage();
        this.getUiid();
        UaaClient.Privacy.PrivacyLevel privacyLevel = this.getPrivacyLevel();
        if (privacyLevel.equals((Object)UaaClient.Privacy.PrivacyLevel.UNDECIDED_TOU) || privacyLevel.equals((Object)UaaClient.Privacy.PrivacyLevel.DECLINE_TOU)) {
            return;
        }
        this.registerInfrastructureProducts();
        UaaClient.ProductUse.Builder builder = this.loadProductUse(product);
        long time = System.currentTimeMillis();
        builder.setDateLastUsed(time);
        String featureName = feature.getName();
        UaaClient.FeatureUse.Builder fu = UaaClient.FeatureUse.newBuilder(feature);
        fu.setDateLastUsed(time);
        if (replace && featureData != null) {
            fu.setFeatureData(ByteString.copyFrom((byte[])featureData));
        }
        boolean replaced = false;
        for (int i = 0; i < builder.getFeatureUseCount(); ++i) {
            UaaClient.FeatureUse existing = builder.getFeatureUse(i);
            if (!existing.getName().equals(featureName)) continue;
            if (!replace) {
                fu.setFeatureData(existing.getFeatureData());
            }
            builder.setFeatureUse(i, fu);
            replaced = true;
            break;
        }
        if (!replaced) {
            builder.addFeatureUse(fu);
        }
        this.saveProductUse(builder);
    }

    private void recordChangesToStorage() {
        P.putBoolean(UNCHANGED_SINCE_LAST_USER_AGENT_REQUEST, false);
        try {
            P.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private void recordNoChangesToStorage() {
        P.putBoolean(UNCHANGED_SINCE_LAST_USER_AGENT_REQUEST, true);
        try {
            P.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    UaaClient.UserAgent clearIfPossible() {
        if (P.getBoolean(UNCHANGED_SINCE_LAST_USER_AGENT_REQUEST, false)) {
            this.recordChangesToStorage();
            return this.rebuildPersistedDetails(true);
        }
        return this.rebuildPersistedDetails(false);
    }

    void clearPreferences() {
        try {
            P.clear();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    int keyCount() {
        try {
            return P.keys().length;
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    boolean isDatabaseClean() {
        return P.getBoolean(UNCHANGED_SINCE_LAST_USER_AGENT_REQUEST, false);
    }
}

