/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.grails.datastore.gorm.config.GrailsDomainClassMappingContext;
import org.grails.datastore.gorm.config.GrailsDomainClassPersistentProperty;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.ManyToOne;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.OneToOne;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsDomainClassPersistentEntity
implements PersistentEntity {
    private GrailsDomainClass domainClass;
    private GrailsDomainClassMappingContext mappingContext;
    private GrailsDomainClassPersistentProperty identifier;
    private GrailsDomainClassPersistentProperty version;
    private Map<String, PersistentProperty> propertiesByName = new HashMap<String, PersistentProperty>();
    private List<PersistentProperty> properties = new ArrayList<PersistentProperty>();
    private List<Association> associations = new ArrayList<Association>();

    public GrailsDomainClassPersistentEntity(GrailsDomainClass domainClass, GrailsDomainClassMappingContext mappingContext) {
        this.domainClass = domainClass;
        this.mappingContext = mappingContext;
    }

    public GrailsDomainClass getDomainClass() {
        return this.domainClass;
    }

    public void initialize() {
        GrailsDomainClassProperty[] persistentProperties;
        this.identifier = new GrailsDomainClassPersistentProperty(this, this.domainClass.getIdentifier());
        this.version = new GrailsDomainClassPersistentProperty(this, this.domainClass.getVersion());
        this.mappingContext.addEntityValidator(this, this.domainClass.getValidator());
        for (GrailsDomainClassProperty grailsDomainClassProperty : persistentProperties = this.domainClass.getPersistentProperties()) {
            Object persistentProperty = grailsDomainClassProperty.isAssociation() ? (grailsDomainClassProperty.isEmbedded() ? this.createEmbedded(this.mappingContext, grailsDomainClassProperty) : (grailsDomainClassProperty.isOneToMany() ? this.createOneToMany(this.mappingContext, grailsDomainClassProperty) : (grailsDomainClassProperty.isHasOne() ? this.createOneToOne(this.mappingContext, grailsDomainClassProperty) : (grailsDomainClassProperty.isOneToOne() ? this.createOneToOne(this.mappingContext, grailsDomainClassProperty) : (grailsDomainClassProperty.isManyToOne() ? this.createManyToOne(this.mappingContext, grailsDomainClassProperty) : (grailsDomainClassProperty.isManyToMany() ? this.createManyToMany(this.mappingContext, grailsDomainClassProperty) : new GrailsDomainClassPersistentProperty(this, grailsDomainClassProperty))))))) : new GrailsDomainClassPersistentProperty(this, grailsDomainClassProperty);
            this.propertiesByName.put(grailsDomainClassProperty.getName(), (PersistentProperty)persistentProperty);
            this.properties.add((PersistentProperty)persistentProperty);
        }
    }

    public String getName() {
        return this.domainClass.getFullName();
    }

    public PersistentProperty getIdentity() {
        return this.identifier;
    }

    public PersistentProperty getVersion() {
        return this.version;
    }

    public boolean isVersioned() {
        return this.version != null;
    }

    public List<PersistentProperty> getPersistentProperties() {
        return this.properties;
    }

    public List<Association> getAssociations() {
        return this.associations;
    }

    public PersistentProperty getPropertyByName(String name) {
        return this.propertiesByName.get(name);
    }

    public Class getJavaClass() {
        return this.domainClass.getClazz();
    }

    public boolean isInstance(Object obj) {
        return this.domainClass.getClazz().isInstance(obj);
    }

    public ClassMapping getMapping() {
        return null;
    }

    public Object newInstance() {
        return this.domainClass.newInstance();
    }

    public List<String> getPersistentPropertyNames() {
        return new ArrayList<String>(this.propertiesByName.keySet());
    }

    public String getDecapitalizedName() {
        return this.domainClass.getLogicalPropertyName();
    }

    public boolean isOwningEntity(PersistentEntity owner) {
        return this.domainClass.isOwningClass(owner.getJavaClass());
    }

    public PersistentEntity getParentEntity() {
        if (!this.isRoot()) {
            return this.getMappingContext().getPersistentEntity(this.getJavaClass().getSuperclass().getName());
        }
        return null;
    }

    public PersistentEntity getRootEntity() {
        if (this.isRoot() || this.getParentEntity() == null) {
            return this;
        }
        PersistentEntity parent = this.getParentEntity();
        while (!parent.isRoot()) {
            parent = parent.getParentEntity();
        }
        return parent;
    }

    public boolean isRoot() {
        return this.domainClass.isRoot();
    }

    public String getDiscriminator() {
        return this.getName();
    }

    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    public boolean hasProperty(String name, Class type) {
        return this.domainClass.hasProperty(name);
    }

    public boolean isIdentityName(String propertyName) {
        return this.domainClass.getIdentifier().getName().equals(propertyName);
    }

    private PersistentProperty createManyToOne(GrailsDomainClassMappingContext ctx, GrailsDomainClassProperty grailsDomainClassProperty) {
        ManyToOne oneToOne = new ManyToOne(this, (MappingContext)ctx, grailsDomainClassProperty.getName(), grailsDomainClassProperty.getType()){

            public PropertyMapping getMapping() {
                return null;
            }
        };
        this.configureAssociation(grailsDomainClassProperty, (Association)oneToOne);
        return oneToOne;
    }

    private PersistentProperty createManyToMany(GrailsDomainClassMappingContext ctx, GrailsDomainClassProperty grailsDomainClassProperty) {
        ManyToMany manyToMany = new ManyToMany(this, (MappingContext)ctx, grailsDomainClassProperty.getName(), grailsDomainClassProperty.getType()){

            public PropertyMapping getMapping() {
                return null;
            }
        };
        this.configureAssociation(grailsDomainClassProperty, (Association)manyToMany);
        return manyToMany;
    }

    private PersistentProperty createOneToOne(GrailsDomainClassMappingContext ctx, GrailsDomainClassProperty grailsDomainClassProperty) {
        OneToOne oneToOne = new OneToOne(this, (MappingContext)ctx, grailsDomainClassProperty.getName(), grailsDomainClassProperty.getType()){

            public PropertyMapping getMapping() {
                return null;
            }
        };
        this.configureAssociation(grailsDomainClassProperty, (Association)oneToOne);
        return oneToOne;
    }

    private OneToMany createOneToMany(GrailsDomainClassMappingContext mappingContext, GrailsDomainClassProperty grailsDomainClassProperty) {
        OneToMany oneToMany = new OneToMany(this, (MappingContext)mappingContext, grailsDomainClassProperty.getName(), grailsDomainClassProperty.getType()){

            public PropertyMapping getMapping() {
                return null;
            }
        };
        this.configureAssociation(grailsDomainClassProperty, (Association)oneToMany);
        return oneToMany;
    }

    private void configureAssociation(GrailsDomainClassProperty grailsDomainClassProperty, Association association) {
        association.setAssociatedEntity(this.getMappingContext().addPersistentEntity(grailsDomainClassProperty.getReferencedPropertyType()));
        association.setOwningSide(grailsDomainClassProperty.isOwningSide());
        association.setReferencedPropertyName(grailsDomainClassProperty.getReferencedPropertyName());
    }

    private PersistentProperty createEmbedded(GrailsDomainClassMappingContext mappingContext, GrailsDomainClassProperty grailsDomainClassProperty) {
        Embedded persistentProperty = new Embedded(this, (MappingContext)mappingContext, grailsDomainClassProperty.getName(), grailsDomainClassProperty.getClass()){

            public PropertyMapping getMapping() {
                return null;
            }
        };
        persistentProperty.setOwningSide(grailsDomainClassProperty.isOwningSide());
        persistentProperty.setReferencedPropertyName(grailsDomainClassProperty.getReferencedPropertyName());
        return persistentProperty;
    }

    public boolean isExternal() {
        return false;
    }

    public void setExternal(boolean external) {
    }
}

