/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.metaclass;

import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.MetaClass;
import org.codehaus.groovy.grails.commons.metaclass.ClosureInvokingDynamicMethod;
import org.codehaus.groovy.grails.commons.metaclass.DefaultDynamicMethods;
import org.codehaus.groovy.grails.commons.metaclass.DynamicMethods;
import org.codehaus.groovy.grails.commons.metaclass.InvocationCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicMethodsExpandoMetaClass
extends ExpandoMetaClass {
    private DynamicMethods dynamicMethods;
    private static final String REGEX_START = "^";
    private static final String REGEX_END = "$";

    public DynamicMethodsExpandoMetaClass(Class<?> aClass) {
        super(aClass, false, true);
        this.dynamicMethods = new DefaultDynamicMethods(aClass);
    }

    public DynamicMethodsExpandoMetaClass(Class<?> aClass, boolean inReg) {
        super(aClass, false, true);
        this.dynamicMethods = new DefaultDynamicMethods(aClass);
        if (inReg) {
            this.registry.setMetaClass(aClass, (MetaClass)this);
        }
    }

    public Object invokeStaticMethod(Object target, String methodName, Object[] arguments) {
        InvocationCallback callback = new InvocationCallback();
        Object returnValue = this.dynamicMethods.invokeStaticMethod(target, methodName, arguments, callback);
        if (callback.isInvoked()) {
            return returnValue;
        }
        return super.invokeStaticMethod(target, methodName, arguments);
    }

    public void setProperty(Class aClass, Object object, String property, Object newValue, boolean b, boolean b1) {
        InvocationCallback callback = new InvocationCallback();
        this.dynamicMethods.setProperty(object, property, newValue, callback);
        if (!callback.isInvoked()) {
            super.setProperty(aClass, object, property, newValue, b, b1);
        }
    }

    public Object getProperty(Class aClass, Object object, String property, boolean b, boolean b1) {
        InvocationCallback callback = new InvocationCallback();
        Object returnValue = this.dynamicMethods.getProperty(object, property, callback);
        if (callback.isInvoked()) {
            return returnValue;
        }
        return super.getProperty(aClass, object, property, b, b1);
    }

    public Object invokeConstructor(Object[] arg0) {
        InvocationCallback callback = new InvocationCallback();
        Object instance = this.dynamicMethods.invokeConstructor(arg0, callback);
        if (callback.isInvoked()) {
            return instance;
        }
        return super.invokeConstructor(arg0);
    }

    public Object invokeMethod(Class aClass, Object target, String methodName, Object[] arguments, boolean b, boolean b1) {
        InvocationCallback callback = new InvocationCallback();
        Object returnValue = this.dynamicMethods.invokeMethod(target, methodName, arguments, callback);
        if (callback.isInvoked()) {
            return returnValue;
        }
        return super.invokeMethod(aClass, target, methodName, arguments, b, b1);
    }

    public Object getProperty(String name) {
        Object propertyValue = super.getProperty(name);
        if (propertyValue instanceof ExpandoMetaClass.ExpandoMetaProperty) {
            return new DynamicExpandoMetaProperty((ExpandoMetaClass.ExpandoMetaProperty)propertyValue);
        }
        return propertyValue;
    }

    public void setProperty(String name, Object value) {
        if (this.isRegexMethod(name, value)) {
            this.dynamicMethods.addDynamicMethodInvocation(new ClosureInvokingDynamicMethod(name, (Closure)value));
        } else {
            super.setProperty(name, value);
        }
    }

    private boolean isRegexMethod(String name, Object value) {
        return name.startsWith(REGEX_START) && name.endsWith(REGEX_END) && value instanceof Closure;
    }

    class DynamicExpandoMetaProperty
    extends ExpandoMetaClass.ExpandoMetaProperty {
        private DynamicExpandoMetaProperty(ExpandoMetaClass.ExpandoMetaProperty wrapped) {
            super((ExpandoMetaClass)DynamicMethodsExpandoMetaClass.this, wrapped.getPropertyName(), wrapped.isStatic());
        }

        public Object leftShift(Object arg) {
            if (DynamicMethodsExpandoMetaClass.this.isRegexMethod(this.propertyName, arg)) {
                this.registerDynamicMethodInvocation(this.propertyName, arg);
                return this;
            }
            return super.leftShift(arg);
        }

        private void registerDynamicMethodInvocation(String name, Object newValue) {
            if (this.isStatic) {
                DynamicMethodsExpandoMetaClass.this.dynamicMethods.addStaticMethodInvocation(new ClosureInvokingDynamicMethod(name, (Closure)newValue));
            } else {
                DynamicMethodsExpandoMetaClass.this.dynamicMethods.addDynamicMethodInvocation(new ClosureInvokingDynamicMethod(name, (Closure)newValue));
            }
        }

        public void setProperty(String property, Object newValue) {
            if (DynamicMethodsExpandoMetaClass.this.isRegexMethod(property, newValue)) {
                this.registerDynamicMethodInvocation(property, newValue);
            } else if (newValue instanceof Closure) {
                if (this.isStatic) {
                    DynamicMethodsExpandoMetaClass.this.registerStaticMethod(property, (Closure)newValue);
                } else {
                    DynamicMethodsExpandoMetaClass.this.registerInstanceMethod(property, (Closure)newValue);
                }
            }
        }
    }
}

