/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.factory;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.ConditionalFlowExecutionListenerHolder;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteria;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteriaFactory;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;

public class ConditionalFlowExecutionListenerLoader
implements FlowExecutionListenerLoader {
    private final Log logger;
    private List listeners;
    static /* synthetic */ Class class$0;

    public ConditionalFlowExecutionListenerLoader() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.execution.factory.ConditionalFlowExecutionListenerLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.listeners = new LinkedList();
    }

    public void addListener(FlowExecutionListener listener, FlowExecutionListenerCriteria criteria) {
        ConditionalFlowExecutionListenerHolder conditional;
        if (listener == null) {
            throw new IllegalArgumentException("The flow execution listener cannot be null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding flow execution listener " + listener + " with criteria " + criteria));
        }
        if ((conditional = this.getHolder(listener)) == null) {
            conditional = new ConditionalFlowExecutionListenerHolder(listener);
            this.listeners.add(conditional);
        }
        if (criteria == null) {
            criteria = new FlowExecutionListenerCriteriaFactory().allFlows();
        }
        conditional.add(criteria);
    }

    public FlowExecutionListener[] getListeners(FlowDefinition flowDefinition) {
        Assert.notNull((Object)flowDefinition, (String)"The Flow to load listeners for cannot be null");
        LinkedList<FlowExecutionListener> listenersToAttach = new LinkedList<FlowExecutionListener>();
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder listenerHolder = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!listenerHolder.listenerAppliesTo(flowDefinition)) continue;
            listenersToAttach.add(listenerHolder.getListener());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loaded [" + listenersToAttach.size() + "] of possible " + this.listeners.size() + " listeners for this execution request for flow '" + flowDefinition.getId() + "', the listeners to attach are " + StylerUtils.style(listenersToAttach)));
        }
        return listenersToAttach.toArray(new FlowExecutionListener[listenersToAttach.size()]);
    }

    private ConditionalFlowExecutionListenerHolder getHolder(FlowExecutionListener listener) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder next = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!next.getListener().equals(listener)) continue;
            return next;
        }
        return null;
    }
}

