/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.validation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.StringUtils;
import org.springframework.validation.MessageCodesResolver;

public class WebFlowMessageCodesResolver
implements MessageCodesResolver {
    public static final String CODE_SEPARATOR = ".";
    private String prefix = "";

    public void setPrefix(String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public String[] resolveMessageCodes(String errorCode, String objectName) {
        return new String[]{this.postProcessMessageCode(String.valueOf(objectName) + CODE_SEPARATOR + errorCode), this.postProcessMessageCode(errorCode)};
    }

    public String[] resolveMessageCodes(String errorCode, String objectName, String field, Class fieldType) {
        ArrayList<String> codeList = new ArrayList<String>();
        ArrayList fieldList = new ArrayList();
        this.buildFieldList(field, fieldList);
        Iterator it = fieldList.iterator();
        while (it.hasNext()) {
            String fieldInList = (String)it.next();
            codeList.add(this.postProcessMessageCode(String.valueOf(objectName) + CODE_SEPARATOR + fieldInList + CODE_SEPARATOR + errorCode));
        }
        int dotIndex = field.lastIndexOf(46);
        if (dotIndex != -1) {
            this.buildFieldList(field.substring(dotIndex + 1), fieldList);
        }
        Iterator it2 = fieldList.iterator();
        while (it2.hasNext()) {
            String fieldInList = (String)it2.next();
            codeList.add(this.postProcessMessageCode(String.valueOf(fieldInList) + CODE_SEPARATOR + errorCode));
        }
        if (fieldType != null) {
            codeList.add(this.postProcessMessageCode(String.valueOf(fieldType.getName()) + CODE_SEPARATOR + errorCode));
        }
        codeList.add(this.postProcessMessageCode(errorCode));
        return StringUtils.toStringArray(codeList);
    }

    protected void buildFieldList(String field, List fieldList) {
        fieldList.add(field);
        String plainField = field;
        int keyIndex = plainField.lastIndexOf(91);
        while (keyIndex != -1) {
            int endKeyIndex = plainField.indexOf(93, keyIndex);
            if (endKeyIndex != -1) {
                plainField = String.valueOf(plainField.substring(0, keyIndex)) + plainField.substring(endKeyIndex + 1);
                fieldList.add(plainField);
                keyIndex = plainField.lastIndexOf(91);
                continue;
            }
            keyIndex = -1;
        }
    }

    protected String postProcessMessageCode(String code) {
        return String.valueOf(this.getPrefix()) + code;
    }
}

