/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.webflow.persistence;

import org.hibernate.HibernateException;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.springframework.orm.hibernate3.SpringSessionContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowAwareCurrentSessionContext
extends SpringSessionContext {
    private static final long serialVersionUID = -836141275847835219L;

    public FlowAwareCurrentSessionContext(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    public Session currentSession() throws HibernateException {
        try {
            RequestContext requestContext = RequestContextHolder.getRequestContext();
            Session s = null;
            if (requestContext != null) {
                FlowExecutionContext context = requestContext.getFlowExecutionContext();
                MutableAttributeMap flowScope = context.getActiveSession().getScope();
                s = (Session)flowScope.get("persistenceContext", org.hibernate.Session.class);
            }
            return s == null ? super.currentSession() : s;
        }
        catch (IllegalStateException e) {
            return super.currentSession();
        }
    }
}

