/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DefaultDocLink;
import org.gradle.api.problems.internal.DefaultFileLocation;
import org.gradle.api.problems.internal.DefaultLineInFileLocation;
import org.gradle.api.problems.internal.DefaultOffsetInFileLocation;
import org.gradle.api.problems.internal.DefaultPluginIdLocation;
import org.gradle.api.problems.internal.DefaultProblem;
import org.gradle.api.problems.internal.DefaultProblemCategory;
import org.gradle.api.problems.internal.DefaultTaskPathLocation;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemCategory;
import org.gradle.api.problems.internal.ProblemLocation;

public class DefaultProblemBuilder
implements InternalProblemBuilder {
    private final String namespace;
    private String label;
    private ProblemCategory category;
    private Severity severity;
    private final List<ProblemLocation> locations;
    private String details;
    private DocLink docLink;
    private List<String> solutions;
    private RuntimeException exception;
    private final Map<String, Object> additionalData;
    private boolean collectLocation = false;

    public DefaultProblemBuilder(Problem problem) {
        this.label = problem.getLabel();
        this.category = problem.getCategory();
        this.severity = problem.getSeverity();
        this.locations = new ArrayList<ProblemLocation>(problem.getLocations());
        this.details = problem.getDetails();
        this.docLink = problem.getDocumentationLink();
        this.solutions = new ArrayList<String>(problem.getSolutions());
        this.exception = problem.getException();
        this.additionalData = new HashMap<String, Object>(problem.getAdditionalData());
        this.namespace = problem.getCategory().getNamespace();
    }

    public DefaultProblemBuilder(String namespace) {
        this.namespace = namespace;
        this.locations = new ArrayList<ProblemLocation>();
        this.additionalData = new HashMap<String, Object>();
    }

    @Override
    public Problem build() {
        if (this.label == null) {
            return this.missingLabelProblem();
        }
        if (this.category == null) {
            return this.missingCategoryProblem();
        }
        for (Object value : this.additionalData.values()) {
            if (value instanceof String) continue;
            return this.invalidProblem("ProblemBuilder.additionalData() supports values of type String, but " + value.getClass().getName() + " as given.", "invalid-additional-data");
        }
        return new DefaultProblem(this.label, this.getSeverity(), this.locations, this.docLink, this.details, this.solutions, this.getExceptionForProblemInstantiation(), this.category, this.additionalData);
    }

    private Problem missingLabelProblem() {
        return this.invalidProblem("problem label must be specified", "missing-label");
    }

    private Problem missingCategoryProblem() {
        return this.invalidProblem("problem category must be specified", "missing-category");
    }

    private Problem invalidProblem(String label, String subcategory) {
        this.category("validation", "problems-api", subcategory).stackLocation();
        return new DefaultProblem(label, Severity.WARNING, Collections.<ProblemLocation>emptyList(), null, null, null, this.getExceptionForProblemInstantiation(), this.category, Collections.<String, Object>emptyMap());
    }

    public RuntimeException getExceptionForProblemInstantiation() {
        return this.getException() == null && this.collectLocation ? new RuntimeException() : this.getException();
    }

    protected Severity getSeverity() {
        if (this.severity == null) {
            return Severity.WARNING;
        }
        return this.severity;
    }

    @Override
    public InternalProblemBuilder label(String label) {
        this.label = label;
        return this;
    }

    @Override
    public InternalProblemBuilder severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public InternalProblemBuilder taskPathLocation(String buildTreePath) {
        this.addLocation(new DefaultTaskPathLocation(buildTreePath));
        return this;
    }

    @Override
    public InternalProblemBuilder fileLocation(String path) {
        this.addLocation(DefaultFileLocation.from(path));
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line) {
        this.addLocation(DefaultLineInFileLocation.from(path, line));
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line, int column) {
        this.addLocation(DefaultLineInFileLocation.from(path, line, column));
        return this;
    }

    @Override
    public InternalProblemBuilder offsetInFileLocation(String path, int offset, int length) {
        this.addLocation(DefaultOffsetInFileLocation.from(path, offset, length));
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line, int column, int length) {
        this.addLocation(DefaultLineInFileLocation.from(path, line, column, length));
        return this;
    }

    @Override
    public InternalProblemBuilder pluginLocation(String pluginId) {
        this.addLocation(new DefaultPluginIdLocation(pluginId));
        return this;
    }

    @Override
    public InternalProblemBuilder stackLocation() {
        this.collectLocation = true;
        return this;
    }

    @Override
    public InternalProblemBuilder details(String details) {
        this.details = details;
        return this;
    }

    @Override
    public InternalProblemBuilder documentedAt(DocLink doc) {
        this.docLink = doc;
        return this;
    }

    @Override
    public InternalProblemBuilder documentedAt(String url) {
        this.docLink = new DefaultDocLink(url);
        return this;
    }

    @Override
    public InternalProblemBuilder category(String category, String ... details) {
        this.category = DefaultProblemCategory.create(this.namespace, category, details);
        return this;
    }

    @Override
    public InternalProblemBuilder solution(@Nullable String solution) {
        if (this.solutions == null) {
            this.solutions = new ArrayList<String>();
        }
        this.solutions.add(solution);
        return this;
    }

    @Override
    public InternalProblemBuilder additionalData(String key, Object value) {
        this.additionalData.put(key, value);
        return this;
    }

    @Override
    public InternalProblemBuilder withException(RuntimeException e) {
        this.exception = e;
        return this;
    }

    @Nullable
    RuntimeException getException() {
        return this.exception;
    }

    protected String getLabel() {
        return this.label;
    }

    protected void addLocation(ProblemLocation location) {
        this.locations.add(location);
    }
}

