/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.dependencies.DefaultResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DefaultPendingDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DeselectVersionAction;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ReplaceSelectionWithConflictResultAction;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolutionConflictTracker;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveOptimizations;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.RootNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ComponentStateFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.SelectorStateResolver;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphSpecificResolveState;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;

class ResolveState
implements ComponentStateFactory<ComponentState> {
    private final Spec<? super DependencyMetadata> edgeFilter;
    private final Map<ModuleIdentifier, ModuleResolveState> modules;
    private final Map<ResolvedConfigurationIdentifier, NodeState> nodes;
    private final Map<SelectorCacheKey, SelectorState> selectors;
    private final RootNode root;
    private final ComponentIdGenerator idGenerator;
    private final DependencyToComponentIdResolver idResolver;
    private final ComponentMetaDataResolver metaDataResolver;
    private final Deque<NodeState> queue;
    private final ConflictResolution conflictResolution;
    private final AttributesSchemaInternal attributesSchema;
    private final ModuleExclusions moduleExclusions;
    private final DeselectVersionAction deselectVersionAction = new DeselectVersionAction(this);
    private final ReplaceSelectionWithConflictResultAction replaceSelectionWithConflictResultAction;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final ImmutableAttributesFactory attributesFactory;
    private final DependencySubstitutionApplicator dependencySubstitutionApplicator;
    private final VersionSelectorScheme versionSelectorScheme;
    private final Comparator<Version> versionComparator;
    private final VersionParser versionParser;
    private final SelectorStateResolver<ComponentState> selectorStateResolver;
    private final ResolveOptimizations resolveOptimizations;
    private final Map<VersionConstraint, ResolvedVersionConstraint> resolvedVersionConstraints = new HashMap<VersionConstraint, ResolvedVersionConstraint>();
    private final AttributeDesugaring attributeDesugaring;
    private final ResolutionConflictTracker conflictTracker;
    private final GraphVariantSelector variantSelector;

    public ResolveState(ComponentIdGenerator idGenerator, RootComponentMetadataBuilder.RootComponentState root, DependencyToComponentIdResolver idResolver, ComponentMetaDataResolver metaDataResolver, Spec<? super DependencyMetadata> edgeFilter, AttributesSchemaInternal attributesSchema, ModuleExclusions moduleExclusions, ComponentSelectorConverter componentSelectorConverter, ImmutableAttributesFactory attributesFactory, AttributeDesugaring attributeDesugaring, DependencySubstitutionApplicator dependencySubstitutionApplicator, VersionSelectorScheme versionSelectorScheme, Comparator<Version> versionComparator, VersionParser versionParser, ModuleConflictResolver<ComponentState> conflictResolver, ConflictResolution conflictResolution, List<? extends DependencyMetadata> syntheticDependencies, ResolutionConflictTracker conflictTracker, GraphVariantSelector variantSelector) {
        this.idGenerator = idGenerator;
        this.idResolver = idResolver;
        this.metaDataResolver = metaDataResolver;
        this.edgeFilter = edgeFilter;
        this.attributesSchema = attributesSchema;
        this.moduleExclusions = moduleExclusions;
        this.componentSelectorConverter = componentSelectorConverter;
        this.attributesFactory = attributesFactory;
        this.dependencySubstitutionApplicator = dependencySubstitutionApplicator;
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
        this.conflictResolution = conflictResolution;
        this.conflictTracker = conflictTracker;
        this.resolveOptimizations = new ResolveOptimizations();
        this.attributeDesugaring = attributeDesugaring;
        this.replaceSelectionWithConflictResultAction = new ReplaceSelectionWithConflictResultAction(this);
        this.variantSelector = variantSelector;
        int graphSize = ResolveState.estimateGraphSize(root);
        this.modules = new LinkedHashMap<ModuleIdentifier, ModuleResolveState>(graphSize);
        this.nodes = new LinkedHashMap<ResolvedConfigurationIdentifier, NodeState>(3 * graphSize / 2);
        this.selectors = new LinkedHashMap<SelectorCacheKey, SelectorState>(5 * graphSize / 2);
        this.queue = new ArrayDeque<NodeState>(graphSize);
        LocalComponentGraphResolveState rootComponentState = root.getRootComponent();
        ComponentGraphResolveMetadata rootComponentMetadata = rootComponentState.getMetadata();
        ModuleVersionIdentifier moduleVersionId = rootComponentMetadata.getModuleVersionId();
        ModuleResolveState rootModule = this.getModule(moduleVersionId.getModule(), true);
        ComponentState rootComponent = rootModule.getVersion(moduleVersionId, rootComponentMetadata.getId());
        rootComponent.setState(rootComponentState, ComponentGraphSpecificResolveState.EMPTY_STATE);
        rootModule.select(rootComponent);
        this.selectorStateResolver = new SelectorStateResolver<ComponentState>(conflictResolver, this, rootComponent, this.resolveOptimizations, versionComparator, versionParser);
        rootModule.setSelectorStateResolver(this.selectorStateResolver);
        ResolvedConfigurationIdentifier rootNodeId = new ResolvedConfigurationIdentifier(moduleVersionId, root.getRootConfigurationName());
        VariantGraphResolveState rootVariant = root.getRootVariant();
        this.root = new RootNode(idGenerator.nextGraphNodeId(), rootComponent, rootNodeId, this, syntheticDependencies, rootVariant);
        this.nodes.put(rootNodeId, this.root);
    }

    public ComponentIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public ResolutionConflictTracker getConflictTracker() {
        return this.conflictTracker;
    }

    public Collection<ModuleResolveState> getModules() {
        return this.modules.values();
    }

    Spec<? super DependencyMetadata> getEdgeFilter() {
        return this.edgeFilter;
    }

    RootNode getRoot() {
        return this.root;
    }

    public ModuleResolveState getModule(ModuleIdentifier id) {
        return this.getModule(id, false);
    }

    private ModuleResolveState getModule(ModuleIdentifier id, boolean rootModule) {
        return this.modules.computeIfAbsent(id, mid -> new ModuleResolveState(this.idGenerator, id, this.metaDataResolver, this.attributesFactory, this.versionComparator, this.versionParser, this.selectorStateResolver, this.resolveOptimizations, rootModule, this.conflictResolution));
    }

    @Override
    public ComponentState getRevision(ComponentIdentifier componentIdentifier, ModuleVersionIdentifier id, ComponentGraphResolveState state, ComponentGraphSpecificResolveState graphState) {
        ComponentState componentState = this.getModule(id.getModule()).getVersion(id, componentIdentifier);
        if (!componentState.alreadyResolved()) {
            componentState.setState(state, graphState);
        }
        return componentState;
    }

    public Collection<NodeState> getNodes() {
        return this.nodes.values();
    }

    public NodeState getNode(ComponentState module, VariantGraphResolveState variant, boolean selectedByVariantAwareResolution) {
        ResolvedConfigurationIdentifier id = new ResolvedConfigurationIdentifier(module.getId(), variant.getName());
        return this.nodes.computeIfAbsent(id, rci -> new NodeState(this.idGenerator.nextGraphNodeId(), id, module, this, variant, selectedByVariantAwareResolution));
    }

    public Collection<SelectorState> getSelectors() {
        return this.selectors.values();
    }

    public SelectorState getSelector(DependencyState dependencyState, boolean ignoreVersion) {
        boolean isVirtualPlatformEdge = dependencyState.getDependency() instanceof LenientPlatformDependencyMetadata;
        SelectorState selectorState = this.selectors.computeIfAbsent(new SelectorCacheKey(dependencyState.getRequested(), ignoreVersion, isVirtualPlatformEdge), req -> {
            ModuleIdentifier moduleIdentifier = dependencyState.getModuleIdentifier();
            return new SelectorState(this.idGenerator.nextGraphNodeId(), dependencyState, this.idResolver, this, moduleIdentifier, ignoreVersion);
        });
        selectorState.update(dependencyState);
        return selectorState;
    }

    @Nullable
    public NodeState peek() {
        return this.queue.isEmpty() ? null : this.queue.getFirst();
    }

    public NodeState pop() {
        NodeState next = this.queue.removeFirst();
        return next.dequeue();
    }

    public void onMoreSelected(NodeState node) {
        if (node.enqueue()) {
            this.queue.addLast(node);
        }
    }

    public void onFewerSelected(NodeState node) {
        if (node.enqueue()) {
            this.queue.addFirst(node);
        }
    }

    public AttributesSchemaInternal getAttributesSchema() {
        return this.attributesSchema;
    }

    public ModuleExclusions getModuleExclusions() {
        return this.moduleExclusions;
    }

    public DeselectVersionAction getDeselectVersionAction() {
        return this.deselectVersionAction;
    }

    public ReplaceSelectionWithConflictResultAction getReplaceSelectionWithConflictResultAction() {
        return this.replaceSelectionWithConflictResultAction;
    }

    public ComponentSelectorConverter getComponentSelectorConverter() {
        return this.componentSelectorConverter;
    }

    public ImmutableAttributesFactory getAttributesFactory() {
        return this.attributesFactory;
    }

    public DependencySubstitutionApplicator getDependencySubstitutionApplicator() {
        return this.dependencySubstitutionApplicator;
    }

    PendingDependenciesVisitor newPendingDependenciesVisitor() {
        return new DefaultPendingDependenciesVisitor(this);
    }

    @Nullable
    ResolvedVersionConstraint resolveVersionConstraint(ComponentSelector selector) {
        if (selector instanceof ModuleComponentSelector) {
            return this.resolveVersionConstraint(((ModuleComponentSelector)selector).getVersionConstraint());
        }
        return null;
    }

    ResolvedVersionConstraint resolveVersionConstraint(VersionConstraint vc) {
        return this.resolvedVersionConstraints.computeIfAbsent(vc, key -> new DefaultResolvedVersionConstraint((VersionConstraint)key, this.versionSelectorScheme));
    }

    ComponentSelector desugarSelector(ComponentSelector requested) {
        return this.attributeDesugaring.desugarSelector(requested);
    }

    AttributeDesugaring getAttributeDesugaring() {
        return this.attributeDesugaring;
    }

    ResolveOptimizations getResolveOptimizations() {
        return this.resolveOptimizations;
    }

    public GraphVariantSelector getVariantSelector() {
        return this.variantSelector;
    }

    private static int estimateGraphSize(RootComponentMetadataBuilder.RootComponentState rootComponentState) {
        int numDependencies = rootComponentState.getRootVariant().getMetadata().getDependencies().size();
        int estimate = (int)(512.0 * Math.log(numDependencies));
        return Math.max(10, estimate);
    }

    private static class SelectorCacheKey {
        private final ComponentSelector componentSelector;
        private final boolean ignoreVersion;
        private final boolean virtualPlatformEdge;

        private SelectorCacheKey(ComponentSelector componentSelector, boolean ignoreVersion, boolean virtualPlatformEdge) {
            this.componentSelector = componentSelector;
            this.ignoreVersion = ignoreVersion;
            this.virtualPlatformEdge = virtualPlatformEdge;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SelectorCacheKey that = (SelectorCacheKey)o;
            return this.ignoreVersion == that.ignoreVersion && this.virtualPlatformEdge == that.virtualPlatformEdge && this.componentSelector.equals(that.componentSelector);
        }

        public int hashCode() {
            return Objects.hash(this.componentSelector, this.ignoreVersion, this.virtualPlatformEdge);
        }
    }
}

