/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.function.Function;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.AbstractCompositeParticipantBuildState;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.deployment.internal.DefaultDeploymentRegistry;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.BuildWorkGraph;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.DefaultBuildWorkGraph;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildOperationFiringBuildTreeWorkExecutor;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeLifecycleControllerFactory;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.BuildTreeWorkExecutor;
import org.gradle.internal.buildtree.DefaultBuildTreeFinishExecutor;
import org.gradle.internal.buildtree.DefaultBuildTreeWorkExecutor;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.composite.IncludedRootBuild;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.util.Path;

class DefaultRootBuildState
extends AbstractCompositeParticipantBuildState
implements RootBuildState,
Stoppable {
    private final ListenerManager listenerManager;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildLifecycleController buildLifecycleController;
    private final BuildTreeLifecycleController buildTreeLifecycleController;
    private final BuildWorkGraph workGraph;
    private boolean completed;

    DefaultRootBuildState(BuildDefinition buildDefinition, BuildTreeState buildTree, BuildLifecycleControllerFactory buildLifecycleControllerFactory, ListenerManager listenerManager, ProjectStateRegistry projectStateRegistry) {
        this.listenerManager = listenerManager;
        this.projectStateRegistry = projectStateRegistry;
        BuildScopeServices buildScopeServices = new BuildScopeServices(buildTree.getServices());
        this.buildLifecycleController = buildLifecycleControllerFactory.newInstance(buildDefinition, (BuildState)this, null, buildScopeServices);
        IncludedBuildTaskGraph controllers = (IncludedBuildTaskGraph)buildScopeServices.get(IncludedBuildTaskGraph.class);
        ExceptionAnalyser exceptionAnalyser = (ExceptionAnalyser)buildScopeServices.get(ExceptionAnalyser.class);
        BuildOperationExecutor buildOperationExecutor = (BuildOperationExecutor)buildScopeServices.get(BuildOperationExecutor.class);
        BuildStateRegistry buildStateRegistry = (BuildStateRegistry)buildScopeServices.get(BuildStateRegistry.class);
        BuildTreeLifecycleControllerFactory buildTreeLifecycleControllerFactory = (BuildTreeLifecycleControllerFactory)buildScopeServices.get(BuildTreeLifecycleControllerFactory.class);
        BuildOperationFiringBuildTreeWorkExecutor workExecutor = new BuildOperationFiringBuildTreeWorkExecutor((BuildTreeWorkExecutor)new DefaultBuildTreeWorkExecutor(controllers, this.buildLifecycleController), buildOperationExecutor);
        DefaultBuildTreeFinishExecutor finishExecutor = new DefaultBuildTreeFinishExecutor(buildStateRegistry, exceptionAnalyser, this.buildLifecycleController);
        this.buildTreeLifecycleController = buildTreeLifecycleControllerFactory.createController(this.buildLifecycleController, (BuildTreeWorkExecutor)workExecutor, (BuildTreeFinishExecutor)finishExecutor);
        this.workGraph = new DefaultBuildWorkGraph(this.buildLifecycleController.getGradle().getTaskGraph(), projectStateRegistry, this.buildLifecycleController);
    }

    protected BuildLifecycleController getBuildController() {
        return this.buildLifecycleController;
    }

    protected ProjectStateRegistry getProjectStateRegistry() {
        return this.projectStateRegistry;
    }

    public BuildWorkGraph getWorkGraph() {
        return this.workGraph;
    }

    public BuildIdentifier getBuildIdentifier() {
        return DefaultBuildIdentifier.ROOT;
    }

    public Path getIdentityPath() {
        return Path.ROOT;
    }

    public boolean isImplicitBuild() {
        return false;
    }

    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
    }

    public File getBuildRootDir() {
        return ((BuildLayout)this.buildLifecycleController.getGradle().getServices().get(BuildLayout.class)).getRootDirectory();
    }

    public IncludedBuildInternal getModel() {
        return new IncludedRootBuild((CompositeBuildParticipantBuildState)this);
    }

    public void stop() {
        this.buildLifecycleController.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Function<? super BuildTreeLifecycleController, T> action) {
        if (this.completed) {
            throw new IllegalStateException("Cannot run more than one action for a build.");
        }
        try {
            T t;
            RootBuildLifecycleListener buildLifecycleListener = (RootBuildLifecycleListener)this.listenerManager.getBroadcaster(RootBuildLifecycleListener.class);
            buildLifecycleListener.afterStart();
            try {
                GradleInternal gradle = this.buildLifecycleController.getGradle();
                final DefaultDeploymentRegistry deploymentRegistry = (DefaultDeploymentRegistry)gradle.getServices().get(DefaultDeploymentRegistry.class);
                gradle.addBuildListener((BuildListener)new InternalBuildAdapter(){

                    public void buildFinished(BuildResult result) {
                        deploymentRegistry.buildFinished(result);
                    }
                });
                t = action.apply((BuildTreeLifecycleController)this.buildTreeLifecycleController);
            }
            catch (Throwable throwable) {
                buildLifecycleListener.beforeComplete();
                throw throwable;
            }
            buildLifecycleListener.beforeComplete();
            return t;
        }
        finally {
            this.completed = true;
        }
    }

    public StartParameterInternal getStartParameter() {
        return this.buildLifecycleController.getGradle().getStartParameter();
    }

    public SettingsInternal getLoadedSettings() {
        return this.buildLifecycleController.getGradle().getSettings();
    }

    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return Path.ROOT;
    }

    public Path getIdentityPathForProject(Path path) {
        return path;
    }

    public GradleInternal getBuild() {
        return this.buildLifecycleController.getGradle();
    }

    public GradleInternal getMutableModel() {
        return this.buildLifecycleController.getGradle();
    }
}

