/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ThrowableConstructorIntrinsicFactory;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/FunctionIntrinsicFactory;", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "Intrinsic", "js.translator"})
public final class ThrowableConstructorIntrinsicFactory
implements FunctionIntrinsicFactory {
    @NotNull
    public static final ThrowableConstructorIntrinsicFactory INSTANCE = new ThrowableConstructorIntrinsicFactory();

    private ThrowableConstructorIntrinsicFactory() {
    }

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof ConstructorDescriptor)) {
            return null;
        }
        SimpleType simpleType2 = ((ConstructorDescriptor)descriptor2).getConstructedClass().getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"descriptor.constructedClass.defaultType");
        if (!TypeUtilsKt.isNotNullThrowable(simpleType2)) {
            return null;
        }
        return Intrinsic.INSTANCE;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ThrowableConstructorIntrinsicFactory$Intrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "arguments", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    public static final class Intrinsic
    extends FunctionIntrinsic {
        @NotNull
        public static final Intrinsic INSTANCE = new Intrinsic();

        private Intrinsic() {
        }

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
            boolean hasCauseParameter;
            Object object;
            List argumentsToPass;
            CallableDescriptor constructor2;
            block4: {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
                Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                constructor2 = callInfo.getResolvedCall().getResultingDescriptor();
                argumentsToPass = CollectionsKt.toMutableList((Collection)arguments2);
                object = constructor2.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(object, (String)"constructor.valueParameters");
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                        boolean bl2 = false;
                        ClassifierDescriptor classifierDescriptor = it.getType().getConstructor().getDeclarationDescriptor();
                        if (!Intrinsics.areEqual((Object)(classifierDescriptor == null ? null : DescriptorUtilsKt.getFqNameSafe(classifierDescriptor)), (Object)StandardNames.FqNames.throwable)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = hasCauseParameter = false;
                }
            }
            if (constructor2.getValueParameters().size() == 1 && hasCauseParameter) {
                object = Namer.getUndefinedExpression();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getUndefinedExpression()");
                argumentsToPass.add(0, object);
            }
            return new JsInvocation((JsExpression)JsAstUtils.pureFqn("newThrowable", (JsExpression)Namer.kotlinObject()), argumentsToPass);
        }
    }
}

