/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.configurationcache.problems.ConfigurationCacheProblemsSummaryKt;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.UniquePropertyProblem;
import org.gradle.internal.logging.ConsoleRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\n \u0014*\u0004\u0018\u00010\u00170\u00172\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0019J(\u0010#\u001a\u00020$*\u00060%j\u0002`&2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\tj\b\u0012\u0004\u0012\u00020\u0005`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013 \u0014*\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheProblemsSummary;", "", "()V", "causes", "", "", "getCauses", "()Ljava/util/List;", "causesSummary", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "problemCount", "", "getProblemCount", "()I", "problemCountSummary", "Ljava/util/concurrent/atomic/AtomicInteger;", "uniqueProblems", "", "Lorg/gradle/configurationcache/problems/UniquePropertyProblem;", "kotlin.jvm.PlatformType", "", "buildSummaryReportLink", "", "reportFile", "Ljava/io/File;", "clickableUrlFor", "file", "onProblem", "", "problem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "textForConsole", "cacheActionText", "htmlReportFile", "appendSummaryHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "cacheAction", "totalProblemCount", "uniqueProblemCount", "configuration-cache"})
public final class ConfigurationCacheProblemsSummary {
    private final Set<UniquePropertyProblem> uniqueProblems = Sets.newConcurrentHashSet();
    private final AtomicInteger problemCountSummary = new AtomicInteger();
    private final ArrayList<Throwable> causesSummary = new ArrayList(5);

    public final int getProblemCount() {
        return this.problemCountSummary.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Throwable> getCauses() {
        List list;
        ArrayList<Throwable> arrayList = this.causesSummary;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (arrayList) {
            boolean bl3 = false;
            list = CollectionsKt.toList((Iterable)this.causesSummary);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onProblem(@NotNull PropertyProblem problem) {
        UniquePropertyProblem uniqueProblem;
        boolean isReported;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        int problemCount = this.problemCountSummary.incrementAndGet();
        boolean bl = isReported = problemCount <= 4096;
        if (isReported && this.uniqueProblems.add(uniqueProblem = UniquePropertyProblem.Companion.of(problem))) {
            Throwable throwable = problem.getException();
            if (throwable != null) {
                Throwable throwable2 = throwable;
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable cause = throwable2;
                boolean bl4 = false;
                ArrayList<Throwable> arrayList = this.causesSummary;
                boolean bl5 = false;
                boolean bl6 = false;
                synchronized (arrayList) {
                    boolean bl7 = false;
                    if (this.causesSummary.size() < 5) {
                        this.causesSummary.add(cause);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
        return isReported;
    }

    @NotNull
    public final String textForConsole(@NotNull String cacheActionText, @NotNull File htmlReportFile) {
        Intrinsics.checkNotNullParameter((Object)cacheActionText, (String)"cacheActionText");
        Intrinsics.checkNotNullParameter((Object)htmlReportFile, (String)"htmlReportFile");
        DocumentationRegistry documentationRegistry = new DocumentationRegistry();
        int totalProblemCount = this.getProblemCount();
        int uniqueProblemCount = this.uniqueProblems.size();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        StringBuilder stringBuilder2 = $this$apply;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        this.appendSummaryHeader($this$apply, cacheActionText, totalProblemCount, uniqueProblemCount);
        stringBuilder2 = $this$apply;
        bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        List list = Ordering.from((Comparator)ConfigurationCacheProblemsSummaryKt.access$consoleComparator()).leastOf((Iterable)this.uniqueProblems, 15);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"Ordering.from(consoleCom\u2026lems, maxConsoleProblems)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder3;
            StringBuilder stringBuilder4;
            UniquePropertyProblem problem = (UniquePropertyProblem)element$iv;
            boolean bl5 = false;
            $this$apply.append("- ");
            $this$apply.append(StringsKt.capitalize((String)problem.getUserCodeLocation()));
            $this$apply.append(": ");
            CharSequence charSequence = $this$apply;
            String string2 = problem.getMessage();
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence.append(string2), (String)"append(value)");
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            String string3 = problem.getDocumentationSection();
            if (string3 == null) continue;
            charSequence = string3;
            boolean bl8 = false;
            bl6 = false;
            CharSequence it = charSequence;
            boolean bl9 = false;
            StringBuilder stringBuilder5 = $this$apply;
            String string4 = "  See " + documentationRegistry.getDocumentationFor("configuration_cache", (String)it);
            boolean bl10 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append(string4), (String)"append(value)");
            boolean bl11 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        if (uniqueProblemCount > 15) {
            stringBuilder2 = $this$apply;
            String string5 = "plus " + (uniqueProblemCount - 15) + " more problems. Please see the report for details.";
            boolean bl12 = false;
            StringBuilder stringBuilder6 = stringBuilder2.append(string5);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            StringBuilder stringBuilder7 = stringBuilder6;
            boolean bl13 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
        }
        stringBuilder2 = $this$apply;
        boolean bl14 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        $this$apply.append(this.buildSummaryReportLink(htmlReportFile));
        String string6 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"StringBuilder().apply {\n\u2026le))\n        }.toString()");
        return string6;
    }

    private final void appendSummaryHeader(StringBuilder $this$appendSummaryHeader, String cacheAction, int totalProblemCount, int uniqueProblemCount) {
        $this$appendSummaryHeader.append(totalProblemCount);
        $this$appendSummaryHeader.append(totalProblemCount == 1 ? " problem was found " : " problems were found ");
        $this$appendSummaryHeader.append(cacheAction);
        $this$appendSummaryHeader.append(" the configuration cache");
        if (totalProblemCount > 4096) {
            $this$appendSummaryHeader.append(", only the first ");
            $this$appendSummaryHeader.append(4096);
            $this$appendSummaryHeader.append(" were considered");
        }
        if (totalProblemCount != uniqueProblemCount) {
            $this$appendSummaryHeader.append(", ");
            $this$appendSummaryHeader.append(uniqueProblemCount);
            $this$appendSummaryHeader.append(" of which ");
            $this$appendSummaryHeader.append(uniqueProblemCount == 1 ? "seems unique" : "seem unique");
        }
        $this$appendSummaryHeader.append(".");
    }

    private final String buildSummaryReportLink(File reportFile) {
        return "See the complete report at " + this.clickableUrlFor(reportFile);
    }

    private final String clickableUrlFor(File file) {
        return new ConsoleRenderer().asClickableFileUrl(file);
    }
}

