/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.Closeable;
import java.io.IOException;
import org.gradle.api.internal.initialization.AbstractClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.RootClassLoaderScope;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.ClassLoaderScopeListeners;
import org.gradle.initialization.ClassLoaderScopeRegistry;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;
import org.gradle.internal.event.ListenerManager;

public class DefaultClassLoaderScopeRegistry
implements ClassLoaderScopeRegistry,
Closeable {
    public static final String CORE_NAME = "core";
    public static final String CORE_AND_PLUGINS_NAME = "coreAndPlugins";
    private final AbstractClassLoaderScope coreAndPluginsScope;
    private final AbstractClassLoaderScope coreScope;
    private final ClassLoaderScopeRegistryListener scopeBroadcaster;
    private final ClassLoaderScopeListeners listeners;

    public DefaultClassLoaderScopeRegistry(ClassLoaderRegistry loaderRegistry, ClassLoaderCache classLoaderCache, ListenerManager listenerManager, ClassLoaderScopeListeners listeners) {
        this.scopeBroadcaster = (ClassLoaderScopeRegistryListener)listenerManager.getBroadcaster(ClassLoaderScopeRegistryListener.class);
        this.listeners = listeners;
        listeners.addListener(this.scopeBroadcaster);
        ClassLoaderScopeRegistryListener globalBroadcast = listeners.getBroadcast();
        this.coreScope = new RootClassLoaderScope(CORE_NAME, loaderRegistry.getRuntimeClassLoader(), loaderRegistry.getGradleCoreApiClassLoader(), classLoaderCache, globalBroadcast);
        this.coreAndPluginsScope = new RootClassLoaderScope(CORE_AND_PLUGINS_NAME, loaderRegistry.getPluginsClassLoader(), loaderRegistry.getGradleApiClassLoader(), classLoaderCache, globalBroadcast);
        this.rootScopesCreated(globalBroadcast);
    }

    @Override
    public void close() throws IOException {
        this.listeners.removeListener(this.scopeBroadcaster);
    }

    @Override
    public ClassLoaderScope getCoreAndPluginsScope() {
        return this.coreAndPluginsScope;
    }

    @Override
    public ClassLoaderScope getCoreScope() {
        return this.coreScope;
    }

    private void rootScopesCreated(ClassLoaderScopeRegistryListener listener) {
        listener.rootScopeCreated(this.coreScope.getId());
        listener.rootScopeCreated(this.coreAndPluginsScope.getId());
    }
}

