/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import java.net.URI;
import java.nio.charset.Charset;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.resources.ApiTextResourceAdapter;
import org.gradle.api.internal.resources.FileCollectionBackedArchiveTextResource;
import org.gradle.api.internal.resources.FileCollectionBackedTextResource;
import org.gradle.api.internal.resources.StringBackedTextResource;
import org.gradle.api.resources.TextResource;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.verifier.HttpRedirectVerifier;
import org.gradle.internal.verifier.HttpRedirectVerifierFactory;
import org.gradle.util.GUtil;

public class DefaultTextResourceFactory
implements TextResourceFactory {
    private final FileOperations fileOperations;
    private final TemporaryFileProvider tempFileProvider;
    private ApiTextResourceAdapter.Factory apiTextResourcesAdapterFactory;

    public DefaultTextResourceFactory(FileOperations fileOperations, TemporaryFileProvider tempFileProvider, ApiTextResourceAdapter.Factory apiTextResourcesAdapterFactory) {
        this.fileOperations = fileOperations;
        this.tempFileProvider = tempFileProvider;
        this.apiTextResourcesAdapterFactory = apiTextResourcesAdapterFactory;
    }

    public TextResource fromString(String string) {
        return new StringBackedTextResource(this.tempFileProvider, string);
    }

    public TextResource fromFile(Object file, String charset) {
        return new FileCollectionBackedTextResource(this.tempFileProvider, this.fileOperations.immutableFiles(file), Charset.forName(charset));
    }

    public TextResource fromFile(Object file) {
        return this.fromFile(file, Charset.defaultCharset().name());
    }

    public TextResource fromArchiveEntry(Object archive, String entryPath, String charset) {
        return new FileCollectionBackedArchiveTextResource(this.fileOperations, this.tempFileProvider, this.fileOperations.immutableFiles(archive), entryPath, Charset.forName(charset));
    }

    public TextResource fromArchiveEntry(Object archive, String entryPath) {
        return this.fromArchiveEntry(archive, entryPath, Charset.defaultCharset().name());
    }

    public TextResource fromUri(Object uri) {
        return this.fromUri(uri, false);
    }

    public TextResource fromInsecureUri(Object uri) {
        return this.fromUri(uri, true);
    }

    private TextResource fromUri(Object uri, boolean allowInsecureProtocol) {
        URI rootUri = this.fileOperations.uri(uri);
        HttpRedirectVerifier redirectVerifier = HttpRedirectVerifierFactory.create((URI)rootUri, (boolean)allowInsecureProtocol, () -> DeprecationLogger.deprecate((String)"Loading a TextResource from an insecure URI").withAdvice(String.format("Switch the URI to '%s' or try 'resources.text.fromInsecureUri(\"%s\")' to silence the warning.", GUtil.toSecureUrl((URI)rootUri), rootUri)).withContext(String.format("The provided URI '%s' uses an insecure protocol (HTTP).", rootUri)).willBeRemovedInGradle7().withDslReference(TextResourceFactory.class, "fromInsecureUri(java.lang.Object)").nagUser(), redirect -> DeprecationLogger.deprecate((String)"Loading a TextResource from an insecure redirect").withAdvice("Switch to HTTPS or use TextResourceFactory.fromInsecureUri(Object) to silence the warning.").withContext(String.format("'%s' redirects to insecure '%s'.", uri, redirect)).willBeRemovedInGradle7().withDslReference(TextResourceFactory.class, "fromInsecureUri(java.lang.Object)").nagUser());
        return this.apiTextResourcesAdapterFactory.create(rootUri, redirectVerifier);
    }
}

