/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseWtpComponent;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.WbDependentModule;
import org.gradle.plugins.ide.eclipse.model.WbResource;
import org.gradle.plugins.ide.eclipse.model.WtpComponent;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.eclipse.model.internal.ProjectDependencyBuilder;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.resolver.IdeDependencySet;
import org.gradle.plugins.ide.internal.resolver.IdeDependencyVisitor;
import org.gradle.plugins.ide.internal.resolver.NullGradleApiSourcesResolver;
import org.gradle.plugins.ide.internal.resolver.UnresolvedIdeDependencyHandler;

public class WtpComponentFactory {
    private final ProjectDependencyBuilder projectDependencyBuilder;
    private final ProjectComponentIdentifier currentProjectId;

    public WtpComponentFactory(Project project, IdeArtifactRegistry artifactRegistry, ProjectStateRegistry projectRegistry) {
        this.projectDependencyBuilder = new ProjectDependencyBuilder(artifactRegistry);
        this.currentProjectId = projectRegistry.stateFor(project).getComponentIdentifier();
    }

    public void configure(EclipseWtpComponent wtp, WtpComponent component) {
        ArrayList entries = Lists.newArrayList();
        entries.addAll(this.getEntriesFromSourceDirs(wtp));
        for (WbResource element : wtp.getResources()) {
            if (!wtp.getProject().file((Object)element.getSourcePath()).isDirectory()) continue;
            entries.add(element);
        }
        entries.addAll(wtp.getProperties());
        Project project = wtp.getProject();
        entries.addAll(this.getEntriesFromConfigurations(project, this.configOrEmptySet(wtp.getRootConfigurations()), this.configOrEmptySet(wtp.getMinusConfigurations()), wtp, "/"));
        entries.addAll(this.getEntriesFromConfigurations(project, this.configOrEmptySet(wtp.getLibConfigurations()), this.configOrEmptySet(wtp.getMinusConfigurations()), wtp, wtp.getLibDeployPath()));
        component.configure(wtp.getDeployName(), wtp.getContextPath(), entries);
    }

    private Set<Configuration> configOrEmptySet(Set<Configuration> configuration) {
        if (configuration == null) {
            return Collections.emptySet();
        }
        return configuration;
    }

    private List<WbResource> getEntriesFromSourceDirs(EclipseWtpComponent wtp) {
        ArrayList result = Lists.newArrayList();
        if (wtp.getSourceDirs() != null) {
            for (File dir : wtp.getSourceDirs()) {
                if (!dir.isDirectory()) continue;
                result.add(new WbResource(wtp.getClassesDeployPath(), wtp.getProject().relativePath((Object)dir)));
            }
        }
        return result;
    }

    private List<WbDependentModule> getEntriesFromConfigurations(Project project, Set<Configuration> plusConfigurations, Set<Configuration> minusConfigurations, EclipseWtpComponent wtp, String deployPath) {
        WtpDependenciesVisitor visitor = new WtpDependenciesVisitor(project, wtp, deployPath);
        new IdeDependencySet(project.getDependencies(), plusConfigurations, minusConfigurations, NullGradleApiSourcesResolver.INSTANCE).visit(visitor);
        return visitor.getEntries();
    }

    private class WtpDependenciesVisitor
    implements IdeDependencyVisitor {
        private final Project project;
        private final EclipseWtpComponent wtp;
        private final String deployPath;
        private final List<WbDependentModule> projectEntries = Lists.newArrayList();
        private final List<WbDependentModule> moduleEntries = Lists.newArrayList();
        private final List<WbDependentModule> fileEntries = Lists.newArrayList();
        private final UnresolvedIdeDependencyHandler unresolvedIdeDependencyHandler = new UnresolvedIdeDependencyHandler();

        private WtpDependenciesVisitor(Project project, EclipseWtpComponent wtp, String deployPath) {
            this.project = project;
            this.wtp = wtp;
            this.deployPath = deployPath;
        }

        @Override
        public boolean isOffline() {
            return !this.includeLibraries();
        }

        private boolean includeLibraries() {
            return !this.project.getPlugins().hasPlugin(JavaPlugin.class);
        }

        @Override
        public boolean downloadSources() {
            return false;
        }

        @Override
        public boolean downloadJavaDoc() {
            return false;
        }

        @Override
        public void visitProjectDependency(ResolvedArtifactResult artifact) {
            ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)artifact.getId().getComponentIdentifier();
            if (!projectId.equals(WtpComponentFactory.this.currentProjectId)) {
                String targetProjectPath = WtpComponentFactory.this.projectDependencyBuilder.determineTargetProjectName(projectId);
                this.projectEntries.add(new WbDependentModule(this.deployPath, "module:/resource/" + targetProjectPath + "/" + targetProjectPath));
            }
        }

        @Override
        public void visitModuleDependency(ResolvedArtifactResult artifact, Set<ResolvedArtifactResult> sources, Set<ResolvedArtifactResult> javaDoc, boolean testDependency) {
            if (this.includeLibraries()) {
                this.moduleEntries.add(this.createWbDependentModuleEntry(artifact.getFile(), this.wtp.getFileReferenceFactory(), this.deployPath));
            }
        }

        @Override
        public void visitFileDependency(ResolvedArtifactResult artifact, boolean testDependency) {
            if (this.includeLibraries()) {
                this.fileEntries.add(this.createWbDependentModuleEntry(artifact.getFile(), this.wtp.getFileReferenceFactory(), this.deployPath));
            }
        }

        @Override
        public void visitGradleApiDependency(ResolvedArtifactResult artifact, File sources, boolean testDependency) {
            this.visitFileDependency(artifact, testDependency);
        }

        @Override
        public void visitUnresolvedDependency(UnresolvedDependencyResult unresolvedDependency) {
            this.unresolvedIdeDependencyHandler.log(unresolvedDependency);
        }

        public List<WbDependentModule> getEntries() {
            ArrayList entries = Lists.newArrayListWithCapacity((int)(this.projectEntries.size() + this.moduleEntries.size() + this.fileEntries.size()));
            entries.addAll(this.projectEntries);
            entries.addAll(this.moduleEntries);
            entries.addAll(this.fileEntries);
            return entries;
        }

        private WbDependentModule createWbDependentModuleEntry(File file, FileReferenceFactory fileReferenceFactory, String deployPath) {
            FileReference ref = fileReferenceFactory.fromFile(file);
            String handleSnippet = ref.isRelativeToPathVariable() ? "var/" + ref.getPath() : "lib/" + ref.getPath();
            return new WbDependentModule(deployPath, "module:/classpath/" + handleSnippet);
        }
    }
}

