/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

/*
 * gr-baz by Balint Seeber (http://spench.net/contact)
 * Information, documentation & samples: http://wiki.spench.net/wiki/gr-baz
 */

/*
 * config.h is generated by configure.  It contains the results
 * of probing for features, options etc.  It should be the first
 * file included in your .cc file.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <baz_test_counter_cc.h>
#include <gnuradio/io_signature.h>
#include <stdio.h>

/*
 * Create a new instance of baz_test_counter_cc and return
 * a boost shared_ptr.  This is effectively the public constructor.
 */
baz_test_counter_cc_sptr 
baz_make_test_counter_cc ()
{
  return baz_test_counter_cc_sptr (new baz_test_counter_cc ());
}

/*
 * Specify constraints on number of input and output streams.
 * This info is used to construct the input and output signatures
 * (2nd & 3rd args to gr::block's constructor).  The input and
 * output signatures are used by the runtime system to
 * check that a valid number and type of inputs and outputs
 * are connected to this block.  In this case, we accept
 * only 1 input and 1 output.
 */
static const int MIN_IN = 1;	// mininum number of input streams
static const int MAX_IN = 1;	// maximum number of input streams
static const int MIN_OUT = 0;	// minimum number of output streams
static const int MAX_OUT = 0;	// maximum number of output streams

typedef unsigned short USHORT;

/*
 * The private constructor
 */
baz_test_counter_cc::baz_test_counter_cc ()
  : gr::sync_block ("test_counter_cc",
		   gr::io_signature::make (MIN_IN, MAX_IN, sizeof (gr_complex)/*2*sizeof(USHORT)*/),
		   gr::io_signature::make (MIN_OUT, MAX_OUT, 0/*sizeof (gr_complex)*/))
  , d_counter(0)
{
}

/*
 * Our virtual destructor.
 */
baz_test_counter_cc::~baz_test_counter_cc ()
{
}

int 
baz_test_counter_cc::work (int noutput_items,
			gr_vector_const_void_star &input_items,
			gr_vector_void_star &output_items)
{
  const gr_complex *in = (const gr_complex *) input_items[0];
  //const USHORT *in = (const USHORT *) input_items[0];
  //gr_complex *out = (gr_complex *) output_items[0];

  for (int n = 0; n < noutput_items; n++){
    USHORT r = (USHORT)in[n].real();
	USHORT i = (USHORT)in[n].imag();
	
	if (r == i)
	{
	  if (r == d_counter)
		++d_counter;
	  else {
		fprintf(stderr, "Test: skipped %05i\n", ((int)r - (int)d_counter));
		d_counter = r + 1;
	  }
	}
	else {
	  if (r == d_counter) {
		fprintf(stderr, "Test: I neq ( %05i ,_%05i_)\n", (int)r, (int)i);
	  }
	  else if (i == d_counter) {
		fprintf(stderr, "Test: R neq (_%05i_, %05i )\n", (int)r, (int)i);
	  }
	  else {
		fprintf(stderr, "Test: * neq (_%05i_,_%05i_)\n", (int)r, (int)i);
	  }
	}
  }

  return noutput_items;
}
